/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.integrity;

import android.os.Build;
import android.os.Bundle;
import com.facebook.FacebookSdk;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0012\u0010\u0014\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J&\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\t\u0018\u00010\u0016j\n\u0012\u0004\u0012\u00020\t\u0018\u0001`\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0007J\u001c\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0007J\b\u0010\u001c\u001a\u00020\fH\u0002J\u001a\u0010\u001d\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0007J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\"\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\""}, d2={"Lcom/facebook/appevents/integrity/MACARuleMatchingManager;", "", "()V", "MACARules", "Lorg/json/JSONArray;", "enabled", "", "keys", "", "", "[Ljava/lang/String;", "enable", "", "generateInfo", "params", "Landroid/os/Bundle;", "event", "getKey", "logic", "Lorg/json/JSONObject;", "getMatchPropertyIDs", "getStringArrayList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "jsonArray", "isMatchCCRule", "ruleString", "data", "loadMACARules", "processParameters", "removeGeneratedInfo", "stringComparison", "variable", "values", "facebook-core_release"})
@AutoHandleExceptions
public final class MACARuleMatchingManager {
    @NotNull
    public static final MACARuleMatchingManager INSTANCE = new MACARuleMatchingManager();
    private static boolean enabled;
    @Nullable
    private static JSONArray MACARules;
    @NotNull
    private static String[] keys;

    private MACARuleMatchingManager() {
    }

    @JvmStatic
    public static final void enable() {
        INSTANCE.loadMACARules();
        if (MACARules != null) {
            enabled = true;
        }
    }

    private final void loadMACARules() {
        FetchedAppSettings fetchedAppSettings = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.INSTANCE.getApplicationId(), false);
        if (fetchedAppSettings == null) {
            return;
        }
        FetchedAppSettings settings = fetchedAppSettings;
        MACARules = settings.getMACARuleMatchingSetting();
    }

    @JvmStatic
    @Nullable
    public static final String getKey(@NotNull JSONObject logic) {
        Intrinsics.checkNotNullParameter((Object)logic, (String)"logic");
        Iterator its = logic.keys();
        if (its.hasNext()) {
            return (String)its.next();
        }
        return null;
    }

    @JvmStatic
    public static final boolean stringComparison(@NotNull String variable, @NotNull JSONObject values, @Nullable Bundle data) {
        boolean bl;
        String string;
        String string2;
        String string3;
        String string4;
        Object object;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        String string5 = MACARuleMatchingManager.getKey(values);
        if (string5 == null) {
            return false;
        }
        String op = string5;
        String ruleValue = values.get(op).toString();
        ArrayList<String> ruleArray = MACARuleMatchingManager.getStringArrayList(values.optJSONArray(op));
        if (Intrinsics.areEqual((Object)op, (Object)"exists")) {
            Object object2 = data;
            Boolean bl2 = object2 == null ? null : Boolean.valueOf(object2.containsKey(variable));
            object2 = ruleValue;
            boolean bl3 = false;
            return Intrinsics.areEqual((Object)bl2, (Object)Boolean.parseBoolean((String)object2));
        }
        Object object3 = data;
        if (object3 == null) {
            object = null;
        } else {
            string4 = variable;
            boolean bl4 = false;
            String string6 = string4.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            object = string3 = object3.get(string6);
        }
        if (string3 == null) {
            string4 = data;
            Bundle bundle = object3 = string4 == null ? null : string4.get(variable);
            if (object3 == null) {
                return false;
            }
            string2 = object3;
        } else {
            string2 = string3;
        }
        String dataValue = string = string2;
        block35 : switch (op) {
            case "contains": {
                bl = StringsKt.contains$default((CharSequence)dataValue.toString(), (CharSequence)ruleValue, (boolean)false, (int)2, null);
                break;
            }
            case "i_contains": {
                string3 = dataValue.toString();
                boolean bl5 = false;
                String string7 = string3;
                if (string7 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                CharSequence charSequence = string8;
                string3 = ruleValue;
                bl5 = false;
                String string9 = string3;
                if (string9 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string10 = string9.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                bl = StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string10, (boolean)false, (int)2, null);
                break;
            }
            case "not_contains": {
                if (!StringsKt.contains$default((CharSequence)dataValue.toString(), (CharSequence)ruleValue, (boolean)false, (int)2, null)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "i_not_contains": {
                string3 = dataValue.toString();
                boolean bl6 = false;
                String string11 = string3;
                if (string11 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string12 = string11.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                CharSequence charSequence = string12;
                string3 = ruleValue;
                bl6 = false;
                String string13 = string3;
                if (string13 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string14 = string13.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string14, (boolean)false, (int)2, null)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "starts_with": {
                bl = StringsKt.startsWith$default((String)dataValue.toString(), (String)ruleValue, (boolean)false, (int)2, null);
                break;
            }
            case "i_starts_with": {
                string3 = dataValue.toString();
                boolean bl7 = false;
                String string15 = string3;
                if (string15 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string16 = string15.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                string3 = ruleValue;
                bl7 = false;
                String string17 = string3;
                if (string17 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string18 = string17.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                bl = StringsKt.startsWith$default((String)string16, (String)string18, (boolean)false, (int)2, null);
                break;
            }
            case "i_str_eq": {
                string3 = dataValue.toString();
                boolean bl8 = false;
                String string19 = string3;
                if (string19 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string20 = string19.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string20, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                string3 = ruleValue;
                bl8 = false;
                String string21 = string3;
                if (string21 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string22 = string21.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string22, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                bl = Intrinsics.areEqual((Object)string20, (Object)string22);
                break;
            }
            case "i_str_neq": {
                string3 = dataValue.toString();
                boolean bl9 = false;
                String string23 = string3;
                if (string23 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string24 = string23.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string24, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                string3 = ruleValue;
                bl9 = false;
                String string25 = string3;
                if (string25 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string26 = string25.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string26, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                if (!Intrinsics.areEqual((Object)string24, (Object)string26)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "in": 
            case "is_any": {
                object3 = ruleArray;
                if (object3 == null) {
                    return false;
                }
                Object arr = object3;
                bl = ((ArrayList)arr).contains(dataValue.toString());
                break;
            }
            case "i_is_any": 
            case "i_str_in": {
                object3 = ruleArray;
                if (object3 == null) {
                    return false;
                }
                Object arr = object3;
                Iterable<String> $this$any$iv = (Iterable)arr;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                    break;
                }
                Iterator<String> iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    String element$iv;
                    String str = element$iv = iterator.next();
                    boolean bl10 = false;
                    String string27 = str;
                    boolean bl11 = false;
                    String string28 = string27;
                    if (string28 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string29 = string28.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string29, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    string27 = dataValue.toString();
                    bl11 = false;
                    String string30 = string27;
                    if (string30 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string31 = string30.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string31, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    if (!Intrinsics.areEqual((Object)string29, (Object)string31)) continue;
                    bl = true;
                    break block35;
                }
                bl = false;
                break;
            }
            case "not_in": 
            case "is_not_any": {
                Iterable<String> $this$any$iv = ruleArray;
                if ($this$any$iv == null) {
                    return false;
                }
                Object arr = $this$any$iv;
                bl = ((ArrayList)arr).contains(dataValue.toString());
                break;
            }
            case "i_str_not_in": 
            case "i_is_not_any": {
                Iterable<String> $this$any$iv = ruleArray;
                if ($this$any$iv == null) {
                    return false;
                }
                Object arr = $this$any$iv;
                Iterable $this$all$iv = (Iterable)arr;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                    break;
                }
                for (Object element$iv : $this$all$iv) {
                    String str = (String)element$iv;
                    boolean bl12 = false;
                    String string32 = str;
                    boolean bl13 = false;
                    String string33 = string32;
                    if (string33 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string34 = string33.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string34, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    string32 = dataValue.toString();
                    bl13 = false;
                    String string35 = string32;
                    if (string35 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string36 = string35.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string36, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    if (!Intrinsics.areEqual((Object)string34, (Object)string36)) continue;
                    bl = false;
                    break block35;
                }
                bl = true;
                break;
            }
            case "regex_match": {
                string3 = ruleValue;
                boolean bl14 = false;
                bl = new Regex(string3).matches((CharSequence)dataValue.toString());
                break;
            }
            case "==": 
            case "eq": 
            case "=": {
                bl = Intrinsics.areEqual((Object)dataValue.toString(), (Object)ruleValue);
                break;
            }
            case "neq": 
            case "ne": 
            case "!=": {
                if (!Intrinsics.areEqual((Object)dataValue.toString(), (Object)ruleValue)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "lt": 
            case "<": {
                string3 = dataValue.toString();
                boolean bl15 = false;
                double d = Double.parseDouble(string3);
                string3 = ruleValue;
                bl15 = false;
                if (d < Double.parseDouble(string3)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "<=": 
            case "lte": 
            case "le": {
                string3 = dataValue.toString();
                boolean bl16 = false;
                double d = Double.parseDouble(string3);
                string3 = ruleValue;
                bl16 = false;
                if (d <= Double.parseDouble(string3)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "gt": 
            case ">": {
                string3 = dataValue.toString();
                boolean bl17 = false;
                double d = Double.parseDouble(string3);
                string3 = ruleValue;
                bl17 = false;
                if (d > Double.parseDouble(string3)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "gte": 
            case "ge": 
            case ">=": {
                string3 = dataValue.toString();
                boolean bl18 = false;
                double d = Double.parseDouble(string3);
                string3 = ruleValue;
                bl18 = false;
                if (d >= Double.parseDouble(string3)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @JvmStatic
    @Nullable
    public static final ArrayList<String> getStringArrayList(@Nullable JSONArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        int n = 0;
        ArrayList<String> res = new ArrayList<String>();
        n = 0;
        int n2 = jsonArray.length();
        if (n < n2) {
            do {
                int i = n++;
                res.add(jsonArray.get(i).toString());
            } while (n < n2);
        }
        return res;
    }

    @JvmStatic
    public static final boolean isMatchCCRule(@Nullable String ruleString, @Nullable Bundle data) {
        boolean bl;
        if (ruleString == null || data == null) {
            return false;
        }
        JSONObject ruleJson = new JSONObject(ruleString);
        String string = MACARuleMatchingManager.getKey(ruleJson);
        if (string == null) {
            return false;
        }
        String op = string;
        Object values = ruleJson.get(op);
        switch (op) {
            case "and": {
                JSONArray jSONArray = (JSONArray)values;
                if (jSONArray == null) {
                    return false;
                }
                int n = 0;
                JSONArray v = jSONArray;
                int n2 = v.length();
                if (n < n2) {
                    do {
                        int i = n++;
                        boolean thisRes = MACARuleMatchingManager.isMatchCCRule(v.get(i).toString(), data);
                        if (thisRes) continue;
                        return false;
                    } while (n < n2);
                }
                return true;
            }
            case "or": {
                JSONArray jSONArray = (JSONArray)values;
                if (jSONArray == null) {
                    return false;
                }
                int n = 0;
                JSONArray v = jSONArray;
                int n3 = v.length();
                if (n < n3) {
                    do {
                        int i = n++;
                        boolean thisRes = MACARuleMatchingManager.isMatchCCRule(v.get(i).toString(), data);
                        if (!thisRes) continue;
                        return true;
                    } while (n < n3);
                }
                return false;
            }
            case "not": {
                if (!MACARuleMatchingManager.isMatchCCRule(values.toString(), data)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                JSONObject jSONObject = (JSONObject)values;
                if (jSONObject == null) {
                    return false;
                }
                JSONObject v = jSONObject;
                return MACARuleMatchingManager.stringComparison(op, v, data);
            }
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final String getMatchPropertyIDs(@Nullable Bundle params) {
        block7: {
            block6: {
                if (MACARules == null) break block6;
                JSONArray jSONArray = MACARules;
                Integer n = jSONArray == null ? null : Integer.valueOf(jSONArray.length());
                boolean bl = false;
                if (n == null || n != 0) break block7;
            }
            return "[]";
        }
        JSONArray jSONArray = MACARules;
        if (jSONArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.json.JSONArray");
        }
        JSONArray rules = jSONArray;
        int n = 0;
        List res = new ArrayList();
        n = 0;
        int n2 = rules.length();
        if (n < n2) {
            do {
                String string;
                String entry;
                JSONObject json;
                long pid;
                int i;
                String string2;
                if ((string2 = rules.optString(i = n++)) == null || (pid = (json = new JSONObject(entry = string2)).optLong("id")) == 0L || (string = json.optString("rule")) == null) continue;
                String rule = string;
                if (!MACARuleMatchingManager.isMatchCCRule(rule, params)) continue;
                res.add(pid);
            } while (n < n2);
        }
        String string = new JSONArray((Collection)res).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONArray(res).toString()");
        return string;
    }

    @JvmStatic
    public static final void processParameters(@Nullable Bundle params, @NotNull String event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!enabled || params == null) {
            return;
        }
        try {
            MACARuleMatchingManager.generateInfo(params, event);
            params.putString("_audiencePropertyIds", MACARuleMatchingManager.getMatchPropertyIDs(params));
            params.putString("cs_maca", "1");
            MACARuleMatchingManager.removeGeneratedInfo(params);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @JvmStatic
    public static final void generateInfo(@NotNull Bundle params, @NotNull String event) {
        String string;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        params.putString("event", event);
        Object object = Utility.INSTANCE.getLocale();
        StringBuilder stringBuilder = new StringBuilder().append(object == null ? "" : ((string = ((Locale)object).getLanguage()) == null ? "" : string)).append('_');
        object = Utility.INSTANCE.getLocale();
        params.putString("_locale", stringBuilder.append(object == null ? "" : ((string = ((Locale)object).getCountry()) == null ? "" : string)).toString());
        object = Utility.INSTANCE.getVersionName();
        params.putString("_appVersion", (String)(object == null ? "" : object));
        params.putString("_deviceOS", "ANDROID");
        params.putString("_platform", "mobile");
        object = Build.MODEL;
        params.putString("_deviceModel", (String)(object == null ? "" : object));
        params.putString("_nativeAppID", FacebookSdk.INSTANCE.getApplicationId());
        object = Utility.INSTANCE.getVersionName();
        params.putString("_nativeAppShortVersion", (String)(object == null ? "" : object));
        params.putString("_timezone", Utility.INSTANCE.getDeviceTimeZoneName());
        params.putString("_carrier", Utility.INSTANCE.getCarrierName());
        params.putString("_deviceOSTypeName", "ANDROID");
        params.putString("_deviceOSVersion", Build.VERSION.RELEASE);
        params.putLong("_remainingDiskGB", Utility.INSTANCE.getAvailableExternalStorageGB());
    }

    @JvmStatic
    public static final void removeGeneratedInfo(@NotNull Bundle params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        for (String k : keys) {
            params.remove(k);
        }
    }

    static {
        String[] stringArray = new String[]{"event", "_locale", "_appVersion", "_deviceOS", "_platform", "_deviceModel", "_nativeAppID", "_nativeAppShortVersion", "_timezone", "_carrier", "_deviceOSTypeName", "_deviceOSVersion", "_remainingDiskGB"};
        keys = stringArray;
    }
}

