/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.iap;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.iap.InAppPurchaseActivityLifecycleTracker;
import com.facebook.appevents.iap.InAppPurchaseAutoLogger;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007J\b\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/appevents/iap/InAppPurchaseManager;", "", "()V", "GOOGLE_BILLINGCLIENT_VERSION", "", "enabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "enableAutoLogging", "", "startTracking", "usingBillingLib2Plus", "", "facebook-core_release"})
@AutoHandleExceptions
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class InAppPurchaseManager {
    @NotNull
    public static final InAppPurchaseManager INSTANCE = new InAppPurchaseManager();
    @NotNull
    private static final String GOOGLE_BILLINGCLIENT_VERSION = "com.google.android.play.billingclient.version";
    @NotNull
    private static final AtomicBoolean enabled = new AtomicBoolean(false);

    private InAppPurchaseManager() {
    }

    @JvmStatic
    public static final void enableAutoLogging() {
        enabled.set(true);
        INSTANCE.startTracking();
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmStatic
    public static final void startTracking() {
        if (!enabled.get()) return;
        if (INSTANCE.usingBillingLib2Plus()) {
            if (FeatureManager.isEnabled(FeatureManager.Feature.IapLoggingLib2)) {
                InAppPurchaseAutoLogger.startIapLogging(FacebookSdk.INSTANCE.getApplicationContext());
                return;
            }
        }
        InAppPurchaseActivityLifecycleTracker.INSTANCE.startIapLogging();
    }

    private final boolean usingBillingLib2Plus() {
        try {
            Context context = FacebookSdk.INSTANCE.getApplicationContext();
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"context.packageManager.getApplicationInfo(\n              context.packageName, PackageManager.GET_META_DATA)");
            ApplicationInfo info = applicationInfo;
            String version = info.metaData.getString(GOOGLE_BILLINGCLIENT_VERSION);
            if (version == null) {
                return false;
            }
            Object object = new String[]{"."};
            List versionArray = StringsKt.split$default((CharSequence)version, (String[])object, (boolean)false, (int)3, (int)2, null);
            object = (String)versionArray.get(0);
            boolean bl = false;
            return Integer.parseInt((String)object) >= 2;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
    }
}

