/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.Log;
import android.util.Patterns;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.aam.MetadataRule;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010 \u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020\u0004H\u0007J\r\u0010#\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b$J\b\u0010%\u001a\u00020!H\u0002J\b\u0010&\u001a\u00020!H\u0007J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0004H\u0002J\u0018\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0002J\u001c\u0010,\u001a\u00020!2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0016H\u0007J\u0012\u0010.\u001a\u00020!2\b\u0010-\u001a\u0004\u0018\u00010/H\u0007Jl\u0010.\u001a\u00020!2\b\u00100\u001a\u0004\u0018\u00010\u00042\b\u00101\u001a\u0004\u0018\u00010\u00042\b\u00102\u001a\u0004\u0018\u00010\u00042\b\u00103\u001a\u0004\u0018\u00010\u00042\b\u00104\u001a\u0004\u0018\u00010\u00042\b\u00105\u001a\u0004\u0018\u00010\u00042\b\u00106\u001a\u0004\u0018\u00010\u00042\b\u00107\u001a\u0004\u0018\u00010\u00042\b\u00108\u001a\u0004\u0018\u00010\u00042\b\u00109\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010:\u001a\u00020!2\b\u0010-\u001a\u0004\u0018\u00010/H\u0002J\u0018\u0010;\u001a\u00020!2\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0012*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/facebook/appevents/UserDataStore;", "", "()V", "CITY", "", "COUNTRY", "DATA_SEPARATOR", "DATE_OF_BIRTH", "EMAIL", "FIRST_NAME", "GENDER", "INTERNAL_USER_DATA_KEY", "LAST_NAME", "MAX_NUM", "", "PHONE", "STATE", "TAG", "kotlin.jvm.PlatformType", "USER_DATA_KEY", "ZIP", "enabledInternalUserData", "", "getEnabledInternalUserData", "()Ljava/util/Map;", "externalHashedUserData", "Ljava/util/concurrent/ConcurrentHashMap;", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "internalHashedUserData", "sharedPreferences", "Landroid/content/SharedPreferences;", "clear", "", "getAllHashedUserData", "getHashedUserData", "getHashedUserData$facebook_core_release", "initAndWait", "initStore", "maybeSHA256Hashed", "", "data", "normalizeData", "type", "setInternalUd", "ud", "setUserDataAndHash", "Landroid/os/Bundle;", "email", "firstName", "lastName", "phone", "dateOfBirth", "gender", "city", "state", "zip", "country", "updateHashUserData", "writeDataIntoCache", "key", "value", "facebook-core_release"})
@AutoHandleExceptions
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class UserDataStore {
    @NotNull
    public static final UserDataStore INSTANCE = new UserDataStore();
    private static final String TAG = UserDataStore.class.getSimpleName();
    @NotNull
    private static final String USER_DATA_KEY = "com.facebook.appevents.UserDataStore.userData";
    @NotNull
    private static final String INTERNAL_USER_DATA_KEY = "com.facebook.appevents.UserDataStore.internalUserData";
    private static SharedPreferences sharedPreferences;
    @NotNull
    private static final AtomicBoolean initialized;
    private static final int MAX_NUM = 5;
    @NotNull
    private static final String DATA_SEPARATOR = ",";
    @NotNull
    private static final ConcurrentHashMap<String, String> externalHashedUserData;
    @NotNull
    private static final ConcurrentHashMap<String, String> internalHashedUserData;
    @NotNull
    public static final String EMAIL = "em";
    @NotNull
    public static final String FIRST_NAME = "fn";
    @NotNull
    public static final String LAST_NAME = "ln";
    @NotNull
    public static final String PHONE = "ph";
    @NotNull
    public static final String DATE_OF_BIRTH = "db";
    @NotNull
    public static final String GENDER = "ge";
    @NotNull
    public static final String CITY = "ct";
    @NotNull
    public static final String STATE = "st";
    @NotNull
    public static final String ZIP = "zp";
    @NotNull
    public static final String COUNTRY = "country";

    private UserDataStore() {
    }

    @JvmStatic
    public static final void initStore() {
        if (initialized.get()) {
            return;
        }
        INSTANCE.initAndWait();
    }

    private final void writeDataIntoCache(String key, String value) {
        FacebookSdk.INSTANCE.getExecutor().execute(() -> UserDataStore.writeDataIntoCache$lambda-0(key, value));
    }

    @JvmStatic
    public static final void setUserDataAndHash(@Nullable Bundle ud) {
        InternalAppEventsLogger.Companion.getAnalyticsExecutor().execute(() -> UserDataStore.setUserDataAndHash$lambda-1(ud));
    }

    @JvmStatic
    public static final void setUserDataAndHash(@Nullable String email, @Nullable String firstName, @Nullable String lastName, @Nullable String phone, @Nullable String dateOfBirth, @Nullable String gender, @Nullable String city, @Nullable String state, @Nullable String zip, @Nullable String country) {
        Bundle ud = new Bundle();
        if (email != null) {
            ud.putString(EMAIL, email);
        }
        if (firstName != null) {
            ud.putString(FIRST_NAME, firstName);
        }
        if (lastName != null) {
            ud.putString(LAST_NAME, lastName);
        }
        if (phone != null) {
            ud.putString(PHONE, phone);
        }
        if (dateOfBirth != null) {
            ud.putString(DATE_OF_BIRTH, dateOfBirth);
        }
        if (gender != null) {
            ud.putString(GENDER, gender);
        }
        if (city != null) {
            ud.putString(CITY, city);
        }
        if (state != null) {
            ud.putString(STATE, state);
        }
        if (zip != null) {
            ud.putString(ZIP, zip);
        }
        if (country != null) {
            ud.putString(COUNTRY, country);
        }
        UserDataStore.setUserDataAndHash(ud);
    }

    @JvmStatic
    public static final void clear() {
        InternalAppEventsLogger.Companion.getAnalyticsExecutor().execute(UserDataStore::clear$lambda-2);
    }

    @JvmStatic
    @NotNull
    public static final String getHashedUserData$facebook_core_release() {
        if (!initialized.get()) {
            Log.w((String)TAG, (String)"initStore should have been called before calling setUserID");
            INSTANCE.initAndWait();
        }
        return Utility.mapToJsonStr((Map<String, String>)externalHashedUserData);
    }

    @JvmStatic
    @NotNull
    public static final String getAllHashedUserData() {
        if (!initialized.get()) {
            INSTANCE.initAndWait();
        }
        Map allHashedUserData = new HashMap();
        allHashedUserData.putAll((Map)externalHashedUserData);
        allHashedUserData.putAll(INSTANCE.getEnabledInternalUserData());
        return Utility.mapToJsonStr(allHashedUserData);
    }

    private final Map<String, String> getEnabledInternalUserData() {
        Map enabledInternalUD = new HashMap();
        Set<String> ruleNames = MetadataRule.Companion.getEnabledRuleNames();
        for (String ruleKey : internalHashedUserData.keySet()) {
            if (!ruleNames.contains(ruleKey)) continue;
            Map map = enabledInternalUD;
            Map map2 = internalHashedUserData;
            boolean bl = false;
            map2 = map2.get(ruleKey);
            bl = false;
            map.put(ruleKey, map2);
        }
        return enabledInternalUD;
    }

    private final synchronized void initAndWait() {
        String string;
        if (initialized.get()) {
            return;
        }
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)FacebookSdk.INSTANCE.getApplicationContext());
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getDefaultSharedPreferences(FacebookSdk.getApplicationContext())");
        Object object = UserDataStore.sharedPreferences = sharedPreferences;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            throw null;
        }
        String string2 = object.getString(USER_DATA_KEY, "");
        String externalUdRaw = string = string2 == null ? "" : string2;
        SharedPreferences sharedPreferences2 = UserDataStore.sharedPreferences;
        if (sharedPreferences2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            throw null;
        }
        object = sharedPreferences2.getString(INTERNAL_USER_DATA_KEY, "");
        String internalUdRaw = string2 = object == null ? "" : object;
        externalHashedUserData.putAll(Utility.jsonStrToMap(externalUdRaw));
        internalHashedUserData.putAll(Utility.jsonStrToMap(internalUdRaw));
        initialized.set(true);
    }

    private final void updateHashUserData(Bundle ud) {
        if (ud == null) {
            return;
        }
        for (String key : ud.keySet()) {
            boolean bl;
            Object object;
            Object object2 = ud.get(key);
            if (object2 == null) continue;
            Object object3 = object2;
            Object rawVal = object3;
            String value = rawVal.toString();
            if (this.maybeSHA256Hashed(value)) {
                object2 = externalHashedUserData;
                object = value;
                bl = false;
                String string = object;
                if (string == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = string.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
                object = string2;
                bl = false;
                object2.put(key, object);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            String encryptedValue = Utility.sha256hash(this.normalizeData(key, value));
            if (encryptedValue == null) continue;
            object = externalHashedUserData;
            bl = false;
            object.put(key, encryptedValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void setInternalUd(@NotNull Map<String, String> ud) {
        Intrinsics.checkNotNullParameter(ud, (String)"ud");
        if (!initialized.get()) {
            INSTANCE.initAndWait();
        }
        Object object = ud;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            int index$iv$iv;
            void $this$trim$iv;
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            String key = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            String rawVal = (String)object3.getValue();
            Object object4 = rawVal;
            String string = key;
            UserDataStore userDataStore = INSTANCE;
            boolean $i$f$trim = false;
            String[] $this$trim$iv$iv = (String[])$this$trim$iv;
            boolean $i$f$trim22 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv2 = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv2 = false;
            while (startIndex$iv$iv <= endIndex$iv$iv2) {
                boolean match$iv$iv;
                index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv : endIndex$iv$iv2;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl4 = false;
                boolean bl5 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv2) {
                    if (!match$iv$iv) {
                        startFound$iv$iv2 = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv2;
            }
            String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv2 + 1)).toString();
            String value = Utility.sha256hash(userDataStore.normalizeData(string, string2));
            if (internalHashedUserData.containsKey(key)) {
                String[] stringArray;
                String originalVal = internalHashedUserData.get(key);
                String $i$f$trim22 = originalVal;
                if ($i$f$trim22 == null) {
                    stringArray = null;
                } else {
                    CharSequence endIndex$iv$iv2 = $i$f$trim22;
                    String startFound$iv$iv2 = DATA_SEPARATOR;
                    index$iv$iv = 0;
                    startFound$iv$iv2 = new Regex(startFound$iv$iv2);
                    index$iv$iv = 0;
                    boolean bl6 = false;
                    List list = startFound$iv$iv2.split(endIndex$iv$iv2, index$iv$iv);
                    if (list == null) {
                        stringArray = null;
                    } else {
                        Collection $this$toTypedArray$iv = list;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                        if (stringArray2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        stringArray = stringArray2;
                    }
                }
                $this$trim$iv$iv = stringArray;
                String[] previousData = $this$trim$iv$iv == null ? new String[]{} : $this$trim$iv$iv;
                Set set = SetsKt.mutableSetOf((Object[])Arrays.copyOf(previousData, previousData.length));
                if (set.contains(value)) {
                    return;
                }
                StringBuilder sb = new StringBuilder();
                String[] stringArray3 = previousData;
                int n = 0;
                if (stringArray3.length == 0) {
                    sb.append(value);
                } else if (previousData.length < 5) {
                    sb.append(originalVal).append(DATA_SEPARATOR).append(value);
                } else {
                    int n2 = 1;
                    n = 5;
                    do {
                        int i = n2++;
                        sb.append(previousData[i]).append(DATA_SEPARATOR);
                    } while (n2 < n);
                    sb.append(value);
                    set.remove(previousData[0]);
                }
                Map map = internalHashedUserData;
                String string3 = sb.toString();
                boolean bl7 = false;
                map.put(key, string3);
                continue;
            }
            object4 = internalHashedUserData;
            boolean bl8 = false;
            object4.put(key, value);
        }
        INSTANCE.writeDataIntoCache(INTERNAL_USER_DATA_KEY, Utility.mapToJsonStr((Map<String, String>)internalHashedUserData));
    }

    private final String normalizeData(String type, String data) {
        boolean bl;
        String data2;
        String $this$trim$iv = data2 = data;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl2 = false;
            boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        CharSequence charSequence = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        int n = 0;
        String string = charSequence;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        data2 = string2;
        if (Intrinsics.areEqual((Object)EMAIL, (Object)type)) {
            String string3;
            if (Patterns.EMAIL_ADDRESS.matcher(data2).matches()) {
                string3 = data2;
            } else {
                Log.e((String)TAG, (String)"Setting email failure: this is not a valid email address");
                string3 = "";
            }
            return string3;
        }
        if (Intrinsics.areEqual((Object)PHONE, (Object)type)) {
            charSequence = data2;
            String string4 = "[^0-9]";
            boolean bl4 = false;
            string4 = new Regex(string4);
            String string5 = "";
            bl = false;
            return string4.replace(charSequence, string5);
        }
        if (Intrinsics.areEqual((Object)GENDER, (Object)type)) {
            String string6;
            String string7;
            charSequence = data2;
            n = 0;
            if (charSequence.length() > 0) {
                charSequence = data2;
                n = 0;
                int n2 = 1;
                bl = false;
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = ((String)charSequence2).substring(n, n2);
                string7 = string8;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string7 = data2 = "";
            }
            if (Intrinsics.areEqual((Object)"f", (Object)data2) || Intrinsics.areEqual((Object)"m", (Object)data2)) {
                string6 = data2;
            } else {
                Log.e((String)TAG, (String)"Setting gender failure: the supported value for gender is f or m");
                string6 = "";
            }
            return string6;
        }
        return data2;
    }

    private final boolean maybeSHA256Hashed(String data) {
        CharSequence charSequence = data;
        Regex regex = new Regex("[A-Fa-f0-9]{64}");
        boolean bl = false;
        return regex.matches(charSequence);
    }

    private static final void writeDataIntoCache$lambda-0(String $key, String $value) {
        SharedPreferences sharedPreferences;
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        if (!initialized.get()) {
            INSTANCE.initAndWait();
        }
        if ((sharedPreferences = UserDataStore.sharedPreferences) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            throw null;
        }
        sharedPreferences.edit().putString($key, $value).apply();
    }

    private static final void setUserDataAndHash$lambda-1(Bundle $ud) {
        if (!initialized.get()) {
            Log.w((String)TAG, (String)"initStore should have been called before calling setUserData");
            INSTANCE.initAndWait();
        }
        INSTANCE.updateHashUserData($ud);
        INSTANCE.writeDataIntoCache(USER_DATA_KEY, Utility.mapToJsonStr((Map<String, String>)externalHashedUserData));
        INSTANCE.writeDataIntoCache(INTERNAL_USER_DATA_KEY, Utility.mapToJsonStr((Map<String, String>)internalHashedUserData));
    }

    private static final void clear$lambda-2() {
        if (!initialized.get()) {
            Log.w((String)TAG, (String)"initStore should have been called before calling setUserData");
            INSTANCE.initAndWait();
        }
        externalHashedUserData.clear();
        SharedPreferences sharedPreferences = UserDataStore.sharedPreferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            throw null;
        }
        sharedPreferences.edit().putString(USER_DATA_KEY, null).apply();
    }

    static {
        initialized = new AtomicBoolean(false);
        externalHashedUserData = new ConcurrentHashMap();
        internalHashedUserData = new ConcurrentHashMap();
    }
}

