/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.AccessTokenAppIdPair;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.AppEventCollection;
import com.facebook.appevents.AppEventDiskStore;
import com.facebook.appevents.AppEventStore;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.AppEventsLoggerImpl;
import com.facebook.appevents.FlushReason;
import com.facebook.appevents.FlushResult;
import com.facebook.appevents.FlushStatistics;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.PersistedEvents;
import com.facebook.appevents.SessionEventsState;
import com.facebook.appevents.cloudbridge.AppEventsCAPIManager;
import com.facebook.appevents.cloudbridge.AppEventsConversionsAPITransformerWebRequests;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Logger;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J*\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190!2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u001fH\u0007J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%H\u0007J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%H\u0007J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150(H\u0007J0\u0010)\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\b\u0010-\u001a\u00020\u0013H\u0007J\u001a\u0010.\u001a\u0004\u0018\u00010\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \t*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/facebook/appevents/AppEventQueue;", "", "()V", "FLUSH_PERIOD_IN_SECONDS", "", "NO_CONNECTIVITY_ERROR_CODE", "NUM_LOG_EVENTS_TO_TRY_TO_FLUSH_AFTER", "TAG", "", "kotlin.jvm.PlatformType", "appEventCollection", "Lcom/facebook/appevents/AppEventCollection;", "flushRunnable", "Ljava/lang/Runnable;", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "singleThreadExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "add", "", "accessTokenAppId", "Lcom/facebook/appevents/AccessTokenAppIdPair;", "appEvent", "Lcom/facebook/appevents/AppEvent;", "buildRequestForSession", "Lcom/facebook/GraphRequest;", "appEvents", "Lcom/facebook/appevents/SessionEventsState;", "limitEventUsage", "", "flushState", "Lcom/facebook/appevents/FlushStatistics;", "buildRequests", "", "flushResults", "flush", "reason", "Lcom/facebook/appevents/FlushReason;", "flushAndWait", "getKeySet", "", "handleResponse", "request", "response", "Lcom/facebook/GraphResponse;", "persistToDisk", "sendEventsToServer", "facebook-core_release"})
@AutoHandleExceptions
public final class AppEventQueue {
    @NotNull
    public static final AppEventQueue INSTANCE = new AppEventQueue();
    private static final String TAG = AppEventQueue.class.getName();
    private static final int NUM_LOG_EVENTS_TO_TRY_TO_FLUSH_AFTER = 100;
    private static final int FLUSH_PERIOD_IN_SECONDS = 15;
    private static final int NO_CONNECTIVITY_ERROR_CODE = -1;
    @NotNull
    private static volatile AppEventCollection appEventCollection = new AppEventCollection();
    private static final ScheduledExecutorService singleThreadExecutor = Executors.newSingleThreadScheduledExecutor();
    @Nullable
    private static ScheduledFuture<?> scheduledFuture;
    @NotNull
    private static final Runnable flushRunnable;

    private AppEventQueue() {
    }

    @JvmStatic
    public static final void persistToDisk() {
        singleThreadExecutor.execute(AppEventQueue::persistToDisk$lambda-1);
    }

    @JvmStatic
    public static final void flush(@NotNull FlushReason reason) {
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        singleThreadExecutor.execute(() -> AppEventQueue.flush$lambda-2(reason));
    }

    @JvmStatic
    public static final void add(@NotNull AccessTokenAppIdPair accessTokenAppId, @NotNull AppEvent appEvent) {
        Intrinsics.checkNotNullParameter((Object)accessTokenAppId, (String)"accessTokenAppId");
        Intrinsics.checkNotNullParameter((Object)appEvent, (String)"appEvent");
        singleThreadExecutor.execute(() -> AppEventQueue.add$lambda-3(accessTokenAppId, appEvent));
    }

    @JvmStatic
    @NotNull
    public static final Set<AccessTokenAppIdPair> getKeySet() {
        return appEventCollection.keySet();
    }

    @JvmStatic
    public static final void flushAndWait(@NotNull FlushReason reason) {
        FlushStatistics flushStatistics;
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        PersistedEvents result = AppEventDiskStore.INSTANCE.readAndClearStore();
        appEventCollection.addPersistedEvents(result);
        FlushStatistics flushResults = null;
        try {
            flushStatistics = AppEventQueue.sendEventsToServer(reason, appEventCollection);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Caught unexpected exception while flushing app events: ", (Throwable)e);
            return;
        }
        flushResults = flushStatistics;
        if (flushResults != null) {
            Intent intent = new Intent("com.facebook.sdk.APP_EVENTS_FLUSHED");
            intent.putExtra("com.facebook.sdk.APP_EVENTS_NUM_EVENTS_FLUSHED", flushResults.getNumEvents());
            intent.putExtra("com.facebook.sdk.APP_EVENTS_FLUSH_RESULT", (Serializable)((Object)flushResults.getResult()));
            Context context = FacebookSdk.INSTANCE.getApplicationContext();
            LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
        }
    }

    @JvmStatic
    @VisibleForTesting(otherwise=2)
    @Nullable
    public static final FlushStatistics sendEventsToServer(@NotNull FlushReason reason, @NotNull AppEventCollection appEventCollection) {
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        Intrinsics.checkNotNullParameter((Object)appEventCollection, (String)"appEventCollection");
        FlushStatistics flushResults = new FlushStatistics();
        List<GraphRequest> requestsToExecute = AppEventQueue.buildRequests(appEventCollection, flushResults);
        Object object = requestsToExecute;
        boolean bl = false;
        if (!object.isEmpty()) {
            object = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"TAG");
            Object[] objectArray = object;
            object = new Object[]{flushResults.getNumEvents(), reason.toString()};
            Logger.Companion.log(LoggingBehavior.APP_EVENTS, (String)objectArray, "Flushing %d events due to %s.", (Object[])object);
            for (GraphRequest request : requestsToExecute) {
                request.executeAndWait();
            }
            return flushResults;
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final List<GraphRequest> buildRequests(@NotNull AppEventCollection appEventCollection, @NotNull FlushStatistics flushResults) {
        Intrinsics.checkNotNullParameter((Object)appEventCollection, (String)"appEventCollection");
        Intrinsics.checkNotNullParameter((Object)flushResults, (String)"flushResults");
        Context context = FacebookSdk.INSTANCE.getApplicationContext();
        boolean limitEventUsage = FacebookSdk.getLimitEventAndDataUsage(context);
        ArrayList<GraphRequest> requestsToExecute = new ArrayList<GraphRequest>();
        for (AccessTokenAppIdPair accessTokenAppId : appEventCollection.keySet()) {
            SessionEventsState sessionEventsState = appEventCollection.get(accessTokenAppId);
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (sessionEventsState == null) {
                boolean bl4 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            GraphRequest request = AppEventQueue.buildRequestForSession(accessTokenAppId, sessionEventsState, limitEventUsage, flushResults);
            if (request == null) continue;
            requestsToExecute.add(request);
            if (!AppEventsCAPIManager.INSTANCE.isEnabled$facebook_core_release()) continue;
            AppEventsConversionsAPITransformerWebRequests.transformGraphRequestAndSendToCAPIGEndPoint(request);
        }
        return requestsToExecute;
    }

    @JvmStatic
    @Nullable
    public static final GraphRequest buildRequestForSession(@NotNull AccessTokenAppIdPair accessTokenAppId, @NotNull SessionEventsState appEvents, boolean limitEventUsage, @NotNull FlushStatistics flushState) {
        int numEvents;
        String installReferrer;
        Intrinsics.checkNotNullParameter((Object)accessTokenAppId, (String)"accessTokenAppId");
        Intrinsics.checkNotNullParameter((Object)appEvents, (String)"appEvents");
        Intrinsics.checkNotNullParameter((Object)flushState, (String)"flushState");
        String applicationId = accessTokenAppId.getApplicationId();
        FetchedAppSettings fetchedAppSettings = FetchedAppSettingsManager.queryAppSettings(applicationId, false);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s/activities";
        Object[] objectArray = new Object[]{applicationId};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        GraphRequest postRequest = GraphRequest.Companion.newPostRequest(null, string2, null, null);
        postRequest.setForceApplicationRequest(true);
        Bundle requestParameters = postRequest.getParameters();
        if (requestParameters == null) {
            requestParameters = new Bundle();
        }
        requestParameters.putString("access_token", accessTokenAppId.getAccessTokenString());
        String pushNotificationsRegistrationId = InternalAppEventsLogger.Companion.getPushNotificationsRegistrationId();
        if (pushNotificationsRegistrationId != null) {
            requestParameters.putString("device_token", pushNotificationsRegistrationId);
        }
        if ((installReferrer = AppEventsLoggerImpl.Companion.getInstallReferrer()) != null) {
            requestParameters.putString("install_referrer", installReferrer);
        }
        postRequest.setParameters(requestParameters);
        boolean supportsImplicitLogging = false;
        if (fetchedAppSettings != null) {
            supportsImplicitLogging = fetchedAppSettings.supportsImplicitLogging();
        }
        if ((numEvents = appEvents.populateRequest(postRequest, FacebookSdk.INSTANCE.getApplicationContext(), supportsImplicitLogging, limitEventUsage)) == 0) {
            return null;
        }
        FlushStatistics flushStatistics = flushState;
        flushStatistics.setNumEvents(flushStatistics.getNumEvents() + numEvents);
        postRequest.setCallback(arg_0 -> AppEventQueue.buildRequestForSession$lambda-4(accessTokenAppId, postRequest, appEvents, flushState, arg_0));
        return postRequest;
    }

    @JvmStatic
    public static final void handleResponse(@NotNull AccessTokenAppIdPair accessTokenAppId, @NotNull GraphRequest request, @NotNull GraphResponse response, @NotNull SessionEventsState appEvents, @NotNull FlushStatistics flushState) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)accessTokenAppId, (String)"accessTokenAppId");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)appEvents, (String)"appEvents");
        Intrinsics.checkNotNullParameter((Object)flushState, (String)"flushState");
        FacebookRequestError error = response.getError();
        String resultDescription = "Success";
        FlushResult flushResult = FlushResult.SUCCESS;
        if (error != null) {
            if (error.getErrorCode() == -1) {
                resultDescription = "Failed: No Connectivity";
                flushResult = FlushResult.NO_CONNECTIVITY;
            } else {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "Failed:\n  Response: %s\n  Error %s";
                objectArray = new Object[]{response.toString(), error.toString()};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                resultDescription = string2;
                flushResult = FlushResult.SERVER_ERROR;
            }
        }
        if (FacebookSdk.isLoggingBehaviorEnabled(LoggingBehavior.APP_EVENTS)) {
            String eventsJsonString = (String)request.getTag();
            Object prettyPrintedEvents = null;
            try {
                JSONArray jsonArray = new JSONArray(eventsJsonString);
                objectArray = jsonArray.toString(2);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"{\n            val jsonArray = JSONArray(eventsJsonString)\n            jsonArray.toString(2)\n          }");
            }
            catch (JSONException exc) {
                objectArray = "<Can't encode events for debug logging>";
            }
            prettyPrintedEvents = objectArray;
            objectArray = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"TAG");
            Object[] objectArray2 = objectArray;
            objectArray = new Object[]{String.valueOf(request.getGraphObject()), resultDescription, prettyPrintedEvents};
            Logger.Companion.log(LoggingBehavior.APP_EVENTS, (String)objectArray2, "Flush completed\nParams: %s\n  Result: %s\n  Events JSON: %s", objectArray);
        }
        appEvents.clearInFlightAndStats(error != null);
        if (flushResult == FlushResult.NO_CONNECTIVITY) {
            FacebookSdk.INSTANCE.getExecutor().execute(() -> AppEventQueue.handleResponse$lambda-5(accessTokenAppId, appEvents));
        }
        if (flushResult != FlushResult.SUCCESS && flushState.getResult() != FlushResult.NO_CONNECTIVITY) {
            flushState.setResult(flushResult);
        }
    }

    private static final void flushRunnable$lambda-0() {
        scheduledFuture = null;
        if (AppEventsLogger.Companion.getFlushBehavior() != AppEventsLogger.FlushBehavior.EXPLICIT_ONLY) {
            AppEventQueue.flushAndWait(FlushReason.TIMER);
        }
    }

    private static final void persistToDisk$lambda-1() {
        AppEventStore.persistEvents(appEventCollection);
        appEventCollection = new AppEventCollection();
    }

    private static final void flush$lambda-2(FlushReason $reason) {
        Intrinsics.checkNotNullParameter((Object)((Object)$reason), (String)"$reason");
        AppEventQueue.flushAndWait($reason);
    }

    private static final void add$lambda-3(AccessTokenAppIdPair $accessTokenAppId, AppEvent $appEvent) {
        Intrinsics.checkNotNullParameter((Object)$accessTokenAppId, (String)"$accessTokenAppId");
        Intrinsics.checkNotNullParameter((Object)$appEvent, (String)"$appEvent");
        appEventCollection.addEvent($accessTokenAppId, $appEvent);
        if (AppEventsLogger.Companion.getFlushBehavior() != AppEventsLogger.FlushBehavior.EXPLICIT_ONLY && appEventCollection.getEventCount() > NUM_LOG_EVENTS_TO_TRY_TO_FLUSH_AFTER) {
            AppEventQueue.flushAndWait(FlushReason.EVENT_THRESHOLD);
        } else if (scheduledFuture == null) {
            scheduledFuture = singleThreadExecutor.schedule(flushRunnable, 15L, TimeUnit.SECONDS);
        }
    }

    private static final void buildRequestForSession$lambda-4(AccessTokenAppIdPair $accessTokenAppId, GraphRequest $postRequest, SessionEventsState $appEvents, FlushStatistics $flushState, GraphResponse response) {
        Intrinsics.checkNotNullParameter((Object)$accessTokenAppId, (String)"$accessTokenAppId");
        Intrinsics.checkNotNullParameter((Object)$postRequest, (String)"$postRequest");
        Intrinsics.checkNotNullParameter((Object)$appEvents, (String)"$appEvents");
        Intrinsics.checkNotNullParameter((Object)$flushState, (String)"$flushState");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        AppEventQueue.handleResponse($accessTokenAppId, $postRequest, response, $appEvents, $flushState);
    }

    private static final void handleResponse$lambda-5(AccessTokenAppIdPair $accessTokenAppId, SessionEventsState $appEvents) {
        Intrinsics.checkNotNullParameter((Object)$accessTokenAppId, (String)"$accessTokenAppId");
        Intrinsics.checkNotNullParameter((Object)$appEvents, (String)"$appEvents");
        AppEventStore.persistEvents($accessTokenAppId, $appEvents);
    }

    static {
        flushRunnable = AppEventQueue::flushRunnable$lambda-0;
    }
}

