/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.FacebookSdkNotInitializedException;
import com.facebook.GraphRequest;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0010\b\u00c1\u0002\u0018\u00002\u00020\u0001:\u00018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0007J\b\u0010 \u001a\u00020\u001fH\u0007J\b\u0010!\u001a\u00020\u001fH\u0007J\b\u0010\"\u001a\u00020\u001fH\u0007J\b\u0010#\u001a\u00020\u001fH\u0007J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0002J!\u0010'\u001a\u00020%2\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140)\"\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020\u0014H\u0002J\b\u0010-\u001a\u00020%H\u0007J\b\u0010.\u001a\u00020%H\u0002J\b\u0010/\u001a\u00020%H\u0002J\u0010\u00100\u001a\u00020%2\u0006\u0010,\u001a\u00020\u0014H\u0002J\u0010\u00101\u001a\u00020%2\u0006\u00102\u001a\u00020\u001fH\u0007J\u0010\u00103\u001a\u00020%2\u0006\u00102\u001a\u00020\u001fH\u0007J\u0010\u00104\u001a\u00020%2\u0006\u00102\u001a\u00020\u001fH\u0007J\u0010\u00105\u001a\u00020%2\u0006\u00102\u001a\u00020\u001fH\u0007J\b\u00106\u001a\u00020%H\u0002J\u0010\u00107\u001a\u00020%2\u0006\u0010,\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \r*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/facebook/UserSettingsManager;", "", "()V", "ADVERTISERID_COLLECTION_FALSE_WARNING", "", "ADVERTISERID_COLLECTION_NOT_SET_WARNING", "ADVERTISER_ID_KEY", "APPLICATION_FIELDS", "AUTOLOG_APPEVENT_NOT_SET_WARNING", "AUTO_APP_LINK_WARNING", "EVENTS_CODELESS_SETUP_ENABLED", "LAST_TIMESTAMP", "TAG", "kotlin.jvm.PlatformType", "TIMEOUT_7D", "", "USER_SETTINGS", "USER_SETTINGS_BITMASK", "VALUE", "advertiserIDCollectionEnabled", "Lcom/facebook/UserSettingsManager$UserSetting;", "autoInitEnabled", "autoLogAppEventsEnabled", "codelessSetupEnabled", "isFetchingCodelessStatus", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isInitialized", "monitorEnabled", "userSettingPref", "Landroid/content/SharedPreferences;", "getAdvertiserIDCollectionEnabled", "", "getAutoInitEnabled", "getAutoLogAppEventsEnabled", "getCodelessSetupEnabled", "getMonitorEnabled", "initializeCodelessSetupEnabledAsync", "", "initializeIfNotInitialized", "initializeUserSetting", "userSettings", "", "([Lcom/facebook/UserSettingsManager$UserSetting;)V", "loadSettingFromManifest", "userSetting", "logIfAutoAppLinkEnabled", "logIfSDKSettingsChanged", "logWarnings", "readSettingFromCache", "setAdvertiserIDCollectionEnabled", "flag", "setAutoInitEnabled", "setAutoLogAppEventsEnabled", "setMonitorEnabled", "validateInitialized", "writeSettingToCache", "UserSetting", "facebook-core_release"})
@AutoHandleExceptions
public final class UserSettingsManager {
    @NotNull
    public static final UserSettingsManager INSTANCE = new UserSettingsManager();
    private static final String TAG = UserSettingsManager.class.getName();
    @NotNull
    private static final AtomicBoolean isInitialized = new AtomicBoolean(false);
    @NotNull
    private static final AtomicBoolean isFetchingCodelessStatus = new AtomicBoolean(false);
    @NotNull
    private static final String EVENTS_CODELESS_SETUP_ENABLED = "auto_event_setup_enabled";
    private static final long TIMEOUT_7D = 604800000L;
    @NotNull
    private static final String ADVERTISER_ID_KEY = "advertiser_id";
    @NotNull
    private static final String APPLICATION_FIELDS = "fields";
    @NotNull
    private static final UserSetting autoInitEnabled = new UserSetting(true, "com.facebook.sdk.AutoInitEnabled");
    @NotNull
    private static final UserSetting autoLogAppEventsEnabled = new UserSetting(true, "com.facebook.sdk.AutoLogAppEventsEnabled");
    @NotNull
    private static final UserSetting advertiserIDCollectionEnabled = new UserSetting(true, "com.facebook.sdk.AdvertiserIDCollectionEnabled");
    @NotNull
    private static final UserSetting codelessSetupEnabled = new UserSetting(false, "auto_event_setup_enabled");
    @NotNull
    private static final UserSetting monitorEnabled = new UserSetting(true, "com.facebook.sdk.MonitorEnabled");
    @NotNull
    private static final String USER_SETTINGS = "com.facebook.sdk.USER_SETTINGS";
    @NotNull
    private static final String USER_SETTINGS_BITMASK = "com.facebook.sdk.USER_SETTINGS_BITMASK";
    private static SharedPreferences userSettingPref;
    @NotNull
    private static final String LAST_TIMESTAMP = "last_timestamp";
    @NotNull
    private static final String VALUE = "value";
    @NotNull
    private static final String AUTOLOG_APPEVENT_NOT_SET_WARNING = "Please set a value for AutoLogAppEventsEnabled. Set the flag to TRUE if you want to collect app install, app launch and in-app purchase events automatically. To request user consent before collecting data, set the flag value to FALSE, then change to TRUE once user consent is received. Learn more: https://developers.facebook.com/docs/app-events/getting-started-app-events-android#disable-auto-events.";
    @NotNull
    private static final String ADVERTISERID_COLLECTION_NOT_SET_WARNING = "You haven't set a value for AdvertiserIDCollectionEnabled. Set the flag to TRUE if you want to collect Advertiser ID for better advertising and analytics results. To request user consent before collecting data, set the flag value to FALSE, then change to TRUE once user consent is received. Learn more: https://developers.facebook.com/docs/app-events/getting-started-app-events-android#disable-auto-events.";
    @NotNull
    private static final String ADVERTISERID_COLLECTION_FALSE_WARNING = "The value for AdvertiserIDCollectionEnabled is currently set to FALSE so you're sending app events without collecting Advertiser ID. This can affect the quality of your advertising and analytics results.";
    @NotNull
    private static final String AUTO_APP_LINK_WARNING = "You haven't set the Auto App Link URL scheme: fb<YOUR APP ID> in AndroidManifest";

    private UserSettingsManager() {
    }

    private final void initializeIfNotInitialized() {
        if (!FacebookSdk.INSTANCE.isInitialized()) {
            return;
        }
        if (!isInitialized.compareAndSet(false, true)) {
            return;
        }
        UserSetting[] userSettingArray = FacebookSdk.INSTANCE.getApplicationContext().getSharedPreferences(USER_SETTINGS, 0);
        Intrinsics.checkNotNullExpressionValue((Object)userSettingArray, (String)"FacebookSdk.getApplicationContext()\n            .getSharedPreferences(USER_SETTINGS, Context.MODE_PRIVATE)");
        userSettingPref = userSettingArray;
        userSettingArray = new UserSetting[]{autoLogAppEventsEnabled, advertiserIDCollectionEnabled, autoInitEnabled};
        this.initializeUserSetting(userSettingArray);
        this.initializeCodelessSetupEnabledAsync();
        this.logWarnings();
        this.logIfSDKSettingsChanged();
    }

    private final void initializeUserSetting(UserSetting ... userSettings) {
        for (UserSetting userSetting : userSettings) {
            if (userSetting == codelessSetupEnabled) {
                this.initializeCodelessSetupEnabledAsync();
                continue;
            }
            if (userSetting.getValue() == null) {
                this.readSettingFromCache(userSetting);
                if (userSetting.getValue() != null) continue;
                this.loadSettingFromManifest(userSetting);
                continue;
            }
            this.writeSettingToCache(userSetting);
        }
    }

    private final void initializeCodelessSetupEnabledAsync() {
        this.readSettingFromCache(codelessSetupEnabled);
        long currTime = System.currentTimeMillis();
        if (codelessSetupEnabled.getValue() != null && currTime - codelessSetupEnabled.getLastTS() < 604800000L) {
            return;
        }
        codelessSetupEnabled.setValue(null);
        codelessSetupEnabled.setLastTS(0L);
        if (!isFetchingCodelessStatus.compareAndSet(false, true)) {
            return;
        }
        FacebookSdk.INSTANCE.getExecutor().execute(() -> UserSettingsManager.initializeCodelessSetupEnabledAsync$lambda-0(currTime));
    }

    private final void writeSettingToCache(UserSetting userSetting) {
        this.validateInitialized();
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(VALUE, (Object)userSetting.getValue());
            jsonObject.put(LAST_TIMESTAMP, userSetting.getLastTS());
            SharedPreferences sharedPreferences = userSettingPref;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"userSettingPref");
                throw null;
            }
            sharedPreferences.edit().putString(userSetting.getKey(), jsonObject.toString()).apply();
            this.logIfSDKSettingsChanged();
        }
        catch (Exception e) {
            Utility.logd(TAG, e);
        }
    }

    private final void readSettingFromCache(UserSetting userSetting) {
        this.validateInitialized();
        try {
            SharedPreferences sharedPreferences = userSettingPref;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"userSettingPref");
                throw null;
            }
            String string = sharedPreferences.getString(userSetting.getKey(), "");
            CharSequence charSequence = string == null ? "" : string;
            String settingStr = charSequence;
            charSequence = settingStr;
            boolean bl = false;
            if (charSequence.length() > 0) {
                JSONObject setting = new JSONObject(settingStr);
                userSetting.setValue(setting.getBoolean(VALUE));
                userSetting.setLastTS(setting.getLong(LAST_TIMESTAMP));
            }
        }
        catch (JSONException je) {
            Utility.logd(TAG, (Exception)((Object)je));
        }
    }

    private final void loadSettingFromManifest(UserSetting userSetting) {
        this.validateInitialized();
        try {
            ApplicationInfo ai;
            Context ctx = FacebookSdk.INSTANCE.getApplicationContext();
            ApplicationInfo applicationInfo = ctx.getPackageManager().getApplicationInfo(ctx.getPackageName(), 128);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ctx.packageManager.getApplicationInfo(ctx.packageName, PackageManager.GET_META_DATA)");
            applicationInfo = ai = applicationInfo;
            if (applicationInfo.metaData != null && ai.metaData.containsKey(userSetting.getKey())) {
                userSetting.setValue(ai.metaData.getBoolean(userSetting.getKey(), userSetting.getDefaultVal()));
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Utility.logd(TAG, (Exception)((Object)e));
        }
    }

    private final void logWarnings() {
        try {
            ApplicationInfo ai;
            Context ctx = FacebookSdk.INSTANCE.getApplicationContext();
            ApplicationInfo applicationInfo = ctx.getPackageManager().getApplicationInfo(ctx.getPackageName(), 128);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ctx.packageManager.getApplicationInfo(ctx.packageName, PackageManager.GET_META_DATA)");
            applicationInfo = ai = applicationInfo;
            if (applicationInfo.metaData != null) {
                if (!ai.metaData.containsKey("com.facebook.sdk.AutoLogAppEventsEnabled")) {
                    Log.w((String)TAG, (String)AUTOLOG_APPEVENT_NOT_SET_WARNING);
                }
                if (!ai.metaData.containsKey("com.facebook.sdk.AdvertiserIDCollectionEnabled")) {
                    Log.w((String)TAG, (String)ADVERTISERID_COLLECTION_NOT_SET_WARNING);
                }
                if (!UserSettingsManager.getAdvertiserIDCollectionEnabled()) {
                    Log.w((String)TAG, (String)ADVERTISERID_COLLECTION_FALSE_WARNING);
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    private final void logIfSDKSettingsChanged() {
        if (!isInitialized.get()) {
            return;
        }
        if (!FacebookSdk.INSTANCE.isInitialized()) {
            return;
        }
        Context ctx = FacebookSdk.INSTANCE.getApplicationContext();
        int bitmask = 0;
        int bit = 0;
        int n = bit;
        bit = n + 1;
        bitmask |= (autoInitEnabled.getValue() ? 1 : 0) << n;
        n = bit;
        bit = n + 1;
        bitmask |= (autoLogAppEventsEnabled.getValue() ? 1 : 0) << n;
        n = bit;
        bit = n + 1;
        bitmask |= (advertiserIDCollectionEnabled.getValue() ? 1 : 0) << n;
        n = bit;
        bit = n + 1;
        bitmask |= (monitorEnabled.getValue() ? 1 : 0) << n;
        SharedPreferences sharedPreferences = userSettingPref;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userSettingPref");
            throw null;
        }
        int previousBitmask = sharedPreferences.getInt(USER_SETTINGS_BITMASK, 0);
        if (previousBitmask != bitmask) {
            sharedPreferences = userSettingPref;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"userSettingPref");
                throw null;
            }
            sharedPreferences.edit().putInt(USER_SETTINGS_BITMASK, bitmask).apply();
            int initialBitmask = 0;
            int usageBitmask = 0;
            try {
                ApplicationInfo ai;
                ApplicationInfo applicationInfo = ctx.getPackageManager().getApplicationInfo(ctx.getPackageName(), 128);
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ctx.packageManager.getApplicationInfo(ctx.packageName, PackageManager.GET_META_DATA)");
                applicationInfo = ai = applicationInfo;
                if (applicationInfo.metaData != null) {
                    String[] stringArray = new String[]{"com.facebook.sdk.AutoInitEnabled", "com.facebook.sdk.AutoLogAppEventsEnabled", "com.facebook.sdk.AdvertiserIDCollectionEnabled", "com.facebook.sdk.MonitorEnabled"};
                    String[] keys = stringArray;
                    boolean[] blArray = new boolean[]{true, true, true, true};
                    boolean[] defaultValues = blArray;
                    int n2 = 0;
                    int n3 = keys.length + -1;
                    if (n2 <= n3) {
                        do {
                            int i;
                            usageBitmask |= (ai.metaData.containsKey(keys[i = n2++]) ? 1 : 0) << i;
                            boolean initialValue = ai.metaData.getBoolean(keys[i], defaultValues[i]);
                            initialBitmask |= (initialValue ? 1 : 0) << i;
                        } while (n2 <= n3);
                    }
                }
            }
            catch (PackageManager.NameNotFoundException ai) {
                // empty catch block
            }
            InternalAppEventsLogger logger = new InternalAppEventsLogger(ctx);
            Bundle parameters = new Bundle();
            parameters.putInt("usage", usageBitmask);
            parameters.putInt("initial", initialBitmask);
            parameters.putInt("previous", previousBitmask);
            parameters.putInt("current", bitmask);
            logger.logChangedSettingsEvent(parameters);
        }
    }

    @JvmStatic
    public static final void logIfAutoAppLinkEnabled() {
        try {
            ApplicationInfo ai;
            Context ctx = FacebookSdk.INSTANCE.getApplicationContext();
            ApplicationInfo applicationInfo = ctx.getPackageManager().getApplicationInfo(ctx.getPackageName(), 128);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ctx.packageManager.getApplicationInfo(ctx.packageName, PackageManager.GET_META_DATA)");
            applicationInfo = ai = applicationInfo;
            if (applicationInfo.metaData != null && ai.metaData.getBoolean("com.facebook.sdk.AutoAppLinkEnabled", false)) {
                InternalAppEventsLogger logger = new InternalAppEventsLogger(ctx);
                Bundle params = new Bundle();
                if (!Utility.INSTANCE.isAutoAppLinkSetup()) {
                    params.putString("SchemeWarning", AUTO_APP_LINK_WARNING);
                    Log.w((String)TAG, (String)AUTO_APP_LINK_WARNING);
                }
                logger.logEvent("fb_auto_applink", params);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    private final void validateInitialized() {
        if (!isInitialized.get()) {
            throw new FacebookSdkNotInitializedException("The UserSettingManager has not been initialized successfully");
        }
    }

    @JvmStatic
    public static final void setAutoInitEnabled(boolean flag) {
        autoInitEnabled.setValue(flag);
        autoInitEnabled.setLastTS(System.currentTimeMillis());
        if (isInitialized.get()) {
            INSTANCE.writeSettingToCache(autoInitEnabled);
        } else {
            INSTANCE.initializeIfNotInitialized();
        }
    }

    @JvmStatic
    public static final boolean getAutoInitEnabled() {
        INSTANCE.initializeIfNotInitialized();
        return autoInitEnabled.getValue();
    }

    @JvmStatic
    public static final void setAutoLogAppEventsEnabled(boolean flag) {
        autoLogAppEventsEnabled.setValue(flag);
        autoLogAppEventsEnabled.setLastTS(System.currentTimeMillis());
        if (isInitialized.get()) {
            INSTANCE.writeSettingToCache(autoLogAppEventsEnabled);
        } else {
            INSTANCE.initializeIfNotInitialized();
        }
    }

    @JvmStatic
    public static final boolean getAutoLogAppEventsEnabled() {
        INSTANCE.initializeIfNotInitialized();
        return autoLogAppEventsEnabled.getValue();
    }

    @JvmStatic
    public static final void setAdvertiserIDCollectionEnabled(boolean flag) {
        advertiserIDCollectionEnabled.setValue(flag);
        advertiserIDCollectionEnabled.setLastTS(System.currentTimeMillis());
        if (isInitialized.get()) {
            INSTANCE.writeSettingToCache(advertiserIDCollectionEnabled);
        } else {
            INSTANCE.initializeIfNotInitialized();
        }
    }

    @JvmStatic
    public static final boolean getAdvertiserIDCollectionEnabled() {
        INSTANCE.initializeIfNotInitialized();
        return advertiserIDCollectionEnabled.getValue();
    }

    @JvmStatic
    public static final boolean getCodelessSetupEnabled() {
        INSTANCE.initializeIfNotInitialized();
        return codelessSetupEnabled.getValue();
    }

    @JvmStatic
    public static final void setMonitorEnabled(boolean flag) {
        monitorEnabled.setValue(flag);
        monitorEnabled.setLastTS(System.currentTimeMillis());
        if (isInitialized.get()) {
            INSTANCE.writeSettingToCache(monitorEnabled);
        } else {
            INSTANCE.initializeIfNotInitialized();
        }
    }

    @JvmStatic
    public static final boolean getMonitorEnabled() {
        INSTANCE.initializeIfNotInitialized();
        return monitorEnabled.getValue();
    }

    private static final void initializeCodelessSetupEnabledAsync$lambda-0(long $currTime) {
        if (advertiserIDCollectionEnabled.getValue()) {
            FetchedAppSettings appSettings = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.INSTANCE.getApplicationId(), false);
            if (appSettings != null && appSettings.getCodelessEventsEnabled()) {
                String advertiserId = null;
                Context context = FacebookSdk.INSTANCE.getApplicationContext();
                AttributionIdentifiers identifiers = AttributionIdentifiers.Companion.getAttributionIdentifiers(context);
                if (identifiers != null && identifiers.getAndroidAdvertiserId() != null) {
                    advertiserId = identifiers.getAndroidAdvertiserId();
                }
                if (advertiserId != null) {
                    Bundle codelessSettingsParams = new Bundle();
                    codelessSettingsParams.putString(ADVERTISER_ID_KEY, advertiserId);
                    codelessSettingsParams.putString(APPLICATION_FIELDS, EVENTS_CODELESS_SETUP_ENABLED);
                    GraphRequest codelessRequest = GraphRequest.Companion.newGraphPathRequest(null, "app", null);
                    codelessRequest.setParameters(codelessSettingsParams);
                    JSONObject response = codelessRequest.executeAndWait().getJSONObject();
                    if (response != null) {
                        codelessSetupEnabled.setValue(response.optBoolean(EVENTS_CODELESS_SETUP_ENABLED, false));
                        codelessSetupEnabled.setLastTS($currTime);
                        INSTANCE.writeSettingToCache(codelessSetupEnabled);
                    }
                }
            }
        }
        isFetchingCodelessStatus.set(false);
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0016\u001a\u00020\u0003R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lcom/facebook/UserSettingsManager$UserSetting;", "", "defaultVal", "", "key", "", "(ZLjava/lang/String;)V", "getDefaultVal", "()Z", "setDefaultVal", "(Z)V", "getKey", "()Ljava/lang/String;", "setKey", "(Ljava/lang/String;)V", "lastTS", "", "getLastTS", "()J", "setLastTS", "(J)V", "value", "getValue", "()Ljava/lang/Boolean;", "setValue", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "facebook-core_release"})
    private static final class UserSetting {
        private boolean defaultVal;
        @NotNull
        private String key;
        @Nullable
        private Boolean value;
        private long lastTS;

        public UserSetting(boolean defaultVal, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.defaultVal = defaultVal;
            this.key = key;
        }

        public final boolean getDefaultVal() {
            return this.defaultVal;
        }

        public final void setDefaultVal(boolean bl) {
            this.defaultVal = bl;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public final void setKey(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.key = string;
        }

        @Nullable
        public final Boolean getValue() {
            return this.value;
        }

        public final void setValue(@Nullable Boolean bl) {
            this.value = bl;
        }

        public final long getLastTS() {
            return this.lastTS;
        }

        public final void setLastTS(long l) {
            this.lastTS = l;
        }

        public final boolean getValue() {
            Boolean bl = this.value;
            return bl == null ? this.defaultVal : bl;
        }
    }
}

