/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.integrity;

import android.os.Build;
import android.os.Bundle;
import com.facebook.FacebookSdk;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0012\u0010\u0014\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u001c\u0010\u0015\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0007J\b\u0010\u0018\u001a\u00020\fH\u0002J\u001a\u0010\u0019\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0007J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\"\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/facebook/appevents/integrity/MACARuleMatchingManager;", "", "()V", "MACARules", "Lorg/json/JSONArray;", "enabled", "", "keys", "", "", "[Ljava/lang/String;", "enable", "", "generateInfo", "params", "Landroid/os/Bundle;", "event", "getKey", "logic", "Lorg/json/JSONObject;", "getMatchPropertyIDs", "isMatchCCRule", "ruleString", "data", "loadMACARules", "processParameters", "removeGeneratedInfo", "stringComparison", "variable", "values", "facebook-core_release"})
public final class MACARuleMatchingManager {
    @NotNull
    public static final MACARuleMatchingManager INSTANCE = new MACARuleMatchingManager();
    private static boolean enabled;
    @Nullable
    private static JSONArray MACARules;
    @NotNull
    private static String[] keys;

    private MACARuleMatchingManager() {
    }

    @JvmStatic
    public static final void enable() {
        if (CrashShieldHandler.isObjectCrashing(MACARuleMatchingManager.class)) {
            return;
        }
        try {
            INSTANCE.loadMACARules();
            if (MACARules != null) {
                enabled = true;
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MACARuleMatchingManager.class);
            return;
        }
    }

    private final void loadMACARules() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            FetchedAppSettings fetchedAppSettings = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.INSTANCE.getApplicationId(), false);
            if (fetchedAppSettings == null) {
                return;
            }
            FetchedAppSettings settings = fetchedAppSettings;
            MACARules = settings.getMACARuleMatchingSetting();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    @JvmStatic
    @Nullable
    public static final String getKey(@NotNull JSONObject jSONObject) {
        if (CrashShieldHandler.isObjectCrashing(MACARuleMatchingManager.class)) {
            return null;
        }
        try {
            JSONObject logic;
            Intrinsics.checkNotNullParameter((Object)logic, (String)"logic");
            Iterator its = logic.keys();
            if (its.hasNext()) {
                return (String)its.next();
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MACARuleMatchingManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean stringComparison(@NotNull String string, @NotNull JSONObject jSONObject, @Nullable Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(MACARuleMatchingManager.class)) {
            return false;
        }
        try {
            boolean bl;
            String string2;
            Object object;
            String string3;
            String string4;
            Object object2;
            void data;
            void values;
            String variable;
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            String string5 = MACARuleMatchingManager.getKey((JSONObject)values);
            if (string5 == null) {
                return false;
            }
            String op = string5;
            String ruleValue = values.get(op).toString();
            Object object3 = data;
            if (object3 == null) {
                object2 = null;
            } else {
                string4 = variable;
                boolean bl2 = false;
                String string6 = string4.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                object2 = string3 = object3.get(string6);
            }
            if (string3 == null) {
                string4 = data;
                Object object4 = object3 = string4 == null ? null : string4.get(variable);
                if (object3 == null) {
                    return false;
                }
                object = object3;
            } else {
                object = string3;
            }
            String dataValue = string2 = object;
            switch (op) {
                case "contains": {
                    bl = StringsKt.contains$default((CharSequence)dataValue.toString(), (CharSequence)ruleValue, (boolean)false, (int)2, null);
                    break;
                }
                case "i_contains": {
                    string3 = dataValue.toString();
                    boolean bl3 = false;
                    String string7 = string3;
                    if (string7 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string8 = string7.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    CharSequence charSequence = string8;
                    string3 = ruleValue;
                    bl3 = false;
                    String string9 = string3;
                    if (string9 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string10 = string9.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    bl = StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string10, (boolean)false, (int)2, null);
                    break;
                }
                case "i_not_contains": {
                    string3 = dataValue.toString();
                    boolean bl4 = false;
                    String string11 = string3;
                    if (string11 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string12 = string11.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    CharSequence charSequence = string12;
                    string3 = ruleValue;
                    bl4 = false;
                    String string13 = string3;
                    if (string13 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string14 = string13.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string14, (boolean)false, (int)2, null)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case "regex_match": {
                    string3 = ruleValue;
                    boolean bl5 = false;
                    bl = new Regex(string3).matches((CharSequence)dataValue.toString());
                    break;
                }
                case "eq": {
                    bl = Intrinsics.areEqual((Object)dataValue.toString(), (Object)ruleValue);
                    break;
                }
                case "neq": {
                    if (!Intrinsics.areEqual((Object)dataValue.toString(), (Object)ruleValue)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case "lt": {
                    string3 = dataValue.toString();
                    boolean bl6 = false;
                    double d = Double.parseDouble(string3);
                    string3 = ruleValue;
                    bl6 = false;
                    if (d < Double.parseDouble(string3)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case "lte": {
                    string3 = dataValue.toString();
                    boolean bl7 = false;
                    double d = Double.parseDouble(string3);
                    string3 = ruleValue;
                    bl7 = false;
                    if (d <= Double.parseDouble(string3)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case "gt": {
                    string3 = dataValue.toString();
                    boolean bl8 = false;
                    double d = Double.parseDouble(string3);
                    string3 = ruleValue;
                    bl8 = false;
                    if (d > Double.parseDouble(string3)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case "gte": {
                    string3 = dataValue.toString();
                    boolean bl9 = false;
                    double d = Double.parseDouble(string3);
                    string3 = ruleValue;
                    bl9 = false;
                    if (d >= Double.parseDouble(string3)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MACARuleMatchingManager.class);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean isMatchCCRule(@Nullable String string, @Nullable Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(MACARuleMatchingManager.class)) {
            return false;
        }
        try {
            boolean bl;
            void data;
            String ruleString;
            if (ruleString == null || data == null) {
                return false;
            }
            JSONObject ruleJson = new JSONObject(ruleString);
            String string2 = MACARuleMatchingManager.getKey(ruleJson);
            if (string2 == null) {
                return false;
            }
            String op = string2;
            Object values = ruleJson.get(op);
            switch (op) {
                case "and": {
                    JSONArray jSONArray = (JSONArray)values;
                    if (jSONArray == null) {
                        return false;
                    }
                    int n = 0;
                    JSONArray v = jSONArray;
                    int n2 = v.length();
                    if (n < n2) {
                        do {
                            int i = n++;
                            boolean thisRes = MACARuleMatchingManager.isMatchCCRule(v.get(i).toString(), (Bundle)data);
                            if (thisRes) continue;
                            return false;
                        } while (n < n2);
                    }
                    return true;
                }
                case "or": {
                    JSONArray jSONArray = (JSONArray)values;
                    if (jSONArray == null) {
                        return false;
                    }
                    int n = 0;
                    JSONArray v = jSONArray;
                    int n3 = v.length();
                    if (n < n3) {
                        do {
                            int i = n++;
                            boolean thisRes = MACARuleMatchingManager.isMatchCCRule(v.get(i).toString(), (Bundle)data);
                            if (!thisRes) continue;
                            return true;
                        } while (n < n3);
                    }
                    return false;
                }
                case "not": {
                    if (!MACARuleMatchingManager.isMatchCCRule(values.toString(), (Bundle)data)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    JSONObject jSONObject = (JSONObject)values;
                    if (jSONObject == null) {
                        return false;
                    }
                    JSONObject v = jSONObject;
                    return MACARuleMatchingManager.stringComparison(op, v, (Bundle)data);
                }
            }
            return bl;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MACARuleMatchingManager.class);
            return false;
        }
    }

    @JvmStatic
    @NotNull
    public static final String getMatchPropertyIDs(@Nullable Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(MACARuleMatchingManager.class)) {
            return null;
        }
        try {
            block10: {
                block9: {
                    if (MACARules == null) break block9;
                    JSONArray jSONArray = MACARules;
                    Integer n = jSONArray == null ? null : Integer.valueOf(jSONArray.length());
                    boolean bl = false;
                    if (n == null || n != 0) break block10;
                }
                return "[]";
            }
            JSONArray jSONArray = MACARules;
            if (jSONArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.json.JSONArray");
            }
            JSONArray rules = jSONArray;
            int n = 0;
            List res = new ArrayList();
            n = 0;
            int n2 = rules.length();
            if (n < n2) {
                do {
                    Bundle params;
                    String string;
                    String entry;
                    JSONObject json;
                    long pid;
                    int i;
                    String string2;
                    if ((string2 = rules.optString(i = n++)) == null || (pid = (json = new JSONObject(entry = string2)).optLong("id")) == 0L || (string = json.optString("rule")) == null) continue;
                    String rule = string;
                    if (!MACARuleMatchingManager.isMatchCCRule(rule, params)) continue;
                    res.add(pid);
                } while (n < n2);
            }
            String string = new JSONArray((Collection)res).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONArray(res).toString()");
            return string;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MACARuleMatchingManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void processParameters(@Nullable Bundle bundle, @NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(MACARuleMatchingManager.class)) {
            return;
        }
        try {
            Bundle params;
            void event;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!enabled || params == null) {
                return;
            }
            try {
                MACARuleMatchingManager.generateInfo(params, (String)event);
                params.putString("_audiencePropertyIds", MACARuleMatchingManager.getMatchPropertyIDs(params));
                params.putString("cs_maca", "1");
                MACARuleMatchingManager.removeGeneratedInfo(params);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MACARuleMatchingManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void generateInfo(@NotNull Bundle bundle, @NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(MACARuleMatchingManager.class)) {
            return;
        }
        try {
            String string2;
            void event;
            Bundle params;
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            params.putString("event", (String)event);
            Object object = Utility.INSTANCE.getLocale();
            StringBuilder stringBuilder = new StringBuilder().append(object == null ? "" : ((string2 = ((Locale)object).getLanguage()) == null ? "" : string2)).append('_');
            object = Utility.INSTANCE.getLocale();
            params.putString("_locale", stringBuilder.append(object == null ? "" : ((string2 = ((Locale)object).getCountry()) == null ? "" : string2)).toString());
            object = Utility.INSTANCE.getVersionName();
            params.putString("_appVersion", (String)(object == null ? "" : object));
            params.putString("_deviceOS", "ANDROID");
            params.putString("_platform", "mobile");
            object = Build.MODEL;
            params.putString("_deviceModel", (String)(object == null ? "" : object));
            params.putString("_nativeAppID", FacebookSdk.INSTANCE.getApplicationId());
            object = Utility.INSTANCE.getVersionName();
            params.putString("_nativeAppShortVersion", (String)(object == null ? "" : object));
            params.putString("_timezone", Utility.INSTANCE.getDeviceTimeZoneName());
            params.putString("_carrier", Utility.INSTANCE.getCarrierName());
            params.putString("_deviceOSTypeName", "ANDROID");
            params.putString("_deviceOSVersion", Build.VERSION.RELEASE);
            params.putLong("_remainingDiskGB", Utility.INSTANCE.getAvailableExternalStorageGB());
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MACARuleMatchingManager.class);
            return;
        }
    }

    @JvmStatic
    public static final void removeGeneratedInfo(@NotNull Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(MACARuleMatchingManager.class)) {
            return;
        }
        try {
            Bundle params;
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            for (String k : keys) {
                params.remove(k);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MACARuleMatchingManager.class);
            return;
        }
    }

    static {
        String[] stringArray = new String[]{"event", "_locale", "_appVersion", "_deviceOS", "_platform", "_deviceModel", "_nativeAppID", "_nativeAppShortVersion", "_timezone", "_carrier", "_deviceOSTypeName", "_deviceOSVersion", "_remainingDiskGB"};
        keys = stringArray;
    }
}

