/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.internal.FetchedAppGateKeepersManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0007J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\b\u0010\u0014\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0007H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/facebook/internal/FeatureManager;", "", "()V", "FEATURE_MANAGER_STORE", "", "featureMapping", "", "Lcom/facebook/internal/FeatureManager$Feature;", "", "checkFeature", "", "feature", "callback", "Lcom/facebook/internal/FeatureManager$Callback;", "defaultStatus", "", "disableFeature", "getFeature", "className", "getGKStatus", "initializeFeatureMapping", "isEnabled", "Callback", "Feature", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class FeatureManager {
    @NotNull
    public static final FeatureManager INSTANCE = new FeatureManager();
    @NotNull
    private static final String FEATURE_MANAGER_STORE = "com.facebook.internal.FEATURE_MANAGER";
    @NotNull
    private static final Map<Feature, String[]> featureMapping;

    private FeatureManager() {
    }

    @JvmStatic
    public static final void checkFeature(@NotNull Feature feature, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        FetchedAppGateKeepersManager.loadAppGateKeepersAsync(new FetchedAppGateKeepersManager.Callback(callback, feature){
            final /* synthetic */ Callback $callback;
            final /* synthetic */ Feature $feature;
            {
                this.$callback = $callback;
                this.$feature = $feature;
            }

            public void onCompleted() {
                this.$callback.onCompleted(FeatureManager.isEnabled(this.$feature));
            }
        });
    }

    @JvmStatic
    public static final boolean isEnabled(@NotNull Feature feature) {
        Feature parent;
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        if (Feature.Unknown == feature) {
            return false;
        }
        if (Feature.Core == feature) {
            return true;
        }
        String version = FacebookSdk.INSTANCE.getApplicationContext().getSharedPreferences(FEATURE_MANAGER_STORE, 0).getString(feature.toKey(), null);
        if (version != null) {
            if (Intrinsics.areEqual((Object)version, (Object)FacebookSdk.INSTANCE.getSdkVersion())) {
                return false;
            }
        }
        return (parent = feature.getParent()) == feature ? INSTANCE.getGKStatus(feature) : FeatureManager.isEnabled(parent) && INSTANCE.getGKStatus(feature);
    }

    @JvmStatic
    public static final void disableFeature(@NotNull Feature feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        FacebookSdk.INSTANCE.getApplicationContext().getSharedPreferences(FEATURE_MANAGER_STORE, 0).edit().putString(feature.toKey(), FacebookSdk.INSTANCE.getSdkVersion()).apply();
    }

    @JvmStatic
    @NotNull
    public static final Feature getFeature(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        INSTANCE.initializeFeatureMapping();
        String[] stringArray = featureMapping;
        boolean bl = false;
        Iterator<Map.Entry<Feature, String[]>> iterator = stringArray.entrySet().iterator();
        while (iterator.hasNext()) {
            String[] value;
            String[] stringArray2 = stringArray = iterator.next();
            boolean bl2 = false;
            Feature key = (Feature)((Object)stringArray2.getKey());
            String[] stringArray3 = stringArray;
            int n = 0;
            for (String v : value = (String[])stringArray3.getValue()) {
                if (!StringsKt.startsWith$default((String)className, (String)v, (boolean)false, (int)2, null)) continue;
                return key;
            }
        }
        return Feature.Unknown;
    }

    private final synchronized void initializeFeatureMapping() {
        if (!featureMapping.isEmpty()) {
            return;
        }
        Map<Feature, String[]> map = featureMapping;
        Feature feature = Feature.AAM;
        String[] stringArray = new String[]{"com.facebook.appevents.aam."};
        boolean bl = false;
        map.put(feature, stringArray);
        map = featureMapping;
        feature = Feature.CodelessEvents;
        stringArray = new String[]{"com.facebook.appevents.codeless."};
        bl = false;
        map.put(feature, stringArray);
        map = featureMapping;
        feature = Feature.CloudBridge;
        stringArray = new String[]{"com.facebook.appevents.cloudbridge."};
        bl = false;
        map.put(feature, stringArray);
        map = featureMapping;
        feature = Feature.ErrorReport;
        stringArray = new String[]{"com.facebook.internal.instrument.errorreport."};
        bl = false;
        map.put(feature, stringArray);
        map = featureMapping;
        feature = Feature.AnrReport;
        stringArray = new String[]{"com.facebook.internal.instrument.anrreport."};
        bl = false;
        map.put(feature, stringArray);
        map = featureMapping;
        feature = Feature.PrivacyProtection;
        stringArray = new String[]{"com.facebook.appevents.ml."};
        bl = false;
        map.put(feature, stringArray);
        map = featureMapping;
        feature = Feature.SuggestedEvents;
        stringArray = new String[]{"com.facebook.appevents.suggestedevents."};
        bl = false;
        map.put(feature, stringArray);
        map = featureMapping;
        feature = Feature.RestrictiveDataFiltering;
        stringArray = new String[]{"com.facebook.appevents.restrictivedatafilter.RestrictiveDataManager"};
        bl = false;
        map.put(feature, stringArray);
        map = featureMapping;
        feature = Feature.IntelligentIntegrity;
        stringArray = new String[]{"com.facebook.appevents.integrity.IntegrityManager"};
        bl = false;
        map.put(feature, stringArray);
        map = featureMapping;
        feature = Feature.EventDeactivation;
        stringArray = new String[]{"com.facebook.appevents.eventdeactivation."};
        bl = false;
        map.put(feature, stringArray);
        map = featureMapping;
        feature = Feature.OnDeviceEventProcessing;
        stringArray = new String[]{"com.facebook.appevents.ondeviceprocessing."};
        bl = false;
        map.put(feature, stringArray);
        map = featureMapping;
        feature = Feature.IapLogging;
        stringArray = new String[]{"com.facebook.appevents.iap."};
        bl = false;
        map.put(feature, stringArray);
        map = featureMapping;
        feature = Feature.Monitoring;
        stringArray = new String[]{"com.facebook.internal.logging.monitor"};
        bl = false;
        map.put(feature, stringArray);
    }

    private final boolean getGKStatus(Feature feature) {
        boolean defaultStatus = this.defaultStatus(feature);
        return FetchedAppGateKeepersManager.getGateKeeperForKey(feature.toKey(), FacebookSdk.INSTANCE.getApplicationId(), defaultStatus);
    }

    private final boolean defaultStatus(Feature feature) {
        boolean bl;
        Feature feature2 = feature;
        int n = WhenMappings.$EnumSwitchMapping$0[feature2.ordinal()];
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    static {
        boolean bl = false;
        featureMapping = new HashMap();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\"\b\u0086\u0001\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001*B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)\u00a8\u0006+"}, d2={"Lcom/facebook/internal/FeatureManager$Feature;", "", "code", "", "(Ljava/lang/String;II)V", "parent", "getParent", "()Lcom/facebook/internal/FeatureManager$Feature;", "toKey", "", "toString", "Unknown", "Core", "AppEvents", "CodelessEvents", "CloudBridge", "RestrictiveDataFiltering", "AAM", "PrivacyProtection", "SuggestedEvents", "IntelligentIntegrity", "ModelRequest", "EventDeactivation", "OnDeviceEventProcessing", "OnDevicePostInstallEventProcessing", "IapLogging", "IapLoggingLib2", "Instrument", "CrashReport", "CrashShield", "ThreadCheck", "ErrorReport", "AnrReport", "Monitoring", "ServiceUpdateCompliance", "Megatron", "Elora", "Login", "ChromeCustomTabsPrefetching", "IgnoreAppSwitchToLoggedOut", "BypassAppSwitch", "Share", "Companion", "facebook-core_release"})
    public static final class Feature
    extends Enum<Feature> {
        @NotNull
        public static final Companion Companion;
        private final int code;
        public static final /* enum */ Feature Unknown;
        public static final /* enum */ Feature Core;
        public static final /* enum */ Feature AppEvents;
        public static final /* enum */ Feature CodelessEvents;
        public static final /* enum */ Feature CloudBridge;
        public static final /* enum */ Feature RestrictiveDataFiltering;
        public static final /* enum */ Feature AAM;
        public static final /* enum */ Feature PrivacyProtection;
        public static final /* enum */ Feature SuggestedEvents;
        public static final /* enum */ Feature IntelligentIntegrity;
        public static final /* enum */ Feature ModelRequest;
        public static final /* enum */ Feature EventDeactivation;
        public static final /* enum */ Feature OnDeviceEventProcessing;
        public static final /* enum */ Feature OnDevicePostInstallEventProcessing;
        public static final /* enum */ Feature IapLogging;
        public static final /* enum */ Feature IapLoggingLib2;
        public static final /* enum */ Feature Instrument;
        public static final /* enum */ Feature CrashReport;
        public static final /* enum */ Feature CrashShield;
        public static final /* enum */ Feature ThreadCheck;
        public static final /* enum */ Feature ErrorReport;
        public static final /* enum */ Feature AnrReport;
        public static final /* enum */ Feature Monitoring;
        public static final /* enum */ Feature ServiceUpdateCompliance;
        public static final /* enum */ Feature Megatron;
        public static final /* enum */ Feature Elora;
        public static final /* enum */ Feature Login;
        public static final /* enum */ Feature ChromeCustomTabsPrefetching;
        public static final /* enum */ Feature IgnoreAppSwitchToLoggedOut;
        public static final /* enum */ Feature BypassAppSwitch;
        public static final /* enum */ Feature Share;
        private static final /* synthetic */ Feature[] $VALUES;

        private Feature(int code) {
            this.code = code;
        }

        @NotNull
        public String toString() {
            String string;
            Feature feature = this;
            int n = WhenMappings.$EnumSwitchMapping$0[feature.ordinal()];
            switch (n) {
                case 1: {
                    string = "CoreKit";
                    break;
                }
                case 2: {
                    string = "AppEvents";
                    break;
                }
                case 3: {
                    string = "CodelessEvents";
                    break;
                }
                case 4: {
                    string = "RestrictiveDataFiltering";
                    break;
                }
                case 5: {
                    string = "Instrument";
                    break;
                }
                case 6: {
                    string = "CrashReport";
                    break;
                }
                case 7: {
                    string = "CrashShield";
                    break;
                }
                case 8: {
                    string = "ThreadCheck";
                    break;
                }
                case 9: {
                    string = "ErrorReport";
                    break;
                }
                case 10: {
                    string = "AnrReport";
                    break;
                }
                case 11: {
                    string = "AAM";
                    break;
                }
                case 12: {
                    string = "AppEventsCloudbridge";
                    break;
                }
                case 13: {
                    string = "PrivacyProtection";
                    break;
                }
                case 14: {
                    string = "SuggestedEvents";
                    break;
                }
                case 15: {
                    string = "IntelligentIntegrity";
                    break;
                }
                case 16: {
                    string = "ModelRequest";
                    break;
                }
                case 17: {
                    string = "EventDeactivation";
                    break;
                }
                case 18: {
                    string = "OnDeviceEventProcessing";
                    break;
                }
                case 19: {
                    string = "OnDevicePostInstallEventProcessing";
                    break;
                }
                case 20: {
                    string = "IAPLogging";
                    break;
                }
                case 21: {
                    string = "IAPLoggingLib2";
                    break;
                }
                case 22: {
                    string = "Monitoring";
                    break;
                }
                case 23: {
                    string = "ServiceUpdateCompliance";
                    break;
                }
                case 24: {
                    string = "Megatron";
                    break;
                }
                case 25: {
                    string = "Elora";
                    break;
                }
                case 26: {
                    string = "LoginKit";
                    break;
                }
                case 27: {
                    string = "ChromeCustomTabsPrefetching";
                    break;
                }
                case 28: {
                    string = "IgnoreAppSwitchToLoggedOut";
                    break;
                }
                case 29: {
                    string = "BypassAppSwitch";
                    break;
                }
                case 30: {
                    string = "ShareKit";
                    break;
                }
                default: {
                    string = "unknown";
                }
            }
            return string;
        }

        @NotNull
        public final String toKey() {
            return Intrinsics.stringPlus((String)"FBSDKFeature", (Object)((Object)this));
        }

        @NotNull
        public final Feature getParent() {
            return (this.code & 0xFF) > 0 ? Companion.fromInt(this.code & 0xFFFFFF00) : ((this.code & 0xFF00) > 0 ? Companion.fromInt(this.code & 0xFFFF0000) : ((this.code & 0xFF0000) > 0 ? Companion.fromInt(this.code & 0xFF000000) : Companion.fromInt(0)));
        }

        public static Feature[] values() {
            Feature[] featureArray = $VALUES;
            return Arrays.copyOf(featureArray, featureArray.length);
        }

        public static Feature valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(Feature.class, value);
        }

        static {
            Unknown = new Feature(-1);
            Core = new Feature(0);
            AppEvents = new Feature(65536);
            CodelessEvents = new Feature(65792);
            CloudBridge = new Feature(67584);
            RestrictiveDataFiltering = new Feature(66048);
            AAM = new Feature(66304);
            PrivacyProtection = new Feature(66560);
            SuggestedEvents = new Feature(66561);
            IntelligentIntegrity = new Feature(66562);
            ModelRequest = new Feature(66563);
            EventDeactivation = new Feature(66816);
            OnDeviceEventProcessing = new Feature(67072);
            OnDevicePostInstallEventProcessing = new Feature(67073);
            IapLogging = new Feature(67328);
            IapLoggingLib2 = new Feature(67329);
            Instrument = new Feature(131072);
            CrashReport = new Feature(131328);
            CrashShield = new Feature(131329);
            ThreadCheck = new Feature(131330);
            ErrorReport = new Feature(131584);
            AnrReport = new Feature(131840);
            Monitoring = new Feature(196608);
            ServiceUpdateCompliance = new Feature(196864);
            Megatron = new Feature(262144);
            Elora = new Feature(327680);
            Login = new Feature(0x1000000);
            ChromeCustomTabsPrefetching = new Feature(0x1010000);
            IgnoreAppSwitchToLoggedOut = new Feature(0x1020000);
            BypassAppSwitch = new Feature(0x1030000);
            Share = new Feature(0x2000000);
            $VALUES = featureArray = new Feature[]{Feature.Unknown, Feature.Core, Feature.AppEvents, Feature.CodelessEvents, Feature.CloudBridge, Feature.RestrictiveDataFiltering, Feature.AAM, Feature.PrivacyProtection, Feature.SuggestedEvents, Feature.IntelligentIntegrity, Feature.ModelRequest, Feature.EventDeactivation, Feature.OnDeviceEventProcessing, Feature.OnDevicePostInstallEventProcessing, Feature.IapLogging, Feature.IapLoggingLib2, Feature.Instrument, Feature.CrashReport, Feature.CrashShield, Feature.ThreadCheck, Feature.ErrorReport, Feature.AnrReport, Feature.Monitoring, Feature.ServiceUpdateCompliance, Feature.Megatron, Feature.Elora, Feature.Login, Feature.ChromeCustomTabsPrefetching, Feature.IgnoreAppSwitchToLoggedOut, Feature.BypassAppSwitch, Feature.Share};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/facebook/internal/FeatureManager$Feature$Companion;", "", "()V", "fromInt", "Lcom/facebook/internal/FeatureManager$Feature;", "code", "", "facebook-core_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Feature fromInt(int code) {
                for (Feature feature : Feature.values()) {
                    if (feature.code != code) continue;
                    return feature;
                }
                return Unknown;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Feature.values().length];
                nArray[Feature.Core.ordinal()] = 1;
                nArray[Feature.AppEvents.ordinal()] = 2;
                nArray[Feature.CodelessEvents.ordinal()] = 3;
                nArray[Feature.RestrictiveDataFiltering.ordinal()] = 4;
                nArray[Feature.Instrument.ordinal()] = 5;
                nArray[Feature.CrashReport.ordinal()] = 6;
                nArray[Feature.CrashShield.ordinal()] = 7;
                nArray[Feature.ThreadCheck.ordinal()] = 8;
                nArray[Feature.ErrorReport.ordinal()] = 9;
                nArray[Feature.AnrReport.ordinal()] = 10;
                nArray[Feature.AAM.ordinal()] = 11;
                nArray[Feature.CloudBridge.ordinal()] = 12;
                nArray[Feature.PrivacyProtection.ordinal()] = 13;
                nArray[Feature.SuggestedEvents.ordinal()] = 14;
                nArray[Feature.IntelligentIntegrity.ordinal()] = 15;
                nArray[Feature.ModelRequest.ordinal()] = 16;
                nArray[Feature.EventDeactivation.ordinal()] = 17;
                nArray[Feature.OnDeviceEventProcessing.ordinal()] = 18;
                nArray[Feature.OnDevicePostInstallEventProcessing.ordinal()] = 19;
                nArray[Feature.IapLogging.ordinal()] = 20;
                nArray[Feature.IapLoggingLib2.ordinal()] = 21;
                nArray[Feature.Monitoring.ordinal()] = 22;
                nArray[Feature.ServiceUpdateCompliance.ordinal()] = 23;
                nArray[Feature.Megatron.ordinal()] = 24;
                nArray[Feature.Elora.ordinal()] = 25;
                nArray[Feature.Login.ordinal()] = 26;
                nArray[Feature.ChromeCustomTabsPrefetching.ordinal()] = 27;
                nArray[Feature.IgnoreAppSwitchToLoggedOut.ordinal()] = 28;
                nArray[Feature.BypassAppSwitch.ordinal()] = 29;
                nArray[Feature.Share.ordinal()] = 30;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/facebook/internal/FeatureManager$Callback;", "", "onCompleted", "", "enabled", "", "facebook-core_release"})
    public static interface Callback {
        public void onCompleted(boolean var1);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Feature.values().length];
            nArray[Feature.RestrictiveDataFiltering.ordinal()] = 1;
            nArray[Feature.Instrument.ordinal()] = 2;
            nArray[Feature.CrashReport.ordinal()] = 3;
            nArray[Feature.CrashShield.ordinal()] = 4;
            nArray[Feature.ThreadCheck.ordinal()] = 5;
            nArray[Feature.ErrorReport.ordinal()] = 6;
            nArray[Feature.AnrReport.ordinal()] = 7;
            nArray[Feature.AAM.ordinal()] = 8;
            nArray[Feature.CloudBridge.ordinal()] = 9;
            nArray[Feature.PrivacyProtection.ordinal()] = 10;
            nArray[Feature.SuggestedEvents.ordinal()] = 11;
            nArray[Feature.IntelligentIntegrity.ordinal()] = 12;
            nArray[Feature.ModelRequest.ordinal()] = 13;
            nArray[Feature.EventDeactivation.ordinal()] = 14;
            nArray[Feature.OnDeviceEventProcessing.ordinal()] = 15;
            nArray[Feature.OnDevicePostInstallEventProcessing.ordinal()] = 16;
            nArray[Feature.IapLogging.ordinal()] = 17;
            nArray[Feature.IapLoggingLib2.ordinal()] = 18;
            nArray[Feature.ChromeCustomTabsPrefetching.ordinal()] = 19;
            nArray[Feature.Monitoring.ordinal()] = 20;
            nArray[Feature.Megatron.ordinal()] = 21;
            nArray[Feature.Elora.ordinal()] = 22;
            nArray[Feature.IgnoreAppSwitchToLoggedOut.ordinal()] = 23;
            nArray[Feature.BypassAppSwitch.ordinal()] = 24;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

