/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.net.Uri;
import com.facebook.LoggingBehavior;
import com.facebook.internal.FileLruCache;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\bH\u0007J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/internal/ImageResponseCache;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "imageCache", "Lcom/facebook/internal/FileLruCache;", "clearCache", "", "getCache", "getCachedImageStream", "Ljava/io/InputStream;", "uri", "Landroid/net/Uri;", "interceptAndCacheImageStream", "connection", "Ljava/net/HttpURLConnection;", "isCDNURL", "", "BufferedHttpInputStream", "facebook-core_release"})
public final class ImageResponseCache {
    @NotNull
    public static final ImageResponseCache INSTANCE = new ImageResponseCache();
    @NotNull
    private static final String TAG;
    private static FileLruCache imageCache;

    private ImageResponseCache() {
    }

    @NotNull
    public final String getTAG() {
        return TAG;
    }

    @JvmStatic
    @NotNull
    public static final synchronized FileLruCache getCache() throws IOException {
        FileLruCache fileLruCache;
        if (imageCache == null) {
            imageCache = new FileLruCache(TAG, new FileLruCache.Limits());
        }
        if ((fileLruCache = imageCache) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageCache");
            throw null;
        }
        return fileLruCache;
    }

    @JvmStatic
    @Nullable
    public static final InputStream getCachedImageStream(@Nullable Uri uri) {
        InputStream imageStream = null;
        if (uri != null && INSTANCE.isCDNURL(uri)) {
            try {
                FileLruCache cache = INSTANCE.getCache();
                String string = uri.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.toString()");
                imageStream = FileLruCache.get$default(cache, string, null, 2, null);
            }
            catch (IOException e) {
                Logger.Companion.log(LoggingBehavior.CACHE, 5, TAG, e.toString());
            }
        }
        return imageStream;
    }

    @JvmStatic
    @Nullable
    public static final InputStream interceptAndCacheImageStream(@NotNull HttpURLConnection connection) throws IOException {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        InputStream stream = null;
        if (connection.getResponseCode() == 200) {
            Uri uri = Uri.parse((String)connection.getURL().toString());
            stream = connection.getInputStream();
            try {
                if (INSTANCE.isCDNURL(uri)) {
                    FileLruCache cache = INSTANCE.getCache();
                    String string = uri.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.toString()");
                    stream = cache.interceptAndPut(string, new BufferedHttpInputStream(stream, connection));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return stream;
    }

    private final boolean isCDNURL(Uri uri) {
        String uriHost;
        if (uri != null && (uriHost = uri.getHost()) != null) {
            if (Intrinsics.areEqual((Object)uriHost, (Object)"fbcdn.net") || StringsKt.endsWith$default((String)uriHost, (String)".fbcdn.net", (boolean)false, (int)2, null)) {
                return true;
            }
            if (StringsKt.startsWith$default((String)uriHost, (String)"fbcdn", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)uriHost, (String)".akamaihd.net", (boolean)false, (int)2, null)) {
                return true;
            }
        }
        return false;
    }

    @JvmStatic
    public static final void clearCache() {
        try {
            INSTANCE.getCache().clearCache();
        }
        catch (IOException e) {
            Logger.Companion.log(LoggingBehavior.CACHE, 5, TAG, Intrinsics.stringPlus((String)"clearCache failed ", (Object)e.getMessage()));
        }
    }

    static {
        String string = ImageResponseCache.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ImageResponseCache::class.java.simpleName");
        TAG = string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/facebook/internal/ImageResponseCache$BufferedHttpInputStream;", "Ljava/io/BufferedInputStream;", "stream", "Ljava/io/InputStream;", "connection", "Ljava/net/HttpURLConnection;", "(Ljava/io/InputStream;Ljava/net/HttpURLConnection;)V", "getConnection", "()Ljava/net/HttpURLConnection;", "setConnection", "(Ljava/net/HttpURLConnection;)V", "close", "", "facebook-core_release"})
    private static final class BufferedHttpInputStream
    extends BufferedInputStream {
        @NotNull
        private HttpURLConnection connection;

        public BufferedHttpInputStream(@Nullable InputStream stream, @NotNull HttpURLConnection connection) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            super(stream, 8192);
            this.connection = connection;
        }

        @NotNull
        public final HttpURLConnection getConnection() {
            return this.connection;
        }

        public final void setConnection(@NotNull HttpURLConnection httpURLConnection) {
            Intrinsics.checkNotNullParameter((Object)httpURLConnection, (String)"<set-?>");
            this.connection = httpURLConnection;
        }

        @Override
        public void close() throws IOException {
            super.close();
            Utility.disconnectQuietly(this.connection);
        }
    }
}

