/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.iap;

import android.content.SharedPreferences;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookSdk;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\t\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\rH\u0001\u00a2\u0006\u0002\b\u0017J\r\u0010\u0018\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\b\u001aJC\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u00142\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0001\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0007J2\u0010 \u001a\u00020\u00192\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\r2\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0007J\u001c\u0010!\u001a\u00020\u00192\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0014H\u0002J\b\u0010\"\u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/facebook/appevents/iap/InAppPurchaseLoggerManager;", "", "()V", "CACHE_CLEAR_TIME_LIMIT_SEC", "", "LAST_CLEARED_TIME", "", "LAST_QUERY_PURCHASE_HISTORY_TIME", "PRODUCT_DETAILS_STORE", "PURCHASE_DETAILS_SET", "PURCHASE_IN_CACHE_INTERVAL", "PURCHASE_TIME", "cachedPurchaseMap", "", "", "cachedPurchaseSet", "", "sharedPreferences", "Landroid/content/SharedPreferences;", "cacheDeDupPurchase", "", "Lorg/json/JSONObject;", "purchaseDetailsMap", "cacheDeDupPurchase$facebook_core_release", "clearOutdatedProductInfoInCache", "", "clearOutdatedProductInfoInCache$facebook_core_release", "constructLoggingReadyMap", "skuDetailsMap", "constructLoggingReadyMap$facebook_core_release", "eligibleQueryPurchaseHistory", "", "filterPurchaseLogging", "logPurchases", "readPurchaseCache", "facebook-core_release"})
@AutoHandleExceptions
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class InAppPurchaseLoggerManager {
    @NotNull
    public static final InAppPurchaseLoggerManager INSTANCE = new InAppPurchaseLoggerManager();
    private static SharedPreferences sharedPreferences;
    @NotNull
    private static final Set<String> cachedPurchaseSet;
    @NotNull
    private static final Map<String, Long> cachedPurchaseMap;
    @NotNull
    private static final String PURCHASE_TIME = "purchaseTime";
    @NotNull
    private static final String PRODUCT_DETAILS_STORE = "com.facebook.internal.iap.PRODUCT_DETAILS";
    @NotNull
    private static final String LAST_CLEARED_TIME = "LAST_CLEARED_TIME";
    @NotNull
    private static final String PURCHASE_DETAILS_SET = "PURCHASE_DETAILS_SET";
    @NotNull
    private static final String LAST_QUERY_PURCHASE_HISTORY_TIME = "LAST_QUERY_PURCHASE_HISTORY_TIME";
    private static final int CACHE_CLEAR_TIME_LIMIT_SEC = 604800;
    private static final int PURCHASE_IN_CACHE_INTERVAL = 86400;

    private InAppPurchaseLoggerManager() {
    }

    private final void readPurchaseCache() {
        Collection collection;
        SharedPreferences cachedSkuSharedPref = FacebookSdk.INSTANCE.getApplicationContext().getSharedPreferences("com.facebook.internal.SKU_DETAILS", 0);
        SharedPreferences cachedPurchaseSharedPref = FacebookSdk.INSTANCE.getApplicationContext().getSharedPreferences("com.facebook.internal.PURCHASE", 0);
        if (cachedSkuSharedPref.contains(LAST_CLEARED_TIME)) {
            cachedSkuSharedPref.edit().clear().apply();
            cachedPurchaseSharedPref.edit().clear().apply();
        }
        Object object = FacebookSdk.INSTANCE.getApplicationContext().getSharedPreferences(PRODUCT_DETAILS_STORE, 0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getApplicationContext().getSharedPreferences(PRODUCT_DETAILS_STORE, Context.MODE_PRIVATE)");
        SharedPreferences sharedPreferences = InAppPurchaseLoggerManager.sharedPreferences = object;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            throw null;
        }
        boolean bl = false;
        object = sharedPreferences.getStringSet(PURCHASE_DETAILS_SET, (Set)new HashSet());
        if (object == null) {
            bl = false;
            collection = new HashSet();
        } else {
            collection = (Collection)object;
        }
        cachedPurchaseSet.addAll(collection);
        for (String purchaseHistory : cachedPurchaseSet) {
            Object object2 = new String[]{";"};
            List splitPurchase = StringsKt.split$default((CharSequence)purchaseHistory, (String[])object2, (boolean)false, (int)2, (int)2, null);
            object2 = cachedPurchaseMap;
            Object e = splitPurchase.get(0);
            Object object3 = (String)splitPurchase.get(1);
            boolean bl2 = false;
            object3 = Long.parseLong((String)object3);
            bl2 = false;
            object2.put(e, object3);
        }
        this.clearOutdatedProductInfoInCache$facebook_core_release();
    }

    @JvmStatic
    public static final void filterPurchaseLogging(@NotNull Map<String, JSONObject> purchaseDetailsMap, @NotNull Map<String, ? extends JSONObject> skuDetailsMap) {
        Intrinsics.checkNotNullParameter(purchaseDetailsMap, (String)"purchaseDetailsMap");
        Intrinsics.checkNotNullParameter(skuDetailsMap, (String)"skuDetailsMap");
        INSTANCE.readPurchaseCache();
        Map<String, String> loggingReadyMap = INSTANCE.constructLoggingReadyMap$facebook_core_release(INSTANCE.cacheDeDupPurchase$facebook_core_release(purchaseDetailsMap), skuDetailsMap);
        INSTANCE.logPurchases(loggingReadyMap);
    }

    private final void logPurchases(Map<String, String> purchaseDetailsMap) {
        Object object = purchaseDetailsMap;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            String purchaseDetails = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            String skuDetails = (String)object3.getValue();
            if (purchaseDetails == null || skuDetails == null) continue;
            AutomaticAnalyticsLogger.logPurchase(purchaseDetails, skuDetails, false);
        }
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final Map<String, JSONObject> cacheDeDupPurchase$facebook_core_release(@NotNull Map<String, JSONObject> purchaseDetailsMap) {
        Intrinsics.checkNotNullParameter(purchaseDetailsMap, (String)"purchaseDetailsMap");
        long nowSec = System.currentTimeMillis() / 1000L;
        Map tempPurchaseDetailsMap = MapsKt.toMap(purchaseDetailsMap);
        Object object = tempPurchaseDetailsMap;
        boolean bl = false;
        SharedPreferences sharedPreferences = object.entrySet().iterator();
        while (sharedPreferences.hasNext()) {
            Object object2 = object = sharedPreferences.next();
            boolean bl2 = false;
            String key = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            JSONObject purchaseJson = (JSONObject)object3.getValue();
            try {
                if (!purchaseJson.has("purchaseToken")) continue;
                String purchaseToken = purchaseJson.getString("purchaseToken");
                if (cachedPurchaseMap.containsKey(purchaseToken)) {
                    purchaseDetailsMap.remove(key);
                    continue;
                }
                cachedPurchaseSet.add(purchaseToken + ';' + nowSec);
            }
            catch (Exception exception) {}
        }
        sharedPreferences = InAppPurchaseLoggerManager.sharedPreferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            throw null;
        }
        sharedPreferences.edit().putStringSet(PURCHASE_DETAILS_SET, cachedPurchaseSet).apply();
        return new HashMap<String, JSONObject>(purchaseDetailsMap);
    }

    @VisibleForTesting(otherwise=2)
    public final void clearOutdatedProductInfoInCache$facebook_core_release() {
        long nowSec = System.currentTimeMillis() / 1000L;
        SharedPreferences sharedPreferences = InAppPurchaseLoggerManager.sharedPreferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            throw null;
        }
        long lastClearedTimeSec = sharedPreferences.getLong(LAST_CLEARED_TIME, 0L);
        if (lastClearedTimeSec == 0L) {
            sharedPreferences = InAppPurchaseLoggerManager.sharedPreferences;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
                throw null;
            }
            sharedPreferences.edit().putLong(LAST_CLEARED_TIME, nowSec).apply();
        } else if (nowSec - lastClearedTimeSec > 604800L) {
            Map tempPurchaseMap = MapsKt.toMap(cachedPurchaseMap);
            Object object = tempPurchaseMap;
            boolean bl = false;
            SharedPreferences sharedPreferences2 = object.entrySet().iterator();
            while (sharedPreferences2.hasNext()) {
                Object object2 = object = sharedPreferences2.next();
                boolean bl2 = false;
                String purchaseToken = (String)object2.getKey();
                Object object3 = object;
                boolean bl3 = false;
                long historyPurchaseTime = ((Number)object3.getValue()).longValue();
                if (nowSec - historyPurchaseTime <= 86400L) continue;
                cachedPurchaseSet.remove(purchaseToken + ';' + historyPurchaseTime);
                cachedPurchaseMap.remove(purchaseToken);
            }
            sharedPreferences2 = InAppPurchaseLoggerManager.sharedPreferences;
            if (sharedPreferences2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
                throw null;
            }
            sharedPreferences2.edit().putStringSet(PURCHASE_DETAILS_SET, cachedPurchaseSet).putLong(LAST_CLEARED_TIME, nowSec).apply();
        }
    }

    @JvmStatic
    public static final boolean eligibleQueryPurchaseHistory() {
        INSTANCE.readPurchaseCache();
        long nowSec = System.currentTimeMillis() / 1000L;
        SharedPreferences sharedPreferences = InAppPurchaseLoggerManager.sharedPreferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            throw null;
        }
        long lastQueryPurchaseHistoryTime = sharedPreferences.getLong(LAST_QUERY_PURCHASE_HISTORY_TIME, 0L);
        if (lastQueryPurchaseHistoryTime != 0L) {
            if (nowSec - lastQueryPurchaseHistoryTime < (long)86400) {
                return false;
            }
        }
        if ((sharedPreferences = InAppPurchaseLoggerManager.sharedPreferences) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            throw null;
        }
        sharedPreferences.edit().putLong(LAST_QUERY_PURCHASE_HISTORY_TIME, nowSec).apply();
        return true;
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final Map<String, String> constructLoggingReadyMap$facebook_core_release(@NotNull Map<String, ? extends JSONObject> purchaseDetailsMap, @NotNull Map<String, ? extends JSONObject> skuDetailsMap) {
        Intrinsics.checkNotNullParameter(purchaseDetailsMap, (String)"purchaseDetailsMap");
        Intrinsics.checkNotNullParameter(skuDetailsMap, (String)"skuDetailsMap");
        long nowSec = System.currentTimeMillis() / 1000L;
        boolean bl = false;
        Map purchaseResultMap = new LinkedHashMap();
        Object object = purchaseDetailsMap;
        boolean bl2 = false;
        Iterator<Map.Entry<String, ? extends JSONObject>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl3 = false;
            String key = (String)object2.getKey();
            Object object3 = object;
            boolean bl4 = false;
            JSONObject purchaseDetail = (JSONObject)object3.getValue();
            JSONObject skuDetail = skuDetailsMap.get(key);
            if (purchaseDetail == null || !purchaseDetail.has(PURCHASE_TIME)) continue;
            try {
                long purchaseTime = purchaseDetail.getLong(PURCHASE_TIME);
                if (nowSec - purchaseTime / 1000L > 86400L || skuDetail == null) continue;
                Map map = purchaseResultMap;
                String string = purchaseDetail.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"purchaseDetail.toString()");
                String string2 = skuDetail.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"skuDetail.toString()");
                boolean bl5 = false;
                map.put(string, string2);
            }
            catch (Exception exception) {}
        }
        return purchaseResultMap;
    }

    static {
        cachedPurchaseSet = new CopyOnWriteArraySet();
        cachedPurchaseMap = new ConcurrentHashMap();
    }
}

