/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.os.Bundle;
import android.webkit.JavascriptInterface;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.Logger;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0007R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00068GX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/facebook/appevents/FacebookSDKJSInterface;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "protocol", "", "getProtocol", "()Ljava/lang/String;", "sendEvent", "", "pixelId", "eventName", "jsonString", "Companion", "facebook-core_release"})
@AutoHandleExceptions
public final class FacebookSDKJSInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Context context;
    @NotNull
    private final String protocol;
    @NotNull
    private static final String TAG;
    @NotNull
    private static final String PARAMETER_FBSDK_PIXEL_REFERRAL = "_fb_pixel_referral_id";

    public FacebookSDKJSInterface(@Nullable Context context) {
        this.context = context;
        this.protocol = "fbmq-0.1";
    }

    @JavascriptInterface
    public final void sendEvent(@Nullable String pixelId, @Nullable String eventName, @Nullable String jsonString) {
        if (pixelId == null) {
            Logger.Companion.log(LoggingBehavior.DEVELOPER_ERRORS, TAG, "Can't bridge an event without a referral Pixel ID. Check your webview Pixel configuration");
            return;
        }
        InternalAppEventsLogger logger = InternalAppEventsLogger.Companion.createInstance$default(InternalAppEventsLogger.Companion, this.context, null, 2, null);
        Bundle parameters = FacebookSDKJSInterface.Companion.jsonStringToBundle(jsonString);
        parameters.putString(PARAMETER_FBSDK_PIXEL_REFERRAL, pixelId);
        logger.logEvent(eventName, parameters);
    }

    @JavascriptInterface
    @NotNull
    public final String getProtocol() {
        return this.protocol;
    }

    static {
        String string = FacebookSDKJSInterface.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FacebookSDKJSInterface::class.java.simpleName");
        TAG = string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/facebook/appevents/FacebookSDKJSInterface$Companion;", "", "()V", "PARAMETER_FBSDK_PIXEL_REFERRAL", "", "TAG", "getTAG", "()Ljava/lang/String;", "jsonStringToBundle", "Landroid/os/Bundle;", "jsonString", "jsonToBundle", "jsonObject", "Lorg/json/JSONObject;", "facebook-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        private final Bundle jsonToBundle(JSONObject jsonObject) throws JSONException {
            Bundle bundle = new Bundle();
            Iterator iterator = jsonObject.keys();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"jsonObject.keys()");
            Iterator iter = iterator;
            while (iter.hasNext()) {
                Object e = iter.next();
                if (e == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                String key = (String)e;
                String value = jsonObject.getString(key);
                bundle.putString(key, value);
            }
            return bundle;
        }

        private final Bundle jsonStringToBundle(String jsonString) {
            try {
                JSONObject jsonObject = new JSONObject(jsonString);
                return this.jsonToBundle(jsonObject);
            }
            catch (JSONException jSONException) {
                return new Bundle();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

