/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.SharedPreferences;
import android.os.Bundle;
import com.facebook.AccessToken;
import com.facebook.FacebookSdk;
import com.facebook.LegacyTokenHelper;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\tJ\b\u0010\u001a\u001a\u00020\u0016H\u0002R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/facebook/AccessTokenCache;", "", "()V", "sharedPreferences", "Landroid/content/SharedPreferences;", "tokenCachingStrategyFactory", "Lcom/facebook/AccessTokenCache$SharedPreferencesTokenCachingStrategyFactory;", "(Landroid/content/SharedPreferences;Lcom/facebook/AccessTokenCache$SharedPreferencesTokenCachingStrategyFactory;)V", "cachedAccessToken", "Lcom/facebook/AccessToken;", "getCachedAccessToken", "()Lcom/facebook/AccessToken;", "legacyAccessToken", "getLegacyAccessToken", "tokenCachingStrategy", "Lcom/facebook/LegacyTokenHelper;", "getTokenCachingStrategy", "()Lcom/facebook/LegacyTokenHelper;", "tokenCachingStrategyField", "clear", "", "hasCachedAccessToken", "", "load", "save", "accessToken", "shouldCheckLegacyToken", "Companion", "SharedPreferencesTokenCachingStrategyFactory", "facebook-core_release"})
public final class AccessTokenCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SharedPreferences sharedPreferences;
    @NotNull
    private final SharedPreferencesTokenCachingStrategyFactory tokenCachingStrategyFactory;
    @Nullable
    private LegacyTokenHelper tokenCachingStrategyField;
    @NotNull
    public static final String CACHED_ACCESS_TOKEN_KEY = "com.facebook.AccessTokenManager.CachedAccessToken";

    public AccessTokenCache(@NotNull SharedPreferences sharedPreferences, @NotNull SharedPreferencesTokenCachingStrategyFactory tokenCachingStrategyFactory) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        Intrinsics.checkNotNullParameter((Object)tokenCachingStrategyFactory, (String)"tokenCachingStrategyFactory");
        this.sharedPreferences = sharedPreferences;
        this.tokenCachingStrategyFactory = tokenCachingStrategyFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoHandleExceptions
    private final LegacyTokenHelper getTokenCachingStrategy() {
        if (this.tokenCachingStrategyField == null) {
            boolean bl = false;
            boolean bl2 = false;
            synchronized (this) {
                boolean bl3 = false;
                if (this.tokenCachingStrategyField == null) {
                    this.tokenCachingStrategyField = this.tokenCachingStrategyFactory.create();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        LegacyTokenHelper legacyTokenHelper = this.tokenCachingStrategyField;
        boolean bl = false;
        boolean bl4 = false;
        bl4 = false;
        boolean bl5 = false;
        if (legacyTokenHelper == null) {
            boolean bl6 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return legacyTokenHelper;
    }

    public AccessTokenCache() {
        SharedPreferences sharedPreferences = FacebookSdk.INSTANCE.getApplicationContext().getSharedPreferences("com.facebook.AccessTokenManager.SharedPreferences", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"FacebookSdk.getApplicationContext()\n              .getSharedPreferences(\n                  AccessTokenManager.SHARED_PREFERENCES_NAME, Context.MODE_PRIVATE)");
        this(sharedPreferences, new SharedPreferencesTokenCachingStrategyFactory());
    }

    @Nullable
    public final AccessToken load() {
        AccessToken accessToken = null;
        if (this.hasCachedAccessToken()) {
            accessToken = this.getCachedAccessToken();
        } else if (this.shouldCheckLegacyToken() && (accessToken = this.getLegacyAccessToken()) != null) {
            this.save(accessToken);
            this.getTokenCachingStrategy().clear();
        }
        return accessToken;
    }

    public final void save(@NotNull AccessToken accessToken) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        try {
            JSONObject jsonObject = accessToken.toJSONObject$facebook_core_release();
            this.sharedPreferences.edit().putString(CACHED_ACCESS_TOKEN_KEY, jsonObject.toString()).apply();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public final void clear() {
        this.sharedPreferences.edit().remove(CACHED_ACCESS_TOKEN_KEY).apply();
        if (this.shouldCheckLegacyToken()) {
            this.getTokenCachingStrategy().clear();
        }
    }

    private final boolean hasCachedAccessToken() {
        return this.sharedPreferences.contains(CACHED_ACCESS_TOKEN_KEY);
    }

    private final AccessToken getCachedAccessToken() {
        AccessToken accessToken;
        String jsonString = this.sharedPreferences.getString(CACHED_ACCESS_TOKEN_KEY, null);
        if (jsonString != null) {
            AccessToken accessToken2;
            try {
                JSONObject jsonObject = new JSONObject(jsonString);
                accessToken2 = AccessToken.Companion.createFromJSONObject$facebook_core_release(jsonObject);
            }
            catch (JSONException e) {
                accessToken2 = null;
            }
            accessToken = accessToken2;
        } else {
            accessToken = null;
        }
        return accessToken;
    }

    private final boolean shouldCheckLegacyToken() {
        return FacebookSdk.INSTANCE.isLegacyTokenUpgradeSupported();
    }

    private final AccessToken getLegacyAccessToken() {
        AccessToken accessToken = null;
        Bundle bundle = this.getTokenCachingStrategy().load();
        if (bundle != null && LegacyTokenHelper.Companion.hasTokenInformation(bundle)) {
            accessToken = AccessToken.Companion.createFromLegacyCache$facebook_core_release(bundle);
        }
        return accessToken;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/facebook/AccessTokenCache$SharedPreferencesTokenCachingStrategyFactory;", "", "()V", "create", "Lcom/facebook/LegacyTokenHelper;", "facebook-core_release"})
    public static final class SharedPreferencesTokenCachingStrategyFactory {
        @NotNull
        public final LegacyTokenHelper create() {
            return new LegacyTokenHelper(FacebookSdk.INSTANCE.getApplicationContext(), null, 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/AccessTokenCache$Companion;", "", "()V", "CACHED_ACCESS_TOKEN_KEY", "", "facebook-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

