/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument.anrreport;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookSdk;
import com.facebook.GraphResponse;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.InstrumentData;
import com.facebook.internal.instrument.InstrumentUtility;
import com.facebook.internal.instrument.anrreport.ANRDetector;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/internal/instrument/anrreport/ANRHandler;", "", "()V", "MAX_ANR_REPORT_NUM", "", "enabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "enable", "", "sendANRReports", "facebook-core_release"})
@AutoHandleExceptions
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ANRHandler {
    @NotNull
    public static final ANRHandler INSTANCE = new ANRHandler();
    private static final int MAX_ANR_REPORT_NUM = 5;
    @NotNull
    private static final AtomicBoolean enabled = new AtomicBoolean(false);

    private ANRHandler() {
    }

    @JvmStatic
    public static final synchronized void enable() {
        if (enabled.getAndSet(true)) {
            return;
        }
        if (FacebookSdk.INSTANCE.getAutoLogAppEventsEnabled()) {
            INSTANCE.sendANRReports();
        }
        ANRDetector.INSTANCE.start();
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @VisibleForTesting
    public static final void sendANRReports() {
        void $this$filterTo$iv$iv2;
        Iterable $this$mapTo$iv$iv;
        File[] reports;
        if (Utility.INSTANCE.isDataProcessingRestricted()) {
            return;
        }
        File[] $this$map$iv = reports = InstrumentUtility.INSTANCE.listAnrReportFiles();
        boolean $i$f$map = false;
        File[] fileArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv;
        int n = ((void)iterator).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_18 = item$iv$iv = iterator[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            InstrumentData instrumentData = InstrumentData.Builder.load((File)it);
            collection.add(instrumentData);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        int $i$f$filter = 0;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            InstrumentData it = (InstrumentData)element$iv$iv;
            boolean bl = false;
            if (!it.isValid()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List validReports = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), ANRHandler::sendANRReports$lambda-2);
        JSONArray anrLogs = new JSONArray();
        $i$f$filter = validReports.size();
        int $this$filterTo$iv$iv2 = 5;
        boolean bl = false;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)Math.min($i$f$filter, $this$filterTo$iv$iv2));
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl2 = false;
            anrLogs.put(validReports.get(it));
        }
        InstrumentUtility.sendReports("anr_reports", anrLogs, arg_0 -> ANRHandler.sendANRReports$lambda-5(validReports, arg_0));
    }

    private static final int sendANRReports$lambda-2(InstrumentData o1, InstrumentData o2) {
        Intrinsics.checkNotNullExpressionValue((Object)o2, (String)"o2");
        return o1.compareTo(o2);
    }

    private static final void sendANRReports$lambda-5(List $validReports, GraphResponse response) {
        Intrinsics.checkNotNullParameter((Object)$validReports, (String)"$validReports");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        try {
            JSONObject jSONObject;
            if (response.getError() == null && Intrinsics.areEqual((Object)((jSONObject = response.getJsonObject()) == null ? null : Boolean.valueOf(jSONObject.getBoolean("success"))), (Object)true)) {
                Iterable $this$forEach$iv = $validReports;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    InstrumentData it = (InstrumentData)element$iv;
                    boolean bl = false;
                    it.clear();
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

