/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ondeviceprocessing;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.appevents.ondeviceprocessing.RemoteServiceParametersHelper;
import com.facebook.internal.FacebookSignatureValidator;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import com.facebook.ppml.receiver.IReceiverService;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0003\u0019\u001a\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0007J&\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/facebook/appevents/ondeviceprocessing/RemoteServiceWrapper;", "", "()V", "RECEIVER_SERVICE_ACTION", "", "RECEIVER_SERVICE_PACKAGE", "RECEIVER_SERVICE_PACKAGE_WAKIZASHI", "TAG", "isServiceAvailable", "", "Ljava/lang/Boolean;", "getVerifiedServiceIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "sendCustomEvents", "Lcom/facebook/appevents/ondeviceprocessing/RemoteServiceWrapper$ServiceResult;", "applicationId", "appEvents", "", "Lcom/facebook/appevents/AppEvent;", "sendEvents", "eventType", "Lcom/facebook/appevents/ondeviceprocessing/RemoteServiceWrapper$EventType;", "sendInstallEvent", "EventType", "RemoteServiceConnection", "ServiceResult", "facebook-core_release"})
@AutoHandleExceptions
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class RemoteServiceWrapper {
    @NotNull
    public static final RemoteServiceWrapper INSTANCE = new RemoteServiceWrapper();
    @NotNull
    private static final String TAG;
    @NotNull
    public static final String RECEIVER_SERVICE_ACTION = "ReceiverService";
    @NotNull
    public static final String RECEIVER_SERVICE_PACKAGE = "com.facebook.katana";
    @NotNull
    public static final String RECEIVER_SERVICE_PACKAGE_WAKIZASHI = "com.facebook.wakizashi";
    @Nullable
    private static Boolean isServiceAvailable;

    private RemoteServiceWrapper() {
    }

    @JvmStatic
    public static final boolean isServiceAvailable() {
        Boolean bl;
        if (isServiceAvailable == null) {
            Context context = FacebookSdk.INSTANCE.getApplicationContext();
            isServiceAvailable = INSTANCE.getVerifiedServiceIntent(context) != null;
        }
        return (bl = isServiceAvailable) == null ? false : bl;
    }

    @JvmStatic
    @NotNull
    public static final ServiceResult sendInstallEvent(@NotNull String applicationId) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        boolean bl = false;
        return INSTANCE.sendEvents(EventType.MOBILE_APP_INSTALL, applicationId, CollectionsKt.emptyList());
    }

    @JvmStatic
    @NotNull
    public static final ServiceResult sendCustomEvents(@NotNull String applicationId, @NotNull List<AppEvent> appEvents) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter(appEvents, (String)"appEvents");
        return INSTANCE.sendEvents(EventType.CUSTOM_APP_EVENTS, applicationId, appEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ServiceResult sendEvents(EventType eventType, String applicationId, List<AppEvent> appEvents) {
        ServiceResult serviceResult = ServiceResult.SERVICE_NOT_AVAILABLE;
        AppEventUtility.INSTANCE.assertIsNotMainThread();
        Context context = FacebookSdk.INSTANCE.getApplicationContext();
        Intent verifiedIntent = this.getVerifiedServiceIntent(context);
        if (verifiedIntent != null) {
            RemoteServiceConnection connection = new RemoteServiceConnection();
            if (context.bindService(verifiedIntent, (ServiceConnection)connection, 1)) {
                try {
                    ServiceResult serviceResult2;
                    IBinder binder = connection.getBinder();
                    if (binder != null) {
                        IReceiverService service = IReceiverService.Stub.asInterface(binder);
                        Bundle eventBundle = RemoteServiceParametersHelper.buildEventsBundle(eventType, applicationId, appEvents);
                        if (eventBundle != null) {
                            service.sendEvents(eventBundle);
                            Utility.logd(TAG, Intrinsics.stringPlus((String)"Successfully sent events to the remote service: ", (Object)eventBundle));
                        }
                        serviceResult2 = ServiceResult.OPERATION_SUCCESS;
                    } else {
                        serviceResult2 = ServiceResult.SERVICE_NOT_AVAILABLE;
                    }
                    serviceResult = serviceResult2;
                }
                catch (InterruptedException exception) {
                    serviceResult = ServiceResult.SERVICE_ERROR;
                    Utility.logd(TAG, exception);
                }
                catch (RemoteException exception) {
                    serviceResult = ServiceResult.SERVICE_ERROR;
                    Utility.logd(TAG, (Exception)((Object)exception));
                }
                finally {
                    context.unbindService((ServiceConnection)connection);
                    Utility.logd(TAG, "Unbound from the remote service");
                }
            } else {
                serviceResult = ServiceResult.SERVICE_ERROR;
            }
        }
        return serviceResult;
    }

    private final Intent getVerifiedServiceIntent(Context context) {
        PackageManager packageManager = context.getPackageManager();
        if (packageManager != null) {
            Intent serviceIntent = new Intent(RECEIVER_SERVICE_ACTION);
            serviceIntent.setPackage(RECEIVER_SERVICE_PACKAGE);
            ResolveInfo serviceInfo = packageManager.resolveService(serviceIntent, 0);
            if (serviceInfo != null) {
                if (FacebookSignatureValidator.validateSignature(context, RECEIVER_SERVICE_PACKAGE)) {
                    return serviceIntent;
                }
            }
            Intent wakizashiServiceIntent = new Intent(RECEIVER_SERVICE_ACTION);
            wakizashiServiceIntent.setPackage(RECEIVER_SERVICE_PACKAGE_WAKIZASHI);
            ResolveInfo wakizashiServiceInfo = packageManager.resolveService(wakizashiServiceIntent, 0);
            if (wakizashiServiceInfo != null) {
                if (FacebookSignatureValidator.validateSignature(context, RECEIVER_SERVICE_PACKAGE_WAKIZASHI)) {
                    return wakizashiServiceIntent;
                }
            }
        }
        return null;
    }

    static {
        String string = RemoteServiceWrapper.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RemoteServiceWrapper::class.java.simpleName");
        TAG = string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/facebook/appevents/ondeviceprocessing/RemoteServiceWrapper$ServiceResult;", "", "(Ljava/lang/String;I)V", "OPERATION_SUCCESS", "SERVICE_NOT_AVAILABLE", "SERVICE_ERROR", "facebook-core_release"})
    public static final class ServiceResult
    extends Enum<ServiceResult> {
        public static final /* enum */ ServiceResult OPERATION_SUCCESS = new ServiceResult();
        public static final /* enum */ ServiceResult SERVICE_NOT_AVAILABLE = new ServiceResult();
        public static final /* enum */ ServiceResult SERVICE_ERROR = new ServiceResult();
        private static final /* synthetic */ ServiceResult[] $VALUES;

        public static ServiceResult[] values() {
            ServiceResult[] serviceResultArray = $VALUES;
            return Arrays.copyOf(serviceResultArray, serviceResultArray.length);
        }

        public static ServiceResult valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(ServiceResult.class, value);
        }

        static {
            $VALUES = serviceResultArray = new ServiceResult[]{ServiceResult.OPERATION_SUCCESS, ServiceResult.SERVICE_NOT_AVAILABLE, ServiceResult.SERVICE_ERROR};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/facebook/appevents/ondeviceprocessing/RemoteServiceWrapper$EventType;", "", "eventType", "", "(Ljava/lang/String;ILjava/lang/String;)V", "toString", "MOBILE_APP_INSTALL", "CUSTOM_APP_EVENTS", "facebook-core_release"})
    public static final class EventType
    extends Enum<EventType> {
        @NotNull
        private final String eventType;
        public static final /* enum */ EventType MOBILE_APP_INSTALL = new EventType("MOBILE_APP_INSTALL");
        public static final /* enum */ EventType CUSTOM_APP_EVENTS = new EventType("CUSTOM_APP_EVENTS");
        private static final /* synthetic */ EventType[] $VALUES;

        private EventType(String eventType) {
            this.eventType = eventType;
        }

        @NotNull
        public String toString() {
            return this.eventType;
        }

        public static EventType[] values() {
            EventType[] eventTypeArray = $VALUES;
            return Arrays.copyOf(eventTypeArray, eventTypeArray.length);
        }

        public static EventType valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(EventType.class, value);
        }

        static {
            $VALUES = eventTypeArray = new EventType[]{EventType.MOBILE_APP_INSTALL, EventType.CUSTOM_APP_EVENTS};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/appevents/ondeviceprocessing/RemoteServiceWrapper$RemoteServiceConnection;", "Landroid/content/ServiceConnection;", "()V", "binder", "Landroid/os/IBinder;", "latch", "Ljava/util/concurrent/CountDownLatch;", "getBinder", "onNullBinding", "", "name", "Landroid/content/ComponentName;", "onServiceConnected", "serviceBinder", "onServiceDisconnected", "facebook-core_release"})
    private static final class RemoteServiceConnection
    implements ServiceConnection {
        @NotNull
        private final CountDownLatch latch = new CountDownLatch(1);
        @Nullable
        private IBinder binder;

        public void onServiceConnected(@NotNull ComponentName name, @NotNull IBinder serviceBinder) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)serviceBinder, (String)"serviceBinder");
            this.binder = serviceBinder;
            this.latch.countDown();
        }

        public void onNullBinding(@NotNull ComponentName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.latch.countDown();
        }

        public void onServiceDisconnected(@NotNull ComponentName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        }

        @Nullable
        public final IBinder getBinder() throws InterruptedException {
            this.latch.await(5L, TimeUnit.SECONDS);
            return this.binder;
        }
    }
}

