/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.internal.HashUtils;
import com.facebook.appevents.internal.SessionInfo;
import com.facebook.appevents.internal.SourceApplicationInfo;
import com.facebook.internal.Logger;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import com.facebook.internal.security.CertificateUtil;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u0015\u001a\u00020\u0010H\u0002J$\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/appevents/internal/SessionLogger;", "", "()V", "INACTIVE_SECONDS_QUANTA", "", "PACKAGE_CHECKSUM", "", "TAG", "computePackageChecksum", "context", "Landroid/content/Context;", "getQuantaIndex", "", "timeBetweenSessions", "", "logActivateApp", "", "activityName", "sourceApplicationInfo", "Lcom/facebook/appevents/internal/SourceApplicationInfo;", "appId", "logClockSkewEvent", "logDeactivateApp", "sessionInfo", "Lcom/facebook/appevents/internal/SessionInfo;", "facebook-core_release"})
@AutoHandleExceptions
public final class SessionLogger {
    @NotNull
    public static final SessionLogger INSTANCE = new SessionLogger();
    @NotNull
    private static final String PACKAGE_CHECKSUM = "PCKGCHKSUM";
    @Nullable
    private static final String TAG = SessionLogger.class.getCanonicalName();
    @NotNull
    private static final long[] INACTIVE_SECONDS_QUANTA;

    private SessionLogger() {
    }

    @JvmStatic
    public static final void logActivateApp(@NotNull String activityName, @Nullable SourceApplicationInfo sourceApplicationInfo, @Nullable String appId, @NotNull Context context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SourceApplicationInfo sourceApplicationInfo2 = sourceApplicationInfo;
        String sourAppInfoStr = sourceApplicationInfo2 == null ? "Unclassified" : ((string = sourceApplicationInfo2.toString()) == null ? "Unclassified" : string);
        Bundle eventParams = new Bundle();
        eventParams.putString("fb_mobile_launch_source", sourAppInfoStr);
        eventParams.putString("fb_mobile_pckg_fp", INSTANCE.computePackageChecksum(context));
        eventParams.putString("fb_mobile_app_cert_hash", CertificateUtil.getCertificateHash(context));
        InternalAppEventsLogger logger = InternalAppEventsLogger.Companion.createInstance(activityName, appId, null);
        logger.logEvent("fb_mobile_activate_app", eventParams);
        if (InternalAppEventsLogger.Companion.getFlushBehavior() != AppEventsLogger.FlushBehavior.EXPLICIT_ONLY) {
            logger.flush();
        }
    }

    @JvmStatic
    public static final void logDeactivateApp(@NotNull String activityName, @Nullable SessionInfo sessionInfo, @Nullable String appId) {
        long sessionLength;
        long interruptionDurationMillis;
        Long l;
        Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
        if (sessionInfo == null) {
            return;
        }
        Long l2 = sessionInfo.getDiskRestoreTime();
        long l3 = l2 == null ? 0L - ((l = sessionInfo.getSessionLastEventTime()) == null ? 0L : l) : (interruptionDurationMillis = l2.longValue());
        if (interruptionDurationMillis < 0L) {
            interruptionDurationMillis = 0L;
            INSTANCE.logClockSkewEvent();
        }
        if ((sessionLength = sessionInfo.getSessionLength()) < 0L) {
            INSTANCE.logClockSkewEvent();
            sessionLength = 0L;
        }
        Bundle eventParams = new Bundle();
        eventParams.putInt("fb_mobile_app_interruptions", sessionInfo.getInterruptionCount());
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Locale locale = Locale.ROOT;
        Object object = "session_quanta_%d";
        Object object2 = new Object[1];
        object2[0] = SessionLogger.getQuantaIndex(interruptionDurationMillis);
        boolean bl = false;
        String string = String.format(locale, (String)object, Arrays.copyOf(object2, ((Object[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(locale, format, *args)");
        eventParams.putString("fb_mobile_time_between_sessions", string);
        SourceApplicationInfo sourceApplicationInfo = sessionInfo.getSourceApplicationInfo();
        object = sourceApplicationInfo;
        Object sourAppInfoStr = object == null ? "Unclassified" : ((object2 = ((SourceApplicationInfo)object).toString()) == null ? "Unclassified" : object2);
        eventParams.putString("fb_mobile_launch_source", (String)sourAppInfoStr);
        object = sessionInfo.getSessionLastEventTime();
        eventParams.putLong("_logTime", (object == null ? 0L : (Long)object) / (long)1000);
        InternalAppEventsLogger.Companion.createInstance(activityName, appId, null).logEvent("fb_mobile_deactivate_app", (double)sessionLength / (double)1000L, eventParams);
    }

    private final void logClockSkewEvent() {
        String string = TAG;
        Intrinsics.checkNotNull((Object)string);
        Logger.Companion.log(LoggingBehavior.APP_EVENTS, string, "Clock skew detected");
    }

    @JvmStatic
    public static final int getQuantaIndex(long timeBetweenSessions) {
        int quantaIndex;
        for (quantaIndex = 0; quantaIndex < INACTIVE_SECONDS_QUANTA.length && INACTIVE_SECONDS_QUANTA[quantaIndex] < timeBetweenSessions; ++quantaIndex) {
        }
        return quantaIndex;
    }

    private final String computePackageChecksum(Context context) {
        String string;
        try {
            String string2;
            PackageManager pm = context.getPackageManager();
            String packageVersion = pm.getPackageInfo((String)context.getPackageName(), (int)0).versionName;
            String packageHashSharedPrefKey = Intrinsics.stringPlus((String)"PCKGCHKSUM;", (Object)packageVersion);
            SharedPreferences preferences = context.getSharedPreferences("com.facebook.sdk.appEventPreferences", 0);
            String packageHash = preferences.getString(packageHashSharedPrefKey, null);
            if (packageHash != null && packageHash.length() == 32) {
                return packageHash;
            }
            String androidPackageManagerChecksum = HashUtils.computeChecksumWithPackageManager(context, null);
            if (androidPackageManagerChecksum != null) {
                string2 = androidPackageManagerChecksum;
            } else {
                ApplicationInfo ai = pm.getApplicationInfo(context.getPackageName(), 0);
                string2 = HashUtils.computeChecksum(ai.sourceDir);
            }
            packageHash = string2;
            preferences.edit().putString(packageHashSharedPrefKey, packageHash).apply();
            string = packageHash;
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    static {
        long[] lArray = new long[]{300000L, 900000L, 1800000L, 3600000L, 21600000L, 43200000L, 86400000L, 172800000L, 259200000L, 604800000L, 1209600000L, 1814400000L, 2419200000L, 5184000000L, 7776000000L, 10368000000L, 12960000000L, 15552000000L, 31536000000L};
        INACTIVE_SECONDS_QUANTA = lArray;
    }
}

