/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless.internal;

import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.Patterns;
import android.view.View;
import android.widget.TextView;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\f\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\rH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/facebook/appevents/codeless/internal/SensitiveUserDataUtils;", "", "()V", "isCreditCard", "", "view", "Landroid/widget/TextView;", "isEmail", "isPassword", "isPersonName", "isPhoneNumber", "isPostalAddress", "isSensitiveUserData", "Landroid/view/View;", "facebook-core_release"})
@AutoHandleExceptions
public final class SensitiveUserDataUtils {
    @NotNull
    public static final SensitiveUserDataUtils INSTANCE = new SensitiveUserDataUtils();

    private SensitiveUserDataUtils() {
    }

    @JvmStatic
    public static final boolean isSensitiveUserData(@Nullable View view) {
        if (view instanceof TextView) {
            return INSTANCE.isPassword((TextView)view) || INSTANCE.isCreditCard((TextView)view) || INSTANCE.isPersonName((TextView)view) || INSTANCE.isPostalAddress((TextView)view) || INSTANCE.isPhoneNumber((TextView)view) || INSTANCE.isEmail((TextView)view);
        }
        return false;
    }

    private final boolean isPassword(TextView view) {
        int inputType = view.getInputType();
        if (inputType == 128) {
            return true;
        }
        TransformationMethod method = view.getTransformationMethod();
        return method instanceof PasswordTransformationMethod;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEmail(TextView view) {
        int inputType = view.getInputType();
        if (inputType == 32) {
            return true;
        }
        String text = ViewHierarchy.getTextOfView((View)view);
        if (text == null) return false;
        CharSequence charSequence = text;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return false;
        }
        boolean bl2 = false;
        if (bl2) {
            return false;
        }
        boolean bl3 = Patterns.EMAIL_ADDRESS.matcher(text).matches();
        return bl3;
    }

    private final boolean isPersonName(TextView view) {
        int inputType = view.getInputType();
        return inputType == 96;
    }

    private final boolean isPostalAddress(TextView view) {
        int inputType = view.getInputType();
        return inputType == 112;
    }

    private final boolean isPhoneNumber(TextView view) {
        int inputType = view.getInputType();
        return inputType == 3;
    }

    private final boolean isCreditCard(TextView view) {
        CharSequence charSequence = ViewHierarchy.getTextOfView((View)view);
        String string = "\\s";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "";
        int n = 0;
        String ccNumber = string.replace(charSequence, string2);
        int length = ccNumber.length();
        if (length < 12 || length > 19) {
            return false;
        }
        int sum = 0;
        boolean alternate = false;
        n = length - 1;
        if (0 <= n) {
            do {
                char digit;
                int i = n--;
                char c = digit = ccNumber.charAt(i);
                boolean bl2 = false;
                if (!Character.isDigit(c)) {
                    return false;
                }
                int n2 = CharsKt.digitToInt((char)digit);
                if (alternate && (n2 *= 2) > 9) {
                    n2 = n2 % 10 + 1;
                }
                sum += n2;
                boolean bl3 = alternate = !alternate;
            } while (0 <= n);
        }
        return sum % 10 == 0;
    }
}

