/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument.crashreport;

import android.util.Log;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.GraphResponse;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.ExceptionAnalyzer;
import com.facebook.internal.instrument.InstrumentData;
import com.facebook.internal.instrument.InstrumentUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0011\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/facebook/internal/instrument/crashreport/CrashHandler;", "Ljava/lang/Thread$UncaughtExceptionHandler;", "previousHandler", "(Ljava/lang/Thread$UncaughtExceptionHandler;)V", "uncaughtException", "", "t", "Ljava/lang/Thread;", "e", "", "Companion", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CrashHandler
implements Thread.UncaughtExceptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Thread.UncaughtExceptionHandler previousHandler;
    @Nullable
    private static final String TAG = CrashHandler.class.getCanonicalName();
    private static final int MAX_CRASH_REPORT_NUM = 5;
    @Nullable
    private static CrashHandler instance;

    private CrashHandler(Thread.UncaughtExceptionHandler previousHandler) {
        this.previousHandler = previousHandler;
    }

    @Override
    public void uncaughtException(@NotNull Thread t, @NotNull Throwable e) {
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (InstrumentUtility.isSDKRelatedException(e)) {
            ExceptionAnalyzer.execute(e);
            InstrumentData.Builder.build(e, InstrumentData.Type.CrashReport).save();
        }
        if ((uncaughtExceptionHandler = this.previousHandler) != null) {
            uncaughtExceptionHandler.uncaughtException(t, e);
        }
    }

    @JvmStatic
    public static final synchronized void enable() {
        Companion.enable();
    }

    public /* synthetic */ CrashHandler(Thread.UncaughtExceptionHandler previousHandler, DefaultConstructorMarker $constructor_marker) {
        this(previousHandler);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/internal/instrument/crashreport/CrashHandler$Companion;", "", "()V", "MAX_CRASH_REPORT_NUM", "", "TAG", "", "instance", "Lcom/facebook/internal/instrument/crashreport/CrashHandler;", "enable", "", "sendExceptionReports", "facebook-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final synchronized void enable() {
            if (FacebookSdk.INSTANCE.getAutoLogAppEventsEnabled()) {
                this.sendExceptionReports();
            }
            if (instance != null) {
                Log.w((String)TAG, (String)"Already enabled!");
                return;
            }
            Thread.UncaughtExceptionHandler oldHandler = Thread.getDefaultUncaughtExceptionHandler();
            instance = new CrashHandler(oldHandler, null);
            Thread.setDefaultUncaughtExceptionHandler(instance);
        }

        /*
         * WARNING - void declaration
         */
        private final void sendExceptionReports() {
            void $this$filterTo$iv$iv2;
            Iterable $this$mapTo$iv$iv;
            File[] reports;
            if (Utility.INSTANCE.isDataProcessingRestricted()) {
                return;
            }
            File[] $this$map$iv = reports = InstrumentUtility.INSTANCE.listExceptionReportFiles();
            boolean $i$f$map = false;
            File[] fileArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv;
            int n = ((void)iterator).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var12_19 = item$iv$iv = iterator[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                InstrumentData instrumentData = InstrumentData.Builder.load((File)it);
                collection.add(instrumentData);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            int $i$f$filter = 0;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                InstrumentData it = (InstrumentData)element$iv$iv;
                boolean bl = false;
                if (!it.isValid()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List validReports = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), Companion::sendExceptionReports$lambda-2);
            JSONArray crashLogs = new JSONArray();
            $i$f$filter = validReports.size();
            int $this$filterTo$iv$iv2 = 5;
            boolean bl = false;
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)Math.min($i$f$filter, $this$filterTo$iv$iv2));
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl2 = false;
                crashLogs.put(validReports.get(it));
            }
            InstrumentUtility.sendReports("crash_reports", crashLogs, arg_0 -> Companion.sendExceptionReports$lambda-5(validReports, arg_0));
        }

        private static final int sendExceptionReports$lambda-2(InstrumentData o1, InstrumentData o2) {
            Intrinsics.checkNotNullExpressionValue((Object)o2, (String)"o2");
            return o1.compareTo(o2);
        }

        private static final void sendExceptionReports$lambda-5(List $validReports, GraphResponse response) {
            Intrinsics.checkNotNullParameter((Object)$validReports, (String)"$validReports");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            try {
                JSONObject jSONObject;
                if (response.getError() == null && Intrinsics.areEqual((Object)((jSONObject = response.getJsonObject()) == null ? null : Boolean.valueOf(jSONObject.getBoolean("success"))), (Object)true)) {
                    Iterable $this$forEach$iv = $validReports;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        InstrumentData it = (InstrumentData)element$iv;
                        boolean bl = false;
                        it.clear();
                    }
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

