/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import com.facebook.AccessTokenSource;
import com.facebook.LoggingBehavior;
import com.facebook.internal.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u0011\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/LegacyTokenHelper;", "", "context", "Landroid/content/Context;", "cacheKey", "", "(Landroid/content/Context;Ljava/lang/String;)V", "cache", "Landroid/content/SharedPreferences;", "clear", "", "deserializeKey", "key", "bundle", "Landroid/os/Bundle;", "load", "save", "serializeKey", "editor", "Landroid/content/SharedPreferences$Editor;", "Companion", "facebook-core_release"})
public final class LegacyTokenHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String cacheKey;
    @NotNull
    private final SharedPreferences cache;
    @NotNull
    public static final String TOKEN_KEY = "com.facebook.TokenCachingStrategy.Token";
    @NotNull
    public static final String EXPIRATION_DATE_KEY = "com.facebook.TokenCachingStrategy.ExpirationDate";
    @NotNull
    public static final String LAST_REFRESH_DATE_KEY = "com.facebook.TokenCachingStrategy.LastRefreshDate";
    @NotNull
    public static final String TOKEN_SOURCE_KEY = "com.facebook.TokenCachingStrategy.AccessTokenSource";
    @NotNull
    public static final String PERMISSIONS_KEY = "com.facebook.TokenCachingStrategy.Permissions";
    @NotNull
    public static final String DECLINED_PERMISSIONS_KEY = "com.facebook.TokenCachingStrategy.DeclinedPermissions";
    @NotNull
    public static final String EXPIRED_PERMISSIONS_KEY = "com.facebook.TokenCachingStrategy.ExpiredPermissions";
    @NotNull
    public static final String APPLICATION_ID_KEY = "com.facebook.TokenCachingStrategy.ApplicationId";
    private static final long INVALID_BUNDLE_MILLISECONDS = Long.MIN_VALUE;
    @NotNull
    private static final String IS_SSO_KEY = "com.facebook.TokenCachingStrategy.IsSSO";
    @NotNull
    public static final String DEFAULT_CACHE_KEY = "com.facebook.SharedPreferencesTokenCachingStrategy.DEFAULT_KEY";
    @NotNull
    private static final String TAG;
    @NotNull
    private static final String JSON_VALUE_TYPE = "valueType";
    @NotNull
    private static final String JSON_VALUE = "value";
    @NotNull
    private static final String JSON_VALUE_ENUM_TYPE = "enumType";
    @NotNull
    private static final String TYPE_BOOLEAN = "bool";
    @NotNull
    private static final String TYPE_BOOLEAN_ARRAY = "bool[]";
    @NotNull
    private static final String TYPE_BYTE = "byte";
    @NotNull
    private static final String TYPE_BYTE_ARRAY = "byte[]";
    @NotNull
    private static final String TYPE_SHORT = "short";
    @NotNull
    private static final String TYPE_SHORT_ARRAY = "short[]";
    @NotNull
    private static final String TYPE_INTEGER = "int";
    @NotNull
    private static final String TYPE_INTEGER_ARRAY = "int[]";
    @NotNull
    private static final String TYPE_LONG = "long";
    @NotNull
    private static final String TYPE_LONG_ARRAY = "long[]";
    @NotNull
    private static final String TYPE_FLOAT = "float";
    @NotNull
    private static final String TYPE_FLOAT_ARRAY = "float[]";
    @NotNull
    private static final String TYPE_DOUBLE = "double";
    @NotNull
    private static final String TYPE_DOUBLE_ARRAY = "double[]";
    @NotNull
    private static final String TYPE_CHAR = "char";
    @NotNull
    private static final String TYPE_CHAR_ARRAY = "char[]";
    @NotNull
    private static final String TYPE_STRING = "string";
    @NotNull
    private static final String TYPE_STRING_LIST = "stringList";
    @NotNull
    private static final String TYPE_ENUM = "enum";

    /*
     * Unable to fully structure code
     */
    @JvmOverloads
    public LegacyTokenHelper(@NotNull Context context, @Nullable String cacheKey) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super();
        context = context;
        if (cacheKey == null) ** GOTO lbl-1000
        var4_4 = cacheKey;
        var5_5 = false;
        if (var4_4.length() == 0) lbl-1000:
        // 2 sources

        {
            v0 = "com.facebook.SharedPreferencesTokenCachingStrategy.DEFAULT_KEY";
        } else {
            v0 = cacheKey;
        }
        this.cacheKey = v0;
        var5_6 = applicationContext = context.getApplicationContext();
        context = var5_6 == null ? context : var5_6;
        var5_6 = context.getSharedPreferences(this.cacheKey, 0);
        Intrinsics.checkNotNullExpressionValue((Object)var5_6, (String)"context.getSharedPreferences(this.cacheKey, Context.MODE_PRIVATE)");
        this.cache = var5_6;
    }

    public /* synthetic */ LegacyTokenHelper(Context context, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(context, string);
    }

    @Nullable
    public final Bundle load() {
        Bundle settings = new Bundle();
        Map allCachedEntries = this.cache.getAll();
        for (String key : allCachedEntries.keySet()) {
            try {
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                this.deserializeKey(key, settings);
            }
            catch (JSONException e) {
                Logger.Companion.log(LoggingBehavior.CACHE, 5, TAG, "Error reading cached value for key: '" + key + "' -- " + (Object)((Object)e));
                return null;
            }
        }
        return settings;
    }

    public final void save(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        SharedPreferences.Editor editor = this.cache.edit();
        for (String key : bundle.keySet()) {
            try {
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"editor");
                this.serializeKey(key, bundle, editor);
            }
            catch (JSONException e) {
                Logger.Companion.log(LoggingBehavior.CACHE, 5, TAG, "Error processing value for key: '" + key + "' -- " + (Object)((Object)e));
                return;
            }
        }
        editor.apply();
    }

    public final void clear() {
        this.cache.edit().clear().apply();
    }

    private final void serializeKey(String key, Bundle bundle, SharedPreferences.Editor editor) throws JSONException {
        Object object;
        Object object2;
        Object object3 = bundle.get(key);
        if (object3 == null) {
            return;
        }
        Object value = object2 = object3;
        String supportedType = null;
        JSONArray jsonArray = null;
        JSONObject json = new JSONObject();
        Object object4 = value;
        if (object4 instanceof Byte) {
            supportedType = TYPE_BYTE;
            json.put(JSON_VALUE, (int)((Number)value).byteValue());
        } else if (object4 instanceof Short) {
            supportedType = TYPE_SHORT;
            json.put(JSON_VALUE, (int)((Number)value).shortValue());
        } else if (object4 instanceof Integer) {
            supportedType = TYPE_INTEGER;
            json.put(JSON_VALUE, ((Number)value).intValue());
        } else if (object4 instanceof Long) {
            supportedType = TYPE_LONG;
            json.put(JSON_VALUE, ((Number)value).longValue());
        } else if (object4 instanceof Float) {
            supportedType = TYPE_FLOAT;
            json.put(JSON_VALUE, (double)((Number)value).floatValue());
        } else if (object4 instanceof Double) {
            supportedType = TYPE_DOUBLE;
            json.put(JSON_VALUE, ((Number)value).doubleValue());
        } else if (object4 instanceof Boolean) {
            supportedType = TYPE_BOOLEAN;
            json.put(JSON_VALUE, ((Boolean)value).booleanValue());
        } else if (object4 instanceof Character) {
            supportedType = TYPE_CHAR;
            json.put(JSON_VALUE, (Object)value.toString());
        } else if (object4 instanceof String) {
            supportedType = TYPE_STRING;
            json.put(JSON_VALUE, value);
        } else if (object4 instanceof Enum) {
            supportedType = TYPE_ENUM;
            json.put(JSON_VALUE, (Object)value.toString());
            json.put(JSON_VALUE_ENUM_TYPE, (Object)value.getClass().getName());
        } else {
            jsonArray = new JSONArray();
            object = value;
            if (object instanceof byte[]) {
                supportedType = TYPE_BYTE_ARRAY;
                for (byte v : (byte[])value) {
                    jsonArray.put((int)v);
                }
            } else if (object instanceof short[]) {
                supportedType = TYPE_SHORT_ARRAY;
                for (short v : (short[])value) {
                    jsonArray.put((int)v);
                }
            } else if (object instanceof int[]) {
                supportedType = TYPE_INTEGER_ARRAY;
                for (int v : (int[])value) {
                    jsonArray.put(v);
                }
            } else if (object instanceof long[]) {
                supportedType = TYPE_LONG_ARRAY;
                for (long v : (long[])value) {
                    jsonArray.put(v);
                }
            } else if (object instanceof float[]) {
                supportedType = TYPE_FLOAT_ARRAY;
                for (float v : (float[])value) {
                    jsonArray.put((double)v);
                }
            } else if (object instanceof double[]) {
                supportedType = TYPE_DOUBLE_ARRAY;
                for (double v : (double[])value) {
                    jsonArray.put(v);
                }
            } else if (object instanceof boolean[]) {
                supportedType = TYPE_BOOLEAN_ARRAY;
                for (boolean v : (boolean[])value) {
                    jsonArray.put(v);
                }
            } else if (object instanceof char[]) {
                supportedType = TYPE_CHAR_ARRAY;
                for (char v : (char[])value) {
                    jsonArray.put((Object)String.valueOf(v));
                }
            } else if (object instanceof List) {
                supportedType = TYPE_STRING_LIST;
                List stringList = (List)value;
                for (String v : stringList) {
                    String string = v;
                    jsonArray.put(string == null ? JSONObject.NULL : string);
                }
            } else {
                jsonArray = null;
            }
        }
        if (supportedType != null) {
            json.put(JSON_VALUE_TYPE, (Object)supportedType);
            if (jsonArray != null) {
                json.putOpt(JSON_VALUE, jsonArray);
            }
            object = json.toString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"json.toString()");
            String jsonString = object;
            editor.putString(key, jsonString);
        }
    }

    private final void deserializeKey(String key, Bundle bundle) throws JSONException {
        block86: {
            String string = this.cache.getString(key, "{}");
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            int n = 0;
            if (string == null) {
                boolean bl3 = false;
                String string2 = "Required value was null.";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            String string3 = string;
            String jsonString = string3;
            JSONObject json = new JSONObject(jsonString);
            String valueType = json.getString(JSON_VALUE_TYPE);
            if (valueType == null) break block86;
            int n2 = -1;
            switch (valueType.hashCode()) {
                case 3029738: {
                    if (valueType.equals(TYPE_BOOLEAN)) {
                        n2 = 1;
                    }
                    break;
                }
                case -891985903: {
                    if (valueType.equals(TYPE_STRING)) {
                        n2 = 2;
                    }
                    break;
                }
                case -1097129250: {
                    if (valueType.equals(TYPE_LONG_ARRAY)) {
                        n2 = 3;
                    }
                    break;
                }
                case 3039496: {
                    if (valueType.equals(TYPE_BYTE)) {
                        n2 = 4;
                    }
                    break;
                }
                case -1325958191: {
                    if (valueType.equals(TYPE_DOUBLE)) {
                        n2 = 5;
                    }
                    break;
                }
                case -1383386164: {
                    if (valueType.equals(TYPE_BOOLEAN_ARRAY)) {
                        n2 = 6;
                    }
                    break;
                }
                case 2067161310: {
                    if (valueType.equals(TYPE_SHORT_ARRAY)) {
                        n2 = 7;
                    }
                    break;
                }
                case 100361105: {
                    if (valueType.equals(TYPE_INTEGER_ARRAY)) {
                        n2 = 8;
                    }
                    break;
                }
                case 97526364: {
                    if (valueType.equals(TYPE_FLOAT)) {
                        n2 = 9;
                    }
                    break;
                }
                case 104431: {
                    if (valueType.equals(TYPE_INTEGER)) {
                        n2 = 10;
                    }
                    break;
                }
                case 3327612: {
                    if (valueType.equals(TYPE_LONG)) {
                        n2 = 11;
                    }
                    break;
                }
                case 3118337: {
                    if (valueType.equals(TYPE_ENUM)) {
                        n2 = 12;
                    }
                    break;
                }
                case -766441794: {
                    if (valueType.equals(TYPE_FLOAT_ARRAY)) {
                        n2 = 13;
                    }
                    break;
                }
                case -1361632968: {
                    if (valueType.equals(TYPE_CHAR_ARRAY)) {
                        n2 = 14;
                    }
                    break;
                }
                case -1374008726: {
                    if (valueType.equals(TYPE_BYTE_ARRAY)) {
                        n2 = 15;
                    }
                    break;
                }
                case 1359468275: {
                    if (valueType.equals(TYPE_DOUBLE_ARRAY)) {
                        n2 = 16;
                    }
                    break;
                }
                case -1573317553: {
                    if (valueType.equals(TYPE_STRING_LIST)) {
                        n2 = 17;
                    }
                    break;
                }
                case 3052374: {
                    if (valueType.equals(TYPE_CHAR)) {
                        n2 = 18;
                    }
                    break;
                }
                case 109413500: {
                    if (valueType.equals(TYPE_SHORT)) {
                        n2 = 19;
                    }
                    break;
                }
            }
            switch (n2) {
                case 1: {
                    bundle.putBoolean(key, json.getBoolean(JSON_VALUE));
                    break;
                }
                case 6: {
                    JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
                    boolean[] array = new boolean[jsonArray.length()];
                    n = 0;
                    int n3 = array.length + -1;
                    if (n <= n3) {
                        do {
                            int i = n++;
                            array[i] = jsonArray.getBoolean(i);
                        } while (n <= n3);
                    }
                    bundle.putBooleanArray(key, array);
                    break;
                }
                case 4: {
                    bundle.putByte(key, (byte)json.getInt(JSON_VALUE));
                    break;
                }
                case 15: {
                    JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
                    byte[] array = new byte[jsonArray.length()];
                    n = 0;
                    int n4 = array.length + -1;
                    if (n <= n4) {
                        do {
                            int i = n++;
                            array[i] = (byte)jsonArray.getInt(i);
                        } while (n <= n4);
                    }
                    bundle.putByteArray(key, array);
                    break;
                }
                case 19: {
                    bundle.putShort(key, (short)json.getInt(JSON_VALUE));
                    break;
                }
                case 7: {
                    JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
                    short[] array = new short[jsonArray.length()];
                    n = 0;
                    int n5 = array.length + -1;
                    if (n <= n5) {
                        do {
                            int i = n++;
                            array[i] = (short)jsonArray.getInt(i);
                        } while (n <= n5);
                    }
                    bundle.putShortArray(key, array);
                    break;
                }
                case 10: {
                    bundle.putInt(key, json.getInt(JSON_VALUE));
                    break;
                }
                case 8: {
                    JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
                    int[] array = new int[jsonArray.length()];
                    n = 0;
                    int n6 = array.length + -1;
                    if (n <= n6) {
                        do {
                            int i = n++;
                            array[i] = jsonArray.getInt(i);
                        } while (n <= n6);
                    }
                    bundle.putIntArray(key, array);
                    break;
                }
                case 11: {
                    bundle.putLong(key, json.getLong(JSON_VALUE));
                    break;
                }
                case 3: {
                    JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
                    long[] array = new long[jsonArray.length()];
                    n = 0;
                    int n7 = array.length + -1;
                    if (n <= n7) {
                        do {
                            int i = n++;
                            array[i] = jsonArray.getLong(i);
                        } while (n <= n7);
                    }
                    bundle.putLongArray(key, array);
                    break;
                }
                case 9: {
                    bundle.putFloat(key, (float)json.getDouble(JSON_VALUE));
                    break;
                }
                case 13: {
                    JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
                    float[] array = new float[jsonArray.length()];
                    n = 0;
                    int n8 = array.length + -1;
                    if (n <= n8) {
                        do {
                            int i = n++;
                            array[i] = (float)jsonArray.getDouble(i);
                        } while (n <= n8);
                    }
                    bundle.putFloatArray(key, array);
                    break;
                }
                case 5: {
                    bundle.putDouble(key, json.getDouble(JSON_VALUE));
                    break;
                }
                case 16: {
                    JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
                    double[] array = new double[jsonArray.length()];
                    n = 0;
                    int n9 = array.length + -1;
                    if (n <= n9) {
                        do {
                            int i = n++;
                            array[i] = jsonArray.getDouble(i);
                        } while (n <= n9);
                    }
                    bundle.putDoubleArray(key, array);
                    break;
                }
                case 18: {
                    String charString = json.getString(JSON_VALUE);
                    if (charString == null || charString.length() != 1) break;
                    bundle.putChar(key, charString.charAt(0));
                    break;
                }
                case 14: {
                    JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
                    char[] array = new char[jsonArray.length()];
                    n = 0;
                    int n10 = array.length + -1;
                    if (n <= n10) {
                        do {
                            int i;
                            String charString;
                            if ((charString = jsonArray.getString(i = n++)) == null || charString.length() != 1) continue;
                            array[i] = charString.charAt(0);
                        } while (n <= n10);
                    }
                    bundle.putCharArray(key, array);
                    break;
                }
                case 2: {
                    bundle.putString(key, json.getString(JSON_VALUE));
                    break;
                }
                case 17: {
                    JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
                    int numStrings = jsonArray.length();
                    ArrayList<String> stringList = new ArrayList<String>(numStrings);
                    int n11 = 0;
                    if (n11 < numStrings) {
                        do {
                            String string4;
                            int i;
                            Object jsonStringValue;
                            if ((jsonStringValue = jsonArray.get(i = n11++)) == JSONObject.NULL) {
                                string4 = null;
                            } else {
                                if (jsonStringValue == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                                }
                                string4 = (String)jsonStringValue;
                            }
                            stringList.add(i, string4);
                        } while (n11 < numStrings);
                    }
                    bundle.putStringArrayList(key, stringList);
                    break;
                }
                case 12: {
                    try {
                        String enumType = json.getString(JSON_VALUE_ENUM_TYPE);
                        Class<?> enumClass = Class.forName(enumType);
                        Object enumValue = Enum.valueOf(enumClass, json.getString(JSON_VALUE));
                        bundle.putSerializable(key, (Serializable)enumValue);
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @JvmOverloads
    public LegacyTokenHelper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    @JvmStatic
    public static final boolean hasTokenInformation(@Nullable Bundle bundle) {
        return Companion.hasTokenInformation(bundle);
    }

    @JvmStatic
    @Nullable
    public static final String getToken(@NotNull Bundle bundle) {
        return Companion.getToken(bundle);
    }

    @JvmStatic
    public static final void putToken(@NotNull Bundle bundle, @NotNull String value) {
        Companion.putToken(bundle, value);
    }

    @JvmStatic
    @Nullable
    public static final Date getExpirationDate(@NotNull Bundle bundle) {
        return Companion.getExpirationDate(bundle);
    }

    @JvmStatic
    public static final void putExpirationDate(@NotNull Bundle bundle, @NotNull Date value) {
        Companion.putExpirationDate(bundle, value);
    }

    @JvmStatic
    public static final long getExpirationMilliseconds(@NotNull Bundle bundle) {
        return Companion.getExpirationMilliseconds(bundle);
    }

    @JvmStatic
    public static final void putExpirationMilliseconds(@NotNull Bundle bundle, long value) {
        Companion.putExpirationMilliseconds(bundle, value);
    }

    @JvmStatic
    @Nullable
    public static final Set<String> getPermissions(@NotNull Bundle bundle) {
        return Companion.getPermissions(bundle);
    }

    @JvmStatic
    public static final void putPermissions(@NotNull Bundle bundle, @NotNull Collection<String> value) {
        Companion.putPermissions(bundle, value);
    }

    @JvmStatic
    public static final void putDeclinedPermissions(@NotNull Bundle bundle, @NotNull Collection<String> value) {
        Companion.putDeclinedPermissions(bundle, value);
    }

    @JvmStatic
    public static final void putExpiredPermissions(@NotNull Bundle bundle, @NotNull Collection<String> value) {
        Companion.putExpiredPermissions(bundle, value);
    }

    @JvmStatic
    @Nullable
    public static final AccessTokenSource getSource(@NotNull Bundle bundle) {
        return Companion.getSource(bundle);
    }

    @JvmStatic
    public static final void putSource(@NotNull Bundle bundle, @NotNull AccessTokenSource value) {
        Companion.putSource(bundle, value);
    }

    @JvmStatic
    @Nullable
    public static final Date getLastRefreshDate(@NotNull Bundle bundle) {
        return Companion.getLastRefreshDate(bundle);
    }

    @JvmStatic
    public static final void putLastRefreshDate(@NotNull Bundle bundle, @NotNull Date value) {
        Companion.putLastRefreshDate(bundle, value);
    }

    @JvmStatic
    public static final long getLastRefreshMilliseconds(@NotNull Bundle bundle) {
        return Companion.getLastRefreshMilliseconds(bundle);
    }

    @JvmStatic
    public static final void putLastRefreshMilliseconds(@NotNull Bundle bundle, long value) {
        Companion.putLastRefreshMilliseconds(bundle, value);
    }

    @JvmStatic
    @Nullable
    public static final String getApplicationId(@NotNull Bundle bundle) {
        return Companion.getApplicationId(bundle);
    }

    @JvmStatic
    public static final void putApplicationId(@NotNull Bundle bundle, @Nullable String value) {
        Companion.putApplicationId(bundle, value);
    }

    static {
        String string = LegacyTokenHelper.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LegacyTokenHelper::class.java.simpleName");
        TAG = string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u00042\u0006\u0010(\u001a\u00020)H\u0007J\u001e\u0010*\u001a\u0004\u0018\u00010+2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010,\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010+2\u0006\u0010(\u001a\u00020)H\u0007J\u0010\u0010.\u001a\u00020\n2\u0006\u0010(\u001a\u00020)H\u0007J\u0012\u0010/\u001a\u0004\u0018\u00010+2\u0006\u0010(\u001a\u00020)H\u0007J\u0010\u00100\u001a\u00020\n2\u0006\u0010(\u001a\u00020)H\u0007J\u0018\u00101\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u0001022\u0006\u0010(\u001a\u00020)H\u0007J\u0012\u00103\u001a\u0004\u0018\u0001042\u0006\u0010(\u001a\u00020)H\u0007J\u0012\u00105\u001a\u0004\u0018\u00010\u00042\u0006\u0010(\u001a\u00020)H\u0007J\u0012\u00106\u001a\u0002072\b\u0010(\u001a\u0004\u0018\u00010)H\u0007J\u001a\u00108\u001a\u0002092\u0006\u0010(\u001a\u00020)2\b\u0010:\u001a\u0004\u0018\u00010\u0004H\u0007J\"\u0010;\u001a\u0002092\u0006\u0010(\u001a\u00020)2\b\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010<\u001a\u00020+H\u0002J\u001e\u0010=\u001a\u0002092\u0006\u0010(\u001a\u00020)2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00040>H\u0007J\u0018\u0010?\u001a\u0002092\u0006\u0010(\u001a\u00020)2\u0006\u0010:\u001a\u00020+H\u0007J\u0018\u0010@\u001a\u0002092\u0006\u0010(\u001a\u00020)2\u0006\u0010:\u001a\u00020\nH\u0007J\u001e\u0010A\u001a\u0002092\u0006\u0010(\u001a\u00020)2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00040>H\u0007J\u0018\u0010B\u001a\u0002092\u0006\u0010(\u001a\u00020)2\u0006\u0010:\u001a\u00020+H\u0007J\u0018\u0010C\u001a\u0002092\u0006\u0010(\u001a\u00020)2\u0006\u0010:\u001a\u00020\nH\u0007J\u001e\u0010D\u001a\u0002092\u0006\u0010(\u001a\u00020)2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00040>H\u0007J\u0018\u0010E\u001a\u0002092\u0006\u0010(\u001a\u00020)2\u0006\u0010:\u001a\u000204H\u0007J\u0018\u0010F\u001a\u0002092\u0006\u0010(\u001a\u00020)2\u0006\u0010:\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/facebook/LegacyTokenHelper$Companion;", "", "()V", "APPLICATION_ID_KEY", "", "DECLINED_PERMISSIONS_KEY", "DEFAULT_CACHE_KEY", "EXPIRATION_DATE_KEY", "EXPIRED_PERMISSIONS_KEY", "INVALID_BUNDLE_MILLISECONDS", "", "IS_SSO_KEY", "JSON_VALUE", "JSON_VALUE_ENUM_TYPE", "JSON_VALUE_TYPE", "LAST_REFRESH_DATE_KEY", "PERMISSIONS_KEY", "TAG", "TOKEN_KEY", "TOKEN_SOURCE_KEY", "TYPE_BOOLEAN", "TYPE_BOOLEAN_ARRAY", "TYPE_BYTE", "TYPE_BYTE_ARRAY", "TYPE_CHAR", "TYPE_CHAR_ARRAY", "TYPE_DOUBLE", "TYPE_DOUBLE_ARRAY", "TYPE_ENUM", "TYPE_FLOAT", "TYPE_FLOAT_ARRAY", "TYPE_INTEGER", "TYPE_INTEGER_ARRAY", "TYPE_LONG", "TYPE_LONG_ARRAY", "TYPE_SHORT", "TYPE_SHORT_ARRAY", "TYPE_STRING", "TYPE_STRING_LIST", "getApplicationId", "bundle", "Landroid/os/Bundle;", "getDate", "Ljava/util/Date;", "key", "getExpirationDate", "getExpirationMilliseconds", "getLastRefreshDate", "getLastRefreshMilliseconds", "getPermissions", "", "getSource", "Lcom/facebook/AccessTokenSource;", "getToken", "hasTokenInformation", "", "putApplicationId", "", "value", "putDate", "date", "putDeclinedPermissions", "", "putExpirationDate", "putExpirationMilliseconds", "putExpiredPermissions", "putLastRefreshDate", "putLastRefreshMilliseconds", "putPermissions", "putSource", "putToken", "facebook-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean hasTokenInformation(@Nullable Bundle bundle) {
            block5: {
                block4: {
                    if (bundle == null) {
                        return false;
                    }
                    String token = bundle.getString(LegacyTokenHelper.TOKEN_KEY);
                    if (token == null) break block4;
                    CharSequence charSequence = token;
                    boolean bl = false;
                    if (!(charSequence.length() == 0)) break block5;
                }
                return false;
            }
            long expiresMilliseconds = bundle.getLong(LegacyTokenHelper.EXPIRATION_DATE_KEY, 0L);
            return expiresMilliseconds != 0L;
        }

        @JvmStatic
        @Nullable
        public final String getToken(@NotNull Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            return bundle.getString(LegacyTokenHelper.TOKEN_KEY);
        }

        @JvmStatic
        public final void putToken(@NotNull Bundle bundle, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)value, (String)LegacyTokenHelper.JSON_VALUE);
            bundle.putString(LegacyTokenHelper.TOKEN_KEY, value);
        }

        @JvmStatic
        @Nullable
        public final Date getExpirationDate(@NotNull Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            return this.getDate(bundle, LegacyTokenHelper.EXPIRATION_DATE_KEY);
        }

        @JvmStatic
        public final void putExpirationDate(@NotNull Bundle bundle, @NotNull Date value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)value, (String)LegacyTokenHelper.JSON_VALUE);
            this.putDate(bundle, LegacyTokenHelper.EXPIRATION_DATE_KEY, value);
        }

        @JvmStatic
        public final long getExpirationMilliseconds(@NotNull Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            return bundle.getLong(LegacyTokenHelper.EXPIRATION_DATE_KEY);
        }

        @JvmStatic
        public final void putExpirationMilliseconds(@NotNull Bundle bundle, long value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            bundle.putLong(LegacyTokenHelper.EXPIRATION_DATE_KEY, value);
        }

        @JvmStatic
        @Nullable
        public final Set<String> getPermissions(@NotNull Bundle bundle) {
            ArrayList arrayList;
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            ArrayList arrayList2 = bundle.getStringArrayList(LegacyTokenHelper.PERMISSIONS_KEY);
            if (arrayList2 == null) {
                return null;
            }
            ArrayList arrayList3 = arrayList = arrayList2;
            return new HashSet(arrayList3);
        }

        @JvmStatic
        public final void putPermissions(@NotNull Bundle bundle, @NotNull Collection<String> value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter(value, (String)LegacyTokenHelper.JSON_VALUE);
            bundle.putStringArrayList(LegacyTokenHelper.PERMISSIONS_KEY, new ArrayList<String>(value));
        }

        @JvmStatic
        public final void putDeclinedPermissions(@NotNull Bundle bundle, @NotNull Collection<String> value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter(value, (String)LegacyTokenHelper.JSON_VALUE);
            bundle.putStringArrayList(LegacyTokenHelper.DECLINED_PERMISSIONS_KEY, new ArrayList<String>(value));
        }

        @JvmStatic
        public final void putExpiredPermissions(@NotNull Bundle bundle, @NotNull Collection<String> value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter(value, (String)LegacyTokenHelper.JSON_VALUE);
            bundle.putStringArrayList(LegacyTokenHelper.EXPIRED_PERMISSIONS_KEY, new ArrayList<String>(value));
        }

        @JvmStatic
        @Nullable
        public final AccessTokenSource getSource(@NotNull Bundle bundle) {
            boolean isSSO;
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            return bundle.containsKey(LegacyTokenHelper.TOKEN_SOURCE_KEY) ? (AccessTokenSource)((Object)bundle.getSerializable(LegacyTokenHelper.TOKEN_SOURCE_KEY)) : ((isSSO = bundle.getBoolean(LegacyTokenHelper.IS_SSO_KEY)) ? AccessTokenSource.FACEBOOK_APPLICATION_WEB : AccessTokenSource.WEB_VIEW);
        }

        @JvmStatic
        public final void putSource(@NotNull Bundle bundle, @NotNull AccessTokenSource value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)LegacyTokenHelper.JSON_VALUE);
            bundle.putSerializable(LegacyTokenHelper.TOKEN_SOURCE_KEY, (Serializable)((Object)value));
        }

        @JvmStatic
        @Nullable
        public final Date getLastRefreshDate(@NotNull Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            return this.getDate(bundle, LegacyTokenHelper.LAST_REFRESH_DATE_KEY);
        }

        @JvmStatic
        public final void putLastRefreshDate(@NotNull Bundle bundle, @NotNull Date value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)value, (String)LegacyTokenHelper.JSON_VALUE);
            this.putDate(bundle, LegacyTokenHelper.LAST_REFRESH_DATE_KEY, value);
        }

        @JvmStatic
        public final long getLastRefreshMilliseconds(@NotNull Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            return bundle.getLong(LegacyTokenHelper.LAST_REFRESH_DATE_KEY);
        }

        @JvmStatic
        public final void putLastRefreshMilliseconds(@NotNull Bundle bundle, long value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            bundle.putLong(LegacyTokenHelper.LAST_REFRESH_DATE_KEY, value);
        }

        @JvmStatic
        @Nullable
        public final String getApplicationId(@NotNull Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            return bundle.getString(LegacyTokenHelper.APPLICATION_ID_KEY);
        }

        @JvmStatic
        public final void putApplicationId(@NotNull Bundle bundle, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            bundle.putString(LegacyTokenHelper.APPLICATION_ID_KEY, value);
        }

        private final Date getDate(Bundle bundle, String key) {
            if (bundle == null) {
                return null;
            }
            long n = bundle.getLong(key, Long.MIN_VALUE);
            return n == Long.MIN_VALUE ? (Date)null : new Date(n);
        }

        private final void putDate(Bundle bundle, String key, Date date) {
            bundle.putLong(key, date.getTime());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

