/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.facebook.internal.NativeProtocol;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/facebook/FacebookBroadcastReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "onFailedAppCall", "", "appCallId", "", "action", "extras", "Landroid/os/Bundle;", "onReceive", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "onSuccessfulAppCall", "facebook-core_release"})
public class FacebookBroadcastReceiver
extends BroadcastReceiver {
    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        String appCallId = intent.getStringExtra("com.facebook.platform.protocol.CALL_ID");
        String action = intent.getStringExtra("com.facebook.platform.protocol.PROTOCOL_ACTION");
        Bundle extras = intent.getExtras();
        if (appCallId != null && action != null && extras != null) {
            if (NativeProtocol.isErrorResult(intent)) {
                this.onFailedAppCall(appCallId, action, extras);
            } else {
                this.onSuccessfulAppCall(appCallId, action, extras);
            }
        }
    }

    protected void onSuccessfulAppCall(@NotNull String appCallId, @NotNull String action, @NotNull Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)appCallId, (String)"appCallId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
    }

    protected void onFailedAppCall(@NotNull String appCallId, @NotNull String action, @NotNull Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)appCallId, (String)"appCallId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
    }
}

