/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Base64;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0007J!\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/facebook/appevents/internal/HashUtils;", "", "()V", "BUFFER_SIZE", "", "MD5", "", "TAG", "TRUSTED_CERTS", "", "[Ljava/lang/String;", "computeChecksum", "path", "computeChecksumWithPackageManager", "context", "Landroid/content/Context;", "nanosTimeout", "", "(Landroid/content/Context;Ljava/lang/Long;)Ljava/lang/String;", "computeFileMd5", "file", "Ljava/io/File;", "facebook-core_release"})
public final class HashUtils {
    @NotNull
    public static final HashUtils INSTANCE = new HashUtils();
    @NotNull
    private static final String MD5 = "MD5";
    private static final int BUFFER_SIZE = 1024;
    @NotNull
    private static final String TAG;
    @NotNull
    private static final String[] TRUSTED_CERTS;

    private HashUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String computeChecksum(@Nullable String path) throws Exception {
        return INSTANCE.computeFileMd5(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String computeFileMd5(File file) throws Exception {
        Closeable closeable = new BufferedInputStream(new FileInputStream(file), 1024);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            BufferedInputStream fis = (BufferedInputStream)closeable;
            boolean bl3 = false;
            MessageDigest md = MessageDigest.getInstance(MD5);
            byte[] buffer = new byte[1024];
            int numRead = 0;
            do {
                if ((numRead = fis.read(buffer)) <= 0) continue;
                md.update(buffer, 0, numRead);
            } while (numRead != -1);
            String string = new BigInteger(1, md.digest()).toString(16);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BigInteger(1, md.digest()).toString(16)");
            String string2 = string;
            return string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final String computeChecksumWithPackageManager(@NotNull Context context, @Nullable Long nanosTimeout) {
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        String[] $this$map$iv = TRUSTED_CERTS;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Certificate certificate = certFactory.generateCertificate(new ByteArrayInputStream(Base64.decode((String)it, (int)0)));
            collection.add(certificate);
        }
        List trustedInstaller = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        Ref.ObjectRef resultChecksum = new Ref.ObjectRef();
        ReentrantLock lock = new ReentrantLock();
        Condition checksumReady = lock.newCondition();
        lock.lock();
        try {
            Object item$iv$iv;
            Class<?> $i$f$mapTo2 = Class.forName("android.content.pm.Checksum");
            Intrinsics.checkNotNullExpressionValue($i$f$mapTo2, (String)"forName(\"android.content.pm.Checksum\")");
            Class<?> checksumClass = $i$f$mapTo2;
            Field field = checksumClass.getField("TYPE_WHOLE_MD5");
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"checksumClass.getField(\"TYPE_WHOLE_MD5\")");
            Field typeWholeMd5Field = field;
            Object TYPE_WHOLE_MD5 = typeWholeMd5Field.get(null);
            Class<?> clazz = Class.forName("android.content.pm.PackageManager$OnChecksumsReadyListener");
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(\"android.content.pm.PackageManager\\$OnChecksumsReadyListener\")");
            Class<?> checksumReadyListenerClass = clazz;
            object = new Class[]{checksumReadyListenerClass};
            item$iv$iv = Proxy.newProxyInstance(HashUtils.class.getClassLoader(), object, new InvocationHandler(TYPE_WHOLE_MD5, (Ref.ObjectRef<String>)resultChecksum, lock, checksumReady){
                final /* synthetic */ Object $TYPE_WHOLE_MD5;
                final /* synthetic */ Ref.ObjectRef<String> $resultChecksum;
                final /* synthetic */ ReentrantLock $lock;
                final /* synthetic */ Condition $checksumReady;
                {
                    this.$TYPE_WHOLE_MD5 = $TYPE_WHOLE_MD5;
                    this.$resultChecksum = $resultChecksum;
                    this.$lock = $lock;
                    this.$checksumReady = $checksumReady;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Nullable
                public Object invoke(@Nullable Object o, @NotNull Method method, @NotNull Object[] objects) {
                    block7: {
                        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
                        try {
                            if (!Intrinsics.areEqual((Object)method.getName(), (Object)"onChecksumsReady") || objects.length != 1 || !(objects[0] instanceof List)) break block7;
                            List list = (List)objects[0];
                            for (E c : list) {
                                if (c == null) continue;
                                Method method2 = c.getClass().getMethod("getSplitName", new Class[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"c.javaClass.getMethod(\"getSplitName\")");
                                Method getSplitNameMethod = method2;
                                Method method3 = c.getClass().getMethod("getType", new Class[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)method3, (String)"c.javaClass.getMethod(\"getType\")");
                                Method getTypeMethod = method3;
                                if (getSplitNameMethod.invoke(c, new Object[0]) != null || !Intrinsics.areEqual((Object)getTypeMethod.invoke(c, new Object[0]), (Object)this.$TYPE_WHOLE_MD5)) continue;
                                Method method4 = c.getClass().getMethod("getValue", new Class[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)method4, (String)"c.javaClass.getMethod(\"getValue\")");
                                Method getValueMethod = method4;
                                Object object = getValueMethod.invoke(c, new Object[0]);
                                if (object == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.ByteArray");
                                }
                                byte[] checksumValue = (byte[])object;
                                this.$resultChecksum.element = new BigInteger(1, checksumValue).toString(16);
                                this.$lock.lock();
                                try {
                                    this.$checksumReady.signalAll();
                                }
                                finally {
                                    this.$lock.unlock();
                                }
                                return null;
                            }
                        }
                        catch (Throwable t) {
                            Log.d((String)HashUtils.access$getTAG$p(), (String)"Can't fetch checksum.", (Throwable)t);
                        }
                    }
                    return null;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)item$iv$iv, (String)"var resultChecksum: String? = null\n    val lock = ReentrantLock()\n    val checksumReady = lock.newCondition()\n    lock.lock()\n\n    try {\n      val checksumClass = Class.forName(\"android.content.pm.Checksum\")\n      val typeWholeMd5Field: Field = checksumClass.getField(\"TYPE_WHOLE_MD5\")\n      val TYPE_WHOLE_MD5 = typeWholeMd5Field.get(null)\n      val checksumReadyListenerClass =\n          Class.forName(\"android.content.pm.PackageManager\\$OnChecksumsReadyListener\")\n      val listener: Any =\n          Proxy.newProxyInstance(\n              HashUtils::class.java.classLoader,\n              arrayOf(checksumReadyListenerClass),\n              object : InvocationHandler {\n                override operator fun invoke(o: Any?, method: Method, objects: Array<Any>): Any? {\n                  try {\n                    if (method.name == \"onChecksumsReady\" &&\n                        objects.size == 1 &&\n                        objects[0] is List<*>) {\n                      val list = objects[0] as List<*>\n                      for (c in list) {\n                        if (c != null) {\n                          val getSplitNameMethod: Method = c.javaClass.getMethod(\"getSplitName\")\n                          val getTypeMethod: Method = c.javaClass.getMethod(\"getType\")\n                          if (getSplitNameMethod.invoke(c) == null &&\n                              getTypeMethod.invoke(c) == TYPE_WHOLE_MD5) {\n                            val getValueMethod: Method = c.javaClass.getMethod(\"getValue\")\n                            val checksumValue = getValueMethod.invoke(c) as ByteArray\n                            resultChecksum = BigInteger(1, checksumValue).toString(16)\n                            lock.lock()\n                            try {\n                              checksumReady.signalAll()\n                            } finally {\n                              lock.unlock()\n                            }\n                            return null\n                          }\n                        }\n                      }\n                    }\n                  } catch (t: Throwable) {\n                    Log.d(TAG, \"Can't fetch checksum.\", t)\n                  }\n                  return null\n                }\n              })");
            Object listener2 = item$iv$iv;
            Class[] classArray = new Class[]{String.class, Boolean.TYPE, Integer.TYPE, List.class, checksumReadyListenerClass};
            object = PackageManager.class.getMethod("requestChecksums", classArray);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"PackageManager::class\n              .java.getMethod(\n                  \"requestChecksums\",\n                  String::class.java,\n                  Boolean::class.javaPrimitiveType,\n                  Int::class.javaPrimitiveType,\n                  MutableList::class.java,\n                  checksumReadyListenerClass)");
            Class[] requestChecksumsMethod = object;
            object = new Object[]{context.getPackageName(), false, TYPE_WHOLE_MD5, CollectionsKt.toMutableList((Collection)trustedInstaller), listener2};
            requestChecksumsMethod.invoke((Object)context.getPackageManager(), (Object[])object);
            if (nanosTimeout == null) {
                checksumReady.await();
            } else {
                checksumReady.awaitNanos(nanosTimeout);
            }
            object = (String)resultChecksum.element;
            return object;
        }
        catch (Throwable t) {
            String string = null;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    public static final /* synthetic */ String access$getTAG$p() {
        return TAG;
    }

    static {
        String[] stringArray = HashUtils.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"HashUtils::class.java.simpleName");
        TAG = stringArray;
        stringArray = new String[]{"MIIEQzCCAyugAwIBAgIJAMLgh0ZkSjCNMA0GCSqGSIb3DQEBBAUAMHQxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9ybmlhMRYwFAYDVQQHEw1Nb3VudGFpbiBWaWV3MRQwEgYDVQQKEwtHb29nbGUgSW5jLjEQMA4GA1UECxMHQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDAeFw0wODA4MjEyMzEzMzRaFw0zNjAxMDcyMzEzMzRaMHQxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9ybmlhMRYwFAYDVQQHEw1Nb3VudGFpbiBWaWV3MRQwEgYDVQQKEwtHb29nbGUgSW5jLjEQMA4GA1UECxMHQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDCCASAwDQYJKoZIhvcNAQEBBQADggENADCCAQgCggEBAKtWLgDYO6IIrgqWbxJOKdoR8qtW0I9Y4sypEwPpt1TTcvZApxsdyxMJZ2JORland2qSGT2y5b+3JKkedxiLDmpHpDsz2WCbdxgxRczfey5YZnTJ4VZbH0xqWVW/8lGmPav5xVwnIiJS6HXk+BVKZF+JcWjAsb/GEuq/eFdpuzSqeYTcfi6idkyugwfYwXFU1+5fZKUaRKYCwkkFQVfcAs1fXA5V+++FGfvjJ/CxURaSxaBvGdGDhfXE28LWuT9ozCl5xw4Yq5OGazvV24mZVSoOO0yZ31j7kYvtwYK6NeADwbSxDdJEqO4k//0zOHKrUiGYXtqw/A0LFFtqoZKFjnkCAQOjgdkwgdYwHQYDVR0OBBYEFMd9jMIhF1Ylmn/Tgt9r45jk14alMIGmBgNVHSMEgZ4wgZuAFMd9jMIhF1Ylmn/Tgt9r45jk14aloXikdjB0MQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTEWMBQGA1UEBxMNTW91bnRhaW4gVmlldzEUMBIGA1UEChMLR29vZ2xlIEluYy4xEDAOBgNVBAsTB0FuZHJvaWQxEDAOBgNVBAMTB0FuZHJvaWSCCQDC4IdGZEowjTAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBAUAA4IBAQBt0lLO74UwLDYKqs6Tm8/yzKkEu116FmH4rkaymUIE0P9KaMftGlMexFlaYjzmB2OxZyl6euNXEsQH8gjwyxCUKRJNexBiGcCEyj6z+a1fuHHvkiaai+KL8W1EyNmgjmyy8AW7P+LLlkR+ho5zEHatRbM/YAnqGcFh5iZBqpknHf1SKMXFh4dd239FJ1jWYfbMDMy3NS5CTMQ2XFI1MvcyUTdZPErjQfTbQe3aDQsQcafEQPD+nqActifKZ0Np0IS9L9kR/wbNvyz6ENwPiTrjV2KRkEjH78ZMcUQXg0L3BYHJ3lc69Vs5Ddf9uUGGMYldX3WfMBEmh/9iFBDAaTCK", "MIIEqDCCA5CgAwIBAgIJANWFuGx90071MA0GCSqGSIb3DQEBBAUAMIGUMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTEWMBQGA1UEBxMNTW91bnRhaW4gVmlldzEQMA4GA1UEChMHQW5kcm9pZDEQMA4GA1UECxMHQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDEiMCAGCSqGSIb3DQEJARYTYW5kcm9pZEBhbmRyb2lkLmNvbTAeFw0wODA0MTUyMzM2NTZaFw0zNTA5MDEyMzM2NTZaMIGUMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTEWMBQGA1UEBxMNTW91bnRhaW4gVmlldzEQMA4GA1UEChMHQW5kcm9pZDEQMA4GA1UECxMHQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDEiMCAGCSqGSIb3DQEJARYTYW5kcm9pZEBhbmRyb2lkLmNvbTCCASAwDQYJKoZIhvcNAQEBBQADggENADCCAQgCggEBANbOLggKv+IxTdGNs8/TGFy0PTP6DHThvbbR24kT9ixcOd9W+EaBPWW+wPPKQmsHxajtWjmQwWfna8mZuSeJS48LIgAZlKkpFeVyxW0qMBujb8X8ETrWy550NaFtI6t9+u7hZeTfHwqNvacKhp1RbE6dBRGWynwMVX8XW8N1+UjFaq6GCJukT4qmpN2afb8sCjUigq0GuMwYXrFVee74bQgLHWGJwPmvmLHC69EH6kWr22ijx4OKXlSIx2xT1AsSHee70w5iDBiK4aph27yH3TxkXy9V89TDdexAcKk/cVHYNnDBapcavl7y0RiQ4biu8ymM8Ga/nmzhRKya6G0cGw8CAQOjgfwwgfkwHQYDVR0OBBYEFI0cxb6VTEM8YYY6FbBMvAPyT+CyMIHJBgNVHSMEgcEwgb6AFI0cxb6VTEM8YYY6FbBMvAPyT+CyoYGapIGXMIGUMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTEWMBQGA1UEBxMNTW91bnRhaW4gVmlldzEQMA4GA1UEChMHQW5kcm9pZDEQMA4GA1UECxMHQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDEiMCAGCSqGSIb3DQEJARYTYW5kcm9pZEBhbmRyb2lkLmNvbYIJANWFuGx90071MAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEEBQADggEBABnTDPEF+3iSP0wNfdIjIz1AlnrPzgAIHVvXxunW7SBrDhEglQZBbKJEk5kT0mtKoOD1JMrSu1xuTKEBahWRbqHsXclaXjoBADb0kkjVEJu/Lh5hgYZnOjvlba8Ld7HCKePCVePoTJBdI4fvugnL8TsgK05aIskyY0hKI9L8KfqfGTl1lzOv2KoWD0KWwtAWPoGChZxmQ+nBli+gwYMzM1vAkP+aayLe0a1EQimlOalO762r0GXO0ks+UeXde2Z4e+8S/pf7pITEI/tP+MxJTALw9QUWEv9lKTk+jkbqxbsh8nfBUapfKqYn0eidpwq2AzVp3juYl7//fKnaPhJD9gs="};
        TRUSTED_CERTS = stringArray;
    }
}

