/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.suggestedevents;

import android.app.Activity;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookSdk;
import com.facebook.appevents.internal.ActivityLifecycleTracker;
import com.facebook.appevents.ml.ModelManager;
import com.facebook.appevents.suggestedevents.FeatureExtractor;
import com.facebook.appevents.suggestedevents.ViewObserver;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\fH\u0002J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u0011J\b\u0010\u0012\u001a\u00020\u000fH\u0007J\u0015\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u0014J\u0017\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004H\u0001\u00a2\u0006\u0002\b\u0017J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/facebook/appevents/suggestedevents/SuggestedEventsManager;", "", "()V", "ELIGIBLE_EVENTS_KEY", "", "PRODUCTION_EVENTS_KEY", "eligibleEvents", "", "enabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "productionEvents", "enable", "", "initialize", "isEligibleEvents", "", "event", "isEligibleEvents$facebook_core_release", "isEnabled", "isProductionEvents", "isProductionEvents$facebook_core_release", "populateEventsFromRawJsonString", "rawSuggestedEventSetting", "populateEventsFromRawJsonString$facebook_core_release", "trackActivity", "activity", "Landroid/app/Activity;", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class SuggestedEventsManager {
    @NotNull
    public static final SuggestedEventsManager INSTANCE = new SuggestedEventsManager();
    @NotNull
    private static final AtomicBoolean enabled = new AtomicBoolean(false);
    @NotNull
    private static final Set<String> productionEvents;
    @NotNull
    private static final Set<String> eligibleEvents;
    @NotNull
    private static final String PRODUCTION_EVENTS_KEY = "production_events";
    @NotNull
    private static final String ELIGIBLE_EVENTS_KEY = "eligible_for_prediction_events";

    private SuggestedEventsManager() {
    }

    @JvmStatic
    public static final synchronized void enable() {
        if (CrashShieldHandler.isObjectCrashing(SuggestedEventsManager.class)) {
            return;
        }
        try {
            FacebookSdk.INSTANCE.getExecutor().execute(SuggestedEventsManager::enable$lambda-0);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SuggestedEventsManager.class);
            return;
        }
    }

    private final void initialize() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            block11: {
                try {
                    File file;
                    FetchedAppSettings fetchedAppSettings = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.INSTANCE.getApplicationId(), false);
                    if (fetchedAppSettings == null) {
                        return;
                    }
                    FetchedAppSettings settings = fetchedAppSettings;
                    Object object = settings.getSuggestedEventsSetting();
                    if (object == null) {
                        return;
                    }
                    String rawSuggestedEventSetting = object;
                    this.populateEventsFromRawJsonString$facebook_core_release(rawSuggestedEventSetting);
                    object = productionEvents;
                    boolean bl = false;
                    if (!(!object.isEmpty())) {
                        object = eligibleEvents;
                        bl = false;
                        if (!(!object.isEmpty())) break block11;
                    }
                    if ((file = ModelManager.getRuleFile(ModelManager.Task.MTML_APP_EVENT_PREDICTION)) == null) {
                        return;
                    }
                    File ruleFile = file;
                    FeatureExtractor.initialize(ruleFile);
                    Activity currActivity = ActivityLifecycleTracker.INSTANCE.getCurrentActivity();
                    if (currActivity != null) {
                        SuggestedEventsManager.trackActivity(currActivity);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting(otherwise=2)
    public final void populateEventsFromRawJsonString$facebook_core_release(@Nullable String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            try {
                String string2;
                int i;
                JSONArray jsonArray;
                int n;
                int n2;
                void rawSuggestedEventSetting;
                JSONObject jsonObject = new JSONObject((String)rawSuggestedEventSetting);
                if (jsonObject.has(PRODUCTION_EVENTS_KEY) && (n2 = 0) < (n = (jsonArray = jsonObject.getJSONArray(PRODUCTION_EVENTS_KEY)).length())) {
                    do {
                        i = n2++;
                        string2 = jsonArray.getString(i);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonArray.getString(i)");
                        productionEvents.add(string2);
                    } while (n2 < n);
                }
                if (jsonObject.has(ELIGIBLE_EVENTS_KEY) && (n2 = 0) < (n = (jsonArray = jsonObject.getJSONArray(ELIGIBLE_EVENTS_KEY)).length())) {
                    do {
                        i = n2++;
                        string2 = jsonArray.getString(i);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonArray.getString(i)");
                        eligibleEvents.add(string2);
                    } while (n2 < n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    public static final void trackActivity(@NotNull Activity activity) {
        if (CrashShieldHandler.isObjectCrashing(SuggestedEventsManager.class)) {
            return;
        }
        try {
            Activity activity2;
            Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
            try {
                if (enabled.get()) {
                    if (!(!FeatureExtractor.INSTANCE.isInitialized() || productionEvents.isEmpty() && eligibleEvents.isEmpty())) {
                        ViewObserver.Companion.startTrackingActivity(activity2);
                        return;
                    }
                }
                ViewObserver.Companion.stopTrackingActivity(activity2);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SuggestedEventsManager.class);
            return;
        }
    }

    @JvmStatic
    public static final boolean isEnabled() {
        if (CrashShieldHandler.isObjectCrashing(SuggestedEventsManager.class)) {
            return false;
        }
        try {
            return enabled.get();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SuggestedEventsManager.class);
            return false;
        }
    }

    @JvmStatic
    public static final boolean isProductionEvents$facebook_core_release(@NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(SuggestedEventsManager.class)) {
            return false;
        }
        try {
            String event;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return productionEvents.contains(event);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SuggestedEventsManager.class);
            return false;
        }
    }

    @JvmStatic
    public static final boolean isEligibleEvents$facebook_core_release(@NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(SuggestedEventsManager.class)) {
            return false;
        }
        try {
            String event;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return eligibleEvents.contains(event);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SuggestedEventsManager.class);
            return false;
        }
    }

    private static final void enable$lambda-0() {
        if (CrashShieldHandler.isObjectCrashing(SuggestedEventsManager.class)) {
            return;
        }
        try {
            if (enabled.get()) {
                return;
            }
            enabled.set(true);
            INSTANCE.initialize();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SuggestedEventsManager.class);
            return;
        }
    }

    static {
        boolean bl = false;
        productionEvents = new LinkedHashSet();
        bl = false;
        eligibleEvents = new LinkedHashSet();
    }
}

