/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Looper;
import android.util.Log;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.FacebookSdkNotInitializedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J$\u0010\u000f\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u00102\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00100\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\b\u0010\u0011\u001a\u00020\u0004H\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u0010\u0017\u001a\u00020\u0004H\u0007J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u001a\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0013H\u0007J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0013H\u0007J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0004H\u0007J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J$\u0010\"\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u00102\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00100\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J$\u0010$\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u00102\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00100\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\u001a\u0010%\u001a\u00020\u000b2\b\u0010#\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\u001a\u0010&\u001a\u00020\u00042\b\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J7\u0010'\u001a\u00020\u000b2\b\u0010#\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u00042\u0016\u0010(\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010)\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020\u000bH\u0007J\b\u0010,\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/facebook/internal/Validate;", "", "()V", "CONTENT_PROVIDER_BASE", "", "CONTENT_PROVIDER_NOT_FOUND_REASON", "CUSTOM_TAB_REDIRECT_URI_PREFIX", "FACEBOOK_ACTIVITY_NOT_FOUND_REASON", "NO_INTERNET_PERMISSION_REASON", "TAG", "containsNoNullOrEmpty", "", "container", "", "name", "containsNoNulls", "T", "hasAppID", "hasBluetoothPermission", "", "context", "Landroid/content/Context;", "hasChangeWifiStatePermission", "hasClientToken", "hasContentProvider", "hasCustomTabRedirectActivity", "redirectURI", "hasFacebookActivity", "shouldThrow", "hasInternetPermissions", "hasLocationPermission", "hasPermission", "permission", "hasWiFiPermission", "notEmpty", "arg", "notEmptyAndContainsNoNulls", "notNull", "notNullOrEmpty", "oneOf", "values", "", "(Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)V", "runningOnUiThread", "sdkInitialized", "facebook-core_release"})
public final class Validate {
    private static final String TAG;
    private static final String NO_INTERNET_PERMISSION_REASON = "No internet permissions granted for the app, please add <uses-permission android:name=\"android.permission.INTERNET\" /> to your AndroidManifest.xml.";
    private static final String FACEBOOK_ACTIVITY_NOT_FOUND_REASON = "FacebookActivity is not declared in the AndroidManifest.xml. If you are using the facebook-common module or dependent modules please add com.facebook.FacebookActivity to your AndroidManifest.xml file. See https://developers.facebook.com/docs/android/getting-started for more info.";
    private static final String CONTENT_PROVIDER_NOT_FOUND_REASON = "A ContentProvider for this app was not set up in the AndroidManifest.xml, please add %s as a provider to your AndroidManifest.xml file. See https://developers.facebook.com/docs/sharing/android for more info.";
    private static final String CONTENT_PROVIDER_BASE = "com.facebook.app.FacebookContentProvider";
    @NotNull
    public static final String CUSTOM_TAB_REDIRECT_URI_PREFIX = "fbconnect://cct.";
    @NotNull
    public static final Validate INSTANCE;

    @JvmStatic
    public static final void notNull(@Nullable Object arg, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (arg == null) {
            throw (Throwable)new NullPointerException("Argument '" + name + "' cannot be null");
        }
    }

    @JvmStatic
    public static final <T> void notEmpty(@NotNull Collection<? extends T> container, @NotNull String name) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        boolean bl = !container.isEmpty();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Container '" + name + "' cannot be empty";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @JvmStatic
    public static final <T> void containsNoNulls(@NotNull Collection<? extends T> container, @NotNull String name) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Validate.notNull(container, name);
        for (T item : container) {
            if (item != null) continue;
            throw (Throwable)new NullPointerException("Container '" + name + "' cannot contain null values");
        }
    }

    @JvmStatic
    public static final void containsNoNullOrEmpty(@NotNull Collection<String> container, @NotNull String name) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Validate.notNull(container, name);
        for (String item : container) {
            if (item == null) {
                throw (Throwable)new NullPointerException("Container '" + name + "' cannot contain null values");
            }
            CharSequence charSequence = item;
            boolean bl = false;
            boolean bl2 = charSequence.length() > 0;
            bl = false;
            boolean bl3 = false;
            if (bl2) continue;
            boolean bl4 = false;
            String string = "Container '" + name + "' cannot contain empty values";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @JvmStatic
    public static final <T> void notEmptyAndContainsNoNulls(@NotNull Collection<? extends T> container, @NotNull String name) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Validate.containsNoNulls(container, name);
        Validate.notEmpty(container, name);
    }

    @JvmStatic
    public static final void runningOnUiThread() {
        if (Intrinsics.areEqual((Object)Looper.getMainLooper(), (Object)Looper.myLooper()) ^ true) {
            throw (Throwable)new FacebookException("This method should be called from the UI thread");
        }
    }

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    @NotNull
    public static final String notNullOrEmpty(@Nullable String arg, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (arg == null) ** GOTO lbl-1000
        var2_2 = arg;
        var3_4 = false;
        if (var2_2.length() > 0) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        var2_3 = v0;
        var3_4 = false;
        var4_5 = false;
        if (!var2_3) {
            $i$a$-require-Validate$notNullOrEmpty$1 = false;
            var4_6 = "Argument '" + name + "' cannot be null or empty";
            throw (Throwable)new IllegalArgumentException(var4_6.toString());
        }
        return arg;
    }

    @JvmStatic
    public static final void notEmpty(@NotNull String arg, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CharSequence charSequence = arg;
        boolean bl = false;
        boolean bl2 = charSequence.length() > 0;
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "Argument '" + name + "' cannot be empty";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @JvmStatic
    public static final void oneOf(@Nullable Object arg, @NotNull String name, Object ... values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        for (Object value : values) {
            if (!Intrinsics.areEqual((Object)value, (Object)arg)) continue;
            return;
        }
        throw (Throwable)new IllegalArgumentException("Argument '" + name + "' was not one of the allowed values");
    }

    @JvmStatic
    public static final void sdkInitialized() {
        if (!FacebookSdk.isInitialized()) {
            throw (Throwable)new FacebookSdkNotInitializedException("The SDK has not been initialized, make sure to call FacebookSdk.sdkInitialize() first.");
        }
    }

    @JvmStatic
    @NotNull
    public static final String hasAppID() {
        String string = FacebookSdk.getApplicationId();
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            boolean bl3 = false;
            String string2 = "No App ID found, please set the App ID.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String hasClientToken() {
        String string = FacebookSdk.getClientToken();
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            boolean bl3 = false;
            String string2 = "No Client Token found, please set the Client Token.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    @JvmStatic
    public static final void hasInternetPermissions(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Validate.hasInternetPermissions(context, true);
    }

    @JvmStatic
    public static final void hasInternetPermissions(@NotNull Context context, boolean shouldThrow) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Validate.notNull(context, "context");
        if (context.checkCallingOrSelfPermission("android.permission.INTERNET") == -1) {
            boolean bl = !shouldThrow;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = NO_INTERNET_PERMISSION_REASON;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Log.w((String)TAG, (String)NO_INTERNET_PERMISSION_REASON);
        }
    }

    @JvmStatic
    public static final boolean hasWiFiPermission(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Validate.hasPermission(context, "android.permission.ACCESS_WIFI_STATE");
    }

    @JvmStatic
    public static final boolean hasChangeWifiStatePermission(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Validate.hasPermission(context, "android.permission.CHANGE_WIFI_STATE");
    }

    @JvmStatic
    public static final boolean hasLocationPermission(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Validate.hasPermission(context, "android.permission.ACCESS_COARSE_LOCATION") || Validate.hasPermission(context, "android.permission.ACCESS_FINE_LOCATION");
    }

    @JvmStatic
    public static final boolean hasBluetoothPermission(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Validate.hasPermission(context, "android.permission.BLUETOOTH") && Validate.hasPermission(context, "android.permission.BLUETOOTH_ADMIN");
    }

    @JvmStatic
    public static final boolean hasPermission(@NotNull Context context, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        return context.checkCallingOrSelfPermission(permission) == 0;
    }

    @JvmStatic
    public static final void hasFacebookActivity(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Validate.hasFacebookActivity(context, true);
    }

    @JvmStatic
    @SuppressLint(value={"WrongConstant"})
    public static final void hasFacebookActivity(@NotNull Context context, boolean shouldThrow) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Validate.notNull(context, "context");
        PackageManager pm = context.getPackageManager();
        ActivityInfo activityInfo = null;
        if (pm != null) {
            ComponentName componentName = new ComponentName(context, "com.facebook.FacebookActivity");
            try {
                activityInfo = pm.getActivityInfo(componentName, 1);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        if (activityInfo == null) {
            boolean bl = !shouldThrow;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = FACEBOOK_ACTIVITY_NOT_FOUND_REASON;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Log.w((String)TAG, (String)FACEBOOK_ACTIVITY_NOT_FOUND_REASON);
        }
    }

    @JvmStatic
    public static final boolean hasCustomTabRedirectActivity(@NotNull Context context, @Nullable String redirectURI) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Validate.notNull(context, "context");
        PackageManager pm = context.getPackageManager();
        List infos = null;
        if (pm != null) {
            Intent intent = new Intent();
            intent.setAction("android.intent.action.VIEW");
            intent.addCategory("android.intent.category.DEFAULT");
            intent.addCategory("android.intent.category.BROWSABLE");
            intent.setData(Uri.parse((String)redirectURI));
            infos = pm.queryIntentActivities(intent, 64);
        }
        boolean hasActivity = false;
        if (infos != null) {
            for (ResolveInfo info : infos) {
                ActivityInfo activityInfo = info.activityInfo;
                if (Intrinsics.areEqual((Object)activityInfo.name, (Object)"com.facebook.CustomTabActivity") && Intrinsics.areEqual((Object)activityInfo.packageName, (Object)context.getPackageName())) {
                    hasActivity = true;
                    continue;
                }
                return false;
            }
        }
        return hasActivity;
    }

    @JvmStatic
    public static final void hasContentProvider(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Validate.notNull(context, "context");
        String appId = Validate.hasAppID();
        PackageManager pm = context.getPackageManager();
        if (pm != null) {
            String providerName = CONTENT_PROVIDER_BASE + appId;
            ProviderInfo providerInfo = pm.resolveContentProvider(providerName, 0);
            boolean bl = false;
            boolean bl2 = false;
            if (providerInfo == null) {
                boolean bl3 = false;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = CONTENT_PROVIDER_NOT_FOUND_REASON;
                Object[] objectArray = new Object[]{providerName};
                boolean bl4 = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                String string3 = string2;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
        }
    }

    private Validate() {
    }

    static {
        Validate validate;
        INSTANCE = validate = new Validate();
        String string = Validate.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Validate::class.java.name");
        TAG = string;
    }
}

