/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ml;

import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.appevents.internal.FileDownloadTask;
import com.facebook.appevents.ml.MTensor;
import com.facebook.appevents.ml.Model;
import com.facebook.appevents.ml.ModelManager;
import com.facebook.appevents.ml.ModelManager$Task$WhenMappings;
import com.facebook.appevents.ml.ModelManager$WhenMappings;
import com.facebook.appevents.ml.Utils;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u000289B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0007J\b\u0010\u001e\u001a\u00020\u001aH\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010\u001cH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&H\u0002J\u0014\u0010'\u001a\u0004\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u0010\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u001cH\u0002J9\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010.2\u0006\u0010\"\u001a\u00020#2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020(0.2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00040.H\u0007\u00a2\u0006\u0002\u00101J%\u00102\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010.2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020(H\u0002\u00a2\u0006\u0002\u00106J%\u00107\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010.2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020(H\u0002\u00a2\u0006\u0002\u00106R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u001c\u0010\u0016\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/facebook/appevents/ml/ModelManager;", "", "()V", "ASSET_URI_KEY", "", "CACHE_KEY_MODELS", "CACHE_KEY_REQUEST_TIMESTAMP", "MODEL_ASSERT_STORE", "MODEL_REQUEST_INTERVAL_MILLISECONDS", "", "MTML_INTEGRITY_DETECT_PREDICTION", "", "MTML_SUGGESTED_EVENTS_PREDICTION", "MTML_USE_CASE", "RULES_URI_KEY", "SDK_MODEL_ASSET", "THRESHOLD_KEY", "USE_CASE_KEY", "VERSION_ID_KEY", "isLocaleEnglish", "", "()Z", "taskHandlers", "", "Lcom/facebook/appevents/ml/ModelManager$TaskHandler;", "addModels", "", "models", "Lorg/json/JSONObject;", "enable", "enableMTML", "fetchModels", "getRuleFile", "Ljava/io/File;", "task", "Lcom/facebook/appevents/ml/ModelManager$Task;", "isValidTimestamp", "timestamp", "", "parseJsonArray", "", "jsonArray", "Lorg/json/JSONArray;", "parseRawJsonObject", "jsonObject", "predict", "", "denses", "texts", "(Lcom/facebook/appevents/ml/ModelManager$Task;[[F[Ljava/lang/String;)[Ljava/lang/String;", "processIntegrityDetectionResult", "res", "Lcom/facebook/appevents/ml/MTensor;", "thresholds", "(Lcom/facebook/appevents/ml/MTensor;[F)[Ljava/lang/String;", "processSuggestedEventResult", "Task", "TaskHandler", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ModelManager {
    private static final Map<String, TaskHandler> taskHandlers;
    private static final String SDK_MODEL_ASSET = "%s/model_asset";
    private static final String MODEL_ASSERT_STORE = "com.facebook.internal.MODEL_STORE";
    private static final String CACHE_KEY_MODELS = "models";
    private static final String MTML_USE_CASE = "MTML";
    private static final String USE_CASE_KEY = "use_case";
    private static final String VERSION_ID_KEY = "version_id";
    private static final String ASSET_URI_KEY = "asset_uri";
    private static final String RULES_URI_KEY = "rules_uri";
    private static final String THRESHOLD_KEY = "thresholds";
    private static final int MODEL_REQUEST_INTERVAL_MILLISECONDS = 259200000;
    private static final String CACHE_KEY_REQUEST_TIMESTAMP = "model_request_timestamp";
    private static final List<String> MTML_SUGGESTED_EVENTS_PREDICTION;
    private static final List<String> MTML_INTEGRITY_DETECT_PREDICTION;
    @NotNull
    public static final ModelManager INSTANCE;

    @JvmStatic
    public static final void enable() {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return;
        }
        try {
            Utility.runOnNonUiThread(enable.1.INSTANCE);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isValidTimestamp(long l) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            void timestamp;
            return timestamp == 0L ? false : System.currentTimeMillis() - timestamp < (long)259200000;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addModels(JSONObject jSONObject) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void models;
            Iterator keys = models.keys();
            try {
                while (keys.hasNext()) {
                    TaskHandler handler;
                    String key = (String)keys.next();
                    if (TaskHandler.Companion.build(models.getJSONObject(key)) == null) {
                        continue;
                    }
                    taskHandlers.put(handler.getUseCase(), handler);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JSONObject parseRawJsonObject(JSONObject jSONObject) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            JSONObject jSONObject2;
            JSONObject resultJsonObject = new JSONObject();
            try {
                void jsonObject;
                JSONArray jsonArray = jsonObject.getJSONArray("data");
                int n = 0;
                int n2 = jsonArray.length();
                while (n < n2) {
                    void i;
                    JSONObject curJsonObject = jsonArray.getJSONObject((int)i);
                    JSONObject tempJsonObject = new JSONObject();
                    tempJsonObject.put(VERSION_ID_KEY, (Object)curJsonObject.getString(VERSION_ID_KEY));
                    tempJsonObject.put(USE_CASE_KEY, (Object)curJsonObject.getString(USE_CASE_KEY));
                    tempJsonObject.put(THRESHOLD_KEY, (Object)curJsonObject.getJSONArray(THRESHOLD_KEY));
                    tempJsonObject.put(ASSET_URI_KEY, (Object)curJsonObject.getString(ASSET_URI_KEY));
                    if (curJsonObject.has(RULES_URI_KEY)) {
                        tempJsonObject.put(RULES_URI_KEY, (Object)curJsonObject.getString(RULES_URI_KEY));
                    }
                    resultJsonObject.put(curJsonObject.getString(USE_CASE_KEY), (Object)tempJsonObject);
                    ++i;
                }
                jSONObject2 = resultJsonObject;
            }
            catch (JSONException je) {
                jSONObject2 = new JSONObject();
            }
            return jSONObject2;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    private final JSONObject fetchModels() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            JSONObject jSONObject;
            GraphRequest graphRequest;
            Object[] appSettingFields = new String[]{USE_CASE_KEY, VERSION_ID_KEY, ASSET_URI_KEY, RULES_URI_KEY, THRESHOLD_KEY};
            Bundle appSettingsParams = new Bundle();
            appSettingsParams.putString("fields", TextUtils.join((CharSequence)",", (Object[])appSettingFields));
            if (Utility.isNullOrEmpty(FacebookSdk.getClientToken())) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = SDK_MODEL_ASSET;
                Object[] objectArray = new Object[]{FacebookSdk.getApplicationId()};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                graphRequest = GraphRequest.Companion.newGraphPathRequest(null, string2, null);
                graphRequest.setSkipClientToken(true);
                graphRequest.setParameters(appSettingsParams);
                jSONObject = graphRequest.executeAndWait().getJSONObject();
                if (jSONObject == null) {
                    return null;
                }
            } else {
                graphRequest = GraphRequest.Companion.newGraphPathRequest(null, "app/model_asset", null);
                graphRequest.setParameters(appSettingsParams);
                jSONObject = graphRequest.executeAndWait().getJSONObject();
                if (jSONObject == null) {
                    return null;
                }
            }
            JSONObject rawResponse = jSONObject;
            return this.parseRawJsonObject(rawResponse);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void enableMTML() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            List slaveTasks = new ArrayList();
            String mtmlAssetUri = null;
            int mtmlVersionId = 0;
            Object object = taskHandlers;
            boolean bl = false;
            Iterator<Map.Entry<String, TaskHandler>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void useCase;
                Map.Entry<String, TaskHandler> entry;
                Map.Entry<String, TaskHandler> entry2 = entry = iterator.next();
                boolean bl2 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl2 = false;
                TaskHandler handler = entry2.getValue();
                if (Intrinsics.areEqual((Object)useCase, (Object)Task.MTML_APP_EVENT_PREDICTION.toUseCase())) {
                    mtmlAssetUri = handler.getAssetUri();
                    mtmlVersionId = Math.max(mtmlVersionId, handler.getVersionId());
                    if (FeatureManager.isEnabled(FeatureManager.Feature.SuggestedEvents) && this.isLocaleEnglish()) {
                        slaveTasks.add(handler.setOnPostExecute(enableMTML.1.INSTANCE));
                    }
                }
                if (!Intrinsics.areEqual((Object)useCase, (Object)Task.MTML_INTEGRITY_DETECT.toUseCase())) continue;
                mtmlAssetUri = handler.getAssetUri();
                mtmlVersionId = Math.max(mtmlVersionId, handler.getVersionId());
                if (!FeatureManager.isEnabled(FeatureManager.Feature.IntelligentIntegrity)) continue;
                slaveTasks.add(handler.setOnPostExecute(enableMTML.2.INSTANCE));
            }
            if (mtmlAssetUri != null && mtmlVersionId > 0 && !slaveTasks.isEmpty()) {
                TaskHandler mtmlHandler = new TaskHandler(MTML_USE_CASE, mtmlAssetUri, null, mtmlVersionId, null);
                TaskHandler.Companion.execute(mtmlHandler, slaveTasks);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLocaleEnglish() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            Locale locale = Utility.getResourceLocale();
            if (locale == null) return true;
            String string = locale.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"locale.language");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"en", (boolean)false, (int)2, null)) return false;
            return true;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final float[] parseJsonArray(JSONArray jSONArray) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void jsonArray;
            if (jsonArray == null) {
                return null;
            }
            float[] thresholds = new float[jsonArray.length()];
            int n = 0;
            int n2 = jsonArray.length();
            while (n < n2) {
                void i;
                try {
                    String string;
                    Intrinsics.checkNotNullExpressionValue((Object)jsonArray.getString((int)i), (String)"jsonArray.getString(i)");
                    boolean bl = false;
                    thresholds[i] = Float.parseFloat(string);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                ++i;
            }
            return thresholds;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final File getRuleFile(@NotNull Task task2) {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return null;
        }
        try {
            Task task3;
            Intrinsics.checkNotNullParameter((Object)((Object)task3), (String)"task");
            TaskHandler taskHandler = taskHandlers.get(task3.toUseCase());
            if (taskHandler == null) {
                return null;
            }
            TaskHandler handler = taskHandler;
            return handler.getRuleFile();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Nullable
    public static final String[] predict(@NotNull Task task2, @NotNull float[][] fArray, @NotNull String[] stringArray) {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return null;
        }
        try {
            TaskHandler handler;
            void texts;
            void denses;
            Task task3;
            Intrinsics.checkNotNullParameter((Object)((Object)task3), (String)"task");
            Intrinsics.checkNotNullParameter((Object)denses, (String)"denses");
            Intrinsics.checkNotNullParameter((Object)texts, (String)"texts");
            TaskHandler taskHandler = handler = taskHandlers.get(task3.toUseCase());
            Object object = taskHandler;
            if (taskHandler == null) return null;
            Model model = ((TaskHandler)object).getModel();
            object = model;
            if (model == null) return null;
            Object model2 = object;
            float[] thresholds = handler.getThresholds();
            int exampleSize = ((void)texts).length;
            int denseSize = ((void)denses[0]).length;
            MTensor dense = new MTensor(new int[]{exampleSize, denseSize});
            int n = 0;
            int n2 = exampleSize;
            while (n < n2) {
                void n3;
                System.arraycopy(denses[n3], 0, dense.getData(), (int)(n3 * denseSize), denseSize);
                ++n3;
            }
            MTensor res = ((Model)model2).predictOnMTML(dense, (String[])texts, task3.toKey());
            if (res == null) return null;
            if (thresholds == null) return null;
            float[] fArray2 = res.getData();
            boolean bl = false;
            if (fArray2.length == 0) {
                return null;
            }
            boolean bl2 = false;
            if (bl2) return null;
            fArray2 = thresholds;
            bl = false;
            if (fArray2.length == 0) {
                return null;
            }
            boolean bl3 = false;
            if (bl3) {
                return null;
            }
            switch (ModelManager$WhenMappings.$EnumSwitchMapping$0[task3.ordinal()]) {
                case 1: {
                    String[] stringArray2 = INSTANCE.processSuggestedEventResult(res, thresholds);
                    return stringArray2;
                }
                case 2: {
                    String[] stringArray2 = INSTANCE.processIntegrityDetectionResult(res, thresholds);
                    return stringArray2;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String[] processSuggestedEventResult(MTensor mTensor, float[] fArray) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            void thresholds;
            void res;
            int exampleSize = res.getShape(0);
            int resSize = res.getShape(1);
            float[] resData = res.getData();
            if (resSize != ((void)thresholds).length) {
                return null;
            }
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)exampleSize);
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String resultItem = "other";
                void $this$forEachIndexed$iv = thresholds;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (void item$iv : $this$forEachIndexed$iv) {
                    void threshold;
                    void it;
                    int n2 = index$iv++;
                    void var23_23 = item$iv;
                    int idx = n2;
                    boolean bl2 = false;
                    if (!(resData[it * resSize + idx] >= threshold)) continue;
                    resultItem = MTML_SUGGESTED_EVENTS_PREDICTION.get(idx);
                }
                String string = resultItem;
                collection.add(string);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return stringArray;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String[] processIntegrityDetectionResult(MTensor mTensor, float[] fArray) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            void thresholds;
            void res;
            int exampleSize = res.getShape(0);
            int resSize = res.getShape(1);
            float[] resData = res.getData();
            if (resSize != ((void)thresholds).length) {
                return null;
            }
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)exampleSize);
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String resultItem = "none";
                void $this$forEachIndexed$iv = thresholds;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (void item$iv : $this$forEachIndexed$iv) {
                    void threshold;
                    void it;
                    int n2 = index$iv++;
                    void var23_23 = item$iv;
                    int idx = n2;
                    boolean bl2 = false;
                    if (!(resData[it * resSize + idx] >= threshold)) continue;
                    resultItem = MTML_INTEGRITY_DETECT_PREDICTION.get(idx);
                }
                String string = resultItem;
                collection.add(string);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return stringArray;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    private ModelManager() {
    }

    static {
        ModelManager modelManager;
        INSTANCE = modelManager = new ModelManager();
        taskHandlers = new ConcurrentHashMap();
        MTML_SUGGESTED_EVENTS_PREDICTION = CollectionsKt.listOf((Object[])new String[]{"other", "fb_mobile_complete_registration", "fb_mobile_add_to_cart", "fb_mobile_purchase", "fb_mobile_initiated_checkout"});
        MTML_INTEGRITY_DETECT_PREDICTION = CollectionsKt.listOf((Object[])new String[]{"none", "address", "health"});
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ float[] access$parseJsonArray(ModelManager modelManager, JSONArray jSONArray) {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return null;
        }
        try {
            void jsonArray;
            ModelManager $this;
            return $this.parseJsonArray((JSONArray)jsonArray);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean access$isValidTimestamp(ModelManager modelManager, long l) {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return false;
        }
        try {
            void timestamp;
            ModelManager $this;
            return $this.isValidTimestamp((long)timestamp);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return false;
        }
    }

    public static final /* synthetic */ JSONObject access$fetchModels(ModelManager modelManager) {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return null;
        }
        try {
            ModelManager $this;
            return $this.fetchModels();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$addModels(ModelManager modelManager, JSONObject jSONObject) {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return;
        }
        try {
            void models;
            ModelManager $this;
            $this.addModels((JSONObject)models);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return;
        }
    }

    public static final /* synthetic */ void access$enableMTML(ModelManager modelManager) {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return;
        }
        try {
            ModelManager $this;
            $this.enableMTML();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0004j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/facebook/appevents/ml/ModelManager$Task;", "", "(Ljava/lang/String;I)V", "toKey", "", "toUseCase", "MTML_INTEGRITY_DETECT", "MTML_APP_EVENT_PREDICTION", "facebook-core_release"})
    public static final class Task
    extends Enum<Task> {
        public static final /* enum */ Task MTML_INTEGRITY_DETECT;
        public static final /* enum */ Task MTML_APP_EVENT_PREDICTION;
        private static final /* synthetic */ Task[] $VALUES;

        static {
            Task[] taskArray = new Task[2];
            Task[] taskArray2 = taskArray;
            taskArray[0] = MTML_INTEGRITY_DETECT = new Task();
            taskArray[1] = MTML_APP_EVENT_PREDICTION = new Task();
            $VALUES = taskArray;
        }

        @NotNull
        public final String toKey() {
            String string;
            switch (ModelManager$Task$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    string = "integrity_detect";
                    break;
                }
                case 2: {
                    string = "app_event_pred";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        @NotNull
        public final String toUseCase() {
            String string;
            switch (ModelManager$Task$WhenMappings.$EnumSwitchMapping$1[this.ordinal()]) {
                case 1: {
                    string = "MTML_INTEGRITY_DETECT";
                    break;
                }
                case 2: {
                    string = "MTML_APP_EVENT_PRED";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        public static Task[] values() {
            return (Task[])$VALUES.clone();
        }

        public static Task valueOf(String string) {
            return Enum.valueOf(Task.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0002\u0018\u0000 *2\u00020\u0001:\u0001*B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010)\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\f\"\u0004\b\u001e\u0010\u000eR\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\f\"\u0004\b$\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u0006+"}, d2={"Lcom/facebook/appevents/ml/ModelManager$TaskHandler;", "", "useCase", "", "assetUri", "ruleUri", "versionId", "", "thresholds", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I[F)V", "getAssetUri", "()Ljava/lang/String;", "setAssetUri", "(Ljava/lang/String;)V", "model", "Lcom/facebook/appevents/ml/Model;", "getModel", "()Lcom/facebook/appevents/ml/Model;", "setModel", "(Lcom/facebook/appevents/ml/Model;)V", "onPostExecute", "Ljava/lang/Runnable;", "ruleFile", "Ljava/io/File;", "getRuleFile", "()Ljava/io/File;", "setRuleFile", "(Ljava/io/File;)V", "getRuleUri", "setRuleUri", "getThresholds", "()[F", "setThresholds", "([F)V", "getUseCase", "setUseCase", "getVersionId", "()I", "setVersionId", "(I)V", "setOnPostExecute", "Companion", "facebook-core_release"})
    private static final class TaskHandler {
        @Nullable
        private File ruleFile;
        @Nullable
        private Model model;
        private Runnable onPostExecute;
        @NotNull
        private String useCase;
        @NotNull
        private String assetUri;
        @Nullable
        private String ruleUri;
        private int versionId;
        @Nullable
        private float[] thresholds;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @Nullable
        public final File getRuleFile() {
            return this.ruleFile;
        }

        public final void setRuleFile(@Nullable File file) {
            this.ruleFile = file;
        }

        @Nullable
        public final Model getModel() {
            return this.model;
        }

        public final void setModel(@Nullable Model model) {
            this.model = model;
        }

        @NotNull
        public final TaskHandler setOnPostExecute(@Nullable Runnable onPostExecute) {
            this.onPostExecute = onPostExecute;
            return this;
        }

        @NotNull
        public final String getUseCase() {
            return this.useCase;
        }

        public final void setUseCase(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.useCase = string;
        }

        @NotNull
        public final String getAssetUri() {
            return this.assetUri;
        }

        public final void setAssetUri(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.assetUri = string;
        }

        @Nullable
        public final String getRuleUri() {
            return this.ruleUri;
        }

        public final void setRuleUri(@Nullable String string) {
            this.ruleUri = string;
        }

        public final int getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(int n) {
            this.versionId = n;
        }

        @Nullable
        public final float[] getThresholds() {
            return this.thresholds;
        }

        public final void setThresholds(@Nullable float[] fArray) {
            this.thresholds = fArray;
        }

        public TaskHandler(@NotNull String useCase, @NotNull String assetUri, @Nullable String ruleUri, int versionId, @Nullable float[] thresholds) {
            Intrinsics.checkNotNullParameter((Object)useCase, (String)"useCase");
            Intrinsics.checkNotNullParameter((Object)assetUri, (String)"assetUri");
            this.useCase = useCase;
            this.assetUri = assetUri;
            this.ruleUri = ruleUri;
            this.versionId = versionId;
            this.thresholds = thresholds;
        }

        public static final /* synthetic */ Runnable access$getOnPostExecute$p(TaskHandler $this) {
            return $this.onPostExecute;
        }

        public static final /* synthetic */ void access$setOnPostExecute$p(TaskHandler $this, Runnable runnable2) {
            $this.onPostExecute = runnable2;
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0004J\u001c\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016\u00a8\u0006\u0017"}, d2={"Lcom/facebook/appevents/ml/ModelManager$TaskHandler$Companion;", "", "()V", "build", "Lcom/facebook/appevents/ml/ModelManager$TaskHandler;", "json", "Lorg/json/JSONObject;", "deleteOldFiles", "", "useCase", "", "versionId", "", "download", "uri", "name", "onComplete", "Lcom/facebook/appevents/internal/FileDownloadTask$Callback;", "execute", "handler", "master", "slaves", "", "facebook-core_release"})
        public static final class Companion {
            @Nullable
            public final TaskHandler build(@Nullable JSONObject json) {
                TaskHandler taskHandler;
                if (json == null) {
                    taskHandler = null;
                } else {
                    TaskHandler taskHandler2;
                    try {
                        String useCase = json.getString(ModelManager.USE_CASE_KEY);
                        String assetUri = json.getString(ModelManager.ASSET_URI_KEY);
                        String ruleUri = json.optString(ModelManager.RULES_URI_KEY, null);
                        int versionId = json.getInt(ModelManager.VERSION_ID_KEY);
                        float[] thresholds = ModelManager.access$parseJsonArray(INSTANCE, json.getJSONArray(ModelManager.THRESHOLD_KEY));
                        String string = useCase;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"useCase");
                        String string2 = assetUri;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"assetUri");
                        taskHandler2 = new TaskHandler(string, string2, ruleUri, versionId, thresholds);
                    }
                    catch (Exception e) {
                        taskHandler2 = null;
                    }
                    taskHandler = taskHandler2;
                }
                return taskHandler;
            }

            public final void execute(@NotNull TaskHandler handler) {
                Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
                this.execute(handler, CollectionsKt.listOf((Object)handler));
            }

            public final void execute(@NotNull TaskHandler master, @NotNull List<TaskHandler> slaves) {
                Intrinsics.checkNotNullParameter((Object)master, (String)"master");
                Intrinsics.checkNotNullParameter(slaves, (String)"slaves");
                this.deleteOldFiles(master.getUseCase(), master.getVersionId());
                String modelFileName = master.getUseCase() + "_" + master.getVersionId();
                this.download(master.getAssetUri(), modelFileName, new FileDownloadTask.Callback(slaves){
                    final /* synthetic */ List $slaves;

                    public final void onComplete(@NotNull File file) {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        Model model = Model.Companion.build(file);
                        if (model != null) {
                            for (TaskHandler slave : this.$slaves) {
                                String ruleFileName = slave.getUseCase() + "_" + slave.getVersionId() + "_rule";
                                com.facebook.appevents.ml.ModelManager$TaskHandler$Companion.access$download(TaskHandler.Companion, slave.getRuleUri(), ruleFileName, new FileDownloadTask.Callback(slave, model){
                                    final /* synthetic */ TaskHandler $slave;
                                    final /* synthetic */ Model $model;

                                    public final void onComplete(@NotNull File file) {
                                        block0: {
                                            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                                            this.$slave.setModel(this.$model);
                                            this.$slave.setRuleFile(file);
                                            Runnable runnable2 = TaskHandler.access$getOnPostExecute$p(this.$slave);
                                            if (runnable2 == null) break block0;
                                            runnable2.run();
                                        }
                                    }
                                    {
                                        this.$slave = taskHandler;
                                        this.$model = model;
                                    }
                                });
                            }
                        }
                    }
                    {
                        this.$slaves = list;
                    }
                });
            }

            private final void deleteOldFiles(String useCase, int versionId) {
                File[] existingFiles;
                block6: {
                    block5: {
                        File file = Utils.getMlDir();
                        if (file == null) {
                            return;
                        }
                        File dir = file;
                        existingFiles = dir.listFiles();
                        if (existingFiles == null) break block5;
                        File[] fileArray = existingFiles;
                        boolean bl = false;
                        if (!(fileArray.length == 0)) break block6;
                    }
                    return;
                }
                String prefixWithVersion = useCase + "_" + versionId;
                File[] fileArray = existingFiles;
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    String name;
                    File f;
                    File file = f = fileArray[i];
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"f");
                    String string = name = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                    if (!StringsKt.startsWith$default((String)string, (String)useCase, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)prefixWithVersion, (boolean)false, (int)2, null)) continue;
                    f.delete();
                }
            }

            private final void download(String uri, String name, FileDownloadTask.Callback onComplete) {
                File file = new File(Utils.getMlDir(), name);
                if (uri == null || file.exists()) {
                    onComplete.onComplete(file);
                    return;
                }
                new FileDownloadTask(uri, file, onComplete).execute(new String[0]);
            }

            private Companion() {
            }

            public static final /* synthetic */ void access$download(Companion $this, String uri, String name, FileDownloadTask.Callback onComplete) {
                $this.download(uri, name, onComplete);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

