/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.facebook.AccessToken$WhenMappings;
import com.facebook.AccessTokenManager;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.LegacyTokenHelper;
import com.facebook.LoggingBehavior;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 E2\u00020\u0001:\u0003CDEB\u0089\u0001\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0010\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u0007\u0012\u0010\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u0007\u0012\u0010\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0011B\u000f\b\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010.\u001a\u00020/2\n\u00100\u001a\u000601j\u0002`2H\u0002J\u001a\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u00105\u001a\u000206H\u0016J\u0013\u00107\u001a\u00020!2\b\u00108\u001a\u0004\u0018\u000109H\u0096\u0002J\b\u0010:\u001a\u000206H\u0016J\r\u0010;\u001a\u00020<H\u0000\u00a2\u0006\u0002\b=J\b\u0010>\u001a\u00020\u0003H\u0016J\b\u0010?\u001a\u00020\u0003H\u0002J\u0018\u0010@\u001a\u00020/2\u0006\u0010A\u001a\u00020\u00132\u0006\u0010B\u001a\u000206H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0019\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0011\u0010\u001d\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\"R\u0011\u0010#\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\"R\u0011\u0010$\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0011\u0010%\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0018R\u0019\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001bR\u0011\u0010(\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0016\u00a8\u0006F"}, d2={"Lcom/facebook/AccessToken;", "Landroid/os/Parcelable;", "accessToken", "", "applicationId", "userId", "permissions", "", "declinedPermissions", "expiredPermissions", "accessTokenSource", "Lcom/facebook/AccessTokenSource;", "expirationTime", "Ljava/util/Date;", "lastRefreshTime", "dataAccessExpirationTime", "graphDomain", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;Lcom/facebook/AccessTokenSource;Ljava/util/Date;Ljava/util/Date;Ljava/util/Date;Ljava/lang/String;)V", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "getApplicationId", "()Ljava/lang/String;", "getDataAccessExpirationTime", "()Ljava/util/Date;", "", "getDeclinedPermissions", "()Ljava/util/Set;", "getExpiredPermissions", "expires", "getExpires", "getGraphDomain", "isDataAccessExpired", "", "()Z", "isExpired", "isInstagramToken", "lastRefresh", "getLastRefresh", "getPermissions", "source", "getSource", "()Lcom/facebook/AccessTokenSource;", "token", "getToken", "getUserId", "appendPermissions", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "convertTokenSourceForGraphDomain", "tokenSource", "describeContents", "", "equals", "other", "", "hashCode", "toJSONObject", "Lorg/json/JSONObject;", "toJSONObject$facebook_core_release", "toString", "tokenToString", "writeToParcel", "dest", "flags", "AccessTokenCreationCallback", "AccessTokenRefreshCallback", "Companion", "facebook-core_release"})
public final class AccessToken
implements Parcelable {
    @NotNull
    private final Date expires;
    @NotNull
    private final Set<String> permissions;
    @NotNull
    private final Set<String> declinedPermissions;
    @NotNull
    private final Set<String> expiredPermissions;
    @NotNull
    private final String token;
    @NotNull
    private final AccessTokenSource source;
    @NotNull
    private final Date lastRefresh;
    @NotNull
    private final String applicationId;
    @NotNull
    private final String userId;
    @NotNull
    private final Date dataAccessExpirationTime;
    @Nullable
    private final String graphDomain;
    @NotNull
    public static final String ACCESS_TOKEN_KEY = "access_token";
    @NotNull
    public static final String EXPIRES_IN_KEY = "expires_in";
    @NotNull
    public static final String USER_ID_KEY = "user_id";
    @NotNull
    public static final String DATA_ACCESS_EXPIRATION_TIME = "data_access_expiration_time";
    @NotNull
    public static final String GRAPH_DOMAIN = "graph_domain";
    @NotNull
    public static final String DEFAULT_GRAPH_DOMAIN = "facebook";
    private static final Date MAX_DATE;
    private static final Date DEFAULT_EXPIRATION_TIME;
    private static final Date DEFAULT_LAST_REFRESH_TIME;
    private static final AccessTokenSource DEFAULT_ACCESS_TOKEN_SOURCE;
    private static final int CURRENT_JSON_FORMAT = 1;
    private static final String VERSION_KEY = "version";
    private static final String EXPIRES_AT_KEY = "expires_at";
    private static final String PERMISSIONS_KEY = "permissions";
    private static final String DECLINED_PERMISSIONS_KEY = "declined_permissions";
    private static final String EXPIRED_PERMISSIONS_KEY = "expired_permissions";
    private static final String TOKEN_KEY = "token";
    private static final String SOURCE_KEY = "source";
    private static final String LAST_REFRESH_KEY = "last_refresh";
    private static final String APPLICATION_ID_KEY = "application_id";
    @JvmField
    @NotNull
    public static final Parcelable.Creator<AccessToken> CREATOR;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Date getExpires() {
        return this.expires;
    }

    @NotNull
    public final Set<String> getPermissions() {
        return this.permissions;
    }

    @NotNull
    public final Set<String> getDeclinedPermissions() {
        return this.declinedPermissions;
    }

    @NotNull
    public final Set<String> getExpiredPermissions() {
        return this.expiredPermissions;
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    @NotNull
    public final AccessTokenSource getSource() {
        return this.source;
    }

    @NotNull
    public final Date getLastRefresh() {
        return this.lastRefresh;
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    @NotNull
    public final String getUserId() {
        return this.userId;
    }

    @NotNull
    public final Date getDataAccessExpirationTime() {
        return this.dataAccessExpirationTime;
    }

    @Nullable
    public final String getGraphDomain() {
        return this.graphDomain;
    }

    @NotNull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{AccessToken");
        builder.append(" token:").append(this.tokenToString());
        this.appendPermissions(builder);
        builder.append("}");
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AccessToken)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.expires, (Object)((AccessToken)other).expires)) return false;
        if (!Intrinsics.areEqual(this.permissions, ((AccessToken)other).permissions)) return false;
        if (!Intrinsics.areEqual(this.declinedPermissions, ((AccessToken)other).declinedPermissions)) return false;
        if (!Intrinsics.areEqual(this.expiredPermissions, ((AccessToken)other).expiredPermissions)) return false;
        if (!Intrinsics.areEqual((Object)this.token, (Object)((AccessToken)other).token)) return false;
        if (this.source != ((AccessToken)other).source) return false;
        if (!Intrinsics.areEqual((Object)this.lastRefresh, (Object)((AccessToken)other).lastRefresh)) return false;
        if (!Intrinsics.areEqual((Object)this.applicationId, (Object)((AccessToken)other).applicationId)) return false;
        if (!Intrinsics.areEqual((Object)this.userId, (Object)((AccessToken)other).userId)) return false;
        if (!Intrinsics.areEqual((Object)this.dataAccessExpirationTime, (Object)((AccessToken)other).dataAccessExpirationTime)) return false;
        if (this.graphDomain == null) {
            if (((AccessToken)other).graphDomain != null) return false;
            return true;
        }
        boolean bl = Intrinsics.areEqual((Object)this.graphDomain, (Object)((AccessToken)other).graphDomain);
        if (!bl) return false;
        return true;
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.expires.hashCode();
        result = result * 31 + ((Object)this.permissions).hashCode();
        result = result * 31 + ((Object)this.declinedPermissions).hashCode();
        result = result * 31 + ((Object)this.expiredPermissions).hashCode();
        result = result * 31 + this.token.hashCode();
        result = result * 31 + this.source.hashCode();
        result = result * 31 + this.lastRefresh.hashCode();
        result = result * 31 + this.applicationId.hashCode();
        result = result * 31 + this.userId.hashCode();
        result = result * 31 + this.dataAccessExpirationTime.hashCode();
        String string = this.graphDomain;
        result = result * 31 + (string != null ? string.hashCode() : 0);
        return result;
    }

    public final boolean isExpired() {
        return new Date().after(this.expires);
    }

    public final boolean isDataAccessExpired() {
        return new Date().after(this.dataAccessExpirationTime);
    }

    public final boolean isInstagramToken() {
        return this.graphDomain != null && this.graphDomain.equals("instagram");
    }

    @NotNull
    public final JSONObject toJSONObject$facebook_core_release() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(VERSION_KEY, 1);
        jsonObject.put(TOKEN_KEY, (Object)this.token);
        jsonObject.put(EXPIRES_AT_KEY, this.expires.getTime());
        JSONArray permissionsArray = new JSONArray((Collection)this.permissions);
        jsonObject.put(PERMISSIONS_KEY, (Object)permissionsArray);
        JSONArray declinedPermissionsArray = new JSONArray((Collection)this.declinedPermissions);
        jsonObject.put(DECLINED_PERMISSIONS_KEY, (Object)declinedPermissionsArray);
        JSONArray expiredPermissionsArray = new JSONArray((Collection)this.expiredPermissions);
        jsonObject.put(EXPIRED_PERMISSIONS_KEY, (Object)expiredPermissionsArray);
        jsonObject.put(LAST_REFRESH_KEY, this.lastRefresh.getTime());
        jsonObject.put(SOURCE_KEY, (Object)this.source.name());
        jsonObject.put(APPLICATION_ID_KEY, (Object)this.applicationId);
        jsonObject.put(USER_ID_KEY, (Object)this.userId);
        jsonObject.put(DATA_ACCESS_EXPIRATION_TIME, this.dataAccessExpirationTime.getTime());
        if (this.graphDomain != null) {
            jsonObject.put(GRAPH_DOMAIN, (Object)this.graphDomain);
        }
        return jsonObject;
    }

    private final String tokenToString() {
        return FacebookSdk.isLoggingBehaviorEnabled(LoggingBehavior.INCLUDE_ACCESS_TOKENS) ? this.token : "ACCESS_TOKEN_REMOVED";
    }

    private final void appendPermissions(StringBuilder builder) {
        builder.append(" permissions:");
        builder.append("[");
        builder.append(TextUtils.join((CharSequence)", ", (Iterable)this.permissions));
        builder.append("]");
    }

    private final AccessTokenSource convertTokenSourceForGraphDomain(AccessTokenSource tokenSource, String graphDomain) {
        if (graphDomain != null && graphDomain.equals("instagram")) {
            AccessTokenSource accessTokenSource;
            switch (AccessToken$WhenMappings.$EnumSwitchMapping$0[tokenSource.ordinal()]) {
                case 1: {
                    accessTokenSource = AccessTokenSource.INSTAGRAM_APPLICATION_WEB;
                    break;
                }
                case 2: {
                    accessTokenSource = AccessTokenSource.INSTAGRAM_CUSTOM_CHROME_TAB;
                    break;
                }
                case 3: {
                    accessTokenSource = AccessTokenSource.INSTAGRAM_WEB_VIEW;
                    break;
                }
                default: {
                    accessTokenSource = tokenSource;
                }
            }
            return accessTokenSource;
        }
        return tokenSource;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeLong(this.expires.getTime());
        dest.writeStringList((List)new ArrayList(this.permissions));
        dest.writeStringList((List)new ArrayList(this.declinedPermissions));
        dest.writeStringList((List)new ArrayList(this.expiredPermissions));
        dest.writeString(this.token);
        dest.writeString(this.source.name());
        dest.writeLong(this.lastRefresh.getTime());
        dest.writeString(this.applicationId);
        dest.writeString(this.userId);
        dest.writeLong(this.dataAccessExpirationTime.getTime());
        dest.writeString(this.graphDomain);
    }

    @JvmOverloads
    public AccessToken(@NotNull String accessToken, @NotNull String applicationId, @NotNull String userId, @Nullable Collection<String> permissions, @Nullable Collection<String> declinedPermissions, @Nullable Collection<String> expiredPermissions, @Nullable AccessTokenSource accessTokenSource, @Nullable Date expirationTime, @Nullable Date lastRefreshTime, @Nullable Date dataAccessExpirationTime, @Nullable String graphDomain) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Validate.notEmpty(accessToken, "accessToken");
        Validate.notEmpty(applicationId, "applicationId");
        Validate.notEmpty(userId, "userId");
        Date date = expirationTime;
        if (date == null) {
            date = DEFAULT_EXPIRATION_TIME;
        }
        this.expires = date;
        Set set = Collections.unmodifiableSet((Set)(permissions != null ? new HashSet<String>(permissions) : new HashSet()));
        Intrinsics.checkNotNullExpressionValue(set, (String)"Collections.unmodifiable\u2026missions) else HashSet())");
        this.permissions = set;
        Set set2 = Collections.unmodifiableSet((Set)(declinedPermissions != null ? new HashSet<String>(declinedPermissions) : new HashSet()));
        Intrinsics.checkNotNullExpressionValue(set2, (String)"Collections.unmodifiable\u2026missions) else HashSet())");
        this.declinedPermissions = set2;
        Set set3 = Collections.unmodifiableSet((Set)(expiredPermissions != null ? new HashSet<String>(expiredPermissions) : new HashSet()));
        Intrinsics.checkNotNullExpressionValue(set3, (String)"Collections.unmodifiable\u2026missions) else HashSet())");
        this.expiredPermissions = set3;
        this.token = accessToken;
        AccessTokenSource accessTokenSource2 = accessTokenSource;
        if (accessTokenSource2 == null) {
            accessTokenSource2 = DEFAULT_ACCESS_TOKEN_SOURCE;
        }
        this.source = this.convertTokenSourceForGraphDomain(accessTokenSource2, graphDomain);
        Date date2 = lastRefreshTime;
        if (date2 == null) {
            date2 = DEFAULT_LAST_REFRESH_TIME;
        }
        this.lastRefresh = date2;
        this.applicationId = applicationId;
        this.userId = userId;
        this.dataAccessExpirationTime = dataAccessExpirationTime != null && dataAccessExpirationTime.getTime() != 0L ? dataAccessExpirationTime : DEFAULT_EXPIRATION_TIME;
        String string = graphDomain;
        if (string == null) {
            string = DEFAULT_GRAPH_DOMAIN;
        }
        this.graphDomain = string;
    }

    public /* synthetic */ AccessToken(String string, String string2, String string3, Collection collection, Collection collection2, Collection collection3, AccessTokenSource accessTokenSource, Date date, Date date2, Date date3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x400) != 0) {
            string4 = DEFAULT_GRAPH_DOMAIN;
        }
        this(string, string2, string3, collection, collection2, collection3, accessTokenSource, date, date2, date3, string4);
    }

    @JvmOverloads
    public AccessToken(@NotNull String accessToken, @NotNull String applicationId, @NotNull String userId, @Nullable Collection<String> permissions, @Nullable Collection<String> declinedPermissions, @Nullable Collection<String> expiredPermissions, @Nullable AccessTokenSource accessTokenSource, @Nullable Date expirationTime, @Nullable Date lastRefreshTime, @Nullable Date dataAccessExpirationTime) {
        this(accessToken, applicationId, userId, permissions, declinedPermissions, expiredPermissions, accessTokenSource, expirationTime, lastRefreshTime, dataAccessExpirationTime, null, 1024, null);
    }

    public AccessToken(@NotNull Parcel parcel) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        this.expires = new Date(parcel.readLong());
        ArrayList permissionsList = new ArrayList();
        parcel.readStringList((List)permissionsList);
        Set set = Collections.unmodifiableSet(new HashSet(permissionsList));
        Intrinsics.checkNotNullExpressionValue(set, (String)"Collections.unmodifiable\u2026HashSet(permissionsList))");
        this.permissions = set;
        permissionsList.clear();
        parcel.readStringList((List)permissionsList);
        Set set2 = Collections.unmodifiableSet(new HashSet(permissionsList));
        Intrinsics.checkNotNullExpressionValue(set2, (String)"Collections.unmodifiable\u2026HashSet(permissionsList))");
        this.declinedPermissions = set2;
        permissionsList.clear();
        parcel.readStringList((List)permissionsList);
        Set set3 = Collections.unmodifiableSet(new HashSet(permissionsList));
        Intrinsics.checkNotNullExpressionValue(set3, (String)"Collections.unmodifiable\u2026HashSet(permissionsList))");
        this.expiredPermissions = set3;
        String token = parcel.readString();
        this.token = Validate.notNullOrEmpty(token, TOKEN_KEY);
        String sourceString = parcel.readString();
        this.source = sourceString != null ? AccessTokenSource.valueOf(sourceString) : DEFAULT_ACCESS_TOKEN_SOURCE;
        this.lastRefresh = new Date(parcel.readLong());
        String applicationId = parcel.readString();
        this.applicationId = Validate.notNullOrEmpty(applicationId, "applicationId");
        String userId = parcel.readString();
        this.userId = Validate.notNullOrEmpty(userId, "userId");
        this.dataAccessExpirationTime = new Date(parcel.readLong());
        this.graphDomain = parcel.readString();
    }

    static {
        Companion = new Companion(null);
        DEFAULT_EXPIRATION_TIME = MAX_DATE = new Date(Long.MAX_VALUE);
        DEFAULT_LAST_REFRESH_TIME = new Date();
        DEFAULT_ACCESS_TOKEN_SOURCE = AccessTokenSource.FACEBOOK_APPLICATION_WEB;
        CREATOR = (Parcelable.Creator)new Parcelable.Creator<AccessToken>(){

            @NotNull
            public AccessToken createFromParcel(@NotNull Parcel source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                return new AccessToken(source);
            }

            @NotNull
            public AccessToken[] newArray(int size) {
                return new AccessToken[size];
            }
        };
    }

    @JvmStatic
    @Nullable
    public static final AccessToken getCurrentAccessToken() {
        return Companion.getCurrentAccessToken();
    }

    @JvmStatic
    public static final void setCurrentAccessToken(@Nullable AccessToken accessToken) {
        Companion.setCurrentAccessToken(accessToken);
    }

    @JvmStatic
    public static final boolean isCurrentAccessTokenActive() {
        return Companion.isCurrentAccessTokenActive();
    }

    @JvmStatic
    public static final boolean isDataAccessActive() {
        return Companion.isDataAccessActive();
    }

    @JvmStatic
    public static final boolean isLoggedInWithInstagram() {
        return Companion.isLoggedInWithInstagram();
    }

    @JvmStatic
    public static final void expireCurrentAccessToken() {
        Companion.expireCurrentAccessToken();
    }

    @JvmStatic
    public static final void refreshCurrentAccessTokenAsync() {
        Companion.refreshCurrentAccessTokenAsync();
    }

    @JvmStatic
    public static final void refreshCurrentAccessTokenAsync(@Nullable AccessTokenRefreshCallback callback2) {
        Companion.refreshCurrentAccessTokenAsync(callback2);
    }

    @JvmStatic
    public static final void createFromNativeLinkingIntent(@NotNull Intent intent, @NotNull String applicationId, @NotNull AccessTokenCreationCallback accessTokenCallback) {
        Companion.createFromNativeLinkingIntent(intent, applicationId, accessTokenCallback);
    }

    @JvmStatic
    @SuppressLint(value={"FieldGetter"})
    @Nullable
    public static final AccessToken createFromRefresh$facebook_core_release(@NotNull AccessToken current, @NotNull Bundle bundle) {
        return Companion.createFromRefresh$facebook_core_release(current, bundle);
    }

    @JvmStatic
    @Nullable
    public static final AccessToken createFromLegacyCache$facebook_core_release(@NotNull Bundle bundle) {
        return Companion.createFromLegacyCache$facebook_core_release(bundle);
    }

    @JvmStatic
    @NotNull
    public static final List<String> getPermissionsFromBundle$facebook_core_release(@NotNull Bundle bundle, @Nullable String key) {
        return Companion.getPermissionsFromBundle$facebook_core_release(bundle, key);
    }

    @JvmStatic
    @NotNull
    public static final AccessToken createFromJSONObject$facebook_core_release(@NotNull JSONObject jsonObject) throws JSONException {
        return Companion.createFromJSONObject$facebook_core_release(jsonObject);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\u0012\u0010\u0006\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&\u00a8\u0006\t"}, d2={"Lcom/facebook/AccessToken$AccessTokenRefreshCallback;", "", "OnTokenRefreshFailed", "", "exception", "Lcom/facebook/FacebookException;", "OnTokenRefreshed", "accessToken", "Lcom/facebook/AccessToken;", "facebook-core_release"})
    public static interface AccessTokenRefreshCallback {
        public void OnTokenRefreshed(@Nullable AccessToken var1);

        public void OnTokenRefreshFailed(@Nullable FacebookException var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\u0012\u0010\u0006\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&\u00a8\u0006\t"}, d2={"Lcom/facebook/AccessToken$AccessTokenCreationCallback;", "", "onError", "", "error", "Lcom/facebook/FacebookException;", "onSuccess", "token", "Lcom/facebook/AccessToken;", "facebook-core_release"})
    public static interface AccessTokenCreationCallback {
        public void onSuccess(@Nullable AccessToken var1);

        public void onError(@Nullable FacebookException var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b J<\u0010!\u001a\u0004\u0018\u00010\b2\u0010\u0010\"\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u0004H\u0002J\u0015\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020+H\u0001\u00a2\u0006\u0002\b,J\u0017\u0010-\u001a\u0004\u0018\u00010\b2\u0006\u0010$\u001a\u00020%H\u0001\u00a2\u0006\u0002\b.J \u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010(\u001a\u00020\u00042\u0006\u00103\u001a\u000204H\u0007J\u001f\u00105\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010$\u001a\u00020%H\u0001\u00a2\u0006\u0002\b6J\b\u00107\u001a\u000200H\u0007J\n\u00108\u001a\u0004\u0018\u00010\bH\u0007J'\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040#2\u0006\u0010$\u001a\u00020%2\b\u0010:\u001a\u0004\u0018\u00010\u0004H\u0001\u00a2\u0006\u0002\b;J\b\u0010<\u001a\u00020=H\u0007J\b\u0010>\u001a\u00020=H\u0007J\b\u0010?\u001a\u00020=H\u0007J\b\u0010@\u001a\u000200H\u0007J\u0012\u0010@\u001a\u0002002\b\u0010A\u001a\u0004\u0018\u00010BH\u0007J\u0012\u0010C\u001a\u0002002\b\u0010D\u001a\u0004\u0018\u00010\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/facebook/AccessToken$Companion;", "", "()V", "ACCESS_TOKEN_KEY", "", "APPLICATION_ID_KEY", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/facebook/AccessToken;", "CURRENT_JSON_FORMAT", "", "DATA_ACCESS_EXPIRATION_TIME", "DECLINED_PERMISSIONS_KEY", "DEFAULT_ACCESS_TOKEN_SOURCE", "Lcom/facebook/AccessTokenSource;", "DEFAULT_EXPIRATION_TIME", "Ljava/util/Date;", "DEFAULT_GRAPH_DOMAIN", "DEFAULT_LAST_REFRESH_TIME", "EXPIRED_PERMISSIONS_KEY", "EXPIRES_AT_KEY", "EXPIRES_IN_KEY", "GRAPH_DOMAIN", "LAST_REFRESH_KEY", "MAX_DATE", "PERMISSIONS_KEY", "SOURCE_KEY", "TOKEN_KEY", "USER_ID_KEY", "VERSION_KEY", "createExpired", "current", "createExpired$facebook_core_release", "createFromBundle", "requestedPermissions", "", "bundle", "Landroid/os/Bundle;", "source", "expirationBase", "applicationId", "createFromJSONObject", "jsonObject", "Lorg/json/JSONObject;", "createFromJSONObject$facebook_core_release", "createFromLegacyCache", "createFromLegacyCache$facebook_core_release", "createFromNativeLinkingIntent", "", "intent", "Landroid/content/Intent;", "accessTokenCallback", "Lcom/facebook/AccessToken$AccessTokenCreationCallback;", "createFromRefresh", "createFromRefresh$facebook_core_release", "expireCurrentAccessToken", "getCurrentAccessToken", "getPermissionsFromBundle", "key", "getPermissionsFromBundle$facebook_core_release", "isCurrentAccessTokenActive", "", "isDataAccessActive", "isLoggedInWithInstagram", "refreshCurrentAccessTokenAsync", "callback", "Lcom/facebook/AccessToken$AccessTokenRefreshCallback;", "setCurrentAccessToken", "accessToken", "facebook-core_release"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final AccessToken getCurrentAccessToken() {
            return AccessTokenManager.Companion.getInstance().getCurrentAccessToken();
        }

        @JvmStatic
        public final void setCurrentAccessToken(@Nullable AccessToken accessToken) {
            AccessTokenManager.Companion.getInstance().setCurrentAccessToken(accessToken);
        }

        @JvmStatic
        public final boolean isCurrentAccessTokenActive() {
            AccessToken accessToken = AccessTokenManager.Companion.getInstance().getCurrentAccessToken();
            return accessToken != null && !accessToken.isExpired();
        }

        @JvmStatic
        public final boolean isDataAccessActive() {
            AccessToken accessToken = AccessTokenManager.Companion.getInstance().getCurrentAccessToken();
            return accessToken != null && !accessToken.isDataAccessExpired();
        }

        @JvmStatic
        public final boolean isLoggedInWithInstagram() {
            AccessToken accessToken = AccessTokenManager.Companion.getInstance().getCurrentAccessToken();
            return accessToken != null && !accessToken.isExpired() && accessToken.isInstagramToken();
        }

        @JvmStatic
        public final void expireCurrentAccessToken() {
            AccessToken accessToken = AccessTokenManager.Companion.getInstance().getCurrentAccessToken();
            if (accessToken != null) {
                this.setCurrentAccessToken(this.createExpired$facebook_core_release(accessToken));
            }
        }

        @JvmStatic
        public final void refreshCurrentAccessTokenAsync() {
            AccessTokenManager.Companion.getInstance().refreshCurrentAccessToken(null);
        }

        @JvmStatic
        public final void refreshCurrentAccessTokenAsync(@Nullable AccessTokenRefreshCallback callback2) {
            AccessTokenManager.Companion.getInstance().refreshCurrentAccessToken(callback2);
        }

        /*
         * Enabled aggressive block sorting
         */
        @JvmStatic
        public final void createFromNativeLinkingIntent(@NotNull Intent intent, @NotNull String applicationId, @NotNull AccessTokenCreationCallback accessTokenCallback) {
            String accessToken;
            Bundle extras;
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                    Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
                    Intrinsics.checkNotNullParameter((Object)accessTokenCallback, (String)"accessTokenCallback");
                    if (intent.getExtras() == null) {
                        accessTokenCallback.onError(new FacebookException("No extras found on intent"));
                        return;
                    }
                    extras = new Bundle(intent.getExtras());
                    accessToken = extras.getString(AccessToken.ACCESS_TOKEN_KEY);
                    if (accessToken == null) break block6;
                    CharSequence charSequence = accessToken;
                    boolean bl = false;
                    if (!(charSequence.length() == 0)) break block7;
                }
                accessTokenCallback.onError(new FacebookException("No access token found on intent"));
                return;
            }
            String userId = extras.getString(AccessToken.USER_ID_KEY);
            if (userId != null) {
                CharSequence charSequence = userId;
                boolean bl = false;
                if (!(charSequence.length() == 0)) {
                    accessTokenCallback.onSuccess(this.createFromBundle(null, extras, AccessTokenSource.FACEBOOK_APPLICATION_WEB, new Date(), applicationId));
                    return;
                }
            }
            Utility.getGraphMeRequestWithCacheAsync(accessToken, new Utility.GraphMeRequestWithCacheCallback(extras, accessTokenCallback, applicationId){
                final /* synthetic */ Bundle $extras;
                final /* synthetic */ AccessTokenCreationCallback $accessTokenCallback;
                final /* synthetic */ String $applicationId;

                public void onSuccess(@Nullable JSONObject userInfo) {
                    try {
                        JSONObject jSONObject = userInfo;
                        String string = jSONObject != null ? jSONObject.getString("id") : null;
                        boolean bl = false;
                        boolean bl2 = false;
                        bl2 = false;
                        boolean bl3 = false;
                        if (string == null) {
                            boolean bl4 = false;
                            String string2 = "Required value was null.";
                            throw (Throwable)new IllegalStateException(string2.toString());
                        }
                        String userId = string;
                        this.$extras.putString("user_id", userId);
                        this.$accessTokenCallback.onSuccess(com.facebook.AccessToken$Companion.access$createFromBundle(AccessToken.Companion, null, this.$extras, AccessTokenSource.FACEBOOK_APPLICATION_WEB, new Date(), this.$applicationId));
                    }
                    catch (Exception ex) {
                        this.$accessTokenCallback.onError(new FacebookException("Unable to generate access token due to missing user id"));
                    }
                }

                public void onFailure(@Nullable FacebookException error) {
                    this.$accessTokenCallback.onError(error);
                }
                {
                    this.$extras = $captured_local_variable$0;
                    this.$accessTokenCallback = $captured_local_variable$1;
                    this.$applicationId = $captured_local_variable$2;
                }
            });
        }

        @JvmStatic
        @SuppressLint(value={"FieldGetter"})
        @Nullable
        public final AccessToken createFromRefresh$facebook_core_release(@NotNull AccessToken current, @NotNull Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            if (current.getSource() != AccessTokenSource.FACEBOOK_APPLICATION_WEB && current.getSource() != AccessTokenSource.FACEBOOK_APPLICATION_NATIVE && current.getSource() != AccessTokenSource.FACEBOOK_APPLICATION_SERVICE) {
                throw (Throwable)new FacebookException("Invalid token source: " + (Object)((Object)current.getSource()));
            }
            Date expires = Utility.getBundleLongAsDate(bundle, AccessToken.EXPIRES_IN_KEY, new Date(0L));
            String string = bundle.getString(AccessToken.ACCESS_TOKEN_KEY);
            if (string == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bundle.getString(ACCESS_TOKEN_KEY) ?: return null");
            String token = string;
            String graphDomain = bundle.getString(AccessToken.GRAPH_DOMAIN);
            Date dataAccessExpirationTime = Utility.getBundleLongAsDate(bundle, AccessToken.DATA_ACCESS_EXPIRATION_TIME, new Date(0L));
            return Utility.isNullOrEmpty(token) ? null : new AccessToken(token, current.getApplicationId(), current.getUserId(), (Collection<String>)current.getPermissions(), (Collection<String>)current.getDeclinedPermissions(), (Collection<String>)current.getExpiredPermissions(), current.getSource(), expires, new Date(), dataAccessExpirationTime, graphDomain);
        }

        @NotNull
        public final AccessToken createExpired$facebook_core_release(@NotNull AccessToken current) {
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            return new AccessToken(current.getToken(), current.getApplicationId(), current.getUserId(), current.getPermissions(), current.getDeclinedPermissions(), current.getExpiredPermissions(), current.getSource(), new Date(), new Date(), current.getDataAccessExpirationTime(), null, 1024, null);
        }

        @JvmStatic
        @Nullable
        public final AccessToken createFromLegacyCache$facebook_core_release(@NotNull Bundle bundle) {
            String string;
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            List<String> permissions = this.getPermissionsFromBundle$facebook_core_release(bundle, "com.facebook.TokenCachingStrategy.Permissions");
            List<String> declinedPermissions = this.getPermissionsFromBundle$facebook_core_release(bundle, "com.facebook.TokenCachingStrategy.DeclinedPermissions");
            List<String> expiredPermissions = this.getPermissionsFromBundle$facebook_core_release(bundle, "com.facebook.TokenCachingStrategy.ExpiredPermissions");
            String applicationId = LegacyTokenHelper.Companion.getApplicationId(bundle);
            if (Utility.isNullOrEmpty(applicationId)) {
                applicationId = FacebookSdk.getApplicationId();
            }
            String string2 = LegacyTokenHelper.Companion.getToken(bundle);
            if (string2 == null) {
                return null;
            }
            String tokenString = string2;
            JSONObject userInfo = Utility.awaitGetGraphMeRequestWithCache(tokenString);
            try {
                JSONObject jSONObject = userInfo;
                string = jSONObject != null ? jSONObject.getString("id") : null;
            }
            catch (JSONException ex) {
                return null;
            }
            String userId = string;
            String string3 = applicationId;
            if (string3 == null) {
                return null;
            }
            String string4 = userId;
            if (string4 == null) {
                return null;
            }
            return new AccessToken(tokenString, string3, string4, permissions, declinedPermissions, expiredPermissions, LegacyTokenHelper.Companion.getSource(bundle), LegacyTokenHelper.Companion.getExpirationDate(bundle), LegacyTokenHelper.Companion.getLastRefreshDate(bundle), null, null, 1024, null);
        }

        @JvmStatic
        @NotNull
        public final List<String> getPermissionsFromBundle$facebook_core_release(@NotNull Bundle bundle, @Nullable String key) {
            List list;
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            List originalPermissions = bundle.getStringArrayList(key);
            List permissions = null;
            if (originalPermissions == null) {
                list = CollectionsKt.emptyList();
            } else {
                List list2 = Collections.unmodifiableList(new ArrayList(originalPermissions));
                list = list2;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"Collections.unmodifiable\u2026ist(originalPermissions))");
            }
            permissions = list;
            return permissions;
        }

        @JvmStatic
        @NotNull
        public final AccessToken createFromJSONObject$facebook_core_release(@NotNull JSONObject jsonObject) throws JSONException {
            Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
            int version = jsonObject.getInt(AccessToken.VERSION_KEY);
            if (version > 1) {
                throw (Throwable)new FacebookException("Unknown AccessToken serialization format.");
            }
            String token = jsonObject.getString(AccessToken.TOKEN_KEY);
            Date expiresAt = new Date(jsonObject.getLong(AccessToken.EXPIRES_AT_KEY));
            JSONArray permissionsArray = jsonObject.getJSONArray(AccessToken.PERMISSIONS_KEY);
            JSONArray declinedPermissionsArray = jsonObject.getJSONArray(AccessToken.DECLINED_PERMISSIONS_KEY);
            JSONArray expiredPermissionsArray = jsonObject.optJSONArray(AccessToken.EXPIRED_PERMISSIONS_KEY);
            Date lastRefresh = new Date(jsonObject.getLong(AccessToken.LAST_REFRESH_KEY));
            String string = jsonObject.getString(AccessToken.SOURCE_KEY);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.getString(SOURCE_KEY)");
            AccessTokenSource source = AccessTokenSource.valueOf(string);
            String applicationId = jsonObject.getString(AccessToken.APPLICATION_ID_KEY);
            String userId = jsonObject.getString(AccessToken.USER_ID_KEY);
            Date dataAccessExpirationTime = new Date(jsonObject.optLong(AccessToken.DATA_ACCESS_EXPIRATION_TIME, 0L));
            String graphDomain = jsonObject.optString(AccessToken.GRAPH_DOMAIN, null);
            String string2 = token;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)AccessToken.TOKEN_KEY);
            String string3 = applicationId;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"applicationId");
            String string4 = userId;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"userId");
            JSONArray jSONArray = permissionsArray;
            Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"permissionsArray");
            Collection collection = Utility.jsonArrayToStringList(jSONArray);
            JSONArray jSONArray2 = declinedPermissionsArray;
            Intrinsics.checkNotNullExpressionValue((Object)jSONArray2, (String)"declinedPermissionsArray");
            return new AccessToken(string2, string3, string4, collection, (Collection<String>)Utility.jsonArrayToStringList(jSONArray2), expiredPermissionsArray == null ? (List)new ArrayList() : Utility.jsonArrayToStringList(expiredPermissionsArray), source, expiresAt, lastRefresh, dataAccessExpirationTime, graphDomain);
        }

        private final AccessToken createFromBundle(List<String> requestedPermissions, Bundle bundle, AccessTokenSource source, Date expirationBase, String applicationId) {
            String string = bundle.getString(AccessToken.ACCESS_TOKEN_KEY);
            if (string == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bundle.getString(ACCESS_TOKEN_KEY) ?: return null");
            String token = string;
            Date date = Utility.getBundleLongAsDate(bundle, AccessToken.EXPIRES_IN_KEY, expirationBase);
            if (date == null) {
                return null;
            }
            Date expires = date;
            String string2 = bundle.getString(AccessToken.USER_ID_KEY);
            if (string2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"bundle.getString(USER_ID_KEY) ?: return null");
            String userId = string2;
            Date dataAccessExpirationTime = Utility.getBundleLongAsDate(bundle, AccessToken.DATA_ACCESS_EXPIRATION_TIME, new Date(0L));
            return new AccessToken(token, applicationId, userId, requestedPermissions, null, null, source, expires, new Date(), dataAccessExpirationTime, null, 1024, null);
        }

        private Companion() {
        }

        public static final /* synthetic */ AccessToken access$createFromBundle(Companion $this, List requestedPermissions, Bundle bundle, AccessTokenSource source, Date expirationBase, String applicationId) {
            return $this.createFromBundle(requestedPermissions, bundle, source, expirationBase, applicationId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

