/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.logging.dumpsys;

import android.annotation.SuppressLint;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/internal/logging/dumpsys/WebViewDumpHelper;", "", "()V", "webViewHTMLs", "", "", "webViews", "", "Lcom/facebook/internal/logging/dumpsys/WebViewDumpHelper$WebViewData;", "dump", "", "writer", "Ljava/io/PrintWriter;", "handle", "view", "Landroid/webkit/WebView;", "Companion", "WebViewData", "facebook-core_release"})
@SuppressLint(value={"NewApi", "StringFormatUse", "DefaultLocale", "BadMethodUse-java.lang.String.length"})
public final class WebViewDumpHelper {
    private final Set<WebViewData> webViews;
    private final Map<String, String> webViewHTMLs;
    @NotNull
    public static final String GET_WEBVIEW_HTML_JS_SCRIPT = "(function() {  try {    const leftOf = %d;    const topOf = %d;    const density = %f;    const elements = Array.from(document.querySelectorAll('body, body *'));    for (const el of elements) {      const rect = el.getBoundingClientRect();      const left = Math.round(leftOf + rect.left * density);      const top = Math.round(topOf + rect.top * density);      const width = Math.round(rect.width * density);      const height = Math.round(rect.height * density);      el.setAttribute('data-rect', `${left},${top},${width},${height}`);      const style = window.getComputedStyle(el);      const hidden = style.display === 'none' || style.visibility !== 'visible' || el.getAttribute('hidden') === 'true';      const disabled = el.disabled || el.getAttribute('aria-disabled') === 'true';      const focused = el === document.activeElement;      if (hidden || disabled || focused) {        el.setAttribute('data-flag', `${hidden ? 'H' : ''}${disabled ? 'D' : ''}${focused ? 'F' : ''}`);      } else {        el.removeAttribute('data-flag');      }    }    document.activeElement.setAttribute('focused', 'true');    const doc = document.cloneNode(true);    for (const el of Array.from(doc.querySelectorAll('script, link'))) {      el.remove();    }    for (const el of Array.from(doc.querySelectorAll('*'))) {      el.removeAttribute('class');    }    return doc.getElementsByTagName('body')[0].outerHTML.trim();  } catch (e) {    return 'Failed: ' + e;  }})();";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void handle(@NotNull WebView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        WebViewData data = new WebViewData(view);
        this.webViews.add(data);
        Resources resources = view.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"view.resources");
        DisplayMetrics dm = resources.getDisplayMetrics();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = GET_WEBVIEW_HTML_JS_SCRIPT;
        Object[] objectArray = new Object[]{data.getLeft(), data.getTop(), Float.valueOf(dm.scaledDensity)};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String scriptWithOffset = string2;
        view.evaluateJavascript(scriptWithOffset, new ValueCallback(this, data){
            final /* synthetic */ WebViewDumpHelper this$0;
            final /* synthetic */ WebViewData $data;

            public final void onReceiveValue(String html) {
                Map map = WebViewDumpHelper.access$getWebViewHTMLs$p(this.this$0);
                String string = this.$data.getKey();
                String string2 = html;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"html");
                map.put(string, string2);
            }
            {
                this.this$0 = webViewDumpHelper;
                this.$data = webViewData;
            }
        });
    }

    public final void dump(@NotNull PrintWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        try {
            for (WebViewData data : this.webViews) {
                String html = this.webViewHTMLs.get(data.getKey());
                if (html == null) continue;
                writer.print("WebView HTML for ");
                writer.print(data);
                writer.println(":");
                writer.println(WebViewDumpHelper.Companion.fixHtmlString(data, html));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.webViews.clear();
        this.webViewHTMLs.clear();
    }

    public WebViewDumpHelper() {
        boolean bl = false;
        this.webViews = new LinkedHashSet();
        bl = false;
        this.webViewHTMLs = new LinkedHashMap();
    }

    public static final /* synthetic */ Map access$getWebViewHTMLs$p(WebViewDumpHelper $this) {
        return $this.webViewHTMLs;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/facebook/internal/logging/dumpsys/WebViewDumpHelper$WebViewData;", "", "webView", "Landroid/webkit/WebView;", "(Landroid/webkit/WebView;)V", "height", "", "getHeight", "()I", "key", "", "getKey", "()Ljava/lang/String;", "left", "getLeft", "top", "getTop", "width", "getWidth", "Companion", "facebook-core_release"})
    private static final class WebViewData {
        @NotNull
        private final String key;
        private final int left;
        private final int top;
        private final int width;
        private final int height;
        private static final int[] location;
        @NotNull
        public static final Companion Companion;

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public final int getLeft() {
            return this.left;
        }

        public final int getTop() {
            return this.top;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public WebViewData(@NotNull WebView webView) {
            Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%s{%s}";
            Object[] objectArray = new Object[]{webView.getClass().getName(), Integer.toHexString(webView.hashCode())};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            this.key = string2;
            webView.getLocationOnScreen(location);
            this.left = location[0];
            this.top = location[1];
            this.width = webView.getWidth();
            this.height = webView.getHeight();
        }

        static {
            Companion = new Companion(null);
            location = new int[2];
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/internal/logging/dumpsys/WebViewDumpHelper$WebViewData$Companion;", "", "()V", "location", "", "facebook-core_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/facebook/internal/logging/dumpsys/WebViewDumpHelper$Companion;", "", "()V", "GET_WEBVIEW_HTML_JS_SCRIPT", "", "fixHtmlString", "data", "Lcom/facebook/internal/logging/dumpsys/WebViewDumpHelper$WebViewData;", "html", "facebook-core_release"})
    public static final class Companion {
        private final String fixHtmlString(WebViewData data, String html) {
            Object[] html2 = html;
            html2 = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)html2, (String)"\\u003C", (String)"<", (boolean)false, (int)4, null), (String)"\\n", (String)"", (boolean)false, (int)4, null), (String)"\\\"", (String)"\"", (boolean)false, (int)4, null);
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "<html id=\"%s\" data-rect=\"%d,%d,%d,%d\">%s</html>";
            Object[] objectArray = new Object[6];
            objectArray[0] = data.getKey();
            objectArray[1] = data.getLeft();
            objectArray[2] = data.getTop();
            objectArray[3] = data.getWidth();
            objectArray[4] = data.getHeight();
            Object[] objectArray2 = html2;
            int n = 1;
            int n2 = html2.length() - 1;
            boolean bl = false;
            if (objectArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = objectArray2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            objectArray[5] = string2;
            objectArray2 = objectArray;
            n = 0;
            String string3 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            return string3;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

