/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.bolts;

import com.facebook.bolts.AndroidExecutors;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/facebook/bolts/BoltsExecutors;", "", "()V", "background", "Ljava/util/concurrent/ExecutorService;", "immediate", "Ljava/util/concurrent/Executor;", "scheduled", "Ljava/util/concurrent/ScheduledExecutorService;", "Companion", "ImmediateExecutor", "facebook-core_release"})
public final class BoltsExecutors {
    private final ExecutorService background;
    private final ScheduledExecutorService scheduled;
    private final Executor immediate;
    private static final BoltsExecutors INSTANCE;
    @NotNull
    public static final Companion Companion;

    private BoltsExecutors() {
        ExecutorService executorService;
        if (!BoltsExecutors.Companion.isAndroidRuntime()) {
            ExecutorService executorService2 = Executors.newCachedThreadPool();
            executorService = executorService2;
            Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"Executors.newCachedThreadPool()");
        } else {
            executorService = AndroidExecutors.Companion.newCachedThreadPool();
        }
        this.background = executorService;
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"Executors.newSingleThreadScheduledExecutor()");
        this.scheduled = scheduledExecutorService;
        this.immediate = new ImmediateExecutor();
    }

    static {
        Companion = new Companion(null);
        INSTANCE = new BoltsExecutors();
    }

    @JvmStatic
    @NotNull
    public static final ExecutorService background() {
        return Companion.background();
    }

    @JvmStatic
    @NotNull
    public static final ScheduledExecutorService scheduled$facebook_core_release() {
        return Companion.scheduled$facebook_core_release();
    }

    @JvmStatic
    @NotNull
    public static final Executor immediate$facebook_core_release() {
        return Companion.immediate$facebook_core_release();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/bolts/BoltsExecutors$ImmediateExecutor;", "Ljava/util/concurrent/Executor;", "()V", "executionDepth", "Ljava/lang/ThreadLocal;", "", "decrementDepth", "execute", "", "command", "Ljava/lang/Runnable;", "incrementDepth", "Companion", "facebook-core_release"})
    private static final class ImmediateExecutor
    implements Executor {
        private final ThreadLocal<Integer> executionDepth = new ThreadLocal();
        private static final int MAX_DEPTH = 15;
        @NotNull
        public static final Companion Companion = new Companion(null);

        private final int incrementDepth() {
            Integer oldDepth = this.executionDepth.get();
            if (oldDepth == null) {
                oldDepth = 0;
            }
            int newDepth = oldDepth + 1;
            this.executionDepth.set(newDepth);
            return newDepth;
        }

        private final int decrementDepth() {
            int newDepth;
            Integer oldDepth = this.executionDepth.get();
            if (oldDepth == null) {
                oldDepth = 0;
            }
            if ((newDepth = oldDepth - 1) == 0) {
                this.executionDepth.remove();
            } else {
                this.executionDepth.set(newDepth);
            }
            return newDepth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(@NotNull Runnable command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            int depth = this.incrementDepth();
            try {
                if (depth <= 15) {
                    command.run();
                } else {
                    Companion.background().execute(command);
                }
            }
            finally {
                this.decrementDepth();
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/bolts/BoltsExecutors$ImmediateExecutor$Companion;", "", "()V", "MAX_DEPTH", "", "facebook-core_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007J\r\u0010\n\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\fJ\r\u0010\r\u001a\u00020\u000eH\u0001\u00a2\u0006\u0002\b\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/facebook/bolts/BoltsExecutors$Companion;", "", "()V", "INSTANCE", "Lcom/facebook/bolts/BoltsExecutors;", "isAndroidRuntime", "", "()Z", "background", "Ljava/util/concurrent/ExecutorService;", "immediate", "Ljava/util/concurrent/Executor;", "immediate$facebook_core_release", "scheduled", "Ljava/util/concurrent/ScheduledExecutorService;", "scheduled$facebook_core_release", "facebook-core_release"})
    public static final class Companion {
        private final boolean isAndroidRuntime() {
            String javaRuntimeName;
            String string = System.getProperty("java.runtime.name");
            if (string == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"System.getProperty(\"java\u2026me.name\") ?: return false");
            String string2 = javaRuntimeName = string;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            boolean bl = false;
            String string3 = string2;
            boolean bl2 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
            return StringsKt.contains$default((CharSequence)string5, (CharSequence)"android", (boolean)false, (int)2, null);
        }

        @JvmStatic
        @NotNull
        public final ExecutorService background() {
            return INSTANCE.background;
        }

        @JvmStatic
        @NotNull
        public final ScheduledExecutorService scheduled$facebook_core_release() {
            return INSTANCE.scheduled;
        }

        @JvmStatic
        @NotNull
        public final Executor immediate$facebook_core_release() {
            return INSTANCE.immediate;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

