/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.iap;

import android.content.Context;
import androidx.annotation.RestrictTo;
import com.facebook.appevents.iap.InAppPurchaseAutoLogger;
import com.facebook.appevents.iap.InAppPurchaseBillingClientWrapper;
import com.facebook.appevents.iap.InAppPurchaseLoggerManager;
import com.facebook.appevents.iap.InAppPurchaseUtils;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/appevents/iap/InAppPurchaseAutoLogger;", "", "()V", "BILLING_CLIENT_PURCHASE_NAME", "", "logPurchase", "", "startIapLogging", "context", "Landroid/content/Context;", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class InAppPurchaseAutoLogger {
    private static final String BILLING_CLIENT_PURCHASE_NAME = "com.android.billingclient.api.Purchase";
    @NotNull
    public static final InAppPurchaseAutoLogger INSTANCE;

    @JvmStatic
    public static final void startIapLogging(@NotNull Context context) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseAutoLogger.class)) {
            return;
        }
        try {
            Context context2;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (InAppPurchaseUtils.getClass(BILLING_CLIENT_PURCHASE_NAME) == null) {
                return;
            }
            InAppPurchaseBillingClientWrapper inAppPurchaseBillingClientWrapper = InAppPurchaseBillingClientWrapper.Companion.getOrCreateInstance(context2);
            if (inAppPurchaseBillingClientWrapper == null) {
                return;
            }
            InAppPurchaseBillingClientWrapper billingClientWrapper = inAppPurchaseBillingClientWrapper;
            if (InAppPurchaseBillingClientWrapper.Companion.isServiceConnected().get()) {
                if (InAppPurchaseLoggerManager.eligibleQueryPurchaseHistory()) {
                    billingClientWrapper.queryPurchaseHistory("inapp", startIapLogging.1.INSTANCE);
                } else {
                    billingClientWrapper.queryPurchase("inapp", startIapLogging.2.INSTANCE);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseAutoLogger.class);
            return;
        }
    }

    private final void logPurchase() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            InAppPurchaseLoggerManager.filterPurchaseLogging(InAppPurchaseBillingClientWrapper.Companion.getPurchaseDetailsMap(), InAppPurchaseBillingClientWrapper.Companion.getSkuDetailsMap());
            InAppPurchaseBillingClientWrapper.Companion.getPurchaseDetailsMap().clear();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    private InAppPurchaseAutoLogger() {
    }

    static {
        InAppPurchaseAutoLogger inAppPurchaseAutoLogger;
        INSTANCE = inAppPurchaseAutoLogger = new InAppPurchaseAutoLogger();
    }

    public static final /* synthetic */ void access$logPurchase(InAppPurchaseAutoLogger inAppPurchaseAutoLogger) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseAutoLogger.class)) {
            return;
        }
        try {
            InAppPurchaseAutoLogger $this;
            $this.logPurchase();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseAutoLogger.class);
            return;
        }
    }
}

