/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.RemoteException;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.facebook.FacebookSdk;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\r\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/facebook/internal/InstallReferrerUtil;", "", "()V", "IS_REFERRER_UPDATED", "", "isUpdated", "", "()Z", "tryConnectReferrerInfo", "", "callback", "Lcom/facebook/internal/InstallReferrerUtil$Callback;", "tryUpdateReferrerInfo", "updateReferrer", "Callback", "facebook-core_release"})
public final class InstallReferrerUtil {
    private static final String IS_REFERRER_UPDATED = "is_referrer_updated";
    @NotNull
    public static final InstallReferrerUtil INSTANCE;

    @JvmStatic
    public static final void tryUpdateReferrerInfo(@NotNull Callback callback2) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        if (!INSTANCE.isUpdated()) {
            INSTANCE.tryConnectReferrerInfo(callback2);
        }
    }

    private final void tryConnectReferrerInfo(Callback callback2) {
        InstallReferrerClient referrerClient = InstallReferrerClient.newBuilder((Context)FacebookSdk.getApplicationContext()).build();
        InstallReferrerStateListener installReferrerStateListener2 = new InstallReferrerStateListener(referrerClient, callback2){
            final /* synthetic */ InstallReferrerClient $referrerClient;
            final /* synthetic */ Callback $callback;

            /*
             * WARNING - void declaration
             */
            public void onInstallReferrerSetupFinished(int n) {
                if (CrashShieldHandler.isObjectCrashing(this)) {
                    return;
                }
                try {
                    void responseCode;
                    switch (responseCode) {
                        case 0: {
                            ReferrerDetails referrerDetails;
                            try {
                                InstallReferrerClient installReferrerClient = this.$referrerClient;
                                Intrinsics.checkNotNullExpressionValue((Object)installReferrerClient, (String)"referrerClient");
                                ReferrerDetails referrerDetails2 = installReferrerClient.getInstallReferrer();
                                Intrinsics.checkNotNullExpressionValue((Object)referrerDetails2, (String)"referrerClient.installReferrer");
                                referrerDetails = referrerDetails2;
                            }
                            catch (RemoteException e) {
                                return;
                            }
                            ReferrerDetails response = referrerDetails;
                            String referrerUrl = response.getInstallReferrer();
                            if (referrerUrl != null && (StringsKt.contains$default((CharSequence)referrerUrl, (CharSequence)"fb", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)referrerUrl, (CharSequence)"facebook", (boolean)false, (int)2, null))) {
                                this.$callback.onReceiveReferrerUrl(referrerUrl);
                            }
                            InstallReferrerUtil.access$updateReferrer(InstallReferrerUtil.INSTANCE);
                            break;
                        }
                        case 2: {
                            InstallReferrerUtil.access$updateReferrer(InstallReferrerUtil.INSTANCE);
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable(throwable, this);
                    return;
                }
            }

            public void onInstallReferrerServiceDisconnected() {
            }
            {
                this.$referrerClient = $captured_local_variable$0;
                this.$callback = $captured_local_variable$1;
            }
        };
        try {
            referrerClient.startConnection(installReferrerStateListener2);
        }
        catch (Exception e) {
            return;
        }
    }

    private final void updateReferrer() {
        SharedPreferences preferences = FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.sdk.appEventPreferences", 0);
        preferences.edit().putBoolean(IS_REFERRER_UPDATED, true).apply();
    }

    private final boolean isUpdated() {
        SharedPreferences preferences = FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.sdk.appEventPreferences", 0);
        return preferences.getBoolean(IS_REFERRER_UPDATED, false);
    }

    private InstallReferrerUtil() {
    }

    static {
        InstallReferrerUtil installReferrerUtil;
        INSTANCE = installReferrerUtil = new InstallReferrerUtil();
    }

    public static final /* synthetic */ void access$updateReferrer(InstallReferrerUtil $this) {
        $this.updateReferrer();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/facebook/internal/InstallReferrerUtil$Callback;", "", "onReceiveReferrerUrl", "", "s", "", "facebook-core_release"})
    public static interface Callback {
        public void onReceiveReferrerUrl(@Nullable String var1);
    }
}

