/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ondeviceprocessing;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.ondeviceprocessing.RemoteServiceWrapper;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0007H\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\u001c\u0010\u000e\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/facebook/appevents/ondeviceprocessing/OnDeviceProcessingManager;", "", "()V", "ALLOWED_IMPLICIT_EVENTS", "", "", "isEventEligibleForOnDeviceProcessing", "", "event", "Lcom/facebook/appevents/AppEvent;", "isOnDeviceProcessingEnabled", "sendCustomEventAsync", "", "applicationId", "sendInstallEventAsync", "preferencesName", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class OnDeviceProcessingManager {
    private static final Set<String> ALLOWED_IMPLICIT_EVENTS;
    @NotNull
    public static final OnDeviceProcessingManager INSTANCE;

    @JvmStatic
    public static final boolean isOnDeviceProcessingEnabled() {
        if (CrashShieldHandler.isObjectCrashing(OnDeviceProcessingManager.class)) {
            return false;
        }
        try {
            Context context = FacebookSdk.getApplicationContext();
            boolean isApplicationTrackingEnabled = !FacebookSdk.getLimitEventAndDataUsage(context) && !Utility.isDataProcessingRestricted();
            return isApplicationTrackingEnabled && RemoteServiceWrapper.isServiceAvailable();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, OnDeviceProcessingManager.class);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void sendInstallEventAsync(@Nullable String string, @Nullable String string2) {
        if (CrashShieldHandler.isObjectCrashing(OnDeviceProcessingManager.class)) {
            return;
        }
        try {
            void preferencesName;
            String applicationId;
            Context context = FacebookSdk.getApplicationContext();
            if (context != null && applicationId != null && preferencesName != null) {
                FacebookSdk.getExecutor().execute(new Runnable(context, (String)preferencesName, applicationId){
                    final /* synthetic */ Context $context;
                    final /* synthetic */ String $preferencesName;
                    final /* synthetic */ String $applicationId;

                    public final void run() {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            if (CrashShieldHandler.isObjectCrashing(this)) {
                                return;
                            }
                            try {
                                if (CrashShieldHandler.isObjectCrashing(this)) {
                                    return;
                                }
                                try {
                                    SharedPreferences preferences = this.$context.getSharedPreferences(this.$preferencesName, 0);
                                    String pingKey = this.$applicationId + "pingForOnDevice";
                                    long lastOnDevicePing = preferences.getLong(pingKey, 0L);
                                    if (lastOnDevicePing == 0L) {
                                        RemoteServiceWrapper.sendInstallEvent(this.$applicationId);
                                        SharedPreferences.Editor editor = preferences.edit();
                                        lastOnDevicePing = System.currentTimeMillis();
                                        editor.putLong(pingKey, lastOnDevicePing);
                                        editor.apply();
                                    }
                                    return;
                                }
                                catch (Throwable throwable) {
                                    CrashShieldHandler.handleThrowable(throwable, this);
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                CrashShieldHandler.handleThrowable(throwable, this);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                    {
                        this.$context = context;
                        this.$preferencesName = string;
                        this.$applicationId = string2;
                    }
                });
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, OnDeviceProcessingManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void sendCustomEventAsync(@NotNull String string, @NotNull AppEvent appEvent) {
        if (CrashShieldHandler.isObjectCrashing(OnDeviceProcessingManager.class)) {
            return;
        }
        try {
            void event;
            String applicationId;
            Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (INSTANCE.isEventEligibleForOnDeviceProcessing((AppEvent)event)) {
                FacebookSdk.getExecutor().execute(new Runnable(applicationId, (AppEvent)event){
                    final /* synthetic */ String $applicationId;
                    final /* synthetic */ AppEvent $event;

                    public final void run() {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            if (CrashShieldHandler.isObjectCrashing(this)) {
                                return;
                            }
                            try {
                                if (CrashShieldHandler.isObjectCrashing(this)) {
                                    return;
                                }
                                try {
                                    RemoteServiceWrapper.sendCustomEvents(this.$applicationId, CollectionsKt.listOf((Object)this.$event));
                                    return;
                                }
                                catch (Throwable throwable) {
                                    CrashShieldHandler.handleThrowable(throwable, this);
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                CrashShieldHandler.handleThrowable(throwable, this);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                    {
                        this.$applicationId = string;
                        this.$event = appEvent;
                    }
                });
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, OnDeviceProcessingManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isEventEligibleForOnDeviceProcessing(AppEvent appEvent) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            void event;
            boolean isAllowedImplicitEvent = event.isImplicit() && ALLOWED_IMPLICIT_EVENTS.contains(event.getName());
            boolean isExplicitEvent = !event.isImplicit();
            return isExplicitEvent || isAllowedImplicitEvent;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    private OnDeviceProcessingManager() {
    }

    static {
        OnDeviceProcessingManager onDeviceProcessingManager;
        INSTANCE = onDeviceProcessingManager = new OnDeviceProcessingManager();
        ALLOWED_IMPLICIT_EVENTS = SetsKt.setOf((Object[])new String[]{"fb_mobile_purchase", "StartTrial", "Subscribe"});
    }
}

