/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.security;

import android.util.Base64;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0007J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/internal/security/OidcSecurityUtil;", "", "()V", "OPENID_KEYS_URL_STRING", "", "getOPENID_KEYS_URL_STRING", "()Ljava/lang/String;", "SIGNATURE_ALGORITHM_SHA256", "getPublicKeyFromString", "Ljava/security/PublicKey;", "key", "getRawKeyFromEndPoint", "kid", "verify", "", "publicKey", "data", "signature", "facebook-core_release"})
public final class OidcSecurityUtil {
    @NotNull
    private static final String OPENID_KEYS_URL_STRING;
    @NotNull
    public static final String SIGNATURE_ALGORITHM_SHA256 = "SHA256withRSA";
    @NotNull
    public static final OidcSecurityUtil INSTANCE;

    @NotNull
    public final String getOPENID_KEYS_URL_STRING() {
        return OPENID_KEYS_URL_STRING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final String getRawKeyFromEndPoint(@NotNull String kid) {
        String string;
        Intrinsics.checkNotNullParameter((Object)kid, (String)"kid");
        URL openIdKeyUrl = new URL(OPENID_KEYS_URL_STRING);
        URLConnection uRLConnection = openIdKeyUrl.openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        try {
            InputStream inputStream = connection.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"connection.inputStream");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable = inputStream2;
            int n = 0;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            n = 8192;
            boolean bl2 = false;
            String data = TextStreamsKt.readText((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
            string = new JSONObject(data).optString(kid);
        }
        catch (Exception _ex) {
            string = null;
        }
        finally {
            connection.disconnect();
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final PublicKey getPublicKeyFromString(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String pubKeyString = StringsKt.replace$default((String)key, (String)"\n", (String)"", (boolean)false, (int)4, null);
        pubKeyString = StringsKt.replace$default((String)pubKeyString, (String)"-----BEGIN PUBLIC KEY-----", (String)"", (boolean)false, (int)4, null);
        pubKeyString = StringsKt.replace$default((String)pubKeyString, (String)"-----END PUBLIC KEY-----", (String)"", (boolean)false, (int)4, null);
        byte[] byArray = Base64.decode((String)pubKeyString, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64.decode(pubKeyString, Base64.DEFAULT)");
        byte[] byteKey = byArray;
        X509EncodedKeySpec x509publicKey = new X509EncodedKeySpec(byteKey);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PublicKey publicKey = kf.generatePublic(x509publicKey);
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"kf.generatePublic(x509publicKey)");
        return publicKey;
    }

    @JvmStatic
    public static final boolean verify(@NotNull PublicKey publicKey, @NotNull String data, @NotNull String signature) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        try {
            Signature sig = Signature.getInstance(SIGNATURE_ALGORITHM_SHA256);
            sig.initVerify(publicKey);
            String string = data;
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            sig.update(byArray);
            byte[] byArray2 = Base64.decode((String)signature, (int)8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"Base64.decode(signature, Base64.URL_SAFE)");
            byte[] decodedSignature = byArray2;
            bl = sig.verify(decodedSignature);
        }
        catch (Exception _ex) {
            return false;
        }
        return bl;
    }

    private OidcSecurityUtil() {
    }

    static {
        OidcSecurityUtil oidcSecurityUtil;
        INSTANCE = oidcSecurityUtil = new OidcSecurityUtil();
        OPENID_KEYS_URL_STRING = "https://www.facebook.com/.well-known/oauth/openid/keys/";
    }
}

