/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.logging.dumpsys;

import android.annotation.SuppressLint;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.os.Build;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.webkit.WebView;
import android.widget.TextView;
import com.facebook.internal.logging.dumpsys.AndroidRootResolver;
import com.facebook.internal.logging.dumpsys.ResourcesUtil;
import com.facebook.internal.logging.dumpsys.WebViewDumpHelper;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001b\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J+\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J(\u0010\u001a\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/facebook/internal/logging/dumpsys/EndToEndDumpsysHelper;", "", "()V", "lithoViewToStringMethod", "Ljava/lang/reflect/Method;", "rootResolver", "Lcom/facebook/internal/logging/dumpsys/AndroidRootResolver;", "webViewDumpHelper", "Lcom/facebook/internal/logging/dumpsys/WebViewDumpHelper;", "dumpViewHierarchy", "", "prefix", "", "writer", "Ljava/io/PrintWriter;", "view", "Landroid/view/View;", "leftOffset", "", "topOffset", "withWebView", "", "withProps", "args", "", "(Ljava/lang/String;Ljava/io/PrintWriter;[Ljava/lang/String;)V", "writeLithoViewSubHierarchy", "Api21Utils", "Api24Utils", "Companion", "facebook-core_release"})
@SuppressLint(value={"HexColorValueUsage", "CatchGeneralException", "BadMethodUse-java.lang.String.length"})
public final class EndToEndDumpsysHelper {
    private final AndroidRootResolver rootResolver = new AndroidRootResolver();
    private final WebViewDumpHelper webViewDumpHelper = new WebViewDumpHelper();
    private Method lithoViewToStringMethod;
    private static final String LITHO_VIEW_CLASS = "com.facebook.litho.LithoView";
    private static final String LITHO_VIEW_TEST_HELPER_CLASS = "com.facebook.litho.LithoViewTestHelper";
    private static final String LITHO_VIEW_TO_STRING_METHOD = "viewToStringForE2E";
    private static final String E2E_ARGUMENT = "e2e";
    private static final String TOP_ROOT_ARGUMENT = "top-root";
    private static final String ALL_ROOTS_ARGUMENT = "all-roots";
    private static final String WITH_WEBVIEW_ARGUMENT = "webview";
    private static final String WITH_PROPS_ARGUMENT = "props";
    private static final String RC_TEXT_VIEW_SIMPLE_CLASS_NAME = "RCTextView";
    private static EndToEndDumpsysHelper instance;
    private static Method rcTextViewGetTextMethod;
    @NotNull
    public static final Companion Companion;

    private final void dumpViewHierarchy(String prefix, PrintWriter writer, String[] args) {
        writer.print(prefix);
        writer.println("Top Level Window View Hierarchy:");
        boolean dumpAllRoots = EndToEndDumpsysHelper.Companion.hasArgument(args, ALL_ROOTS_ARGUMENT);
        boolean dumpTopRootOnly = EndToEndDumpsysHelper.Companion.hasArgument(args, TOP_ROOT_ARGUMENT);
        boolean withWebView = EndToEndDumpsysHelper.Companion.hasArgument(args, WITH_WEBVIEW_ARGUMENT);
        boolean withProps = EndToEndDumpsysHelper.Companion.hasArgument(args, WITH_PROPS_ARGUMENT);
        try {
            List<AndroidRootResolver.Root> roots = this.rootResolver.listActiveRoots();
            if (roots == null || roots.isEmpty()) {
                return;
            }
            Collections.reverse(roots);
            WindowManager.LayoutParams prevRootParam = null;
            for (AndroidRootResolver.Root root : roots) {
                AndroidRootResolver.Root root2 = root;
                if (root2 == null || (root2 = root2.getView()) == null) continue;
                if (root2.getVisibility() != 0) {
                    continue;
                }
                if (!dumpAllRoots && prevRootParam != null) {
                    int n = root.getParam().type - prevRootParam.type;
                    boolean bl = false;
                    if (Math.abs(n) != 1) break;
                }
                this.dumpViewHierarchy(prefix + "  ", writer, root.getView(), 0, 0, withWebView, withProps);
                prevRootParam = root.getParam();
                if (!dumpTopRootOnly) continue;
                break;
            }
            this.webViewDumpHelper.dump(writer);
        }
        catch (Exception e) {
            writer.println("Failure in view hierarchy dump: " + e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void dumpViewHierarchy(String prefix, PrintWriter writer, View view, int leftOffset, int topOffset, boolean withWebView, boolean withProps) {
        String prefix2 = prefix;
        writer.print(prefix2);
        if (view == null) {
            writer.println("null");
            return;
        }
        writer.print(view.getClass().getName());
        writer.print("{");
        writer.print(Integer.toHexString(view.hashCode()));
        EndToEndDumpsysHelper.Companion.writeViewFlags(writer, view);
        EndToEndDumpsysHelper.Companion.writeViewBounds(writer, view, leftOffset, topOffset);
        EndToEndDumpsysHelper.Companion.writeViewTestId(writer, view);
        EndToEndDumpsysHelper.Companion.writeViewText(writer, view);
        if (withProps && Build.VERSION.SDK_INT >= 21) {
            Api21Utils.INSTANCE.writeExtraProps(writer, view);
        }
        writer.println("}");
        if (EndToEndDumpsysHelper.Companion.isExtendsLithoView(view)) {
            this.writeLithoViewSubHierarchy(writer, view, prefix2, withProps);
        }
        if (withWebView && view instanceof WebView) {
            this.webViewDumpHelper.handle((WebView)view);
        }
        if (!(view instanceof ViewGroup)) {
            return;
        }
        int n = ((ViewGroup)view).getChildCount();
        if (n <= 0) {
            return;
        }
        prefix2 = prefix2 + "  ";
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            void i;
            this.dumpViewHierarchy(prefix2, writer, ((ViewGroup)view).getChildAt((int)i), location[0], location[1], withWebView, withProps);
            ++i;
        }
    }

    private final void writeLithoViewSubHierarchy(PrintWriter writer, View view, String prefix, boolean withProps) {
        try {
            if (this.lithoViewToStringMethod == null) {
                Class<?> clazz = Class.forName(LITHO_VIEW_TEST_HELPER_CLASS);
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"Class.forName(LITHO_VIEW_TEST_HELPER_CLASS)");
                Class<?> helperClass = clazz;
                this.lithoViewToStringMethod = helperClass.getDeclaredMethod(LITHO_VIEW_TO_STRING_METHOD, View.class, Integer.TYPE, Boolean.TYPE);
            }
            Method method = this.lithoViewToStringMethod;
            Object object = method != null ? method.invoke(null, view, prefix.length() / 2 + 1, withProps) : null;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String lithoViewDump = (String)object;
            Intrinsics.checkNotNullExpressionValue((Object)writer.append(lithoViewDump), (String)"writer.append(lithoViewDump)");
        }
        catch (Exception e) {
            writer.append(prefix).append("Failed litho view sub hierarch dump: ").append(EndToEndDumpsysHelper.Companion.fixString(e.getMessage(), 100)).println();
        }
    }

    static {
        Companion = new Companion(null);
    }

    @JvmStatic
    public static final boolean maybeDump(@NotNull String prefix, @NotNull PrintWriter writer, @Nullable String[] args) {
        return Companion.maybeDump(prefix, writer, args);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/internal/logging/dumpsys/EndToEndDumpsysHelper$Api21Utils;", "", "()V", "keyedTagsField", "Ljava/lang/reflect/Field;", "getTags", "Lorg/json/JSONObject;", "view", "Landroid/view/View;", "writeExtraProps", "", "writer", "Ljava/io/PrintWriter;", "facebook-core_release"})
    private static final class Api21Utils {
        private static Field keyedTagsField;
        @NotNull
        public static final Api21Utils INSTANCE;

        public final void writeExtraProps(@NotNull PrintWriter writer, @NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            if (Build.VERSION.SDK_INT < 21) {
                return;
            }
            AccessibilityNodeInfo accessibilityNodeInfo = Companion.createNodeInfoFromView(view);
            if (accessibilityNodeInfo == null) {
                return;
            }
            AccessibilityNodeInfo nodeInfo = accessibilityNodeInfo;
            JSONObject props = new JSONObject();
            try {
                String cd;
                JSONObject tags;
                if (view instanceof TextView) {
                    ColorStateList colorStateList = ((TextView)view).getTextColors();
                    Intrinsics.checkNotNullExpressionValue((Object)colorStateList, (String)"view.textColors");
                    props.put("textColor", colorStateList.getDefaultColor());
                    props.put("textSize", (double)((TextView)view).getTextSize());
                    props.put("hint", (Object)Companion.fixString(((TextView)view).getHint(), 100));
                }
                if ((tags = this.getTags(view)) != null) {
                    props.put("keyedTags", (Object)tags);
                }
                JSONArray actions = new JSONArray();
                Object object = nodeInfo.getActionList().iterator();
                while (object.hasNext()) {
                    AccessibilityNodeInfo.AccessibilityAction action;
                    AccessibilityNodeInfo.AccessibilityAction accessibilityAction = action = (AccessibilityNodeInfo.AccessibilityAction)object.next();
                    Intrinsics.checkNotNullExpressionValue((Object)accessibilityAction, (String)"action");
                    CharSequence charSequence = accessibilityAction.getLabel();
                    if (charSequence == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    String actionLabel = (String)charSequence;
                    if (actionLabel == null) continue;
                    actions.put((Object)Companion.fixString(actionLabel, 50));
                }
                if (actions.length() > 0) {
                    props.put("actions", (Object)actions);
                }
                if ((cd = Companion.fixString(nodeInfo.getContentDescription(), 50)) != null) {
                    object = cd;
                    boolean bl = false;
                    if (object.length() > 0) {
                        props.put("content-description", (Object)cd);
                    }
                }
                props.put("accessibility-focused", nodeInfo.isAccessibilityFocused()).put("checkable", nodeInfo.isCheckable()).put("checked", nodeInfo.isChecked()).put("class-name", (Object)Companion.fixString(nodeInfo.getClassName(), 50)).put("clickable", nodeInfo.isClickable()).put("content-invalid", nodeInfo.isContentInvalid()).put("dismissable", nodeInfo.isDismissable()).put("editable", nodeInfo.isEditable()).put("enabled", nodeInfo.isEnabled()).put("focusable", nodeInfo.isFocusable()).put("focused", nodeInfo.isFocused()).put("long-clickable", nodeInfo.isLongClickable()).put("multiline", nodeInfo.isMultiLine()).put("password", nodeInfo.isPassword()).put("scrollable", nodeInfo.isScrollable()).put("selected", nodeInfo.isSelected()).put("visible-to-user", nodeInfo.isVisibleToUser());
                if (Build.VERSION.SDK_INT >= 24) {
                    Api24Utils.INSTANCE.addExtraProps(props, nodeInfo);
                }
            }
            catch (Exception e) {
                try {
                    props.put("DUMP-ERROR", (Object)Companion.fixString(e.getMessage(), 50));
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            writer.append(" props=\"").append(props.toString()).append("\"");
        }

        private final JSONObject getTags(View view) {
            JSONObject tags = null;
            try {
                if (keyedTagsField == null) {
                    Field field = keyedTagsField = View.class.getDeclaredField("mKeyedTags");
                    if (field != null) {
                        field.setAccessible(true);
                    }
                }
                Field field = keyedTagsField;
                Object object = field != null ? field.get(view) : null;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.util.SparseArray<*>");
                }
                SparseArray keyedTags = (SparseArray)object;
                if (keyedTags != null && keyedTags.size() > 0) {
                    tags = new JSONObject();
                    int count = keyedTags.size();
                    for (int i = 0; i < count; ++i) {
                        String id = ResourcesUtil.getIdStringQuietly(view.getResources(), keyedTags.keyAt(i));
                        try {
                            tags.put(id, keyedTags.valueAt(i));
                            continue;
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return tags;
        }

        private Api21Utils() {
        }

        static {
            Api21Utils api21Utils;
            INSTANCE = api21Utils = new Api21Utils();
            try {
                Field field = keyedTagsField = View.class.getDeclaredField("mKeyedTags");
                if (field != null) {
                    field.setAccessible(true);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/facebook/internal/logging/dumpsys/EndToEndDumpsysHelper$Api24Utils;", "", "()V", "addExtraProps", "", "props", "Lorg/json/JSONObject;", "nodeInfo", "Landroid/view/accessibility/AccessibilityNodeInfo;", "facebook-core_release"})
    private static final class Api24Utils {
        @NotNull
        public static final Api24Utils INSTANCE;

        public final void addExtraProps(@NotNull JSONObject props, @NotNull AccessibilityNodeInfo nodeInfo) throws JSONException {
            Intrinsics.checkNotNullParameter((Object)props, (String)EndToEndDumpsysHelper.WITH_PROPS_ARGUMENT);
            Intrinsics.checkNotNullParameter((Object)nodeInfo, (String)"nodeInfo");
            if (Build.VERSION.SDK_INT < 24) {
                return;
            }
            props.put("context-clickable", nodeInfo.isContextClickable()).put("drawing-order", nodeInfo.getDrawingOrder()).put("important-for-accessibility", nodeInfo.isImportantForAccessibility());
        }

        private Api24Utils() {
        }

        static {
            Api24Utils api24Utils;
            INSTANCE = api24Utils = new Api24Utils();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u001a\u0010\u0015\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0003J%\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J-\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001eH\u0007\u00a2\u0006\u0002\u0010&J\u0018\u0010'\u001a\u00020(2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010)\u001a\u00020(2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0019H\u0002J\u0018\u0010,\u001a\u00020(2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010-\u001a\u00020(2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010.\u001a\u00020(2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u0014H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/facebook/internal/logging/dumpsys/EndToEndDumpsysHelper$Companion;", "", "()V", "ALL_ROOTS_ARGUMENT", "", "E2E_ARGUMENT", "LITHO_VIEW_CLASS", "LITHO_VIEW_TEST_HELPER_CLASS", "LITHO_VIEW_TO_STRING_METHOD", "RC_TEXT_VIEW_SIMPLE_CLASS_NAME", "TOP_ROOT_ARGUMENT", "WITH_PROPS_ARGUMENT", "WITH_WEBVIEW_ARGUMENT", "instance", "Lcom/facebook/internal/logging/dumpsys/EndToEndDumpsysHelper;", "rcTextViewGetTextMethod", "Ljava/lang/reflect/Method;", "createNodeInfoFromView", "Landroid/view/accessibility/AccessibilityNodeInfo;", "view", "Landroid/view/View;", "fixString", "str", "", "maxLength", "", "getTextFromRcTextView", "hasArgument", "", "args", "", "argument", "([Ljava/lang/String;Ljava/lang/String;)Z", "isExtendsLithoView", "maybeDump", "prefix", "writer", "Ljava/io/PrintWriter;", "(Ljava/lang/String;Ljava/io/PrintWriter;[Ljava/lang/String;)Z", "maybeWriteViewTestIdFromTag", "", "writeViewBounds", "leftOffset", "topOffset", "writeViewFlags", "writeViewTestId", "writeViewText", "facebook-core_release"})
    public static final class Companion {
        @JvmStatic
        public final boolean maybeDump(@NotNull String prefix, @NotNull PrintWriter writer, @Nullable String[] args) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            if (args != null) {
                String[] stringArray = args;
                boolean bl = false;
                String[] stringArray2 = stringArray;
                boolean bl2 = false;
                if (!(stringArray2.length == 0) && Intrinsics.areEqual((Object)EndToEndDumpsysHelper.E2E_ARGUMENT, (Object)args[0])) {
                    if (instance == null) {
                        instance = new EndToEndDumpsysHelper();
                    }
                    EndToEndDumpsysHelper endToEndDumpsysHelper = instance;
                    if (endToEndDumpsysHelper != null) {
                        endToEndDumpsysHelper.dumpViewHierarchy(prefix, writer, args);
                    }
                    return true;
                }
            }
            return false;
        }

        private final boolean isExtendsLithoView(View view) {
            for (Class<?> aClass = view.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
                if (!Intrinsics.areEqual((Object)aClass.getName(), (Object)EndToEndDumpsysHelper.LITHO_VIEW_CLASS)) continue;
                return true;
            }
            return false;
        }

        private final void writeViewFlags(PrintWriter writer, View view) {
            writer.print(" ");
            switch (view.getVisibility()) {
                case 0: {
                    writer.print("V");
                    break;
                }
                case 4: {
                    writer.print("I");
                    break;
                }
                case 8: {
                    writer.print("G");
                    break;
                }
                default: {
                    writer.print(".");
                }
            }
            writer.print(view.isFocusable() ? "F" : ".");
            writer.print(view.isEnabled() ? "E" : ".");
            writer.print(".");
            writer.print(view.isHorizontalScrollBarEnabled() ? "H" : ".");
            writer.print(view.isVerticalScrollBarEnabled() ? "V" : ".");
            writer.print(view.isClickable() ? "C" : ".");
            writer.print(view.isLongClickable() ? "L" : ".");
            writer.print(" ");
            writer.print(view.isFocused() ? "F" : ".");
            writer.print(view.isSelected() ? "S" : ".");
            writer.print(view.isHovered() ? "H" : ".");
            writer.print(view.isActivated() ? "A" : ".");
            writer.print(view.isDirty() ? "D" : ".");
        }

        private final void writeViewBounds(PrintWriter writer, View view, int leftOffset, int topOffset) {
            int[] location = new int[2];
            view.getLocationOnScreen(location);
            writer.print(" ");
            writer.print(location[0] - leftOffset);
            writer.print(",");
            writer.print(location[1] - topOffset);
            writer.print("-");
            writer.print(location[0] + view.getWidth() - leftOffset);
            writer.print(",");
            writer.print(location[1] + view.getHeight() - topOffset);
        }

        private final void writeViewTestId(PrintWriter writer, View view) {
            try {
                String string;
                int id = view.getId();
                if (id == -1) {
                    this.maybeWriteViewTestIdFromTag(writer, view);
                    return;
                }
                writer.append(" #");
                writer.append(Integer.toHexString(id));
                Resources resources = view.getResources();
                if (id <= 0 || resources == null) {
                    this.maybeWriteViewTestIdFromTag(writer, view);
                    return;
                }
                String packageName = null;
                switch (id & 0xFF000000) {
                    case 0x7F000000: {
                        string = "app";
                        break;
                    }
                    case 0x1000000: {
                        string = "android";
                        break;
                    }
                    default: {
                        String string2 = resources.getResourcePackageName(id);
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getResourcePackageName(id)");
                    }
                }
                packageName = string;
                writer.print(" ");
                writer.print(packageName);
                writer.print(":");
                writer.print(resources.getResourceTypeName(id));
                writer.print("/");
                writer.print(resources.getResourceEntryName(id));
            }
            catch (Exception e) {
                this.maybeWriteViewTestIdFromTag(writer, view);
            }
        }

        private final void maybeWriteViewTestIdFromTag(PrintWriter writer, View view) {
            Object object = view.getTag();
            if (!(object instanceof String)) {
                object = null;
            }
            String string = (String)object;
            if (string == null) {
                return;
            }
            String tag = string;
            CharSequence charSequence = tag;
            boolean bl = false;
            if (charSequence.length() == 0) {
                return;
            }
            writer.print(" app:tag/");
            writer.print(this.fixString(tag, 60));
        }

        @SuppressLint(value={"ReflectionMethodUse"})
        private final void writeViewText(PrintWriter writer, View view) {
            try {
                String text;
                block18: {
                    block17: {
                        block14: {
                            Object tag;
                            block16: {
                                block15: {
                                    block13: {
                                        text = null;
                                        if (!(view instanceof TextView)) break block13;
                                        text = ((Object)((TextView)view).getText()).toString();
                                        break block14;
                                    }
                                    if (!Intrinsics.areEqual((Object)view.getClass().getSimpleName(), (Object)EndToEndDumpsysHelper.RC_TEXT_VIEW_SIMPLE_CLASS_NAME)) break block15;
                                    text = this.getTextFromRcTextView(view);
                                    break block14;
                                }
                                CharSequence content = view.getContentDescription();
                                if (content != null) {
                                    text = ((Object)content).toString();
                                }
                                if (text == null) break block16;
                                CharSequence charSequence = text;
                                boolean bl = false;
                                if (!(charSequence.length() == 0)) break block14;
                            }
                            if ((tag = view.getTag()) != null) {
                                String $this$trim$iv = tag.toString();
                                boolean $i$f$trim = false;
                                CharSequence $this$trim$iv$iv = $this$trim$iv;
                                boolean $i$f$trim2 = false;
                                int startIndex$iv$iv = 0;
                                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                                boolean startFound$iv$iv = false;
                                while (startIndex$iv$iv <= endIndex$iv$iv) {
                                    boolean match$iv$iv;
                                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                                    boolean bl = false;
                                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                                    if (!startFound$iv$iv) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv;
                                }
                                text = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                            }
                        }
                        if (text == null) break block17;
                        CharSequence charSequence = text;
                        boolean bl = false;
                        if (!(charSequence.length() == 0)) break block18;
                    }
                    return;
                }
                writer.print(" text=\"");
                writer.print(this.fixString(text, 600));
                writer.print("\"");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @SuppressLint(value={"PrivateApi", "ReflectionMethodUse"})
        private final String getTextFromRcTextView(View view) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            Object textViewValue;
            if (rcTextViewGetTextMethod == null) {
                rcTextViewGetTextMethod = view.getClass().getDeclaredMethod("getText", new Class[0]);
            }
            Method method = rcTextViewGetTextMethod;
            Object object = textViewValue = method != null ? method.invoke((Object)view, new Object[0]) : null;
            return object != null ? object.toString() : null;
        }

        private final String fixString(CharSequence str, int maxLength) {
            block6: {
                block5: {
                    if (str == null) break block5;
                    CharSequence charSequence = str;
                    boolean bl = false;
                    if (!(charSequence.length() == 0)) break block6;
                }
                return "";
            }
            String fixed = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)((Object)str).toString(), (String)" \n", (String)" ", (boolean)false, (int)4, null), (String)"\n", (String)" ", (boolean)false, (int)4, null), (String)"\"", (String)"", (boolean)false, (int)4, null);
            if (str.length() > maxLength) {
                StringBuilder stringBuilder = new StringBuilder();
                String string = fixed;
                int n = 0;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, maxLength);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                fixed = stringBuilder.append(string3).append("...").toString();
            }
            return fixed;
        }

        private final boolean hasArgument(String[] args, String argument) {
            if (args == null) {
                return false;
            }
            for (String arg : args) {
                if (!StringsKt.equals((String)argument, (String)arg, (boolean)true)) continue;
                return true;
            }
            return false;
        }

        private final AccessibilityNodeInfo createNodeInfoFromView(View view) {
            if (view == null) {
                return null;
            }
            AccessibilityNodeInfo nodeInfo = AccessibilityNodeInfo.obtain();
            try {
                view.onInitializeAccessibilityNodeInfo(nodeInfo);
            }
            catch (NullPointerException e) {
                AccessibilityNodeInfo accessibilityNodeInfo = nodeInfo;
                if (accessibilityNodeInfo != null) {
                    accessibilityNodeInfo.recycle();
                }
                return null;
            }
            return nodeInfo;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

