/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestBatch;
import com.facebook.GraphResponse;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.InstrumentData;
import com.facebook.internal.instrument.InstrumentUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\r\u0010\n\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u000bJ\r\u0010\f\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/internal/instrument/ExceptionAnalyzer;", "", "()V", "enabled", "", "enable", "", "execute", "e", "", "isDebug", "isDebug$facebook_core_release", "sendExceptionAnalysisReports", "sendExceptionAnalysisReports$facebook_core_release", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ExceptionAnalyzer {
    private static boolean enabled;
    @NotNull
    public static final ExceptionAnalyzer INSTANCE;

    @JvmStatic
    @VisibleForTesting(otherwise=2)
    public static final boolean isDebug$facebook_core_release() {
        return false;
    }

    @JvmStatic
    public static final void enable() {
        enabled = true;
        if (FacebookSdk.getAutoLogAppEventsEnabled()) {
            INSTANCE.sendExceptionAnalysisReports$facebook_core_release();
        }
    }

    @JvmStatic
    public static final void execute(@Nullable Throwable e) {
        if (!enabled || ExceptionAnalyzer.isDebug$facebook_core_release() || e == null) {
            return;
        }
        Set disabledFeatures = new HashSet();
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"e.stackTrace");
        StackTraceElement[] $this$forEach$iv = stackTraceElementArray;
        boolean $i$f$forEach = false;
        StackTraceElement[] stackTraceElementArray2 = $this$forEach$iv;
        int n = stackTraceElementArray2.length;
        for (int i = 0; i < n; ++i) {
            StackTraceElement element$iv;
            StackTraceElement it = element$iv = stackTraceElementArray2[i];
            boolean bl = false;
            StackTraceElement stackTraceElement = it;
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement, (String)"it");
            String string = stackTraceElement.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.className");
            FeatureManager.Feature feature = FeatureManager.getFeature(string);
            if (feature == FeatureManager.Feature.Unknown) continue;
            FeatureManager.disableFeature(feature);
            disabledFeatures.add(feature.toString());
        }
        if (FacebookSdk.getAutoLogAppEventsEnabled()) {
            Collection collection = disabledFeatures;
            boolean bl = false;
            if (!collection.isEmpty()) {
                InstrumentData.Builder.build(new JSONArray((Collection)disabledFeatures)).save();
            }
        }
    }

    @VisibleForTesting(otherwise=2)
    public final void sendExceptionAnalysisReports$facebook_core_release() {
        if (Utility.isDataProcessingRestricted()) {
            return;
        }
        File[] reports2 = InstrumentUtility.listExceptionAnalysisReportFiles();
        List requests = new ArrayList();
        for (File report : reports2) {
            InstrumentData instrumentData = InstrumentData.Builder.load(report);
            if (!instrumentData.isValid()) continue;
            JSONObject params = new JSONObject();
            try {
                params.put("crash_shield", (Object)instrumentData.toString());
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "%s/instruments";
                Object[] objectArray = new Object[]{FacebookSdk.getApplicationId()};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                GraphRequest request2 = GraphRequest.Companion.newPostRequest(null, string2, params, new GraphRequest.Callback(instrumentData){
                    final /* synthetic */ InstrumentData $instrumentData;

                    public final void onCompleted(@NotNull GraphResponse response) {
                        block2: {
                            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                            try {
                                if (response.getError() != null) break block2;
                                JSONObject jSONObject = response.getJsonObject();
                                if (jSONObject == null) break block2;
                                if (!jSONObject.getBoolean("success")) break block2;
                                this.$instrumentData.clear();
                            }
                            catch (JSONException jSONException) {
                                // empty catch block
                            }
                        }
                    }
                    {
                        this.$instrumentData = instrumentData;
                    }
                });
                requests.add(request2);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (requests.isEmpty()) {
            return;
        }
        GraphRequestBatch requestBatch = new GraphRequestBatch(requests);
        requestBatch.executeAsync();
    }

    private ExceptionAnalyzer() {
    }

    static {
        ExceptionAnalyzer exceptionAnalyzer;
        INSTANCE = exceptionAnalyzer = new ExceptionAnalyzer();
    }
}

