/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Base64;
import android.util.Log;
import android.view.View;
import androidx.annotation.RestrictTo;
import com.facebook.AccessToken;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.codeless.CodelessManager;
import com.facebook.appevents.codeless.ViewIndexer;
import com.facebook.appevents.codeless.internal.UnityReflection;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.internal.InternalSettings;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\nJ\u0006\u0010\u0012\u001a\u00020\u000eJ\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\nH\u0007J\u0006\u0010\u0016\u001a\u00020\u000eR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/appevents/codeless/ViewIndexer;", "", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "activityReference", "Ljava/lang/ref/WeakReference;", "indexingTimer", "Ljava/util/Timer;", "previousDigest", "", "uiThreadHandler", "Landroid/os/Handler;", "processRequest", "", "request", "Lcom/facebook/GraphRequest;", "currentDigest", "schedule", "sendToServer", "tree", "sendToServerUnity", "unschedule", "Companion", "ScreenshotTaker", "facebook-core_release"})
public final class ViewIndexer {
    private final Handler uiThreadHandler;
    private final WeakReference<Activity> activityReference;
    private Timer indexingTimer;
    private String previousDigest;
    private static final String TAG;
    private static final String SUCCESS = "success";
    private static final String TREE_PARAM = "tree";
    private static final String APP_VERSION_PARAM = "app_version";
    private static final String PLATFORM_PARAM = "platform";
    private static final String REQUEST_TYPE = "request_type";
    private static ViewIndexer instance;
    @NotNull
    public static final Companion Companion;

    public final void schedule() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            TimerTask indexingTask2 = new TimerTask(this){
                final /* synthetic */ ViewIndexer this$0;

                public void run() {
                    try {
                        Activity activity = (Activity)ViewIndexer.access$getActivityReference$p(this.this$0).get();
                        View rootView = AppEventUtility.getRootView(activity);
                        if (activity == null || rootView == null) {
                            return;
                        }
                        String string = activity.getClass().getSimpleName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"activity.javaClass.simpleName");
                        String activityName = string;
                        if (!CodelessManager.getIsAppIndexingEnabled$facebook_core_release()) {
                            return;
                        }
                        if (InternalSettings.isUnityApp()) {
                            UnityReflection.captureViewHierarchy();
                            return;
                        }
                        FutureTask<V> screenshotFuture = new FutureTask<V>(new ScreenshotTaker(rootView));
                        ViewIndexer.access$getUiThreadHandler$p(this.this$0).post((Runnable)screenshotFuture);
                        String screenshot = "";
                        try {
                            screenshot = (String)screenshotFuture.get(1L, TimeUnit.SECONDS);
                        }
                        catch (Exception e) {
                            Log.e((String)ViewIndexer.access$getTAG$cp(), (String)"Failed to take screenshot.", (Throwable)e);
                        }
                        JSONObject viewTree = new JSONObject();
                        try {
                            viewTree.put("screenname", (Object)activityName);
                            viewTree.put("screenshot", (Object)screenshot);
                            JSONArray viewArray = new JSONArray();
                            JSONObject rootViewInfo = ViewHierarchy.getDictionaryOfView(rootView);
                            viewArray.put((Object)rootViewInfo);
                            viewTree.put("view", (Object)viewArray);
                        }
                        catch (JSONException e) {
                            Log.e((String)ViewIndexer.access$getTAG$cp(), (String)"Failed to create JSONObject");
                        }
                        String string2 = viewTree.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"viewTree.toString()");
                        String tree = string2;
                        ViewIndexer.access$sendToServer(this.this$0, tree);
                    }
                    catch (Exception e) {
                        Log.e((String)ViewIndexer.access$getTAG$cp(), (String)"UI Component tree indexing failure!", (Throwable)e);
                    }
                }
                {
                    this.this$0 = this$0;
                }
            };
            try {
                FacebookSdk.getExecutor().execute(new Runnable(this, indexingTask2){
                    final /* synthetic */ ViewIndexer this$0;
                    final /* synthetic */ TimerTask $indexingTask;

                    public final void run() {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            if (CrashShieldHandler.isObjectCrashing(this)) {
                                return;
                            }
                            try {
                                try {
                                    Timer timer = ViewIndexer.access$getIndexingTimer$p(this.this$0);
                                    if (timer != null) {
                                        Timer timer2 = timer;
                                        boolean bl = false;
                                        boolean bl2 = false;
                                        Timer it = timer2;
                                        boolean bl3 = false;
                                        it.cancel();
                                    }
                                    ViewIndexer.access$setPreviousDigest$p(this.this$0, null);
                                    Timer timer3 = new Timer();
                                    timer3.scheduleAtFixedRate(this.$indexingTask, 0L, (long)1000);
                                    ViewIndexer.access$setIndexingTimer$p(this.this$0, timer3);
                                }
                                catch (Exception e) {
                                    Log.e((String)ViewIndexer.access$getTAG$cp(), (String)"Error scheduling indexing job", (Throwable)e);
                                }
                                return;
                            }
                            catch (Throwable throwable) {
                                CrashShieldHandler.handleThrowable(throwable, this);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                    {
                        this.this$0 = viewIndexer;
                        this.$indexingTask = timerTask;
                    }
                });
            }
            catch (RejectedExecutionException e) {
                Log.e((String)TAG, (String)"Error scheduling indexing job", (Throwable)e);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    public final void unschedule() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            if ((Activity)this.activityReference.get() == null) {
                return;
            }
            try {
                Timer timer = this.indexingTimer;
                if (timer != null) {
                    Timer timer2 = timer;
                    boolean bl = false;
                    boolean bl2 = false;
                    Timer it = timer2;
                    boolean bl3 = false;
                    it.cancel();
                }
                this.indexingTimer = null;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error unscheduling indexing job", (Throwable)e);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Plase use sendToServerUnityInstance and sendToServerUnity will be removed soon.")
    public final void sendToServerUnity(@NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void tree;
            Intrinsics.checkNotNullParameter((Object)tree, (String)TREE_PARAM);
            ViewIndexer viewIndexer = instance;
            if (viewIndexer != null) {
                viewIndexer.sendToServer((String)tree);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendToServer(String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void tree;
            FacebookSdk.getExecutor().execute(new Runnable(this, (String)tree){
                final /* synthetic */ ViewIndexer this$0;
                final /* synthetic */ String $tree;

                public final void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            String currentDigest = Utility.md5hash(this.$tree);
                            AccessToken accessToken = AccessToken.Companion.getCurrentAccessToken();
                            if (currentDigest != null && Intrinsics.areEqual((Object)currentDigest, (Object)ViewIndexer.access$getPreviousDigest$p(this.this$0))) {
                                return;
                            }
                            GraphRequest request2 = ViewIndexer.Companion.buildAppIndexingRequest(this.$tree, accessToken, FacebookSdk.getApplicationId(), "app_indexing");
                            this.this$0.processRequest(request2, currentDigest);
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
                {
                    this.this$0 = viewIndexer;
                    this.$tree = string;
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void processRequest(@Nullable GraphRequest graphRequest, @Nullable String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void request2;
            if (request2 == null) {
                return;
            }
            GraphResponse res = request2.executeAndWait();
            try {
                JSONObject jsonRes = res.getJSONObject();
                if (jsonRes != null) {
                    if (Intrinsics.areEqual((Object)"true", (Object)jsonRes.optString(SUCCESS))) {
                        void currentDigest;
                        Logger.Companion.log(LoggingBehavior.APP_EVENTS, TAG, "Successfully send UI component tree to server");
                        this.previousDigest = currentDigest;
                    }
                    if (jsonRes.has("is_app_indexing_enabled")) {
                        boolean appIndexingEnabled = jsonRes.getBoolean("is_app_indexing_enabled");
                        CodelessManager.updateAppIndexing$facebook_core_release(appIndexingEnabled);
                    }
                } else {
                    Log.e((String)TAG, (String)("Error sending UI component tree to Facebook: " + res.getError()));
                }
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"Error decoding server response.", (Throwable)e);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    public ViewIndexer(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.activityReference = new WeakReference<Activity>(activity);
        this.previousDigest = null;
        this.uiThreadHandler = new Handler(Looper.getMainLooper());
        instance = this;
    }

    static {
        Companion = new Companion(null);
        String string = ViewIndexer.class.getCanonicalName();
        if (string == null) {
            string = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ViewIndexer::class.java.canonicalName ?: \"\"");
        TAG = string;
    }

    public static final /* synthetic */ WeakReference access$getActivityReference$p(ViewIndexer viewIndexer) {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return null;
        }
        try {
            ViewIndexer $this;
            return $this.activityReference;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return null;
        }
    }

    public static final /* synthetic */ Handler access$getUiThreadHandler$p(ViewIndexer viewIndexer) {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return null;
        }
        try {
            ViewIndexer $this;
            return $this.uiThreadHandler;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return null;
        }
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return null;
        }
        try {
            return TAG;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$sendToServer(ViewIndexer viewIndexer, String string) {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return;
        }
        try {
            void tree;
            ViewIndexer $this;
            $this.sendToServer((String)tree);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return;
        }
    }

    public static final /* synthetic */ Timer access$getIndexingTimer$p(ViewIndexer viewIndexer) {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return null;
        }
        try {
            ViewIndexer $this;
            return $this.indexingTimer;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setIndexingTimer$p(ViewIndexer viewIndexer, Timer timer) {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return;
        }
        try {
            void <set-?>;
            $this.indexingTimer = <set-?>;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return;
        }
    }

    public static final /* synthetic */ String access$getPreviousDigest$p(ViewIndexer viewIndexer) {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return null;
        }
        try {
            ViewIndexer $this;
            return $this.previousDigest;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setPreviousDigest$p(ViewIndexer viewIndexer, String string) {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return;
        }
        try {
            void <set-?>;
            $this.previousDigest = <set-?>;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return;
        }
    }

    public static final /* synthetic */ ViewIndexer access$getInstance$cp() {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return null;
        }
        try {
            return instance;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return null;
        }
    }

    public static final /* synthetic */ void access$setInstance$cp(ViewIndexer viewIndexer) {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return;
        }
        try {
            ViewIndexer viewIndexer2;
            instance = viewIndexer2;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return;
        }
    }

    @JvmStatic
    public static final void sendToServerUnityInstance(@NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return;
        }
        try {
            String tree;
            Companion.sendToServerUnityInstance(tree);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static final GraphRequest buildAppIndexingRequest(@Nullable String string, @Nullable AccessToken accessToken, @Nullable String string2, @NotNull String string3) {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return null;
        }
        try {
            void requestType;
            void appId;
            void accessToken2;
            String appIndex;
            return Companion.buildAppIndexingRequest(appIndex, (AccessToken)accessToken2, (String)appId, (String)requestType);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return null;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0007\u001a\u00020\u0002H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/appevents/codeless/ViewIndexer$ScreenshotTaker;", "Ljava/util/concurrent/Callable;", "", "rootView", "Landroid/view/View;", "(Landroid/view/View;)V", "Ljava/lang/ref/WeakReference;", "call", "facebook-core_release"})
    private static final class ScreenshotTaker
    implements Callable<String> {
        private final WeakReference<View> rootView;

        @Override
        @NotNull
        public String call() {
            View view = (View)this.rootView.get();
            if (view == null || view.getWidth() == 0 || view.getHeight() == 0) {
                return "";
            }
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            Canvas canvas = new Canvas(bitmap);
            view.draw(canvas);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 10, (OutputStream)outputStream);
            String string = Base64.encodeToString((byte[])outputStream.toByteArray(), (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Base64.encodeToString(ou\u2026eArray(), Base64.NO_WRAP)");
            return string;
        }

        public ScreenshotTaker(@NotNull View rootView) {
            Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
            this.rootView = new WeakReference<View>(rootView);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/appevents/codeless/ViewIndexer$Companion;", "", "()V", "APP_VERSION_PARAM", "", "PLATFORM_PARAM", "REQUEST_TYPE", "SUCCESS", "TAG", "TREE_PARAM", "instance", "Lcom/facebook/appevents/codeless/ViewIndexer;", "buildAppIndexingRequest", "Lcom/facebook/GraphRequest;", "appIndex", "accessToken", "Lcom/facebook/AccessToken;", "appId", "requestType", "sendToServerUnityInstance", "", "tree", "facebook-core_release"})
    public static final class Companion {
        @JvmStatic
        public final void sendToServerUnityInstance(@NotNull String tree) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)tree, (String)ViewIndexer.TREE_PARAM);
                ViewIndexer viewIndexer = ViewIndexer.access$getInstance$cp();
                if (viewIndexer == null) break block0;
                ViewIndexer viewIndexer2 = viewIndexer;
                boolean bl = false;
                boolean bl2 = false;
                ViewIndexer it = viewIndexer2;
                boolean bl3 = false;
                ViewIndexer.access$sendToServer(it, tree);
            }
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @Nullable
        public final GraphRequest buildAppIndexingRequest(@Nullable String appIndex, @Nullable AccessToken accessToken, @Nullable String appId, @NotNull String requestType) {
            Intrinsics.checkNotNullParameter((Object)requestType, (String)"requestType");
            if (appIndex == null) {
                return null;
            }
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            String string = "%s/app_indexing";
            Object[] objectArray = new Object[]{appId};
            boolean bl = false;
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            GraphRequest postRequest = GraphRequest.Companion.newPostRequest(accessToken, string2, null, null);
            Bundle requestParameters = postRequest.getParameters();
            if (requestParameters == null) {
                requestParameters = new Bundle();
            }
            requestParameters.putString(ViewIndexer.TREE_PARAM, appIndex);
            requestParameters.putString(ViewIndexer.APP_VERSION_PARAM, AppEventUtility.getAppVersion());
            requestParameters.putString(ViewIndexer.PLATFORM_PARAM, "android");
            requestParameters.putString(ViewIndexer.REQUEST_TYPE, requestType);
            if (Intrinsics.areEqual((Object)requestType, (Object)"app_indexing")) {
                requestParameters.putString("device_session_id", CodelessManager.getCurrentDeviceSessionID$facebook_core_release());
            }
            postRequest.setParameters(requestParameters);
            postRequest.setCallback(buildAppIndexingRequest.1.INSTANCE);
            return postRequest;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

