/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import androidx.annotation.RestrictTo;
import com.facebook.appevents.AppEventsManager;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/facebook/appevents/AppEventsManager;", "", "()V", "start", "", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class AppEventsManager {
    @NotNull
    public static final AppEventsManager INSTANCE;

    @JvmStatic
    public static final void start() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsManager.class)) {
            return;
        }
        try {
            FetchedAppSettingsManager.getAppSettingsAsync(new FetchedAppSettingsManager.FetchedAppSettingsCallback(){

                public void onSuccess(@Nullable FetchedAppSettings fetchedAppSettings) {
                    FeatureManager.checkFeature(FeatureManager.Feature.AAM, start.onSuccess.1.INSTANCE);
                    FeatureManager.checkFeature(FeatureManager.Feature.RestrictiveDataFiltering, start.onSuccess.2.INSTANCE);
                    FeatureManager.checkFeature(FeatureManager.Feature.PrivacyProtection, start.onSuccess.3.INSTANCE);
                    FeatureManager.checkFeature(FeatureManager.Feature.EventDeactivation, start.onSuccess.4.INSTANCE);
                    FeatureManager.checkFeature(FeatureManager.Feature.IapLogging, start.onSuccess.5.INSTANCE);
                }

                public void onError() {
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsManager.class);
            return;
        }
    }

    private AppEventsManager() {
    }

    static {
        AppEventsManager appEventsManager;
        INSTANCE = appEventsManager = new AppEventsManager();
    }
}

