/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.AccessTokenAppIdPair;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.AppEventCollection;
import com.facebook.appevents.AppEventQueue;
import com.facebook.appevents.AppEventStore;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.AppEventsLoggerImpl;
import com.facebook.appevents.FlushReason;
import com.facebook.appevents.FlushResult;
import com.facebook.appevents.FlushStatistics;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.PersistedEvents;
import com.facebook.appevents.SessionEventsState;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Logger;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J*\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190!2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u001fH\u0007J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%H\u0007J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%H\u0007J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150(H\u0007J0\u0010)\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\b\u0010-\u001a\u00020\u0013H\u0007J\u001a\u0010.\u001a\u0004\u0018\u00010\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/facebook/appevents/AppEventQueue;", "", "()V", "FLUSH_PERIOD_IN_SECONDS", "", "NO_CONNECTIVITY_ERROR_CODE", "NUM_LOG_EVENTS_TO_TRY_TO_FLUSH_AFTER", "TAG", "", "appEventCollection", "Lcom/facebook/appevents/AppEventCollection;", "flushRunnable", "Ljava/lang/Runnable;", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "singleThreadExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "add", "", "accessTokenAppId", "Lcom/facebook/appevents/AccessTokenAppIdPair;", "appEvent", "Lcom/facebook/appevents/AppEvent;", "buildRequestForSession", "Lcom/facebook/GraphRequest;", "appEvents", "Lcom/facebook/appevents/SessionEventsState;", "limitEventUsage", "", "flushState", "Lcom/facebook/appevents/FlushStatistics;", "buildRequests", "", "flushResults", "flush", "reason", "Lcom/facebook/appevents/FlushReason;", "flushAndWait", "getKeySet", "", "handleResponse", "request", "response", "Lcom/facebook/GraphResponse;", "persistToDisk", "sendEventsToServer", "facebook-core_release"})
public final class AppEventQueue {
    private static final String TAG;
    private static final int NUM_LOG_EVENTS_TO_TRY_TO_FLUSH_AFTER;
    private static final int FLUSH_PERIOD_IN_SECONDS = 15;
    private static final int NO_CONNECTIVITY_ERROR_CODE = -1;
    private static volatile AppEventCollection appEventCollection;
    private static final ScheduledExecutorService singleThreadExecutor;
    private static ScheduledFuture<?> scheduledFuture;
    private static final Runnable flushRunnable;
    @NotNull
    public static final AppEventQueue INSTANCE;

    @JvmStatic
    public static final void persistToDisk() {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return;
        }
        try {
            singleThreadExecutor.execute(persistToDisk.1.INSTANCE);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return;
        }
    }

    @JvmStatic
    public static final void flush(@NotNull FlushReason flushReason) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return;
        }
        try {
            FlushReason reason;
            Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
            singleThreadExecutor.execute(new Runnable(reason){
                final /* synthetic */ FlushReason $reason;

                public final void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            AppEventQueue.flushAndWait(this.$reason);
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
                {
                    this.$reason = flushReason;
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void add(@NotNull AccessTokenAppIdPair accessTokenAppIdPair, @NotNull AppEvent appEvent) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return;
        }
        try {
            void appEvent2;
            AccessTokenAppIdPair accessTokenAppId;
            Intrinsics.checkNotNullParameter((Object)accessTokenAppId, (String)"accessTokenAppId");
            Intrinsics.checkNotNullParameter((Object)appEvent2, (String)"appEvent");
            singleThreadExecutor.execute(new Runnable(accessTokenAppId, (AppEvent)appEvent2){
                final /* synthetic */ AccessTokenAppIdPair $accessTokenAppId;
                final /* synthetic */ AppEvent $appEvent;

                public final void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            AppEventQueue.access$getAppEventCollection$p(AppEventQueue.INSTANCE).addEvent(this.$accessTokenAppId, this.$appEvent);
                            if (AppEventsLogger.Companion.getFlushBehavior() != AppEventsLogger.FlushBehavior.EXPLICIT_ONLY && AppEventQueue.access$getAppEventCollection$p(AppEventQueue.INSTANCE).getEventCount() > AppEventQueue.access$getNUM_LOG_EVENTS_TO_TRY_TO_FLUSH_AFTER$p(AppEventQueue.INSTANCE)) {
                                AppEventQueue.flushAndWait(FlushReason.EVENT_THRESHOLD);
                            } else if (AppEventQueue.access$getScheduledFuture$p(AppEventQueue.INSTANCE) == null) {
                                AppEventQueue.access$setScheduledFuture$p(AppEventQueue.INSTANCE, AppEventQueue.access$getSingleThreadExecutor$p(AppEventQueue.INSTANCE).schedule(AppEventQueue.access$getFlushRunnable$p(AppEventQueue.INSTANCE), (long)15, TimeUnit.SECONDS));
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
                {
                    this.$accessTokenAppId = accessTokenAppIdPair;
                    this.$appEvent = appEvent;
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return;
        }
    }

    @JvmStatic
    @NotNull
    public static final Set<AccessTokenAppIdPair> getKeySet() {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return null;
        }
        try {
            return appEventCollection.keySet();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return null;
        }
    }

    @JvmStatic
    public static final void flushAndWait(@NotNull FlushReason flushReason) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return;
        }
        try {
            FlushStatistics flushStatistics;
            FlushReason reason;
            Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
            PersistedEvents result = AppEventStore.readAndClearStore();
            appEventCollection.addPersistedEvents(result);
            FlushStatistics flushResults = null;
            try {
                flushStatistics = AppEventQueue.sendEventsToServer(reason, appEventCollection);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Caught unexpected exception while flushing app events: ", (Throwable)e);
                return;
            }
            flushResults = flushStatistics;
            if (flushResults != null) {
                Intent intent = new Intent("com.facebook.sdk.APP_EVENTS_FLUSHED");
                intent.putExtra("com.facebook.sdk.APP_EVENTS_NUM_EVENTS_FLUSHED", flushResults.getNumEvents());
                intent.putExtra("com.facebook.sdk.APP_EVENTS_FLUSH_RESULT", (Serializable)((Object)flushResults.getResult()));
                Context context = FacebookSdk.getApplicationContext();
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @VisibleForTesting(otherwise=2)
    @Nullable
    public static final FlushStatistics sendEventsToServer(@NotNull FlushReason flushReason, @NotNull AppEventCollection appEventCollection) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return null;
        }
        try {
            void appEventCollection2;
            FlushReason reason;
            Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
            Intrinsics.checkNotNullParameter((Object)appEventCollection2, (String)"appEventCollection");
            FlushStatistics flushResults = new FlushStatistics();
            List<GraphRequest> requestsToExecute = AppEventQueue.buildRequests((AppEventCollection)appEventCollection2, flushResults);
            Collection collection = requestsToExecute;
            boolean bl = false;
            if (!collection.isEmpty()) {
                Logger.Companion.log(LoggingBehavior.APP_EVENTS, TAG, "Flushing %d events due to %s.", flushResults.getNumEvents(), reason.toString());
                for (GraphRequest request2 : requestsToExecute) {
                    request2.executeAndWait();
                }
                return flushResults;
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<GraphRequest> buildRequests(@NotNull AppEventCollection appEventCollection, @NotNull FlushStatistics flushStatistics) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return null;
        }
        try {
            void flushResults;
            AppEventCollection appEventCollection2;
            Intrinsics.checkNotNullParameter((Object)appEventCollection2, (String)"appEventCollection");
            Intrinsics.checkNotNullParameter((Object)flushResults, (String)"flushResults");
            Context context = FacebookSdk.getApplicationContext();
            boolean limitEventUsage = FacebookSdk.getLimitEventAndDataUsage(context);
            ArrayList<GraphRequest> requestsToExecute = new ArrayList<GraphRequest>();
            for (AccessTokenAppIdPair accessTokenAppId : appEventCollection2.keySet()) {
                SessionEventsState sessionEventsState = appEventCollection2.get(accessTokenAppId);
                boolean bl = false;
                boolean bl2 = false;
                bl2 = false;
                boolean bl3 = false;
                if (sessionEventsState == null) {
                    boolean bl4 = false;
                    String string = "Required value was null.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                GraphRequest request2 = AppEventQueue.buildRequestForSession(accessTokenAppId, sessionEventsState, limitEventUsage, (FlushStatistics)flushResults);
                if (request2 == null) continue;
                requestsToExecute.add(request2);
            }
            return requestsToExecute;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final GraphRequest buildRequestForSession(@NotNull AccessTokenAppIdPair accessTokenAppIdPair, @NotNull SessionEventsState sessionEventsState, boolean bl, @NotNull FlushStatistics flushStatistics) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return null;
        }
        try {
            void limitEventUsage;
            int numEvents;
            String installReferrer;
            void flushState;
            void appEvents;
            AccessTokenAppIdPair accessTokenAppId;
            Intrinsics.checkNotNullParameter((Object)accessTokenAppId, (String)"accessTokenAppId");
            Intrinsics.checkNotNullParameter((Object)appEvents, (String)"appEvents");
            Intrinsics.checkNotNullParameter((Object)flushState, (String)"flushState");
            String applicationId = accessTokenAppId.getApplicationId();
            FetchedAppSettings fetchedAppSettings = FetchedAppSettingsManager.queryAppSettings(applicationId, false);
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%s/activities";
            Object[] objectArray = new Object[]{applicationId};
            boolean bl2 = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            GraphRequest postRequest = GraphRequest.Companion.newPostRequest(null, string2, null, null);
            postRequest.setForceApplicationRequest(true);
            Bundle requestParameters = postRequest.getParameters();
            if (requestParameters == null) {
                requestParameters = new Bundle();
            }
            requestParameters.putString("access_token", accessTokenAppId.getAccessTokenString());
            String pushNotificationsRegistrationId = InternalAppEventsLogger.Companion.getPushNotificationsRegistrationId();
            if (pushNotificationsRegistrationId != null) {
                requestParameters.putString("device_token", pushNotificationsRegistrationId);
            }
            if ((installReferrer = AppEventsLoggerImpl.Companion.getInstallReferrer()) != null) {
                requestParameters.putString("install_referrer", installReferrer);
            }
            postRequest.setParameters(requestParameters);
            boolean supportsImplicitLogging = false;
            if (fetchedAppSettings != null) {
                supportsImplicitLogging = fetchedAppSettings.supportsImplicitLogging();
            }
            if ((numEvents = appEvents.populateRequest(postRequest, FacebookSdk.getApplicationContext(), supportsImplicitLogging, (boolean)limitEventUsage)) == 0) {
                return null;
            }
            void v1 = flushState;
            v1.setNumEvents(v1.getNumEvents() + numEvents);
            postRequest.setCallback(new GraphRequest.Callback(accessTokenAppId, postRequest, (SessionEventsState)appEvents, (FlushStatistics)flushState){
                final /* synthetic */ AccessTokenAppIdPair $accessTokenAppId;
                final /* synthetic */ GraphRequest $postRequest;
                final /* synthetic */ SessionEventsState $appEvents;
                final /* synthetic */ FlushStatistics $flushState;

                public final void onCompleted(@NotNull GraphResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    AppEventQueue.handleResponse(this.$accessTokenAppId, this.$postRequest, response, this.$appEvents, this.$flushState);
                }
                {
                    this.$accessTokenAppId = accessTokenAppIdPair;
                    this.$postRequest = graphRequest;
                    this.$appEvents = sessionEventsState;
                    this.$flushState = flushStatistics;
                }
            });
            return postRequest;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void handleResponse(@NotNull AccessTokenAppIdPair accessTokenAppIdPair, @NotNull GraphRequest graphRequest, @NotNull GraphResponse graphResponse, @NotNull SessionEventsState sessionEventsState, @NotNull FlushStatistics flushStatistics) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return;
        }
        try {
            Object object;
            void flushState;
            void appEvents;
            void response;
            void request2;
            AccessTokenAppIdPair accessTokenAppId;
            Intrinsics.checkNotNullParameter((Object)accessTokenAppId, (String)"accessTokenAppId");
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Intrinsics.checkNotNullParameter((Object)appEvents, (String)"appEvents");
            Intrinsics.checkNotNullParameter((Object)flushState, (String)"flushState");
            FacebookRequestError error = response.getError();
            String resultDescription = "Success";
            FlushResult flushResult = FlushResult.SUCCESS;
            if (error != null) {
                if (error.getErrorCode() == -1) {
                    resultDescription = "Failed: No Connectivity";
                    flushResult = FlushResult.NO_CONNECTIVITY;
                } else {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string = "Failed:\n  Response: %s\n  Error %s";
                    object = new Object[]{response.toString(), error.toString()};
                    boolean bl = false;
                    String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                    resultDescription = string2;
                    flushResult = FlushResult.SERVER_ERROR;
                }
            }
            if (FacebookSdk.isLoggingBehaviorEnabled(LoggingBehavior.APP_EVENTS)) {
                String eventsJsonString = (String)request2.getTag();
                Object[] prettyPrintedEvents = null;
                try {
                    JSONArray jsonArray = new JSONArray(eventsJsonString);
                    String string = jsonArray.toString(2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonArray.toString(2)");
                    object = string;
                }
                catch (JSONException exc) {
                    object = "<Can't encode events for debug logging>";
                }
                prettyPrintedEvents = object;
                Logger.Companion.log(LoggingBehavior.APP_EVENTS, TAG, "Flush completed\nParams: %s\n  Result: %s\n  Events JSON: %s", String.valueOf(request2.getGraphObject()), resultDescription, prettyPrintedEvents);
            }
            appEvents.clearInFlightAndStats(error != null);
            if (flushResult == FlushResult.NO_CONNECTIVITY) {
                FacebookSdk.getExecutor().execute(new Runnable(accessTokenAppId, (SessionEventsState)appEvents){
                    final /* synthetic */ AccessTokenAppIdPair $accessTokenAppId;
                    final /* synthetic */ SessionEventsState $appEvents;

                    public final void run() {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            if (CrashShieldHandler.isObjectCrashing(this)) {
                                return;
                            }
                            try {
                                AppEventStore.persistEvents(this.$accessTokenAppId, this.$appEvents);
                                return;
                            }
                            catch (Throwable throwable) {
                                CrashShieldHandler.handleThrowable(throwable, this);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                    {
                        this.$accessTokenAppId = accessTokenAppIdPair;
                        this.$appEvents = sessionEventsState;
                    }
                });
            }
            if (flushResult != FlushResult.SUCCESS && flushState.getResult() != FlushResult.NO_CONNECTIVITY) {
                flushState.setResult(flushResult);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return;
        }
    }

    private AppEventQueue() {
    }

    static {
        AppEventQueue appEventQueue;
        INSTANCE = appEventQueue = new AppEventQueue();
        String string = AppEventQueue.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"AppEventQueue::class.java.name");
        TAG = string;
        NUM_LOG_EVENTS_TO_TRY_TO_FLUSH_AFTER = 100;
        appEventCollection = new AppEventCollection();
        singleThreadExecutor = Executors.newSingleThreadScheduledExecutor();
        flushRunnable = flushRunnable.1.INSTANCE;
    }

    public static final /* synthetic */ AppEventCollection access$getAppEventCollection$p(AppEventQueue appEventQueue) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return null;
        }
        try {
            AppEventQueue $this;
            AppEventQueue appEventQueue2 = $this;
            return appEventCollection;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setAppEventCollection$p(AppEventQueue appEventQueue, AppEventCollection appEventCollection) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return;
        }
        try {
            void <set-?>;
            AppEventQueue $this;
            AppEventQueue appEventQueue2 = $this;
            AppEventQueue.appEventCollection = <set-?>;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return;
        }
    }

    public static final /* synthetic */ int access$getNUM_LOG_EVENTS_TO_TRY_TO_FLUSH_AFTER$p(AppEventQueue appEventQueue) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return 0;
        }
        try {
            AppEventQueue $this;
            AppEventQueue appEventQueue2 = $this;
            return NUM_LOG_EVENTS_TO_TRY_TO_FLUSH_AFTER;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return 0;
        }
    }

    public static final /* synthetic */ ScheduledFuture access$getScheduledFuture$p(AppEventQueue appEventQueue) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return null;
        }
        try {
            AppEventQueue $this;
            AppEventQueue appEventQueue2 = $this;
            return scheduledFuture;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setScheduledFuture$p(AppEventQueue appEventQueue, ScheduledFuture scheduledFuture) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return;
        }
        try {
            void <set-?>;
            AppEventQueue $this;
            AppEventQueue appEventQueue2 = $this;
            AppEventQueue.scheduledFuture = <set-?>;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return;
        }
    }

    public static final /* synthetic */ ScheduledExecutorService access$getSingleThreadExecutor$p(AppEventQueue appEventQueue) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return null;
        }
        try {
            AppEventQueue $this;
            AppEventQueue appEventQueue2 = $this;
            return singleThreadExecutor;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return null;
        }
    }

    public static final /* synthetic */ Runnable access$getFlushRunnable$p(AppEventQueue appEventQueue) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return null;
        }
        try {
            AppEventQueue $this;
            AppEventQueue appEventQueue2 = $this;
            return flushRunnable;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return null;
        }
    }
}

