/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.FacebookSdkNotInitializedException;
import com.facebook.GraphRequest;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0010\b\u00c1\u0002\u0018\u00002\u00020\u0001:\u00017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0007J\b\u0010\u001f\u001a\u00020\u001eH\u0007J\b\u0010 \u001a\u00020\u001eH\u0007J\b\u0010!\u001a\u00020\u001eH\u0007J\b\u0010\"\u001a\u00020\u001eH\u0007J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020$H\u0002J!\u0010&\u001a\u00020$2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130(\"\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020\u0013H\u0002J\b\u0010,\u001a\u00020$H\u0007J\b\u0010-\u001a\u00020$H\u0002J\b\u0010.\u001a\u00020$H\u0002J\u0010\u0010/\u001a\u00020$2\u0006\u0010+\u001a\u00020\u0013H\u0002J\u0010\u00100\u001a\u00020$2\u0006\u00101\u001a\u00020\u001eH\u0007J\u0010\u00102\u001a\u00020$2\u0006\u00101\u001a\u00020\u001eH\u0007J\u0010\u00103\u001a\u00020$2\u0006\u00101\u001a\u00020\u001eH\u0007J\u0010\u00104\u001a\u00020$2\u0006\u00101\u001a\u00020\u001eH\u0007J\b\u00105\u001a\u00020$H\u0002J\u0010\u00106\u001a\u00020$2\u0006\u0010+\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/facebook/UserSettingsManager;", "", "()V", "ADVERTISERID_COLLECTION_FALSE_WARNING", "", "ADVERTISERID_COLLECTION_NOT_SET_WARNING", "ADVERTISER_ID_KEY", "APPLICATION_FIELDS", "AUTOLOG_APPEVENT_NOT_SET_WARNING", "AUTO_APP_LINK_WARNING", "EVENTS_CODELESS_SETUP_ENABLED", "LAST_TIMESTAMP", "TAG", "TIMEOUT_7D", "", "USER_SETTINGS", "USER_SETTINGS_BITMASK", "VALUE", "advertiserIDCollectionEnabled", "Lcom/facebook/UserSettingsManager$UserSetting;", "autoInitEnabled", "autoLogAppEventsEnabled", "codelessSetupEnabled", "isFetchingCodelessStatus", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isInitialized", "monitorEnabled", "userSettingPref", "Landroid/content/SharedPreferences;", "getAdvertiserIDCollectionEnabled", "", "getAutoInitEnabled", "getAutoLogAppEventsEnabled", "getCodelessSetupEnabled", "getMonitorEnabled", "initializeCodelessSetupEnabledAsync", "", "initializeIfNotInitialized", "initializeUserSetting", "userSettings", "", "([Lcom/facebook/UserSettingsManager$UserSetting;)V", "loadSettingFromManifest", "userSetting", "logIfAutoAppLinkEnabled", "logIfSDKSettingsChanged", "logWarnings", "readSettingFromCache", "setAdvertiserIDCollectionEnabled", "flag", "setAutoInitEnabled", "setAutoLogAppEventsEnabled", "setMonitorEnabled", "validateInitialized", "writeSettingToCache", "UserSetting", "facebook-core_release"})
public final class UserSettingsManager {
    private static final String TAG;
    private static final AtomicBoolean isInitialized;
    private static final AtomicBoolean isFetchingCodelessStatus;
    private static final String EVENTS_CODELESS_SETUP_ENABLED = "auto_event_setup_enabled";
    private static final long TIMEOUT_7D = 604800000L;
    private static final String ADVERTISER_ID_KEY = "advertiser_id";
    private static final String APPLICATION_FIELDS = "fields";
    private static final UserSetting autoInitEnabled;
    private static final UserSetting autoLogAppEventsEnabled;
    private static final UserSetting advertiserIDCollectionEnabled;
    private static final UserSetting codelessSetupEnabled;
    private static final UserSetting monitorEnabled;
    private static final String USER_SETTINGS = "com.facebook.sdk.USER_SETTINGS";
    private static final String USER_SETTINGS_BITMASK = "com.facebook.sdk.USER_SETTINGS_BITMASK";
    private static SharedPreferences userSettingPref;
    private static final String LAST_TIMESTAMP = "last_timestamp";
    private static final String VALUE = "value";
    private static final String AUTOLOG_APPEVENT_NOT_SET_WARNING = "Please set a value for AutoLogAppEventsEnabled. Set the flag to TRUE if you want to collect app install, app launch and in-app purchase events automatically. To request user consent before collecting data, set the flag value to FALSE, then change to TRUE once user consent is received. Learn more: https://developers.facebook.com/docs/app-events/getting-started-app-events-android#disable-auto-events.";
    private static final String ADVERTISERID_COLLECTION_NOT_SET_WARNING = "You haven't set a value for AdvertiserIDCollectionEnabled. Set the flag to TRUE if you want to collect Advertiser ID for better advertising and analytics results. To request user consent before collecting data, set the flag value to FALSE, then change to TRUE once user consent is received. Learn more: https://developers.facebook.com/docs/app-events/getting-started-app-events-android#disable-auto-events.";
    private static final String ADVERTISERID_COLLECTION_FALSE_WARNING = "The value for AdvertiserIDCollectionEnabled is currently set to FALSE so you're sending app events without collecting Advertiser ID. This can affect the quality of your advertising and analytics results.";
    private static final String AUTO_APP_LINK_WARNING = "You haven't set the Auto App Link URL scheme: fb<YOUR APP ID> in AndroidManifest";
    @NotNull
    public static final UserSettingsManager INSTANCE;

    private final void initializeIfNotInitialized() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            if (!FacebookSdk.isInitialized()) {
                return;
            }
            if (!isInitialized.compareAndSet(false, true)) {
                return;
            }
            SharedPreferences sharedPreferences = FacebookSdk.getApplicationContext().getSharedPreferences(USER_SETTINGS, 0);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"FacebookSdk.getApplicati\u2026GS, Context.MODE_PRIVATE)");
            userSettingPref = sharedPreferences;
            this.initializeUserSetting(autoLogAppEventsEnabled, advertiserIDCollectionEnabled, autoInitEnabled);
            this.initializeCodelessSetupEnabledAsync();
            this.logWarnings();
            this.logIfSDKSettingsChanged();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeUserSetting(UserSetting ... userSettingArray) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void userSettings;
            for (void userSetting : userSettings) {
                if (userSetting == codelessSetupEnabled) {
                    this.initializeCodelessSetupEnabledAsync();
                    continue;
                }
                if (userSetting.getValue() == null) {
                    this.readSettingFromCache((UserSetting)userSetting);
                    if (userSetting.getValue() != null) continue;
                    this.loadSettingFromManifest((UserSetting)userSetting);
                    continue;
                }
                this.writeSettingToCache((UserSetting)userSetting);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    private final void initializeCodelessSetupEnabledAsync() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            this.readSettingFromCache(codelessSetupEnabled);
            long currTime = System.currentTimeMillis();
            if (codelessSetupEnabled.getValue() != null && currTime - codelessSetupEnabled.getLastTS() < 604800000L) {
                return;
            }
            codelessSetupEnabled.setValue(null);
            codelessSetupEnabled.setLastTS(0L);
            if (!isFetchingCodelessStatus.compareAndSet(false, true)) {
                return;
            }
            FacebookSdk.getExecutor().execute(new Runnable(currTime){
                final /* synthetic */ long $currTime;

                public final void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            FetchedAppSettings appSettings;
                            if (UserSettingsManager.access$getAdvertiserIDCollectionEnabled$p(UserSettingsManager.INSTANCE).getValue() && (appSettings = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.getApplicationId(), false)) != null && appSettings.getCodelessEventsEnabled()) {
                                String advertiserId = null;
                                Context context = FacebookSdk.getApplicationContext();
                                AttributionIdentifiers identifiers = AttributionIdentifiers.Companion.getAttributionIdentifiers(context);
                                if (identifiers != null && identifiers.getAndroidAdvertiserId() != null) {
                                    advertiserId = identifiers.getAndroidAdvertiserId();
                                }
                                if (advertiserId != null) {
                                    Bundle codelessSettingsParams = new Bundle();
                                    codelessSettingsParams.putString("advertiser_id", advertiserId);
                                    codelessSettingsParams.putString("fields", "auto_event_setup_enabled");
                                    GraphRequest codelessRequest = GraphRequest.Companion.newGraphPathRequest(null, FacebookSdk.getApplicationId(), null);
                                    codelessRequest.setSkipClientToken(true);
                                    codelessRequest.setParameters(codelessSettingsParams);
                                    JSONObject response = codelessRequest.executeAndWait().getJSONObject();
                                    if (response != null) {
                                        UserSettingsManager.access$getCodelessSetupEnabled$p(UserSettingsManager.INSTANCE).setValue(response.optBoolean("auto_event_setup_enabled", false));
                                        UserSettingsManager.access$getCodelessSetupEnabled$p(UserSettingsManager.INSTANCE).setLastTS(this.$currTime);
                                        UserSettingsManager.access$writeSettingToCache(UserSettingsManager.INSTANCE, UserSettingsManager.access$getCodelessSetupEnabled$p(UserSettingsManager.INSTANCE));
                                    }
                                }
                            }
                            UserSettingsManager.access$isFetchingCodelessStatus$p(UserSettingsManager.INSTANCE).set(false);
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
                {
                    this.$currTime = l;
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeSettingToCache(UserSetting userSetting) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            this.validateInitialized();
            try {
                void userSetting2;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(VALUE, (Object)userSetting2.getValue());
                jsonObject.put(LAST_TIMESTAMP, userSetting2.getLastTS());
                SharedPreferences sharedPreferences = userSettingPref;
                if (sharedPreferences == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userSettingPref");
                }
                sharedPreferences.edit().putString(userSetting2.getKey(), jsonObject.toString()).commit();
                this.logIfSDKSettingsChanged();
            }
            catch (Exception e) {
                Utility.logd(TAG, e);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void readSettingFromCache(UserSetting userSetting) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            this.validateInitialized();
            try {
                void userSetting2;
                String string;
                SharedPreferences sharedPreferences = userSettingPref;
                if (sharedPreferences == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userSettingPref");
                }
                if ((string = sharedPreferences.getString(userSetting2.getKey(), "")) == null) {
                    string = "";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"userSettingPref.getStrin\u2026serSetting.key, \"\") ?: \"\"");
                String settingStr = string;
                CharSequence charSequence = settingStr;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    JSONObject setting = new JSONObject(settingStr);
                    userSetting2.setValue(setting.getBoolean(VALUE));
                    userSetting2.setLastTS(setting.getLong(LAST_TIMESTAMP));
                }
            }
            catch (JSONException je) {
                Utility.logd(TAG, (Exception)((Object)je));
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadSettingFromManifest(UserSetting userSetting) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            this.validateInitialized();
            try {
                void userSetting2;
                ApplicationInfo ai;
                Context ctx = FacebookSdk.getApplicationContext();
                ApplicationInfo applicationInfo = ai = ctx.getPackageManager().getApplicationInfo(ctx.getPackageName(), 128);
                if ((applicationInfo != null ? applicationInfo.metaData : null) != null && ai.metaData.containsKey(userSetting2.getKey())) {
                    userSetting2.setValue(ai.metaData.getBoolean(userSetting2.getKey(), userSetting2.getDefaultVal()));
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Utility.logd(TAG, (Exception)((Object)e));
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    private final void logWarnings() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            try {
                ApplicationInfo ai;
                Context ctx = FacebookSdk.getApplicationContext();
                ApplicationInfo applicationInfo = ai = ctx.getPackageManager().getApplicationInfo(ctx.getPackageName(), 128);
                if ((applicationInfo != null ? applicationInfo.metaData : null) != null) {
                    if (!ai.metaData.containsKey("com.facebook.sdk.AutoLogAppEventsEnabled")) {
                        Log.w((String)TAG, (String)AUTOLOG_APPEVENT_NOT_SET_WARNING);
                    }
                    if (!ai.metaData.containsKey("com.facebook.sdk.AdvertiserIDCollectionEnabled")) {
                        Log.w((String)TAG, (String)ADVERTISERID_COLLECTION_NOT_SET_WARNING);
                    }
                    if (!UserSettingsManager.getAdvertiserIDCollectionEnabled()) {
                        Log.w((String)TAG, (String)ADVERTISERID_COLLECTION_FALSE_WARNING);
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void logIfSDKSettingsChanged() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            int previousBitmask;
            if (!isInitialized.get()) {
                return;
            }
            if (!FacebookSdk.isInitialized()) {
                return;
            }
            Context ctx = FacebookSdk.getApplicationContext();
            int bitmask = 0;
            int bit = 0;
            bitmask |= (autoInitEnabled.getValue() ? 1 : 0) << bit++;
            bitmask |= (autoLogAppEventsEnabled.getValue() ? 1 : 0) << bit++;
            bitmask |= (advertiserIDCollectionEnabled.getValue() ? 1 : 0) << bit++;
            bitmask |= (monitorEnabled.getValue() ? 1 : 0) << bit++;
            SharedPreferences sharedPreferences = userSettingPref;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"userSettingPref");
            }
            if ((previousBitmask = sharedPreferences.getInt(USER_SETTINGS_BITMASK, 0)) != bitmask) {
                SharedPreferences sharedPreferences2 = userSettingPref;
                if (sharedPreferences2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userSettingPref");
                }
                sharedPreferences2.edit().putInt(USER_SETTINGS_BITMASK, bitmask).commit();
                int initialBitmask = 0;
                int usageBitmask = 0;
                try {
                    ApplicationInfo ai;
                    ApplicationInfo applicationInfo = ai = ctx.getPackageManager().getApplicationInfo(ctx.getPackageName(), 128);
                    if ((applicationInfo != null ? applicationInfo.metaData : null) != null) {
                        String[] keys = new String[]{"com.facebook.sdk.AutoInitEnabled", "com.facebook.sdk.AutoLogAppEventsEnabled", "com.facebook.sdk.AdvertiserIDCollectionEnabled", "com.facebook.sdk.MonitorEnabled"};
                        boolean[] defaultValues = new boolean[]{true, true, true, true};
                        int n = 0;
                        int n2 = keys.length;
                        while (n < n2) {
                            void i;
                            usageBitmask |= (ai.metaData.containsKey(keys[i]) ? 1 : 0) << i;
                            boolean initialValue = ai.metaData.getBoolean(keys[i], defaultValues[i]);
                            initialBitmask |= (initialValue ? 1 : 0) << i;
                            ++i;
                        }
                    }
                }
                catch (PackageManager.NameNotFoundException ai) {
                    // empty catch block
                }
                InternalAppEventsLogger logger = new InternalAppEventsLogger(ctx);
                Bundle parameters = new Bundle();
                parameters.putInt("usage", usageBitmask);
                parameters.putInt("initial", initialBitmask);
                parameters.putInt("previous", previousBitmask);
                parameters.putInt("current", bitmask);
                logger.logChangedSettingsEvent(parameters);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    @JvmStatic
    public static final void logIfAutoAppLinkEnabled() {
        if (CrashShieldHandler.isObjectCrashing(UserSettingsManager.class)) {
            return;
        }
        try {
            try {
                ApplicationInfo ai;
                Context ctx = FacebookSdk.getApplicationContext();
                ApplicationInfo applicationInfo = ai = ctx.getPackageManager().getApplicationInfo(ctx.getPackageName(), 128);
                if ((applicationInfo != null ? applicationInfo.metaData : null) != null && ai.metaData.getBoolean("com.facebook.sdk.AutoAppLinkEnabled", false)) {
                    InternalAppEventsLogger logger = new InternalAppEventsLogger(ctx);
                    Bundle params = new Bundle();
                    if (!Utility.isAutoAppLinkSetup()) {
                        params.putString("SchemeWarning", AUTO_APP_LINK_WARNING);
                        Log.w((String)TAG, (String)AUTO_APP_LINK_WARNING);
                    }
                    logger.logEvent("fb_auto_applink", params);
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserSettingsManager.class);
            return;
        }
    }

    private final void validateInitialized() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            if (!isInitialized.get()) {
                throw (Throwable)new FacebookSdkNotInitializedException("The UserSettingManager has not been initialized successfully");
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    @JvmStatic
    public static final void setAutoInitEnabled(boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(UserSettingsManager.class)) {
            return;
        }
        try {
            boolean flag;
            autoInitEnabled.setValue(flag);
            autoInitEnabled.setLastTS(System.currentTimeMillis());
            if (isInitialized.get()) {
                INSTANCE.writeSettingToCache(autoInitEnabled);
            } else {
                INSTANCE.initializeIfNotInitialized();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserSettingsManager.class);
            return;
        }
    }

    @JvmStatic
    public static final boolean getAutoInitEnabled() {
        if (CrashShieldHandler.isObjectCrashing(UserSettingsManager.class)) {
            return false;
        }
        try {
            INSTANCE.initializeIfNotInitialized();
            return autoInitEnabled.getValue();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserSettingsManager.class);
            return false;
        }
    }

    @JvmStatic
    public static final void setAutoLogAppEventsEnabled(boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(UserSettingsManager.class)) {
            return;
        }
        try {
            boolean flag;
            autoLogAppEventsEnabled.setValue(flag);
            autoLogAppEventsEnabled.setLastTS(System.currentTimeMillis());
            if (isInitialized.get()) {
                INSTANCE.writeSettingToCache(autoLogAppEventsEnabled);
            } else {
                INSTANCE.initializeIfNotInitialized();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserSettingsManager.class);
            return;
        }
    }

    @JvmStatic
    public static final boolean getAutoLogAppEventsEnabled() {
        if (CrashShieldHandler.isObjectCrashing(UserSettingsManager.class)) {
            return false;
        }
        try {
            INSTANCE.initializeIfNotInitialized();
            return autoLogAppEventsEnabled.getValue();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserSettingsManager.class);
            return false;
        }
    }

    @JvmStatic
    public static final void setAdvertiserIDCollectionEnabled(boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(UserSettingsManager.class)) {
            return;
        }
        try {
            boolean flag;
            advertiserIDCollectionEnabled.setValue(flag);
            advertiserIDCollectionEnabled.setLastTS(System.currentTimeMillis());
            if (isInitialized.get()) {
                INSTANCE.writeSettingToCache(advertiserIDCollectionEnabled);
            } else {
                INSTANCE.initializeIfNotInitialized();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserSettingsManager.class);
            return;
        }
    }

    @JvmStatic
    public static final boolean getAdvertiserIDCollectionEnabled() {
        if (CrashShieldHandler.isObjectCrashing(UserSettingsManager.class)) {
            return false;
        }
        try {
            INSTANCE.initializeIfNotInitialized();
            return advertiserIDCollectionEnabled.getValue();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserSettingsManager.class);
            return false;
        }
    }

    @JvmStatic
    public static final boolean getCodelessSetupEnabled() {
        if (CrashShieldHandler.isObjectCrashing(UserSettingsManager.class)) {
            return false;
        }
        try {
            INSTANCE.initializeIfNotInitialized();
            return codelessSetupEnabled.getValue();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserSettingsManager.class);
            return false;
        }
    }

    @JvmStatic
    public static final void setMonitorEnabled(boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(UserSettingsManager.class)) {
            return;
        }
        try {
            boolean flag;
            monitorEnabled.setValue(flag);
            monitorEnabled.setLastTS(System.currentTimeMillis());
            if (isInitialized.get()) {
                INSTANCE.writeSettingToCache(monitorEnabled);
            } else {
                INSTANCE.initializeIfNotInitialized();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserSettingsManager.class);
            return;
        }
    }

    @JvmStatic
    public static final boolean getMonitorEnabled() {
        if (CrashShieldHandler.isObjectCrashing(UserSettingsManager.class)) {
            return false;
        }
        try {
            INSTANCE.initializeIfNotInitialized();
            return monitorEnabled.getValue();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserSettingsManager.class);
            return false;
        }
    }

    private UserSettingsManager() {
    }

    static {
        UserSettingsManager userSettingsManager;
        INSTANCE = userSettingsManager = new UserSettingsManager();
        String string = UserSettingsManager.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UserSettingsManager::class.java.name");
        TAG = string;
        isInitialized = new AtomicBoolean(false);
        isFetchingCodelessStatus = new AtomicBoolean(false);
        autoInitEnabled = new UserSetting(true, "com.facebook.sdk.AutoInitEnabled");
        autoLogAppEventsEnabled = new UserSetting(true, "com.facebook.sdk.AutoLogAppEventsEnabled");
        advertiserIDCollectionEnabled = new UserSetting(true, "com.facebook.sdk.AdvertiserIDCollectionEnabled");
        codelessSetupEnabled = new UserSetting(false, EVENTS_CODELESS_SETUP_ENABLED);
        monitorEnabled = new UserSetting(true, "com.facebook.sdk.MonitorEnabled");
    }

    public static final /* synthetic */ UserSetting access$getAdvertiserIDCollectionEnabled$p(UserSettingsManager userSettingsManager) {
        if (CrashShieldHandler.isObjectCrashing(UserSettingsManager.class)) {
            return null;
        }
        try {
            UserSettingsManager $this;
            UserSettingsManager userSettingsManager2 = $this;
            return advertiserIDCollectionEnabled;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserSettingsManager.class);
            return null;
        }
    }

    public static final /* synthetic */ UserSetting access$getCodelessSetupEnabled$p(UserSettingsManager userSettingsManager) {
        if (CrashShieldHandler.isObjectCrashing(UserSettingsManager.class)) {
            return null;
        }
        try {
            UserSettingsManager $this;
            UserSettingsManager userSettingsManager2 = $this;
            return codelessSetupEnabled;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserSettingsManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$writeSettingToCache(UserSettingsManager userSettingsManager, UserSetting userSetting) {
        if (CrashShieldHandler.isObjectCrashing(UserSettingsManager.class)) {
            return;
        }
        try {
            void userSetting2;
            UserSettingsManager $this;
            $this.writeSettingToCache((UserSetting)userSetting2);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserSettingsManager.class);
            return;
        }
    }

    public static final /* synthetic */ AtomicBoolean access$isFetchingCodelessStatus$p(UserSettingsManager userSettingsManager) {
        if (CrashShieldHandler.isObjectCrashing(UserSettingsManager.class)) {
            return null;
        }
        try {
            UserSettingsManager $this;
            UserSettingsManager userSettingsManager2 = $this;
            return isFetchingCodelessStatus;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserSettingsManager.class);
            return null;
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0016\u001a\u00020\u0003R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lcom/facebook/UserSettingsManager$UserSetting;", "", "defaultVal", "", "key", "", "(ZLjava/lang/String;)V", "getDefaultVal", "()Z", "setDefaultVal", "(Z)V", "getKey", "()Ljava/lang/String;", "setKey", "(Ljava/lang/String;)V", "lastTS", "", "getLastTS", "()J", "setLastTS", "(J)V", "value", "getValue", "()Ljava/lang/Boolean;", "setValue", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "facebook-core_release"})
    private static final class UserSetting {
        @Nullable
        private Boolean value;
        private long lastTS;
        private boolean defaultVal;
        @NotNull
        private String key;

        @Nullable
        public final Boolean getValue() {
            return this.value;
        }

        public final void setValue(@Nullable Boolean bl) {
            this.value = bl;
        }

        public final long getLastTS() {
            return this.lastTS;
        }

        public final void setLastTS(long l) {
            this.lastTS = l;
        }

        public final boolean getValue() {
            Boolean bl = this.value;
            return bl != null ? bl : this.defaultVal;
        }

        public final boolean getDefaultVal() {
            return this.defaultVal;
        }

        public final void setDefaultVal(boolean bl) {
            this.defaultVal = bl;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public final void setKey(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.key = string;
        }

        public UserSetting(boolean defaultVal, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.defaultVal = defaultVal;
            this.key = key;
        }
    }
}

