/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import androidx.annotation.VisibleForTesting;
import com.facebook.internal.Validate;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0017\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\b\u0010\u0015\u001a\u00020\u0003H\u0007J\r\u0010\u0016\u001a\u00020\u0017H\u0001\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0011H\u0016R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/facebook/AuthenticationTokenHeader;", "Landroid/os/Parcelable;", "encodedHeaderString", "", "(Ljava/lang/String;)V", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "alg", "typ", "kid", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAlg", "()Ljava/lang/String;", "getKid", "getTyp", "describeContents", "", "isValidHeader", "", "headerString", "toEnCodedString", "toJSONObject", "Lorg/json/JSONObject;", "toJSONObject$facebook_core_release", "toString", "writeToParcel", "", "dest", "flags", "CREATOR", "facebook-core_release"})
public final class AuthenticationTokenHeader
implements Parcelable {
    @NotNull
    private final String alg;
    @NotNull
    private final String typ;
    @NotNull
    private final String kid;
    @NotNull
    public static final CREATOR CREATOR = new CREATOR(null);

    @NotNull
    public final String getAlg() {
        return this.alg;
    }

    @NotNull
    public final String getTyp() {
        return this.typ;
    }

    @NotNull
    public final String getKid() {
        return this.kid;
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeString(this.alg);
        dest.writeString(this.typ);
        dest.writeString(this.kid);
    }

    public int describeContents() {
        return 0;
    }

    @NotNull
    public String toString() {
        JSONObject headerJsonObject = this.toJSONObject$facebook_core_release();
        String string = headerJsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"headerJsonObject.toString()");
        return string;
    }

    private final boolean isValidHeader(String headerString) {
        boolean bl;
        Validate.notEmpty(headerString, "encodedHeaderString");
        byte[] decodedBytes = Base64.decode((String)headerString, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)decodedBytes, (String)"decodedBytes");
        byte[] byArray = decodedBytes;
        boolean bl2 = false;
        String claimsString = new String(byArray, Charsets.UTF_8);
        try {
            String alg;
            JSONObject jsonObj = new JSONObject(claimsString);
            String string = alg = jsonObj.optString("alg");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"alg");
            CharSequence charSequence = string;
            boolean bl3 = false;
            boolean validAlg = charSequence.length() > 0 && Intrinsics.areEqual((Object)alg, (Object)"RS256");
            String string2 = jsonObj.optString("kid");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonObj.optString(\"kid\")");
            CharSequence charSequence2 = string2;
            boolean bl4 = false;
            boolean hasKid = charSequence2.length() > 0;
            String string3 = jsonObj.optString("typ");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"jsonObj.optString(\"typ\")");
            CharSequence charSequence3 = string3;
            boolean bl5 = false;
            boolean validTyp = charSequence3.length() > 0;
            bl = validAlg && hasKid && validTyp;
        }
        catch (JSONException _ex) {
            bl = false;
        }
        return bl;
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final JSONObject toJSONObject$facebook_core_release() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("alg", (Object)this.alg);
        jsonObject.put("typ", (Object)this.typ);
        jsonObject.put("kid", (Object)this.kid);
        return jsonObject;
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final String toEnCodedString() {
        String claimsJsonString;
        String string = claimsJsonString = this.toString();
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String string3 = Base64.encodeToString((byte[])byArray, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Base64.encodeToString(cl\u2026eArray(), Base64.DEFAULT)");
        return string3;
    }

    public AuthenticationTokenHeader(@NotNull String encodedHeaderString) {
        Intrinsics.checkNotNullParameter((Object)encodedHeaderString, (String)"encodedHeaderString");
        boolean bl = this.isValidHeader(encodedHeaderString);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Invalid Header";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        byte[] decodedBytes = Base64.decode((String)encodedHeaderString, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)decodedBytes, (String)"decodedBytes");
        byte[] byArray = decodedBytes;
        boolean bl5 = false;
        String claimsString = new String(byArray, Charsets.UTF_8);
        JSONObject jsonObj = new JSONObject(claimsString);
        String string = jsonObj.getString("alg");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObj.getString(\"alg\")");
        this.alg = string;
        String string2 = jsonObj.getString("typ");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonObj.getString(\"typ\")");
        this.typ = string2;
        String string3 = jsonObj.getString("kid");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"jsonObj.getString(\"kid\")");
        this.kid = string3;
    }

    public AuthenticationTokenHeader(@NotNull Parcel parcel) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        String alg = parcel.readString();
        Validate.notNullOrEmpty(alg, "alg");
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (alg == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.alg = alg;
        String typ = parcel.readString();
        Validate.notNullOrEmpty(typ, "typ");
        bl2 = false;
        bl3 = false;
        bl3 = false;
        boolean bl5 = false;
        if (typ == null) {
            boolean bl6 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.typ = typ;
        String kid = parcel.readString();
        Validate.notNullOrEmpty(kid, "kid");
        bl3 = false;
        bl5 = false;
        bl5 = false;
        boolean bl7 = false;
        if (kid == null) {
            boolean bl8 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.kid = kid;
    }

    @VisibleForTesting(otherwise=2)
    public AuthenticationTokenHeader(@NotNull String alg, @NotNull String typ, @NotNull String kid) {
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Intrinsics.checkNotNullParameter((Object)typ, (String)"typ");
        Intrinsics.checkNotNullParameter((Object)kid, (String)"kid");
        this.alg = alg;
        this.typ = typ;
        this.kid = kid;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001d\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/facebook/AuthenticationTokenHeader$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lcom/facebook/AuthenticationTokenHeader;", "()V", "createFromParcel", "parcel", "Landroid/os/Parcel;", "newArray", "", "size", "", "(I)[Lcom/facebook/AuthenticationTokenHeader;", "facebook-core_release"})
    public static final class CREATOR
    implements Parcelable.Creator<AuthenticationTokenHeader> {
        @NotNull
        public AuthenticationTokenHeader createFromParcel(@NotNull Parcel parcel) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            return new AuthenticationTokenHeader(parcel);
        }

        @NotNull
        public AuthenticationTokenHeader[] newArray(int size) {
            return new AuthenticationTokenHeader[size];
        }

        private CREATOR() {
        }

        public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

