/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.SharedPreferences;
import com.facebook.AuthenticationToken;
import com.facebook.FacebookSdk;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0007R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/AuthenticationTokenCache;", "", "()V", "sharedPreferences", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;)V", "cachedAuthenticationToken", "Lcom/facebook/AuthenticationToken;", "getCachedAuthenticationToken", "()Lcom/facebook/AuthenticationToken;", "clear", "", "hasCachedAuthenticationToken", "", "load", "save", "authenticationToken", "Companion", "facebook-core_release"})
public final class AuthenticationTokenCache {
    private final SharedPreferences sharedPreferences;
    @NotNull
    public static final String CACHED_AUTHENTICATION_TOKEN_KEY = "com.facebook.AuthenticationManager.CachedAuthenticationToken";
    @NotNull
    public static final String CACHED_AUTHENTICATION_TOKEN_NONCE_KEY = "com.facebook.AuthenticationManager.CachedAuthenticationTokenNonce";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final AuthenticationToken load() {
        AuthenticationToken authenticationToken = null;
        if (this.hasCachedAuthenticationToken()) {
            authenticationToken = this.getCachedAuthenticationToken();
        }
        return authenticationToken;
    }

    public final void save(@NotNull AuthenticationToken authenticationToken) {
        Intrinsics.checkNotNullParameter((Object)authenticationToken, (String)"authenticationToken");
        this.sharedPreferences.edit().putString(CACHED_AUTHENTICATION_TOKEN_KEY, authenticationToken.getToken()).putString(CACHED_AUTHENTICATION_TOKEN_NONCE_KEY, authenticationToken.getExpectedNonce()).apply();
    }

    public final void clear() {
        this.sharedPreferences.edit().remove(CACHED_AUTHENTICATION_TOKEN_KEY).apply();
        this.sharedPreferences.edit().remove(CACHED_AUTHENTICATION_TOKEN_NONCE_KEY).apply();
    }

    private final boolean hasCachedAuthenticationToken() {
        return this.sharedPreferences.contains(CACHED_AUTHENTICATION_TOKEN_KEY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final AuthenticationToken getCachedAuthenticationToken() {
        String idTokenString = this.sharedPreferences.getString(CACHED_AUTHENTICATION_TOKEN_KEY, null);
        String idTokenExpectedNonce = this.sharedPreferences.getString(CACHED_AUTHENTICATION_TOKEN_NONCE_KEY, null);
        Object object = idTokenString;
        boolean bl = false;
        boolean bl2 = false;
        if (object == null) return null;
        if (object.length() == 0) {
            return null;
        }
        boolean bl3 = false;
        if (bl3) return null;
        object = idTokenExpectedNonce;
        bl = false;
        bl2 = false;
        if (object == null) return null;
        if (object.length() == 0) {
            return null;
        }
        boolean bl4 = false;
        if (bl4) return null;
        try {
            object = new AuthenticationToken(idTokenString, idTokenExpectedNonce);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        CharSequence charSequence = object;
        return charSequence;
    }

    public AuthenticationTokenCache(@NotNull SharedPreferences sharedPreferences) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        this.sharedPreferences = sharedPreferences;
    }

    public AuthenticationTokenCache() {
        SharedPreferences sharedPreferences = FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.AccessTokenManager.SharedPreferences", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"FacebookSdk.getApplicati\u2026    Context.MODE_PRIVATE)");
        this(sharedPreferences);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/AuthenticationTokenCache$Companion;", "", "()V", "CACHED_AUTHENTICATION_TOKEN_KEY", "", "CACHED_AUTHENTICATION_TOKEN_NONCE_KEY", "facebook-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

