/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.os.Parcel;
import android.os.Parcelable;
import com.facebook.AuthenticationTokenClaims;
import com.facebook.AuthenticationTokenHeader;
import com.facebook.internal.Validate;
import com.facebook.internal.security.OidcSecurityUtil;
import java.io.IOException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0001&B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0016J(\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0017H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006'"}, d2={"Lcom/facebook/AuthenticationToken;", "Landroid/os/Parcelable;", "token", "", "expectedNonce", "(Ljava/lang/String;Ljava/lang/String;)V", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "claims", "Lcom/facebook/AuthenticationTokenClaims;", "getClaims", "()Lcom/facebook/AuthenticationTokenClaims;", "getExpectedNonce", "()Ljava/lang/String;", "header", "Lcom/facebook/AuthenticationTokenHeader;", "getHeader", "()Lcom/facebook/AuthenticationTokenHeader;", "signature", "getSignature", "getToken", "describeContents", "", "equals", "", "other", "", "hashCode", "isValidSignature", "headerString", "claimsString", "sigString", "kid", "writeToParcel", "", "dest", "flags", "Companion", "facebook-core_release"})
public final class AuthenticationToken
implements Parcelable {
    @NotNull
    private final String token;
    @NotNull
    private final String expectedNonce;
    @NotNull
    private final AuthenticationTokenHeader header;
    @NotNull
    private final AuthenticationTokenClaims claims;
    @NotNull
    private final String signature;
    @NotNull
    public static final String AUTHENTICATION_TOKEN_KEY = "id_token";
    @JvmField
    @NotNull
    public static final Parcelable.Creator<AuthenticationToken> CREATOR;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final String getToken() {
        return this.token;
    }

    @NotNull
    public final String getExpectedNonce() {
        return this.expectedNonce;
    }

    @NotNull
    public final AuthenticationTokenHeader getHeader() {
        return this.header;
    }

    @NotNull
    public final AuthenticationTokenClaims getClaims() {
        return this.claims;
    }

    @NotNull
    public final String getSignature() {
        return this.signature;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AuthenticationToken)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.token, (Object)((AuthenticationToken)other).token);
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.token.hashCode();
        return result;
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeString(this.token);
        dest.writeString(this.expectedNonce);
    }

    public int describeContents() {
        return 0;
    }

    private final boolean isValidSignature(String headerString, String claimsString, String sigString, String kid) {
        try {
            String string = OidcSecurityUtil.getRawKeyFromEndPoint(kid);
            if (string == null) {
                return false;
            }
            String pubKeyString = string;
            PublicKey pubKey = OidcSecurityUtil.getPublicKeyFromString(pubKeyString);
            return OidcSecurityUtil.verify(pubKey, headerString + '.' + claimsString, sigString);
        }
        catch (InvalidKeySpecException ex) {
            return false;
        }
        catch (IOException _ex) {
            return false;
        }
    }

    @JvmOverloads
    public AuthenticationToken(@NotNull String token, @NotNull String expectedNonce) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)expectedNonce, (String)"expectedNonce");
        Validate.notEmpty(token, "token");
        Validate.notEmpty(expectedNonce, "expectedNonce");
        List tokenArray = StringsKt.split$default((CharSequence)token, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
        boolean bl = tokenArray.size() == 3;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Invalid IdToken string";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String rawHeader = (String)tokenArray.get(0);
        String rawClaims = (String)tokenArray.get(1);
        String rawSignature = (String)tokenArray.get(2);
        this.token = token;
        this.expectedNonce = expectedNonce;
        this.header = new AuthenticationTokenHeader(rawHeader);
        this.claims = new AuthenticationTokenClaims(rawClaims, expectedNonce);
        boolean bl5 = this.isValidSignature(rawHeader, rawClaims, rawSignature, this.header.getKid());
        boolean bl6 = false;
        boolean bl7 = false;
        if (!bl5) {
            boolean bl8 = false;
            String string = "Invalid Signature";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.signature = rawSignature;
    }

    public AuthenticationToken(@NotNull Parcel parcel) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        String token = parcel.readString();
        Validate.notNullOrEmpty(token, "token");
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (token == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.token = token;
        String expectedNonce = parcel.readString();
        Validate.notNull(expectedNonce, "expectedNonce");
        bl2 = false;
        bl3 = false;
        bl3 = false;
        boolean bl5 = false;
        if (expectedNonce == null) {
            boolean bl6 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.expectedNonce = expectedNonce;
        List tokenArray = StringsKt.split$default((CharSequence)token, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
        this.header = new AuthenticationTokenHeader((String)tokenArray.get(0));
        this.claims = new AuthenticationTokenClaims((String)tokenArray.get(1), expectedNonce);
        this.signature = (String)tokenArray.get(2);
    }

    static {
        Companion = new Companion(null);
        CREATOR = (Parcelable.Creator)new Parcelable.Creator<AuthenticationToken>(){

            @NotNull
            public AuthenticationToken createFromParcel(@NotNull Parcel source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                return new AuthenticationToken(source);
            }

            @NotNull
            public AuthenticationToken[] newArray(int size) {
                return new AuthenticationToken[size];
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/AuthenticationToken$Companion;", "", "()V", "AUTHENTICATION_TOKEN_KEY", "", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/facebook/AuthenticationToken;", "facebook-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

