/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.iap.InAppPurchaseEventManager;
import com.facebook.internal.FetchedAppGateKeepersManager;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Validate;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J.\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0007J\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J \u0010\u0016\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/appevents/internal/AutomaticAnalyticsLogger;", "", "()V", "APP_EVENTS_IF_AUTO_LOG_SUBS", "", "TAG", "internalAppEventsLogger", "Lcom/facebook/appevents/InternalAppEventsLogger;", "getPurchaseLoggingParameters", "Lcom/facebook/appevents/internal/AutomaticAnalyticsLogger$PurchaseLoggingParameters;", "purchase", "skuDetails", "extraParameter", "", "isImplicitPurchaseLoggingEnabled", "", "logActivateAppEvent", "", "logActivityTimeSpentEvent", "activityName", "timeSpentInSeconds", "", "logPurchase", "isSubscription", "PurchaseLoggingParameters", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class AutomaticAnalyticsLogger {
    private static final String TAG;
    private static final String APP_EVENTS_IF_AUTO_LOG_SUBS = "app_events_if_auto_log_subs";
    private static final InternalAppEventsLogger internalAppEventsLogger;
    @NotNull
    public static final AutomaticAnalyticsLogger INSTANCE;

    @JvmStatic
    public static final void logActivateAppEvent() {
        Context context = FacebookSdk.getApplicationContext();
        String appId = FacebookSdk.getApplicationId();
        boolean autoLogAppEvents = FacebookSdk.getAutoLogAppEventsEnabled();
        Validate.notNull(context, "context");
        if (autoLogAppEvents) {
            if (context instanceof Application) {
                AppEventsLogger.Companion.activateApp((Application)context, appId);
            } else {
                Log.w((String)TAG, (String)"Automatic logging of basic events will not happen, because FacebookSdk.getApplicationContext() returns object that is not instance of android.app.Application. Make sure you call FacebookSdk.sdkInitialize() from Application class and pass application context.");
            }
        }
    }

    @JvmStatic
    public static final void logActivityTimeSpentEvent(@Nullable String activityName, long timeSpentInSeconds) {
        Context context = FacebookSdk.getApplicationContext();
        String appId = FacebookSdk.getApplicationId();
        Validate.notNull(context, "context");
        String string = appId;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"appId");
        FetchedAppSettings settings = FetchedAppSettingsManager.queryAppSettings(string, false);
        if (settings != null && settings.getAutomaticLoggingEnabled() && timeSpentInSeconds > 0L) {
            InternalAppEventsLogger logger = new InternalAppEventsLogger(context);
            Bundle params = new Bundle(1);
            params.putCharSequence("fb_aa_time_spent_view_name", (CharSequence)activityName);
            logger.logEvent("fb_aa_time_spent_on_view", timeSpentInSeconds, params);
        }
    }

    @JvmStatic
    public static final void logPurchase(@NotNull String purchase, @NotNull String skuDetails, boolean isSubscription) {
        boolean logAsSubs;
        Intrinsics.checkNotNullParameter((Object)purchase, (String)"purchase");
        Intrinsics.checkNotNullParameter((Object)skuDetails, (String)"skuDetails");
        if (!AutomaticAnalyticsLogger.isImplicitPurchaseLoggingEnabled()) {
            return;
        }
        PurchaseLoggingParameters purchaseLoggingParameters = INSTANCE.getPurchaseLoggingParameters(purchase, skuDetails);
        if (purchaseLoggingParameters == null) {
            return;
        }
        PurchaseLoggingParameters loggingParameters = purchaseLoggingParameters;
        boolean bl = logAsSubs = isSubscription && FetchedAppGateKeepersManager.getGateKeeperForKey(APP_EVENTS_IF_AUTO_LOG_SUBS, FacebookSdk.getApplicationId(), false);
        if (logAsSubs) {
            String eventName = InAppPurchaseEventManager.hasFreeTrialPeirod(skuDetails) ? "StartTrial" : "Subscribe";
            internalAppEventsLogger.logEventImplicitly(eventName, loggingParameters.getPurchaseAmount(), loggingParameters.getCurrency(), loggingParameters.getParam());
        } else {
            internalAppEventsLogger.logPurchaseImplicitly(loggingParameters.getPurchaseAmount(), loggingParameters.getCurrency(), loggingParameters.getParam());
        }
    }

    @JvmStatic
    public static final boolean isImplicitPurchaseLoggingEnabled() {
        String appId = FacebookSdk.getApplicationId();
        FetchedAppSettings settings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(appId);
        return settings != null && FacebookSdk.getAutoLogAppEventsEnabled() && settings.getIAPAutomaticLoggingEnabled();
    }

    private final PurchaseLoggingParameters getPurchaseLoggingParameters(String purchase, String skuDetails) {
        return this.getPurchaseLoggingParameters(purchase, skuDetails, new HashMap());
    }

    /*
     * WARNING - void declaration
     */
    private final PurchaseLoggingParameters getPurchaseLoggingParameters(String purchase, String skuDetails, Map<String, String> extraParameter) {
        PurchaseLoggingParameters purchaseLoggingParameters;
        try {
            JSONObject purchaseJSON = new JSONObject(purchase);
            JSONObject skuDetailsJSON = new JSONObject(skuDetails);
            Bundle params = new Bundle(1);
            params.putCharSequence("fb_iap_product_id", (CharSequence)purchaseJSON.getString("productId"));
            params.putCharSequence("fb_iap_purchase_time", (CharSequence)purchaseJSON.getString("purchaseTime"));
            params.putCharSequence("fb_iap_purchase_token", (CharSequence)purchaseJSON.getString("purchaseToken"));
            params.putCharSequence("fb_iap_package_name", (CharSequence)purchaseJSON.optString("packageName"));
            params.putCharSequence("fb_iap_product_title", (CharSequence)skuDetailsJSON.optString("title"));
            params.putCharSequence("fb_iap_product_description", (CharSequence)skuDetailsJSON.optString("description"));
            String type = skuDetailsJSON.optString("type");
            params.putCharSequence("fb_iap_product_type", (CharSequence)type);
            if (Intrinsics.areEqual((Object)type, (Object)"subs")) {
                String introductoryPriceCycles;
                params.putCharSequence("fb_iap_subs_auto_renewing", (CharSequence)Boolean.toString(purchaseJSON.optBoolean("autoRenewing", false)));
                params.putCharSequence("fb_iap_subs_period", (CharSequence)skuDetailsJSON.optString("subscriptionPeriod"));
                params.putCharSequence("fb_free_trial_period", (CharSequence)skuDetailsJSON.optString("freeTrialPeriod"));
                String string = introductoryPriceCycles = skuDetailsJSON.optString("introductoryPriceCycles");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"introductoryPriceCycles");
                CharSequence charSequence = string;
                boolean bl = false;
                if (!(charSequence.length() == 0)) {
                    params.putCharSequence("fb_intro_price_amount_micros", (CharSequence)skuDetailsJSON.optString("introductoryPriceAmountMicros"));
                    params.putCharSequence("fb_intro_price_cycles", (CharSequence)introductoryPriceCycles);
                }
            }
            Map<String, String> $this$forEach$iv = extraParameter;
            boolean $i$f$forEach = false;
            Map<String, String> map = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                void k;
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> $dstr$k$v = element$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry<String, String> entry = $dstr$k$v;
                boolean bl3 = false;
                String string = entry.getKey();
                entry = $dstr$k$v;
                bl3 = false;
                String v = entry.getValue();
                params.putCharSequence((String)k, (CharSequence)v);
            }
            BigDecimal bigDecimal = new BigDecimal((double)skuDetailsJSON.getLong("price_amount_micros") / 1000000.0);
            Currency currency = Currency.getInstance(skuDetailsJSON.getString("price_currency_code"));
            Intrinsics.checkNotNullExpressionValue((Object)currency, (String)"Currency.getInstance(sku\u2026g(\"price_currency_code\"))");
            purchaseLoggingParameters = new PurchaseLoggingParameters(bigDecimal, currency, params);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Error parsing in-app subscription data.", (Throwable)e);
            purchaseLoggingParameters = null;
        }
        return purchaseLoggingParameters;
    }

    private AutomaticAnalyticsLogger() {
    }

    static {
        AutomaticAnalyticsLogger automaticAnalyticsLogger;
        INSTANCE = automaticAnalyticsLogger = new AutomaticAnalyticsLogger();
        TAG = AutomaticAnalyticsLogger.class.getCanonicalName();
        internalAppEventsLogger = new InternalAppEventsLogger(FacebookSdk.getApplicationContext());
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/facebook/appevents/internal/AutomaticAnalyticsLogger$PurchaseLoggingParameters;", "", "purchaseAmount", "Ljava/math/BigDecimal;", "currency", "Ljava/util/Currency;", "param", "Landroid/os/Bundle;", "(Ljava/math/BigDecimal;Ljava/util/Currency;Landroid/os/Bundle;)V", "getCurrency", "()Ljava/util/Currency;", "setCurrency", "(Ljava/util/Currency;)V", "getParam", "()Landroid/os/Bundle;", "setParam", "(Landroid/os/Bundle;)V", "getPurchaseAmount", "()Ljava/math/BigDecimal;", "setPurchaseAmount", "(Ljava/math/BigDecimal;)V", "facebook-core_release"})
    private static final class PurchaseLoggingParameters {
        @NotNull
        private BigDecimal purchaseAmount;
        @NotNull
        private Currency currency;
        @NotNull
        private Bundle param;

        @NotNull
        public final BigDecimal getPurchaseAmount() {
            return this.purchaseAmount;
        }

        public final void setPurchaseAmount(@NotNull BigDecimal bigDecimal) {
            Intrinsics.checkNotNullParameter((Object)bigDecimal, (String)"<set-?>");
            this.purchaseAmount = bigDecimal;
        }

        @NotNull
        public final Currency getCurrency() {
            return this.currency;
        }

        public final void setCurrency(@NotNull Currency currency) {
            Intrinsics.checkNotNullParameter((Object)currency, (String)"<set-?>");
            this.currency = currency;
        }

        @NotNull
        public final Bundle getParam() {
            return this.param;
        }

        public final void setParam(@NotNull Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"<set-?>");
            this.param = bundle;
        }

        public PurchaseLoggingParameters(@NotNull BigDecimal purchaseAmount, @NotNull Currency currency, @NotNull Bundle param) {
            Intrinsics.checkNotNullParameter((Object)purchaseAmount, (String)"purchaseAmount");
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
            this.purchaseAmount = purchaseAmount;
            this.currency = currency;
            this.param = param;
        }
    }
}

