/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.logging.dumpsys;

import android.content.res.Resources;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\n\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lcom/facebook/internal/logging/dumpsys/ResourcesUtil;", "", "()V", "getFallbackIdString", "", "resourceId", "", "getIdString", "r", "Landroid/content/res/Resources;", "getIdStringQuietly", "getResourcePackageId", "id", "facebook-core_release"})
public final class ResourcesUtil {
    public static final ResourcesUtil INSTANCE;

    @JvmStatic
    @NotNull
    public static final String getIdStringQuietly(@Nullable Resources r, int resourceId) {
        String string;
        try {
            string = ResourcesUtil.getIdString(r, resourceId);
        }
        catch (Resources.NotFoundException e) {
            string = INSTANCE.getFallbackIdString(resourceId);
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getIdString(@Nullable Resources r, int resourceId) throws Resources.NotFoundException {
        if (r == null) {
            return INSTANCE.getFallbackIdString(resourceId);
        }
        String prefix = null;
        String prefixSeparator = null;
        switch (INSTANCE.getResourcePackageId(resourceId)) {
            case 127: {
                prefix = "";
                prefixSeparator = "";
                break;
            }
            default: {
                String string = r.getResourcePackageName(resourceId);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"r.getResourcePackageName(resourceId)");
                prefix = string;
                prefixSeparator = ":";
            }
        }
        String typeName = r.getResourceTypeName(resourceId);
        String entryName = r.getResourceEntryName(resourceId);
        StringBuilder sb = new StringBuilder(1 + prefix.length() + prefixSeparator.length() + typeName.length() + 1 + entryName.length());
        sb.append("@");
        sb.append(prefix);
        sb.append(prefixSeparator);
        sb.append(typeName);
        sb.append("/");
        sb.append(entryName);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String getFallbackIdString(int resourceId) {
        return "#" + Integer.toHexString(resourceId);
    }

    private final int getResourcePackageId(int id) {
        return id >>> 24 & 0xFF;
    }

    private ResourcesUtil() {
    }

    static {
        ResourcesUtil resourcesUtil;
        INSTANCE = resourcesUtil = new ResourcesUtil();
    }
}

