/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument.crashshield;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookSdk;
import com.facebook.internal.instrument.ExceptionAnalyzer;
import com.facebook.internal.instrument.InstrumentData;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0007J\u001a\u0010\f\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0001H\u0007J\b\u0010\u0010\u001a\u00020\bH\u0007J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0001H\u0007J\u0012\u0010\u0012\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0007J\b\u0010\u0013\u001a\u00020\nH\u0007J\b\u0010\u0014\u001a\u00020\nH\u0007J\u0012\u0010\u0015\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00010\u0001 \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/internal/instrument/crashshield/CrashShieldHandler;", "", "()V", "crashingObjects", "", "kotlin.jvm.PlatformType", "", "enabled", "", "disable", "", "enable", "handleThrowable", "e", "", "o", "isDebug", "isObjectCrashing", "methodFinished", "reset", "resetCrashingObjects", "scheduleCrashInDebug", "facebook-core_release"})
public final class CrashShieldHandler {
    private static final Set<Object> crashingObjects;
    private static boolean enabled;
    public static final CrashShieldHandler INSTANCE;

    @JvmStatic
    public static final void enable() {
        enabled = true;
    }

    @JvmStatic
    @VisibleForTesting
    public static final void disable() {
        enabled = false;
    }

    @JvmStatic
    public static final void handleThrowable(@Nullable Throwable e, @NotNull Object o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        if (!enabled) {
            return;
        }
        crashingObjects.add(o);
        if (FacebookSdk.getAutoLogAppEventsEnabled()) {
            ExceptionAnalyzer.execute(e);
            InstrumentData.Builder.build(e, InstrumentData.Type.CrashShield).save();
        }
        CrashShieldHandler.scheduleCrashInDebug(e);
    }

    @JvmStatic
    public static final boolean isObjectCrashing(@NotNull Object o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        return crashingObjects.contains(o);
    }

    @JvmStatic
    public static final void methodFinished(@Nullable Object o) {
    }

    @JvmStatic
    public static final void reset() {
        CrashShieldHandler.resetCrashingObjects();
    }

    @JvmStatic
    public static final void resetCrashingObjects() {
        crashingObjects.clear();
    }

    @JvmStatic
    @VisibleForTesting
    public static final boolean isDebug() {
        return false;
    }

    @JvmStatic
    @VisibleForTesting
    public static final void scheduleCrashInDebug(@Nullable Throwable e) {
        if (CrashShieldHandler.isDebug()) {
            new Handler(Looper.getMainLooper()).post(new Runnable(e){
                final /* synthetic */ Throwable $e;

                public void run() {
                    throw (Throwable)new RuntimeException(this.$e);
                }
                {
                    this.$e = $captured_local_variable$0;
                }
            });
        }
    }

    private CrashShieldHandler() {
    }

    static {
        CrashShieldHandler crashShieldHandler;
        INSTANCE = crashShieldHandler = new CrashShieldHandler();
        crashingObjects = Collections.newSetFromMap(new WeakHashMap());
    }
}

