/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import com.facebook.FacebookSdk;
import com.facebook.LoggingBehavior;
import com.facebook.internal.FileLruCache;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.util.Date;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000b\u0018\u0000 )2\u00020\u0001:\b'()*+,-.B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0016\u001a\u00020\u0017J\u001f\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00032\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0087\u0002J\u0016\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0019J\u001c\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00032\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0007J\b\u0010 \u001a\u00020\u0017H\u0002J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u000bH\u0002J\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020\u0003H\u0016J\b\u0010&\u001a\u00020\u0017H\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/facebook/internal/FileLruCache;", "", "tag", "", "limits", "Lcom/facebook/internal/FileLruCache$Limits;", "(Ljava/lang/String;Lcom/facebook/internal/FileLruCache$Limits;)V", "condition", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "directory", "Ljava/io/File;", "isTrimInProgress", "", "isTrimPending", "lastClearCacheTime", "Ljava/util/concurrent/atomic/AtomicLong;", "location", "getLocation", "()Ljava/lang/String;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "clearCache", "", "get", "Ljava/io/InputStream;", "key", "contentTag", "interceptAndPut", "input", "openPutStream", "Ljava/io/OutputStream;", "postTrim", "renameToTargetAndTrim", "buffer", "sizeInBytesForTest", "", "toString", "trim", "BufferFile", "CloseCallbackOutputStream", "Companion", "CopyingInputStream", "Limits", "ModifiedFile", "StreamCloseCallback", "StreamHeader", "facebook-core_release"})
public final class FileLruCache {
    private final File directory;
    private boolean isTrimPending;
    private boolean isTrimInProgress;
    private final ReentrantLock lock;
    private final Condition condition;
    private final AtomicLong lastClearCacheTime;
    private final String tag;
    private final Limits limits;
    @NotNull
    private static final String TAG;
    private static final String HEADER_CACHEKEY_KEY = "key";
    private static final String HEADER_CACHE_CONTENT_TAG_KEY = "tag";
    private static final AtomicLong bufferIndex;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long sizeInBytesForTest() {
        Lock lock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            while (this.isTrimPending || this.isTrimInProgress) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException interruptedException) {}
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        File[] files = this.directory.listFiles();
        long total = 0L;
        if (files != null) {
            for (File file : files) {
                total += file.length();
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @Nullable
    public final InputStream get(@NotNull String key, @Nullable String contentTag) throws IOException {
        boolean success;
        BufferedInputStream buffered;
        File file;
        block10: {
            JSONObject header;
            block9: {
                JSONObject jSONObject;
                block8: {
                    InputStream inputStream;
                    FileInputStream fileInputStream;
                    Intrinsics.checkNotNullParameter((Object)key, (String)HEADER_CACHEKEY_KEY);
                    file = new File(this.directory, Utility.md5hash(key));
                    FileInputStream input = null;
                    try {
                        fileInputStream = new FileInputStream(file);
                    }
                    catch (IOException e) {
                        return null;
                    }
                    input = fileInputStream;
                    buffered = new BufferedInputStream(input, 8192);
                    success = false;
                    try {
                        if (StreamHeader.INSTANCE.readHeader(buffered) != null) break block8;
                        inputStream = null;
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            buffered.close();
                        }
                        throw throwable;
                    }
                    buffered.close();
                    return inputStream;
                }
                header = jSONObject;
                String foundKey = header.optString(HEADER_CACHEKEY_KEY);
                if (!(Intrinsics.areEqual((Object)foundKey, (Object)key) ^ true)) break block9;
                InputStream inputStream = null;
                buffered.close();
                return inputStream;
            }
            String headerContentTag = header.optString(HEADER_CACHE_CONTENT_TAG_KEY, null);
            if (contentTag != null || !(Intrinsics.areEqual((Object)contentTag, (Object)headerContentTag) ^ true)) break block10;
            InputStream inputStream = null;
            buffered.close();
            return inputStream;
        }
        long accessTime = new Date().getTime();
        Logger.Companion.log(LoggingBehavior.CACHE, TAG, "Setting lastModified to " + Long.valueOf(accessTime) + " for " + file.getName());
        file.setLastModified(accessTime);
        success = true;
        InputStream inputStream = buffered;
        return inputStream;
    }

    public static /* synthetic */ InputStream get$default(FileLruCache fileLruCache, String string, String string2, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return fileLruCache.get(string, string2);
    }

    @JvmOverloads
    @Nullable
    public final InputStream get(@NotNull String key) throws IOException {
        return FileLruCache.get$default(this, key, null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final OutputStream openPutStream(@NotNull String key, @Nullable String contentTag) throws IOException {
        OutputStream outputStream;
        FileOutputStream fileOutputStream;
        Intrinsics.checkNotNullParameter((Object)key, (String)HEADER_CACHEKEY_KEY);
        File buffer = BufferFile.INSTANCE.newFile(this.directory);
        buffer.delete();
        if (!buffer.createNewFile()) {
            throw (Throwable)new IOException("Could not create file at " + buffer.getAbsolutePath());
        }
        FileOutputStream file = null;
        try {
            fileOutputStream = new FileOutputStream(buffer);
        }
        catch (FileNotFoundException e) {
            Logger.Companion.log(LoggingBehavior.CACHE, 5, TAG, "Error creating buffer output stream: " + e);
            throw (Throwable)new IOException(e.getMessage());
        }
        file = fileOutputStream;
        long bufferFileCreateTime = System.currentTimeMillis();
        StreamCloseCallback renameToTargetCallback2 = new StreamCloseCallback(this, bufferFileCreateTime, buffer, key){
            final /* synthetic */ FileLruCache this$0;
            final /* synthetic */ long $bufferFileCreateTime;
            final /* synthetic */ File $buffer;
            final /* synthetic */ String $key;

            public void onClose() {
                if (this.$bufferFileCreateTime < FileLruCache.access$getLastClearCacheTime$p(this.this$0).get()) {
                    this.$buffer.delete();
                } else {
                    FileLruCache.access$renameToTargetAndTrim(this.this$0, this.$key, this.$buffer);
                }
            }
            {
                this.this$0 = this$0;
                this.$bufferFileCreateTime = $captured_local_variable$1;
                this.$buffer = $captured_local_variable$2;
                this.$key = $captured_local_variable$3;
            }
        };
        CloseCallbackOutputStream cleanup = new CloseCallbackOutputStream(file, renameToTargetCallback2);
        BufferedOutputStream buffered = new BufferedOutputStream(cleanup, 8192);
        boolean success = false;
        try {
            JSONObject header = new JSONObject();
            header.put(HEADER_CACHEKEY_KEY, (Object)key);
            if (!Utility.isNullOrEmpty(contentTag)) {
                header.put(HEADER_CACHE_CONTENT_TAG_KEY, (Object)contentTag);
            }
            StreamHeader.INSTANCE.writeHeader(buffered, header);
            success = true;
            outputStream = buffered;
        }
        catch (JSONException e) {
            try {
                Logger.Companion.log(LoggingBehavior.CACHE, 5, TAG, "Error creating JSON header for cache file: " + (Object)((Object)e));
                throw (Throwable)new IOException(e.getMessage());
            }
            catch (Throwable throwable) {
                if (!success) {
                    buffered.close();
                }
                throw throwable;
            }
        }
        return outputStream;
    }

    public static /* synthetic */ OutputStream openPutStream$default(FileLruCache fileLruCache, String string, String string2, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return fileLruCache.openPutStream(string, string2);
    }

    @JvmOverloads
    @NotNull
    public final OutputStream openPutStream(@NotNull String key) throws IOException {
        return FileLruCache.openPutStream$default(this, key, null, 2, null);
    }

    public final void clearCache() {
        File[] filesToDelete = this.directory.listFiles(BufferFile.INSTANCE.excludeBufferFiles());
        this.lastClearCacheTime.set(System.currentTimeMillis());
        if (filesToDelete != null) {
            FacebookSdk.getExecutor().execute(new Runnable(filesToDelete){
                final /* synthetic */ File[] $filesToDelete;

                public final void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        for (File file : this.$filesToDelete) {
                            file.delete();
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
                {
                    this.$filesToDelete = fileArray;
                }
            });
        }
    }

    @NotNull
    public final String getLocation() {
        String string = this.directory.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"directory.path");
        return string;
    }

    private final void renameToTargetAndTrim(String key, File buffer) {
        File target = new File(this.directory, Utility.md5hash(key));
        if (!buffer.renameTo(target)) {
            buffer.delete();
        }
        this.postTrim();
    }

    @NotNull
    public final InputStream interceptAndPut(@NotNull String key, @NotNull InputStream input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)key, (String)HEADER_CACHEKEY_KEY);
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        OutputStream output = FileLruCache.openPutStream$default(this, key, null, 2, null);
        return new CopyingInputStream(input, output);
    }

    @NotNull
    public String toString() {
        return "{FileLruCache: tag:" + this.tag + " file:" + this.directory.getName() + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void postTrim() {
        Lock lock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            if (!this.isTrimPending) {
                this.isTrimPending = true;
                FacebookSdk.getExecutor().execute(new Runnable(this){
                    final /* synthetic */ FileLruCache this$0;
                    {
                        this.this$0 = fileLruCache;
                    }

                    public final void run() {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            FileLruCache.access$trim(this.this$0);
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                });
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void trim() {
        Lock lock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            this.isTrimPending = false;
            this.isTrimInProgress = true;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        try {
            File file;
            Logger.Companion.log(LoggingBehavior.CACHE, TAG, "trim started");
            PriorityQueue<ModifiedFile> heap = new PriorityQueue<ModifiedFile>();
            long size = 0L;
            long count = 0L;
            File[] filesToTrim = this.directory.listFiles(BufferFile.INSTANCE.excludeBufferFiles());
            if (filesToTrim != null) {
                File[] fileArray = filesToTrim;
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File file2 = file = fileArray[i];
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                    ModifiedFile modified = new ModifiedFile(file2);
                    heap.add(modified);
                    Logger.Companion.log(LoggingBehavior.CACHE, TAG, "  trim considering time=" + Long.valueOf(modified.getModified()) + " name=" + modified.getFile().getName());
                    size += file.length();
                    long l = count;
                    count = l + 1L;
                }
            }
            while (size > (long)this.limits.getByteCount() || count > (long)this.limits.getFileCount()) {
                file = ((ModifiedFile)heap.remove()).getFile();
                Logger.Companion.log(LoggingBehavior.CACHE, TAG, "  trim removing " + file.getName());
                size -= file.length();
                long l = count;
                count = l + -1L;
                file.delete();
            }
        }
        finally {
            lock = this.lock;
            boolean bl4 = false;
            boolean bl5 = false;
            lock.lock();
            try {
                boolean bl6 = false;
                this.isTrimInProgress = false;
                this.condition.signalAll();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
    }

    public FileLruCache(@NotNull String tag, @NotNull Limits limits) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)HEADER_CACHE_CONTENT_TAG_KEY);
        Intrinsics.checkNotNullParameter((Object)limits, (String)"limits");
        this.tag = tag;
        this.limits = limits;
        this.directory = new File(FacebookSdk.getCacheDir(), this.tag);
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.lastClearCacheTime = new AtomicLong(0L);
        if (this.directory.mkdirs() || this.directory.isDirectory()) {
            BufferFile.INSTANCE.deleteAll(this.directory);
        }
    }

    static {
        Companion = new Companion(null);
        String string = FileLruCache.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileLruCache::class.java.simpleName");
        TAG = string;
        bufferIndex = new AtomicLong();
    }

    public static final /* synthetic */ AtomicLong access$getLastClearCacheTime$p(FileLruCache $this) {
        return $this.lastClearCacheTime;
    }

    public static final /* synthetic */ void access$renameToTargetAndTrim(FileLruCache $this, String key, File buffer) {
        $this.renameToTargetAndTrim(key, buffer);
    }

    public static final /* synthetic */ void access$trim(FileLruCache $this) {
        $this.trim();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/internal/FileLruCache$BufferFile;", "", "()V", "FILE_NAME_PREFIX", "", "filterExcludeBufferFiles", "Ljava/io/FilenameFilter;", "filterExcludeNonBufferFiles", "deleteAll", "", "root", "Ljava/io/File;", "excludeBufferFiles", "excludeNonBufferFiles", "newFile", "facebook-core_release"})
    private static final class BufferFile {
        private static final String FILE_NAME_PREFIX = "buffer";
        private static final FilenameFilter filterExcludeBufferFiles;
        private static final FilenameFilter filterExcludeNonBufferFiles;
        public static final BufferFile INSTANCE;

        public final void deleteAll(@NotNull File root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            File[] filesToDelete = root.listFiles(this.excludeNonBufferFiles());
            if (filesToDelete != null) {
                for (File file : filesToDelete) {
                    file.delete();
                }
            }
        }

        @NotNull
        public final FilenameFilter excludeBufferFiles() {
            return filterExcludeBufferFiles;
        }

        @NotNull
        public final FilenameFilter excludeNonBufferFiles() {
            return filterExcludeNonBufferFiles;
        }

        @NotNull
        public final File newFile(@Nullable File root) {
            String name = FILE_NAME_PREFIX + String.valueOf(bufferIndex.incrementAndGet());
            return new File(root, name);
        }

        private BufferFile() {
        }

        static {
            BufferFile bufferFile;
            INSTANCE = bufferFile = new BufferFile();
            filterExcludeBufferFiles = filterExcludeBufferFiles.1.INSTANCE;
            filterExcludeNonBufferFiles = filterExcludeNonBufferFiles.1.INSTANCE;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/internal/FileLruCache$StreamHeader;", "", "()V", "HEADER_VERSION", "", "readHeader", "Lorg/json/JSONObject;", "stream", "Ljava/io/InputStream;", "writeHeader", "", "Ljava/io/OutputStream;", "header", "facebook-core_release"})
    private static final class StreamHeader {
        private static final int HEADER_VERSION = 0;
        public static final StreamHeader INSTANCE;

        public final void writeHeader(@NotNull OutputStream stream, @NotNull JSONObject header) throws IOException {
            String headerString;
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            String string = header.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"header.toString()");
            String string2 = headerString = string;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] headerBytes = byArray;
            stream.write(0);
            stream.write(headerBytes.length >> 16 & 0xFF);
            stream.write(headerBytes.length >> 8 & 0xFF);
            stream.write(headerBytes.length >> 0 & 0xFF);
            stream.write(headerBytes);
        }

        @Nullable
        public final JSONObject readHeader(@NotNull InputStream stream) throws IOException {
            JSONObject jSONObject;
            int readCount;
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            int version = stream.read();
            if (version != 0) {
                return null;
            }
            int headerSize = 0;
            int n = 3;
            boolean bl = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl2 = false;
                int b = stream.read();
                if (b == -1) {
                    Logger.Companion.log(LoggingBehavior.CACHE, Companion.getTAG(), "readHeader: stream.read returned -1 while reading header size");
                    return null;
                }
                headerSize <<= 8;
                headerSize += b & 0xFF;
            }
            byte[] headerBytes = new byte[headerSize];
            for (int count = 0; count < headerBytes.length; count += readCount) {
                readCount = stream.read(headerBytes, count, headerBytes.length - count);
                if (readCount >= 1) continue;
                Logger.Companion.log(LoggingBehavior.CACHE, Companion.getTAG(), "readHeader: stream.read stopped at " + Integer.valueOf(count) + " when expected " + headerBytes.length);
                return null;
            }
            n3 = 0;
            String headerString = new String(headerBytes, Charsets.UTF_8);
            JSONObject header = null;
            JSONTokener tokener = new JSONTokener(headerString);
            try {
                Object parsed = tokener.nextValue();
                if (!(parsed instanceof JSONObject)) {
                    Logger.Companion.log(LoggingBehavior.CACHE, Companion.getTAG(), "readHeader: expected JSONObject, got " + parsed.getClass().getCanonicalName());
                    return null;
                }
                jSONObject = (JSONObject)parsed;
            }
            catch (JSONException e) {
                throw (Throwable)new IOException(e.getMessage());
            }
            header = jSONObject;
            return header;
        }

        private StreamHeader() {
        }

        static {
            StreamHeader streamHeader;
            INSTANCE = streamHeader = new StreamHeader();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0011H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/facebook/internal/FileLruCache$CloseCallbackOutputStream;", "Ljava/io/OutputStream;", "innerStream", "callback", "Lcom/facebook/internal/FileLruCache$StreamCloseCallback;", "(Ljava/io/OutputStream;Lcom/facebook/internal/FileLruCache$StreamCloseCallback;)V", "getCallback", "()Lcom/facebook/internal/FileLruCache$StreamCloseCallback;", "getInnerStream", "()Ljava/io/OutputStream;", "close", "", "flush", "write", "buffer", "", "offset", "", "count", "oneByte", "facebook-core_release"})
    private static final class CloseCallbackOutputStream
    extends OutputStream {
        @NotNull
        private final OutputStream innerStream;
        @NotNull
        private final StreamCloseCallback callback;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.innerStream.close();
            }
            finally {
                this.callback.onClose();
            }
        }

        @Override
        public void flush() throws IOException {
            this.innerStream.flush();
        }

        @Override
        public void write(@NotNull byte[] buffer, int offset, int count) throws IOException {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            this.innerStream.write(buffer, offset, count);
        }

        @Override
        public void write(@NotNull byte[] buffer) throws IOException {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            this.innerStream.write(buffer);
        }

        @Override
        public void write(int oneByte) throws IOException {
            this.innerStream.write(oneByte);
        }

        @NotNull
        public final OutputStream getInnerStream() {
            return this.innerStream;
        }

        @NotNull
        public final StreamCloseCallback getCallback() {
            return this.callback;
        }

        public CloseCallbackOutputStream(@NotNull OutputStream innerStream, @NotNull StreamCloseCallback callback2) {
            Intrinsics.checkNotNullParameter((Object)innerStream, (String)"innerStream");
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            this.innerStream = innerStream;
            this.callback = callback2;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\b\u0010\u0017\u001a\u00020\rH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/facebook/internal/FileLruCache$CopyingInputStream;", "Ljava/io/InputStream;", "input", "output", "Ljava/io/OutputStream;", "(Ljava/io/InputStream;Ljava/io/OutputStream;)V", "getInput", "()Ljava/io/InputStream;", "getOutput", "()Ljava/io/OutputStream;", "available", "", "close", "", "mark", "readlimit", "markSupported", "", "read", "buffer", "", "offset", "length", "reset", "skip", "", "byteCount", "facebook-core_release"})
    private static final class CopyingInputStream
    extends InputStream {
        @NotNull
        private final InputStream input;
        @NotNull
        private final OutputStream output;

        @Override
        public int available() throws IOException {
            return this.input.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.input.close();
            }
            finally {
                this.output.close();
            }
        }

        @Override
        public void mark(int readlimit) {
            throw (Throwable)new UnsupportedOperationException();
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read(@NotNull byte[] buffer) throws IOException {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            int count = this.input.read(buffer);
            if (count > 0) {
                this.output.write(buffer, 0, count);
            }
            return count;
        }

        @Override
        public int read() throws IOException {
            int b = this.input.read();
            if (b >= 0) {
                this.output.write(b);
            }
            return b;
        }

        @Override
        public int read(@NotNull byte[] buffer, int offset, int length) throws IOException {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            int count = this.input.read(buffer, offset, length);
            if (count > 0) {
                this.output.write(buffer, offset, count);
            }
            return count;
        }

        @Override
        public synchronized void reset() {
            throw (Throwable)new UnsupportedOperationException();
        }

        @Override
        public long skip(long byteCount) throws IOException {
            long total;
            int count;
            byte[] buffer = new byte[1024];
            for (total = 0L; total < byteCount; total += (long)count) {
                count = this.read(buffer, 0, (int)Math.min(byteCount - total, (long)buffer.length));
                if (count >= 0) continue;
                return total;
            }
            return total;
        }

        @NotNull
        public final InputStream getInput() {
            return this.input;
        }

        @NotNull
        public final OutputStream getOutput() {
            return this.output;
        }

        public CopyingInputStream(@NotNull InputStream input, @NotNull OutputStream output) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            this.input = input;
            this.output = output;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lcom/facebook/internal/FileLruCache$Limits;", "", "()V", "value", "", "byteCount", "getByteCount", "()I", "setByteCount", "(I)V", "fileCount", "getFileCount", "setFileCount", "facebook-core_release"})
    public static final class Limits {
        private int byteCount = 0x100000;
        private int fileCount = 1024;

        public final int getByteCount() {
            return this.byteCount;
        }

        public final void setByteCount(int value) {
            if (value < 0) {
                throw (Throwable)new InvalidParameterException("Cache byte-count limit must be >= 0");
            }
            this.byteCount = value;
        }

        public final int getFileCount() {
            return this.fileCount;
        }

        public final void setFileCount(int value) {
            if (value < 0) {
                throw (Throwable)new InvalidParameterException("Cache file count limit must be >= 0");
            }
            this.fileCount = value;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/facebook/internal/FileLruCache$ModifiedFile;", "", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "modified", "", "getModified", "()J", "compareTo", "", "another", "equals", "", "", "hashCode", "Companion", "facebook-core_release"})
    private static final class ModifiedFile
    implements Comparable<ModifiedFile> {
        private final long modified;
        @NotNull
        private final File file;
        private static final int HASH_SEED = 29;
        private static final int HASH_MULTIPLIER = 37;
        public static final Companion Companion = new Companion(null);

        public final long getModified() {
            return this.modified;
        }

        @Override
        public int compareTo(@NotNull ModifiedFile another) {
            Intrinsics.checkNotNullParameter((Object)another, (String)"another");
            return this.modified < another.modified ? -1 : (this.modified > another.modified ? 1 : this.file.compareTo(another.file));
        }

        public boolean equals(@Nullable Object another) {
            return another instanceof ModifiedFile && this.compareTo((ModifiedFile)another) == 0;
        }

        public int hashCode() {
            int result = 29;
            result = result * 37 + this.file.hashCode();
            result = result * 37 + (int)(this.modified % (long)Integer.MAX_VALUE);
            return result;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public ModifiedFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.modified = this.file.lastModified();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/internal/FileLruCache$ModifiedFile$Companion;", "", "()V", "HASH_MULTIPLIER", "", "HASH_SEED", "facebook-core_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e2\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/facebook/internal/FileLruCache$StreamCloseCallback;", "", "onClose", "", "facebook-core_release"})
    private static interface StreamCloseCallback {
        public void onClose();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/facebook/internal/FileLruCache$Companion;", "", "()V", "HEADER_CACHEKEY_KEY", "", "HEADER_CACHE_CONTENT_TAG_KEY", "TAG", "getTAG", "()Ljava/lang/String;", "bufferIndex", "Ljava/util/concurrent/atomic/AtomicLong;", "facebook-core_release"})
    public static final class Companion {
        @NotNull
        public final String getTAG() {
            return TAG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

