/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.suggestedevents;

import android.app.Activity;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewTreeObserver;
import com.facebook.appevents.codeless.internal.SensitiveUserDataUtils;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.appevents.suggestedevents.SuggestedEventViewHierarchy;
import com.facebook.appevents.suggestedevents.ViewOnClickListener;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

final class ViewObserver
implements ViewTreeObserver.OnGlobalLayoutListener {
    private static final String TAG = ViewObserver.class.getCanonicalName();
    private WeakReference<Activity> activityWeakReference;
    private final Handler uiThreadHandler;
    private AtomicBoolean isTracking;
    private static final Map<Integer, ViewObserver> observers = new HashMap<Integer, ViewObserver>();
    private static final int MAX_TEXT_LENGTH = 300;

    static void startTrackingActivity(Activity activity) {
        if (CrashShieldHandler.isObjectCrashing(ViewObserver.class)) {
            return;
        }
        try {
            Activity activity2;
            int key = activity2.hashCode();
            if (!observers.containsKey(key)) {
                ViewObserver observer = new ViewObserver(activity2);
                observers.put(key, observer);
                observer.startTracking();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewObserver.class);
            return;
        }
    }

    static void stopTrackingActivity(Activity activity) {
        if (CrashShieldHandler.isObjectCrashing(ViewObserver.class)) {
            return;
        }
        try {
            Activity activity2;
            int key = activity2.hashCode();
            if (observers.containsKey(key)) {
                ViewObserver observer = observers.get(key);
                observers.remove(key);
                observer.stopTracking();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewObserver.class);
            return;
        }
    }

    private ViewObserver(Activity activity) {
        this.activityWeakReference = new WeakReference<Activity>(activity);
        this.uiThreadHandler = new Handler(Looper.getMainLooper());
        this.isTracking = new AtomicBoolean(false);
    }

    private void startTracking() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            if (this.isTracking.getAndSet(true)) {
                return;
            }
            View rootView = AppEventUtility.getRootView((Activity)this.activityWeakReference.get());
            if (rootView == null) {
                return;
            }
            ViewTreeObserver observer = rootView.getViewTreeObserver();
            if (observer.isAlive()) {
                observer.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                this.process();
                Activity activity = (Activity)this.activityWeakReference.get();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    private void stopTracking() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            if (!this.isTracking.getAndSet(false)) {
                return;
            }
            View rootView = AppEventUtility.getRootView((Activity)this.activityWeakReference.get());
            if (rootView == null) {
                return;
            }
            ViewTreeObserver observer = rootView.getViewTreeObserver();
            if (!observer.isAlive()) {
                return;
            }
            if (Build.VERSION.SDK_INT < 16) {
                observer.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                observer.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    public void onGlobalLayout() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            this.process();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    private void process() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        try {
                            View rootView = AppEventUtility.getRootView((Activity)ViewObserver.access$000(ViewObserver.this).get());
                            Activity activity = (Activity)ViewObserver.access$000(ViewObserver.this).get();
                            if (rootView == null || activity == null) {
                                return;
                            }
                            List<View> clickableViews = SuggestedEventViewHierarchy.getAllClickableViews(rootView);
                            for (View view : clickableViews) {
                                String text;
                                if (SensitiveUserDataUtils.isSensitiveUserData(view) || (text = SuggestedEventViewHierarchy.getTextOfViewRecursively(view)).isEmpty() || text.length() > 300) continue;
                                ViewOnClickListener.attachListener(view, rootView, activity.getLocalClassName());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            };
            if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
                runnable2.run();
            } else {
                this.uiThreadHandler.post(runnable2);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    static /* synthetic */ WeakReference access$000(ViewObserver viewObserver) {
        if (CrashShieldHandler.isObjectCrashing(ViewObserver.class)) {
            return null;
        }
        try {
            ViewObserver x0;
            return x0.activityWeakReference;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewObserver.class);
            return null;
        }
    }
}

