/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ondeviceprocessing;

import android.os.Bundle;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.eventdeactivation.EventDeactivationManager;
import com.facebook.appevents.ondeviceprocessing.RemoteServiceWrapper;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007J\u001e\u0010\r\u001a\u00020\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/facebook/appevents/ondeviceprocessing/RemoteServiceParametersHelper;", "", "()V", "TAG", "", "buildEventsBundle", "Landroid/os/Bundle;", "eventType", "Lcom/facebook/appevents/ondeviceprocessing/RemoteServiceWrapper$EventType;", "applicationId", "appEvents", "", "Lcom/facebook/appevents/AppEvent;", "buildEventsJson", "Lorg/json/JSONArray;", "includeImplicitEvents", "", "facebook-core_release"})
public final class RemoteServiceParametersHelper {
    private static final String TAG;
    public static final RemoteServiceParametersHelper INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final Bundle buildEventsBundle(@NotNull RemoteServiceWrapper.EventType eventType, @NotNull String string, @NotNull List<AppEvent> list) {
        if (CrashShieldHandler.isObjectCrashing(RemoteServiceParametersHelper.class)) {
            return null;
        }
        try {
            void appEvents;
            void applicationId;
            RemoteServiceWrapper.EventType eventType2;
            Intrinsics.checkNotNullParameter((Object)((Object)eventType2), (String)"eventType");
            Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)appEvents, (String)"appEvents");
            Bundle eventBundle = new Bundle();
            eventBundle.putString("event", eventType2.toString());
            eventBundle.putString("app_id", (String)applicationId);
            if (RemoteServiceWrapper.EventType.CUSTOM_APP_EVENTS == eventType2) {
                JSONArray filteredEventsJson = INSTANCE.buildEventsJson((List<AppEvent>)appEvents, (String)applicationId);
                if (filteredEventsJson.length() == 0) {
                    return null;
                }
                eventBundle.putString("custom_events", filteredEventsJson.toString());
            }
            return eventBundle;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, RemoteServiceParametersHelper.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JSONArray buildEventsJson(List<AppEvent> list, String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void applicationId;
            void appEvents;
            JSONArray filteredEventsJsonArray = new JSONArray();
            List mutableAppEvents = CollectionsKt.toMutableList((Collection)((Collection)appEvents));
            EventDeactivationManager.processEvents(mutableAppEvents);
            boolean includeImplicitEvents = this.includeImplicitEvents((String)applicationId);
            for (AppEvent event : mutableAppEvents) {
                if (event.isChecksumValid()) {
                    boolean isExplicitEvent;
                    boolean bl = isExplicitEvent = !event.isImplicit();
                    if (!isExplicitEvent && (!event.isImplicit() || !includeImplicitEvents)) continue;
                    filteredEventsJsonArray.put((Object)event.getJsonObject());
                    continue;
                }
                Utility.logd(TAG, "Event with invalid checksum: " + event);
            }
            return filteredEventsJsonArray;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean includeImplicitEvents(String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            void applicationId;
            boolean supportsImplicitLogging = false;
            FetchedAppSettings appSettings = FetchedAppSettingsManager.queryAppSettings((String)applicationId, false);
            if (appSettings != null) {
                supportsImplicitLogging = appSettings.supportsImplicitLogging();
            }
            return supportsImplicitLogging;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    private RemoteServiceParametersHelper() {
    }

    static {
        RemoteServiceParametersHelper remoteServiceParametersHelper;
        INSTANCE = remoteServiceParametersHelper = new RemoteServiceParametersHelper();
        String string = RemoteServiceWrapper.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RemoteServiceWrapper::class.java.simpleName");
        TAG = string;
    }
}

