/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import com.facebook.FacebookSdk;
import com.facebook.bolts.AppLinks;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u0019\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u0003H\u0016J\u0006\u0010\u000b\u001a\u00020\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/facebook/appevents/internal/SourceApplicationInfo;", "", "callingApplicationPackage", "", "isOpenedByAppLink", "", "(Ljava/lang/String;Z)V", "getCallingApplicationPackage", "()Ljava/lang/String;", "()Z", "toString", "writeSourceApplicationInfoToDisk", "", "Companion", "Factory", "facebook-core_release"})
public final class SourceApplicationInfo {
    @Nullable
    private final String callingApplicationPackage;
    private final boolean isOpenedByAppLink;
    private static final String SOURCE_APPLICATION_HAS_BEEN_SET_BY_THIS_INTENT = "_fbSourceApplicationHasBeenSet";
    private static final String CALL_APPLICATION_PACKAGE_KEY = "com.facebook.appevents.SourceApplicationInfo.callingApplicationPackage";
    private static final String OPENED_BY_APP_LINK_KEY = "com.facebook.appevents.SourceApplicationInfo.openedByApplink";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String toString() {
        String openType = "Unclassified";
        if (this.isOpenedByAppLink) {
            openType = "Applink";
        }
        return this.callingApplicationPackage != null ? openType + '(' + this.callingApplicationPackage + ')' : openType;
    }

    public final void writeSourceApplicationInfoToDisk() {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)FacebookSdk.getApplicationContext());
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(CALL_APPLICATION_PACKAGE_KEY, this.callingApplicationPackage);
        editor.putBoolean(OPENED_BY_APP_LINK_KEY, this.isOpenedByAppLink);
        editor.apply();
    }

    @Nullable
    public final String getCallingApplicationPackage() {
        return this.callingApplicationPackage;
    }

    public final boolean isOpenedByAppLink() {
        return this.isOpenedByAppLink;
    }

    private SourceApplicationInfo(String callingApplicationPackage, boolean isOpenedByAppLink) {
        this.callingApplicationPackage = callingApplicationPackage;
        this.isOpenedByAppLink = isOpenedByAppLink;
    }

    public /* synthetic */ SourceApplicationInfo(String callingApplicationPackage, boolean isOpenedByAppLink, DefaultConstructorMarker $constructor_marker) {
        this(callingApplicationPackage, isOpenedByAppLink);
    }

    @JvmStatic
    @Nullable
    public static final SourceApplicationInfo getStoredSourceApplicatioInfo() {
        return Companion.getStoredSourceApplicatioInfo();
    }

    @JvmStatic
    public static final void clearSavedSourceApplicationInfoFromDisk() {
        Companion.clearSavedSourceApplicationInfoFromDisk();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/facebook/appevents/internal/SourceApplicationInfo$Factory;", "", "()V", "create", "Lcom/facebook/appevents/internal/SourceApplicationInfo;", "activity", "Landroid/app/Activity;", "facebook-core_release"})
    public static final class Factory {
        public static final Factory INSTANCE;

        @JvmStatic
        @Nullable
        public static final SourceApplicationInfo create(@NotNull Activity activity) {
            String callingApplicationPackage;
            boolean openedByAppLink;
            block4: {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                openedByAppLink = false;
                callingApplicationPackage = "";
                ComponentName callingApplication = activity.getCallingActivity();
                if (callingApplication != null && Intrinsics.areEqual((Object)(callingApplicationPackage = callingApplication.getPackageName()), (Object)activity.getPackageName())) {
                    return null;
                }
                Intent openIntent = activity.getIntent();
                if (openIntent != null && !openIntent.getBooleanExtra(SourceApplicationInfo.SOURCE_APPLICATION_HAS_BEEN_SET_BY_THIS_INTENT, false)) {
                    openIntent.putExtra(SourceApplicationInfo.SOURCE_APPLICATION_HAS_BEEN_SET_BY_THIS_INTENT, true);
                    Bundle appLinkData = AppLinks.getAppLinkData(openIntent);
                    if (appLinkData != null) {
                        openedByAppLink = true;
                        Bundle appLinkReferrerData = appLinkData.getBundle("referer_app_link");
                        if (appLinkReferrerData != null) {
                            String appLinkReferrerPackage;
                            callingApplicationPackage = appLinkReferrerPackage = appLinkReferrerData.getString("package");
                        }
                    }
                }
                Intent intent = openIntent;
                if (intent == null) break block4;
                intent.putExtra(SourceApplicationInfo.SOURCE_APPLICATION_HAS_BEEN_SET_BY_THIS_INTENT, true);
            }
            return new SourceApplicationInfo(callingApplicationPackage, openedByAppLink, null);
        }

        private Factory() {
        }

        static {
            Factory factory;
            INSTANCE = factory = new Factory();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/facebook/appevents/internal/SourceApplicationInfo$Companion;", "", "()V", "CALL_APPLICATION_PACKAGE_KEY", "", "OPENED_BY_APP_LINK_KEY", "SOURCE_APPLICATION_HAS_BEEN_SET_BY_THIS_INTENT", "clearSavedSourceApplicationInfoFromDisk", "", "getStoredSourceApplicatioInfo", "Lcom/facebook/appevents/internal/SourceApplicationInfo;", "facebook-core_release"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final SourceApplicationInfo getStoredSourceApplicatioInfo() {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)FacebookSdk.getApplicationContext());
            if (!sharedPreferences.contains(SourceApplicationInfo.CALL_APPLICATION_PACKAGE_KEY)) {
                return null;
            }
            String callingApplicationPackage = sharedPreferences.getString(SourceApplicationInfo.CALL_APPLICATION_PACKAGE_KEY, null);
            boolean openedByAppLink = sharedPreferences.getBoolean(SourceApplicationInfo.OPENED_BY_APP_LINK_KEY, false);
            return new SourceApplicationInfo(callingApplicationPackage, openedByAppLink, null);
        }

        @JvmStatic
        public final void clearSavedSourceApplicationInfoFromDisk() {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)FacebookSdk.getApplicationContext());
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.remove(SourceApplicationInfo.CALL_APPLICATION_PACKAGE_KEY);
            editor.remove(SourceApplicationInfo.OPENED_BY_APP_LINK_KEY);
            editor.apply();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

