/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.facebook.FacebookSdk;
import com.facebook.appevents.internal.SourceApplicationInfo;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B%\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020$R \u0010\b\u001a\u0004\u0018\u00010\u00038FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\u0017\u0010\n\"\u0004\b\u0018\u0010\fR\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u001c\u0010\nR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006'"}, d2={"Lcom/facebook/appevents/internal/SessionInfo;", "", "sessionStartTime", "", "sessionLastEventTime", "sessionId", "Ljava/util/UUID;", "(Ljava/lang/Long;Ljava/lang/Long;Ljava/util/UUID;)V", "diskRestoreTime", "getDiskRestoreTime", "()Ljava/lang/Long;", "setDiskRestoreTime", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "<set-?>", "", "interruptionCount", "getInterruptionCount", "()I", "getSessionId", "()Ljava/util/UUID;", "setSessionId", "(Ljava/util/UUID;)V", "getSessionLastEventTime", "setSessionLastEventTime", "sessionLength", "getSessionLength", "()J", "getSessionStartTime", "sourceApplicationInfo", "Lcom/facebook/appevents/internal/SourceApplicationInfo;", "getSourceApplicationInfo", "()Lcom/facebook/appevents/internal/SourceApplicationInfo;", "setSourceApplicationInfo", "(Lcom/facebook/appevents/internal/SourceApplicationInfo;)V", "incrementInterruptionCount", "", "writeSessionToDisk", "Companion", "facebook-core_release"})
public final class SessionInfo {
    private int interruptionCount;
    @Nullable
    private Long diskRestoreTime;
    @Nullable
    private SourceApplicationInfo sourceApplicationInfo;
    @Nullable
    private final Long sessionStartTime;
    @Nullable
    private Long sessionLastEventTime;
    @NotNull
    private UUID sessionId;
    private static final String LAST_SESSION_INFO_START_KEY = "com.facebook.appevents.SessionInfo.sessionStartTime";
    private static final String LAST_SESSION_INFO_END_KEY = "com.facebook.appevents.SessionInfo.sessionEndTime";
    private static final String INTERRUPTION_COUNT_KEY = "com.facebook.appevents.SessionInfo.interruptionCount";
    private static final String SESSION_ID_KEY = "com.facebook.appevents.SessionInfo.sessionId";
    public static final Companion Companion = new Companion(null);

    public final int getInterruptionCount() {
        return this.interruptionCount;
    }

    @Nullable
    public final Long getDiskRestoreTime() {
        Long l = this.diskRestoreTime;
        return l != null ? l : 0L;
    }

    public final void setDiskRestoreTime(@Nullable Long l) {
        this.diskRestoreTime = l;
    }

    @Nullable
    public final SourceApplicationInfo getSourceApplicationInfo() {
        return this.sourceApplicationInfo;
    }

    public final void setSourceApplicationInfo(@Nullable SourceApplicationInfo sourceApplicationInfo) {
        this.sourceApplicationInfo = sourceApplicationInfo;
    }

    public final void incrementInterruptionCount() {
        int n = this.interruptionCount;
        this.interruptionCount = n + 1;
    }

    public final long getSessionLength() {
        long l;
        if (this.sessionStartTime == null || this.sessionLastEventTime == null) {
            l = 0L;
        } else {
            Long l2 = this.sessionLastEventTime;
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (l2 == null) {
                boolean bl4 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            l = ((Number)l2).longValue() - this.sessionStartTime;
        }
        return l;
    }

    public final void writeSessionToDisk() {
        block1: {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)FacebookSdk.getApplicationContext());
            SharedPreferences.Editor editor = sharedPreferences.edit();
            Long l = this.sessionStartTime;
            editor.putLong(LAST_SESSION_INFO_START_KEY, l != null ? l : 0L);
            Long l2 = this.sessionLastEventTime;
            editor.putLong(LAST_SESSION_INFO_END_KEY, l2 != null ? l2 : 0L);
            editor.putInt(INTERRUPTION_COUNT_KEY, this.interruptionCount);
            editor.putString(SESSION_ID_KEY, this.sessionId.toString());
            editor.apply();
            if (this.sourceApplicationInfo == null) break block1;
            SourceApplicationInfo sourceApplicationInfo = this.sourceApplicationInfo;
            if (sourceApplicationInfo != null) {
                sourceApplicationInfo.writeSourceApplicationInfoToDisk();
            }
        }
    }

    @Nullable
    public final Long getSessionStartTime() {
        return this.sessionStartTime;
    }

    @Nullable
    public final Long getSessionLastEventTime() {
        return this.sessionLastEventTime;
    }

    public final void setSessionLastEventTime(@Nullable Long l) {
        this.sessionLastEventTime = l;
    }

    @NotNull
    public final UUID getSessionId() {
        return this.sessionId;
    }

    public final void setSessionId(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.sessionId = uUID;
    }

    @JvmOverloads
    public SessionInfo(@Nullable Long sessionStartTime, @Nullable Long sessionLastEventTime, @NotNull UUID sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        this.sessionStartTime = sessionStartTime;
        this.sessionLastEventTime = sessionLastEventTime;
        this.sessionId = sessionId;
    }

    public /* synthetic */ SessionInfo(Long l, Long l2, UUID uUID, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            UUID uUID2 = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"UUID.randomUUID()");
            uUID = uUID2;
        }
        this(l, l2, uUID);
    }

    @JvmOverloads
    public SessionInfo(@Nullable Long sessionStartTime, @Nullable Long sessionLastEventTime) {
        this(sessionStartTime, sessionLastEventTime, null, 4, null);
    }

    public static final /* synthetic */ int access$getInterruptionCount$p(SessionInfo $this) {
        return $this.interruptionCount;
    }

    @JvmStatic
    @Nullable
    public static final SessionInfo getStoredSessionInfo() {
        return Companion.getStoredSessionInfo();
    }

    @JvmStatic
    public static final void clearSavedSessionFromDisk() {
        Companion.clearSavedSessionFromDisk();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/appevents/internal/SessionInfo$Companion;", "", "()V", "INTERRUPTION_COUNT_KEY", "", "LAST_SESSION_INFO_END_KEY", "LAST_SESSION_INFO_START_KEY", "SESSION_ID_KEY", "clearSavedSessionFromDisk", "", "getStoredSessionInfo", "Lcom/facebook/appevents/internal/SessionInfo;", "facebook-core_release"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final SessionInfo getStoredSessionInfo() {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)FacebookSdk.getApplicationContext());
            long startTime = sharedPreferences.getLong(SessionInfo.LAST_SESSION_INFO_START_KEY, 0L);
            long endTime = sharedPreferences.getLong(SessionInfo.LAST_SESSION_INFO_END_KEY, 0L);
            String sessionIDStr = sharedPreferences.getString(SessionInfo.SESSION_ID_KEY, null);
            if (startTime == 0L || endTime == 0L || sessionIDStr == null) {
                return null;
            }
            SessionInfo sessionInfo = new SessionInfo(startTime, endTime, null, 4, null);
            sessionInfo.interruptionCount = sharedPreferences.getInt(SessionInfo.INTERRUPTION_COUNT_KEY, 0);
            sessionInfo.setSourceApplicationInfo(SourceApplicationInfo.Companion.getStoredSourceApplicatioInfo());
            sessionInfo.setDiskRestoreTime(System.currentTimeMillis());
            UUID uUID = UUID.fromString(sessionIDStr);
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.fromString(sessionIDStr)");
            sessionInfo.setSessionId(uUID);
            return sessionInfo;
        }

        @JvmStatic
        public final void clearSavedSessionFromDisk() {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)FacebookSdk.getApplicationContext());
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.remove(SessionInfo.LAST_SESSION_INFO_START_KEY);
            editor.remove(SessionInfo.LAST_SESSION_INFO_END_KEY);
            editor.remove(SessionInfo.INTERRUPTION_COUNT_KEY);
            editor.remove(SessionInfo.SESSION_ID_KEY);
            editor.apply();
            SourceApplicationInfo.Companion.clearSavedSourceApplicationInfoFromDisk();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

