/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.os.AsyncTask;
import androidx.annotation.VisibleForTesting;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u0012B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ%\u0010\u000b\u001a\u00020\u00042\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\r\"\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/facebook/appevents/internal/FileDownloadTask;", "Landroid/os/AsyncTask;", "", "Ljava/lang/Void;", "", "uriStr", "destFile", "Ljava/io/File;", "onSuccess", "Lcom/facebook/appevents/internal/FileDownloadTask$Callback;", "(Ljava/lang/String;Ljava/io/File;Lcom/facebook/appevents/internal/FileDownloadTask$Callback;)V", "doInBackground", "args", "", "([Ljava/lang/String;)Ljava/lang/Boolean;", "onPostExecute", "", "isSuccess", "Callback", "facebook-core_release"})
public final class FileDownloadTask
extends AsyncTask<String, Void, Boolean> {
    private final String uriStr;
    private final File destFile;
    private final Callback onSuccess;

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting(otherwise=4)
    @NotNull
    public Boolean doInBackground(String ... stringArray) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return null;
        }
        try {
            void args;
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            try {
                URLConnection conn;
                URL url = new URL(this.uriStr);
                URLConnection uRLConnection = conn = url.openConnection();
                Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"conn");
                int contentLength = uRLConnection.getContentLength();
                DataInputStream stream = new DataInputStream(url.openStream());
                byte[] buffer = new byte[contentLength];
                stream.readFully(buffer);
                stream.close();
                DataOutputStream fos = new DataOutputStream(new FileOutputStream(this.destFile));
                fos.write(buffer);
                fos.flush();
                fos.close();
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, (Object)this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onPostExecute(boolean bl) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void isSuccess;
            if (isSuccess != false) {
                this.onSuccess.onComplete(this.destFile);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, (Object)this);
            return;
        }
    }

    public FileDownloadTask(@NotNull String uriStr, @NotNull File destFile, @NotNull Callback onSuccess2) {
        Intrinsics.checkNotNullParameter((Object)uriStr, (String)"uriStr");
        Intrinsics.checkNotNullParameter((Object)destFile, (String)"destFile");
        Intrinsics.checkNotNullParameter((Object)onSuccess2, (String)"onSuccess");
        this.uriStr = uriStr;
        this.destFile = destFile;
        this.onSuccess = onSuccess2;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/facebook/appevents/internal/FileDownloadTask$Callback;", "", "onComplete", "", "file", "Ljava/io/File;", "facebook-core_release"})
    public static interface Callback {
        public void onComplete(@NotNull File var1);
    }
}

