/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.aam.MetadataIndexer;
import com.facebook.appevents.codeless.CodelessManager;
import com.facebook.appevents.iap.InAppPurchaseManager;
import com.facebook.appevents.internal.ActivityLifecycleTracker;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.appevents.internal.Constants;
import com.facebook.appevents.internal.SessionInfo;
import com.facebook.appevents.internal.SessionLogger;
import com.facebook.appevents.suggestedevents.SuggestedEventsManager;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.lang.ref.WeakReference;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\n\u0010 \u001a\u0004\u0018\u00010\rH\u0007J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0007J\b\u0010#\u001a\u00020$H\u0007J\b\u0010%\u001a\u00020$H\u0007J\u0012\u0010&\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010\rH\u0007J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\rH\u0002J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\rH\u0002J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\rH\u0007J\u001a\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-2\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/facebook/appevents/internal/ActivityLifecycleTracker;", "", "()V", "INCORRECT_IMPL_WARNING", "", "INTERRUPTION_THRESHOLD_MILLISECONDS", "", "TAG", "activityReferences", "", "appId", "currActivity", "Ljava/lang/ref/WeakReference;", "Landroid/app/Activity;", "currentActivityAppearTime", "currentFuture", "Ljava/util/concurrent/ScheduledFuture;", "currentFutureLock", "currentSession", "Lcom/facebook/appevents/internal/SessionInfo;", "foregroundActivityCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "sessionTimeoutInSeconds", "getSessionTimeoutInSeconds", "()I", "singleThreadExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "tracking", "Ljava/util/concurrent/atomic/AtomicBoolean;", "cancelCurrentTask", "", "getCurrentActivity", "getCurrentSessionGuid", "Ljava/util/UUID;", "isInBackground", "", "isTracking", "onActivityCreated", "activity", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "startTracking", "application", "Landroid/app/Application;", "facebook-core_release"})
public final class ActivityLifecycleTracker {
    private static final String TAG;
    private static final String INCORRECT_IMPL_WARNING = "Unexpected activity pause without a matching activity resume. Logging data may be incorrect. Make sure you call activateApp from your Application's onCreate method";
    private static final long INTERRUPTION_THRESHOLD_MILLISECONDS = 1000L;
    private static final ScheduledExecutorService singleThreadExecutor;
    private static volatile ScheduledFuture<?> currentFuture;
    private static final Object currentFutureLock;
    private static final AtomicInteger foregroundActivityCount;
    private static volatile SessionInfo currentSession;
    private static final AtomicBoolean tracking;
    private static String appId;
    private static long currentActivityAppearTime;
    private static int activityReferences;
    private static WeakReference<Activity> currActivity;
    public static final ActivityLifecycleTracker INSTANCE;

    @JvmStatic
    public static final void startTracking(@NotNull Application application, @Nullable String appId) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        if (!tracking.compareAndSet(false, true)) {
            return;
        }
        FeatureManager.checkFeature(FeatureManager.Feature.CodelessEvents, startTracking.1.INSTANCE);
        ActivityLifecycleTracker.appId = appId;
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Logger.Companion.log(LoggingBehavior.APP_EVENTS, ActivityLifecycleTracker.access$getTAG$p(ActivityLifecycleTracker.INSTANCE), "onActivityCreated");
                AppEventUtility.assertIsMainThread();
                ActivityLifecycleTracker.onActivityCreated(activity);
            }

            public void onActivityStarted(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                ActivityLifecycleTracker activityLifecycleTracker = ActivityLifecycleTracker.INSTANCE;
                int n = ActivityLifecycleTracker.access$getActivityReferences$p(activityLifecycleTracker);
                ActivityLifecycleTracker.access$setActivityReferences$p(activityLifecycleTracker, n + 1);
                Logger.Companion.log(LoggingBehavior.APP_EVENTS, ActivityLifecycleTracker.access$getTAG$p(ActivityLifecycleTracker.INSTANCE), "onActivityStarted");
            }

            public void onActivityResumed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Logger.Companion.log(LoggingBehavior.APP_EVENTS, ActivityLifecycleTracker.access$getTAG$p(ActivityLifecycleTracker.INSTANCE), "onActivityResumed");
                AppEventUtility.assertIsMainThread();
                ActivityLifecycleTracker.onActivityResumed(activity);
            }

            public void onActivityPaused(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Logger.Companion.log(LoggingBehavior.APP_EVENTS, ActivityLifecycleTracker.access$getTAG$p(ActivityLifecycleTracker.INSTANCE), "onActivityPaused");
                AppEventUtility.assertIsMainThread();
                ActivityLifecycleTracker.access$onActivityPaused(ActivityLifecycleTracker.INSTANCE, activity);
            }

            public void onActivityStopped(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Logger.Companion.log(LoggingBehavior.APP_EVENTS, ActivityLifecycleTracker.access$getTAG$p(ActivityLifecycleTracker.INSTANCE), "onActivityStopped");
                AppEventsLogger.Companion.onContextStop();
                ActivityLifecycleTracker activityLifecycleTracker = ActivityLifecycleTracker.INSTANCE;
                int n = ActivityLifecycleTracker.access$getActivityReferences$p(activityLifecycleTracker);
                ActivityLifecycleTracker.access$setActivityReferences$p(activityLifecycleTracker, n + -1);
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
                Logger.Companion.log(LoggingBehavior.APP_EVENTS, ActivityLifecycleTracker.access$getTAG$p(ActivityLifecycleTracker.INSTANCE), "onActivitySaveInstanceState");
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Logger.Companion.log(LoggingBehavior.APP_EVENTS, ActivityLifecycleTracker.access$getTAG$p(ActivityLifecycleTracker.INSTANCE), "onActivityDestroyed");
                ActivityLifecycleTracker.access$onActivityDestroyed(ActivityLifecycleTracker.INSTANCE, activity);
            }
        });
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final boolean isInBackground() {
        return activityReferences == 0;
    }

    @JvmStatic
    public static final boolean isTracking() {
        return tracking.get();
    }

    @JvmStatic
    @Nullable
    public static final UUID getCurrentSessionGuid() {
        UUID uUID;
        if (currentSession != null) {
            SessionInfo sessionInfo = currentSession;
            uUID = sessionInfo != null ? sessionInfo.getSessionId() : null;
        } else {
            uUID = null;
        }
        return uUID;
    }

    @JvmStatic
    public static final void onActivityCreated(@Nullable Activity activity) {
        singleThreadExecutor.execute(onActivityCreated.1.INSTANCE);
    }

    @JvmStatic
    public static final void onActivityResumed(@NotNull Activity activity) {
        long currentTime;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        currActivity = new WeakReference<Activity>(activity);
        foregroundActivityCount.incrementAndGet();
        INSTANCE.cancelCurrentTask();
        currentActivityAppearTime = currentTime = System.currentTimeMillis();
        String activityName = Utility.getActivityName((Context)activity);
        CodelessManager.onActivityResumed(activity);
        MetadataIndexer.onActivityResumed(activity);
        SuggestedEventsManager.trackActivity(activity);
        InAppPurchaseManager.startTracking();
        Context appContext = activity.getApplicationContext();
        Runnable handleActivityResume2 = new Runnable(currentTime, activityName, appContext){
            final /* synthetic */ long $currentTime;
            final /* synthetic */ String $activityName;
            final /* synthetic */ Context $appContext;

            public final void run() {
                if (CrashShieldHandler.isObjectCrashing(this)) {
                    return;
                }
                try {
                    Long lastEventTime;
                    SessionInfo sessionInfo = ActivityLifecycleTracker.access$getCurrentSession$p(ActivityLifecycleTracker.INSTANCE);
                    Long l = lastEventTime = sessionInfo != null ? sessionInfo.getSessionLastEventTime() : null;
                    if (ActivityLifecycleTracker.access$getCurrentSession$p(ActivityLifecycleTracker.INSTANCE) == null) {
                        ActivityLifecycleTracker.access$setCurrentSession$p(ActivityLifecycleTracker.INSTANCE, new SessionInfo(this.$currentTime, null, null, 4, null));
                        String string = ActivityLifecycleTracker.access$getAppId$p(ActivityLifecycleTracker.INSTANCE);
                        Context context = this.$appContext;
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
                        SessionLogger.logActivateApp(this.$activityName, null, string, context);
                    } else if (lastEventTime != null) {
                        long suspendTime = this.$currentTime - lastEventTime;
                        if (suspendTime > (long)(ActivityLifecycleTracker.access$getSessionTimeoutInSeconds$p(ActivityLifecycleTracker.INSTANCE) * 1000)) {
                            SessionLogger.logDeactivateApp(this.$activityName, ActivityLifecycleTracker.access$getCurrentSession$p(ActivityLifecycleTracker.INSTANCE), ActivityLifecycleTracker.access$getAppId$p(ActivityLifecycleTracker.INSTANCE));
                            String string = ActivityLifecycleTracker.access$getAppId$p(ActivityLifecycleTracker.INSTANCE);
                            Context context = this.$appContext;
                            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
                            SessionLogger.logActivateApp(this.$activityName, null, string, context);
                            ActivityLifecycleTracker.access$setCurrentSession$p(ActivityLifecycleTracker.INSTANCE, new SessionInfo(this.$currentTime, null, null, 4, null));
                        } else if (suspendTime > 1000L) {
                            SessionInfo sessionInfo2 = ActivityLifecycleTracker.access$getCurrentSession$p(ActivityLifecycleTracker.INSTANCE);
                            if (sessionInfo2 != null) {
                                sessionInfo2.incrementInterruptionCount();
                            }
                        }
                    }
                    SessionInfo sessionInfo3 = ActivityLifecycleTracker.access$getCurrentSession$p(ActivityLifecycleTracker.INSTANCE);
                    if (sessionInfo3 != null) {
                        sessionInfo3.setSessionLastEventTime(this.$currentTime);
                    }
                    SessionInfo sessionInfo4 = ActivityLifecycleTracker.access$getCurrentSession$p(ActivityLifecycleTracker.INSTANCE);
                    if (sessionInfo4 != null) {
                        sessionInfo4.writeSessionToDisk();
                    }
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable(throwable, this);
                    return;
                }
            }
            {
                this.$currentTime = l;
                this.$activityName = string;
                this.$appContext = context;
            }
        };
        singleThreadExecutor.execute(handleActivityResume2);
    }

    private final void onActivityPaused(Activity activity) {
        int count = foregroundActivityCount.decrementAndGet();
        if (count < 0) {
            foregroundActivityCount.set(0);
            Log.w((String)TAG, (String)INCORRECT_IMPL_WARNING);
        }
        this.cancelCurrentTask();
        long currentTime = System.currentTimeMillis();
        String activityName = Utility.getActivityName((Context)activity);
        CodelessManager.onActivityPaused(activity);
        Runnable handleActivityPaused2 = new Runnable(currentTime, activityName){
            final /* synthetic */ long $currentTime;
            final /* synthetic */ String $activityName;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                if (CrashShieldHandler.isObjectCrashing(this)) {
                    return;
                }
                try {
                    long appearTime;
                    if (ActivityLifecycleTracker.access$getCurrentSession$p(ActivityLifecycleTracker.INSTANCE) == null) {
                        ActivityLifecycleTracker.access$setCurrentSession$p(ActivityLifecycleTracker.INSTANCE, new SessionInfo(this.$currentTime, null, null, 4, null));
                    }
                    SessionInfo sessionInfo = ActivityLifecycleTracker.access$getCurrentSession$p(ActivityLifecycleTracker.INSTANCE);
                    if (sessionInfo != null) {
                        sessionInfo.setSessionLastEventTime(this.$currentTime);
                    }
                    if (ActivityLifecycleTracker.access$getForegroundActivityCount$p(ActivityLifecycleTracker.INSTANCE).get() <= 0) {
                        Runnable task2 = new Runnable(this){
                            final /* synthetic */ onActivityPaused.handleActivityPaused.1 this$0;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final void run() {
                                if (CrashShieldHandler.isObjectCrashing(this)) {
                                    return;
                                }
                                try {
                                    if (ActivityLifecycleTracker.access$getCurrentSession$p(ActivityLifecycleTracker.INSTANCE) == null) {
                                        ActivityLifecycleTracker.access$setCurrentSession$p(ActivityLifecycleTracker.INSTANCE, new SessionInfo(this.this$0.$currentTime, null, null, 4, null));
                                    }
                                    if (ActivityLifecycleTracker.access$getForegroundActivityCount$p(ActivityLifecycleTracker.INSTANCE).get() <= 0) {
                                        SessionLogger.logDeactivateApp(this.this$0.$activityName, ActivityLifecycleTracker.access$getCurrentSession$p(ActivityLifecycleTracker.INSTANCE), ActivityLifecycleTracker.access$getAppId$p(ActivityLifecycleTracker.INSTANCE));
                                        SessionInfo.Companion.clearSavedSessionFromDisk();
                                        ActivityLifecycleTracker.access$setCurrentSession$p(ActivityLifecycleTracker.INSTANCE, null);
                                    }
                                    Object object = ActivityLifecycleTracker.access$getCurrentFutureLock$p(ActivityLifecycleTracker.INSTANCE);
                                    boolean bl = false;
                                    boolean bl2 = false;
                                    synchronized (object) {
                                        boolean bl3 = false;
                                        ActivityLifecycleTracker.access$setCurrentFuture$p(ActivityLifecycleTracker.INSTANCE, null);
                                        Unit unit = Unit.INSTANCE;
                                    }
                                    return;
                                }
                                catch (Throwable throwable) {
                                    CrashShieldHandler.handleThrowable(throwable, this);
                                    return;
                                }
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        };
                        Object object = ActivityLifecycleTracker.access$getCurrentFutureLock$p(ActivityLifecycleTracker.INSTANCE);
                        boolean bl = false;
                        boolean bl2 = false;
                        synchronized (object) {
                            boolean bl3 = false;
                            ActivityLifecycleTracker.access$setCurrentFuture$p(ActivityLifecycleTracker.INSTANCE, ActivityLifecycleTracker.access$getSingleThreadExecutor$p(ActivityLifecycleTracker.INSTANCE).schedule(task2, (long)ActivityLifecycleTracker.access$getSessionTimeoutInSeconds$p(ActivityLifecycleTracker.INSTANCE), TimeUnit.SECONDS));
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                    long timeSpentOnActivityInSeconds = (appearTime = ActivityLifecycleTracker.access$getCurrentActivityAppearTime$p(ActivityLifecycleTracker.INSTANCE)) > 0L ? (this.$currentTime - appearTime) / (long)1000 : 0L;
                    AutomaticAnalyticsLogger.logActivityTimeSpentEvent(this.$activityName, timeSpentOnActivityInSeconds);
                    SessionInfo sessionInfo2 = ActivityLifecycleTracker.access$getCurrentSession$p(ActivityLifecycleTracker.INSTANCE);
                    if (sessionInfo2 != null) {
                        sessionInfo2.writeSessionToDisk();
                    }
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable(throwable, this);
                    return;
                }
            }
            {
                this.$currentTime = l;
                this.$activityName = string;
            }
        };
        singleThreadExecutor.execute(handleActivityPaused2);
    }

    private final void onActivityDestroyed(Activity activity) {
        CodelessManager.onActivityDestroyed(activity);
    }

    private final int getSessionTimeoutInSeconds() {
        FetchedAppSettings fetchedAppSettings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(FacebookSdk.getApplicationId());
        if (fetchedAppSettings == null) {
            return Constants.getDefaultAppEventsSessionTimeoutInSeconds();
        }
        FetchedAppSettings settings = fetchedAppSettings;
        return settings.getSessionTimeoutInSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cancelCurrentTask() {
        Object object = currentFutureLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (currentFuture != null) {
                ScheduledFuture<?> scheduledFuture = currentFuture;
                if (scheduledFuture != null) {
                    scheduledFuture.cancel(false);
                }
            }
            currentFuture = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    @JvmStatic
    @Nullable
    public static final Activity getCurrentActivity() {
        Object object;
        if (currActivity != null) {
            WeakReference<Activity> weakReference = currActivity;
            object = weakReference != null ? (Activity)weakReference.get() : null;
        } else {
            object = null;
        }
        return object;
    }

    private ActivityLifecycleTracker() {
    }

    static {
        ActivityLifecycleTracker activityLifecycleTracker;
        INSTANCE = activityLifecycleTracker = new ActivityLifecycleTracker();
        String string = ActivityLifecycleTracker.class.getCanonicalName();
        if (string == null) {
            string = "com.facebook.appevents.internal.ActivityLifecycleTracker";
        }
        TAG = string;
        singleThreadExecutor = Executors.newSingleThreadScheduledExecutor();
        currentFutureLock = new Object();
        foregroundActivityCount = new AtomicInteger(0);
        tracking = new AtomicBoolean(false);
    }

    public static final /* synthetic */ String access$getTAG$p(ActivityLifecycleTracker $this) {
        ActivityLifecycleTracker activityLifecycleTracker = $this;
        return TAG;
    }

    public static final /* synthetic */ int access$getActivityReferences$p(ActivityLifecycleTracker $this) {
        ActivityLifecycleTracker activityLifecycleTracker = $this;
        return activityReferences;
    }

    public static final /* synthetic */ void access$setActivityReferences$p(ActivityLifecycleTracker $this, int n) {
        ActivityLifecycleTracker activityLifecycleTracker = $this;
        activityReferences = n;
    }

    public static final /* synthetic */ void access$onActivityPaused(ActivityLifecycleTracker $this, Activity activity) {
        $this.onActivityPaused(activity);
    }

    public static final /* synthetic */ void access$onActivityDestroyed(ActivityLifecycleTracker $this, Activity activity) {
        $this.onActivityDestroyed(activity);
    }

    public static final /* synthetic */ SessionInfo access$getCurrentSession$p(ActivityLifecycleTracker $this) {
        ActivityLifecycleTracker activityLifecycleTracker = $this;
        return currentSession;
    }

    public static final /* synthetic */ void access$setCurrentSession$p(ActivityLifecycleTracker $this, SessionInfo sessionInfo) {
        ActivityLifecycleTracker activityLifecycleTracker = $this;
        currentSession = sessionInfo;
    }

    public static final /* synthetic */ String access$getAppId$p(ActivityLifecycleTracker $this) {
        ActivityLifecycleTracker activityLifecycleTracker = $this;
        return appId;
    }

    public static final /* synthetic */ void access$setAppId$p(ActivityLifecycleTracker $this, String string) {
        ActivityLifecycleTracker activityLifecycleTracker = $this;
        appId = string;
    }

    public static final /* synthetic */ int access$getSessionTimeoutInSeconds$p(ActivityLifecycleTracker $this) {
        return $this.getSessionTimeoutInSeconds();
    }

    public static final /* synthetic */ AtomicInteger access$getForegroundActivityCount$p(ActivityLifecycleTracker $this) {
        ActivityLifecycleTracker activityLifecycleTracker = $this;
        return foregroundActivityCount;
    }

    public static final /* synthetic */ Object access$getCurrentFutureLock$p(ActivityLifecycleTracker $this) {
        ActivityLifecycleTracker activityLifecycleTracker = $this;
        return currentFutureLock;
    }

    public static final /* synthetic */ ScheduledFuture access$getCurrentFuture$p(ActivityLifecycleTracker $this) {
        ActivityLifecycleTracker activityLifecycleTracker = $this;
        return currentFuture;
    }

    public static final /* synthetic */ void access$setCurrentFuture$p(ActivityLifecycleTracker $this, ScheduledFuture scheduledFuture) {
        ActivityLifecycleTracker activityLifecycleTracker = $this;
        currentFuture = scheduledFuture;
    }

    public static final /* synthetic */ ScheduledExecutorService access$getSingleThreadExecutor$p(ActivityLifecycleTracker $this) {
        ActivityLifecycleTracker activityLifecycleTracker = $this;
        return singleThreadExecutor;
    }

    public static final /* synthetic */ long access$getCurrentActivityAppearTime$p(ActivityLifecycleTracker $this) {
        ActivityLifecycleTracker activityLifecycleTracker = $this;
        return currentActivityAppearTime;
    }

    public static final /* synthetic */ void access$setCurrentActivityAppearTime$p(ActivityLifecycleTracker $this, long l) {
        ActivityLifecycleTracker activityLifecycleTracker = $this;
        currentActivityAppearTime = l;
    }
}

