/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.iap;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.IBinder;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class InAppPurchaseEventManager {
    private static final HashMap<String, Method> methodMap = new HashMap();
    private static final HashMap<String, Class<?>> classMap = new HashMap();
    private static final int CACHE_CLEAR_TIME_LIMIT_SEC = 604800;
    private static final int SKU_DETAIL_EXPIRE_TIME_SEC = 43200;
    private static final String SUBSCRIPTION = "subs";
    private static final String INAPP = "inapp";
    private static final int PURCHASE_EXPIRE_TIME_SEC = 86400;
    private static final int PURCHASE_STOP_QUERY_TIME_SEC = 1200;
    private static final int MAX_QUERY_PURCHASE_NUM = 30;
    private static final String IN_APP_BILLING_SERVICE_STUB = "com.android.vending.billing.IInAppBillingService$Stub";
    private static final String IN_APP_BILLING_SERVICE = "com.android.vending.billing.IInAppBillingService";
    private static final String AS_INTERFACE = "asInterface";
    private static final String GET_SKU_DETAILS = "getSkuDetails";
    private static final String GET_PURCHASES = "getPurchases";
    private static final String GET_PURCHASE_HISTORY = "getPurchaseHistory";
    private static final String IS_BILLING_SUPPORTED = "isBillingSupported";
    private static final String ITEM_ID_LIST = "ITEM_ID_LIST";
    private static final String RESPONSE_CODE = "RESPONSE_CODE";
    private static final String DETAILS_LIST = "DETAILS_LIST";
    private static final String INAPP_PURCHASE_DATA_LIST = "INAPP_PURCHASE_DATA_LIST";
    private static final String INAPP_CONTINUATION_TOKEN = "INAPP_CONTINUATION_TOKEN";
    private static final String LAST_CLEARED_TIME = "LAST_CLEARED_TIME";
    private static final String PACKAGE_NAME = FacebookSdk.getApplicationContext().getPackageName();
    private static final String SKU_DETAILS_STORE = "com.facebook.internal.SKU_DETAILS";
    private static final String PURCHASE_INAPP_STORE = "com.facebook.internal.PURCHASE";
    private static final SharedPreferences skuDetailSharedPrefs = FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.internal.SKU_DETAILS", 0);
    private static final SharedPreferences purchaseInappSharedPrefs = FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.internal.PURCHASE", 0);

    /*
     * WARNING - void declaration
     */
    @Nullable
    static Object asInterface(Context context, IBinder iBinder) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseEventManager.class)) {
            return null;
        }
        try {
            Context context2;
            void service;
            Object[] args = new Object[]{service};
            return InAppPurchaseEventManager.invokeMethod(context2, IN_APP_BILLING_SERVICE_STUB, AS_INTERFACE, null, args);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseEventManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static Map<String, String> getSkuDetails(Context context, ArrayList<String> arrayList, Object object, boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseEventManager.class)) {
            return null;
        }
        try {
            void isSubscription;
            void inAppBillingObj;
            Context context2;
            void skuList;
            Map<String, String> skuDetailsMap = InAppPurchaseEventManager.readSkuDetailsFromCache((ArrayList<String>)skuList);
            ArrayList<String> unresolvedSkuList = new ArrayList<String>();
            for (String sku : skuList) {
                if (skuDetailsMap.containsKey(sku)) continue;
                unresolvedSkuList.add(sku);
            }
            skuDetailsMap.putAll(InAppPurchaseEventManager.getSkuDetailsFromGoogle(context2, unresolvedSkuList, inAppBillingObj, (boolean)isSubscription));
            return skuDetailsMap;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseEventManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, String> getSkuDetailsFromGoogle(Context context, ArrayList<String> arrayList, Object object, boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseEventManager.class)) {
            return null;
        }
        try {
            Bundle bundle;
            int response;
            Context context2;
            void isSubscription;
            void skuList;
            void inAppBillingObj;
            HashMap<String, String> skuDetailsMap = new HashMap<String, String>();
            if (inAppBillingObj == null || skuList.isEmpty()) {
                return skuDetailsMap;
            }
            Bundle querySkus = new Bundle();
            querySkus.putStringArrayList(ITEM_ID_LIST, (ArrayList)skuList);
            Object[] args = new Object[]{3, PACKAGE_NAME, isSubscription != false ? SUBSCRIPTION : INAPP, querySkus};
            Object result = InAppPurchaseEventManager.invokeMethod(context2, IN_APP_BILLING_SERVICE, GET_SKU_DETAILS, inAppBillingObj, args);
            if (result != null && (response = (bundle = (Bundle)result).getInt(RESPONSE_CODE)) == 0) {
                ArrayList skuDetailsList = bundle.getStringArrayList(DETAILS_LIST);
                if (skuDetailsList != null && skuList.size() == skuDetailsList.size()) {
                    for (int i = 0; i < skuList.size(); ++i) {
                        skuDetailsMap.put((String)skuList.get(i), (String)skuDetailsList.get(i));
                    }
                }
                InAppPurchaseEventManager.writeSkuDetailsToCache(skuDetailsMap);
            }
            return skuDetailsMap;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseEventManager.class);
            return null;
        }
    }

    private static Map<String, String> readSkuDetailsFromCache(ArrayList<String> arrayList) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseEventManager.class)) {
            return null;
        }
        try {
            ArrayList<String> skuList;
            HashMap<String, String> skuDetailsMap = new HashMap<String, String>();
            long nowSec = System.currentTimeMillis() / 1000L;
            for (String sku : skuList) {
                String[] splitted;
                long timeSec;
                String rawString = skuDetailSharedPrefs.getString(sku, null);
                if (rawString == null || nowSec - (timeSec = Long.parseLong((splitted = rawString.split(";", 2))[0])) >= 43200L) continue;
                skuDetailsMap.put(sku, splitted[1]);
            }
            return skuDetailsMap;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseEventManager.class);
            return null;
        }
    }

    private static void writeSkuDetailsToCache(Map<String, String> map) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseEventManager.class)) {
            return;
        }
        try {
            Map<String, String> skuDetailsMap;
            long nowSec = System.currentTimeMillis() / 1000L;
            SharedPreferences.Editor editor = skuDetailSharedPrefs.edit();
            for (Map.Entry<String, String> pair : skuDetailsMap.entrySet()) {
                editor.putString(pair.getKey(), nowSec + ";" + pair.getValue());
            }
            editor.apply();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseEventManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Boolean isBillingSupported(Context context, Object object, String string) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseEventManager.class)) {
            return null;
        }
        try {
            Context context2;
            void type;
            void inAppBillingObj;
            if (inAppBillingObj == null) {
                return false;
            }
            Object[] args = new Object[]{3, PACKAGE_NAME, type};
            Object result = InAppPurchaseEventManager.invokeMethod(context2, IN_APP_BILLING_SERVICE, IS_BILLING_SUPPORTED, inAppBillingObj, args);
            return result != null && (Integer)result == 0;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseEventManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static ArrayList<String> getPurchasesInapp(Context context, Object object) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseEventManager.class)) {
            return null;
        }
        try {
            void inAppBillingObj;
            Context context2;
            return InAppPurchaseEventManager.filterPurchases(InAppPurchaseEventManager.getPurchases(context2, inAppBillingObj, INAPP));
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseEventManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static ArrayList<String> getPurchasesSubs(Context context, Object object) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseEventManager.class)) {
            return null;
        }
        try {
            void inAppBillingObj;
            Context context2;
            return InAppPurchaseEventManager.filterPurchases(InAppPurchaseEventManager.getPurchases(context2, inAppBillingObj, SUBSCRIPTION));
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseEventManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ArrayList<String> getPurchases(Context context, Object object, String string) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseEventManager.class)) {
            return null;
        }
        try {
            void type;
            Context context2;
            void inAppBillingObj;
            ArrayList<String> purchases = new ArrayList<String>();
            if (inAppBillingObj == null) {
                return purchases;
            }
            if (InAppPurchaseEventManager.isBillingSupported(context2, inAppBillingObj, (String)type).booleanValue()) {
                String continuationToken = null;
                int queriedPurchaseNum = 0;
                do {
                    Bundle purchaseDetails;
                    int response;
                    Object[] args = new Object[]{3, PACKAGE_NAME, type, continuationToken};
                    Object result = InAppPurchaseEventManager.invokeMethod(context2, IN_APP_BILLING_SERVICE, GET_PURCHASES, inAppBillingObj, args);
                    continuationToken = null;
                    if (result == null || (response = (purchaseDetails = (Bundle)result).getInt(RESPONSE_CODE)) != 0) continue;
                    ArrayList details = purchaseDetails.getStringArrayList(INAPP_PURCHASE_DATA_LIST);
                    if (details == null) break;
                    queriedPurchaseNum += details.size();
                    purchases.addAll(details);
                    continuationToken = purchaseDetails.getString(INAPP_CONTINUATION_TOKEN);
                } while (queriedPurchaseNum < 30 && continuationToken != null);
            }
            return purchases;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseEventManager.class);
            return null;
        }
    }

    public static boolean hasFreeTrialPeirod(String string) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseEventManager.class)) {
            return false;
        }
        try {
            try {
                String skuDetail;
                JSONObject skuDetailsJson = new JSONObject(skuDetail);
                String freeTrialPeriod = skuDetailsJson.optString("freeTrialPeriod");
                return freeTrialPeriod != null && !freeTrialPeriod.isEmpty();
            }
            catch (JSONException jSONException) {
                return false;
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseEventManager.class);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    static ArrayList<String> getPurchaseHistoryInapp(Context context, Object object) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseEventManager.class)) {
            return null;
        }
        try {
            Context context2;
            void inAppBillingObj;
            ArrayList<String> purchases = new ArrayList<String>();
            if (inAppBillingObj == null) {
                return purchases;
            }
            Class<?> iapClass = InAppPurchaseEventManager.getClass(context2, IN_APP_BILLING_SERVICE);
            if (iapClass == null) {
                return purchases;
            }
            Method method = InAppPurchaseEventManager.getMethod(iapClass, GET_PURCHASE_HISTORY);
            if (method == null) {
                return purchases;
            }
            purchases = InAppPurchaseEventManager.getPurchaseHistory(context2, inAppBillingObj, INAPP);
            return InAppPurchaseEventManager.filterPurchases(purchases);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseEventManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ArrayList<String> getPurchaseHistory(Context context, Object object, String string) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseEventManager.class)) {
            return null;
        }
        try {
            void type;
            void inAppBillingObj;
            Context context2;
            ArrayList<String> purchases = new ArrayList<String>();
            if (InAppPurchaseEventManager.isBillingSupported(context2, inAppBillingObj, (String)type).booleanValue()) {
                String continuationToken = null;
                int queriedPurchaseNum = 0;
                boolean reachTimeLimit = false;
                do {
                    ArrayList details;
                    Object[] args = new Object[]{6, PACKAGE_NAME, type, continuationToken, new Bundle()};
                    continuationToken = null;
                    Object result = InAppPurchaseEventManager.invokeMethod(context2, IN_APP_BILLING_SERVICE, GET_PURCHASE_HISTORY, inAppBillingObj, args);
                    if (result == null) continue;
                    long nowSec = System.currentTimeMillis() / 1000L;
                    Bundle purchaseDetails = (Bundle)result;
                    int response = purchaseDetails.getInt(RESPONSE_CODE);
                    if (response != 0 || (details = purchaseDetails.getStringArrayList(INAPP_PURCHASE_DATA_LIST)) == null) continue;
                    for (String detail : details) {
                        try {
                            JSONObject detailJson = new JSONObject(detail);
                            long purchaseTimeSec = detailJson.getLong("purchaseTime") / 1000L;
                            if (nowSec - purchaseTimeSec > 1200L) {
                                reachTimeLimit = true;
                                break;
                            }
                            purchases.add(detail);
                            ++queriedPurchaseNum;
                        }
                        catch (JSONException jSONException) {}
                    }
                    continuationToken = purchaseDetails.getString(INAPP_CONTINUATION_TOKEN);
                } while (queriedPurchaseNum < 30 && continuationToken != null && !reachTimeLimit);
            }
            return purchases;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseEventManager.class);
            return null;
        }
    }

    private static ArrayList<String> filterPurchases(ArrayList<String> arrayList) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseEventManager.class)) {
            return null;
        }
        try {
            ArrayList<String> purchases;
            ArrayList<String> filteredPurchase = new ArrayList<String>();
            SharedPreferences.Editor editor = purchaseInappSharedPrefs.edit();
            long nowSec = System.currentTimeMillis() / 1000L;
            for (String purchase : purchases) {
                try {
                    String historyPurchaseToken;
                    JSONObject purchaseJson = new JSONObject(purchase);
                    String sku = purchaseJson.getString("productId");
                    long purchaseTimeMillis = purchaseJson.getLong("purchaseTime");
                    String purchaseToken = purchaseJson.getString("purchaseToken");
                    if (nowSec - purchaseTimeMillis / 1000L > 86400L || (historyPurchaseToken = purchaseInappSharedPrefs.getString(sku, "")).equals(purchaseToken)) continue;
                    editor.putString(sku, purchaseToken);
                    filteredPurchase.add(purchase);
                }
                catch (JSONException jSONException) {}
            }
            editor.apply();
            return filteredPurchase;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseEventManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static Method getMethod(Class<?> clazz, String string) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseEventManager.class)) {
            return null;
        }
        try {
            void methodName;
            Method method = methodMap.get(methodName);
            if (method != null) {
                return method;
            }
            try {
                Class<?> classObj;
                Class[] paramTypes = null;
                switch (methodName) {
                    case "asInterface": {
                        paramTypes = new Class[]{IBinder.class};
                        break;
                    }
                    case "getSkuDetails": {
                        paramTypes = new Class[]{Integer.TYPE, String.class, String.class, Bundle.class};
                        break;
                    }
                    case "isBillingSupported": {
                        paramTypes = new Class[]{Integer.TYPE, String.class, String.class};
                        break;
                    }
                    case "getPurchases": {
                        paramTypes = new Class[]{Integer.TYPE, String.class, String.class, String.class};
                        break;
                    }
                    case "getPurchaseHistory": {
                        paramTypes = new Class[]{Integer.TYPE, String.class, String.class, String.class, Bundle.class};
                    }
                }
                method = classObj.getDeclaredMethod((String)methodName, paramTypes);
                methodMap.put((String)methodName, method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return method;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseEventManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static Class<?> getClass(Context context, String string) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseEventManager.class)) {
            return null;
        }
        try {
            void className;
            Class<?> classObj = classMap.get(className);
            if (classObj != null) {
                return classObj;
            }
            try {
                Context context2;
                classObj = context2.getClassLoader().loadClass((String)className);
                classMap.put((String)className, classObj);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return classObj;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseEventManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static Object invokeMethod(Context context, String string, String string2, Object object, Object[] objectArray) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseEventManager.class)) {
            return null;
        }
        try {
            Object obj;
            void methodName;
            void className;
            Context context2;
            Class<?> classObj = InAppPurchaseEventManager.getClass(context2, (String)className);
            if (classObj == null) {
                return null;
            }
            Method methodObj = InAppPurchaseEventManager.getMethod(classObj, (String)methodName);
            if (methodObj == null) {
                return null;
            }
            if (obj != null) {
                obj = classObj.cast(obj);
            }
            try {
                void args;
                return methodObj.invoke(obj, (Object[])args);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseEventManager.class);
            return null;
        }
    }

    static void clearSkuDetailsCache() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseEventManager.class)) {
            return;
        }
        try {
            long nowSec = System.currentTimeMillis() / 1000L;
            long lastClearedTimeSec = skuDetailSharedPrefs.getLong(LAST_CLEARED_TIME, 0L);
            if (lastClearedTimeSec == 0L) {
                skuDetailSharedPrefs.edit().putLong(LAST_CLEARED_TIME, nowSec).apply();
            } else if (nowSec - lastClearedTimeSec > 604800L) {
                skuDetailSharedPrefs.edit().clear().putLong(LAST_CLEARED_TIME, nowSec).apply();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseEventManager.class);
            return;
        }
    }
}

