/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.iap;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.facebook.appevents.iap.InAppPurchaseSkuDetailsWrapper;
import com.facebook.appevents.iap.InAppPurchaseUtils;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class InAppPurchaseBillingClientWrapper {
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    @Nullable
    private static InAppPurchaseBillingClientWrapper mInstance = null;
    public static final AtomicBoolean isServiceConnected = new AtomicBoolean(false);
    private final Context context;
    private final Object billingClient;
    private final InAppPurchaseSkuDetailsWrapper inAppPurchaseSkuDetailsWrapper;
    private final Class<?> billingClientClazz;
    private final Class<?> purchaseResultClazz;
    private final Class<?> purchaseClazz;
    private final Class<?> skuDetailsClazz;
    private final Class<?> PurchaseHistoryRecordClazz;
    private final Class<?> skuDetailsResponseListenerClazz;
    private final Class<?> purchaseHistoryResponseListenerClazz;
    private final Method queryPurchasesMethod;
    private final Method getPurchaseListMethod;
    private final Method getOriginalJsonMethod;
    private final Method getOriginalJsonSkuMethod;
    private final Method getOriginalJsonPurchaseHistoryMethod;
    private final Method querySkuDetailsAsyncMethod;
    private final Method queryPurchaseHistoryAsyncMethod;
    public static final Map<String, JSONObject> purchaseDetailsMap = new ConcurrentHashMap<String, JSONObject>();
    public static final Map<String, JSONObject> skuDetailsMap = new ConcurrentHashMap<String, JSONObject>();
    private final Set<String> historyPurchaseSet = new CopyOnWriteArraySet<String>();
    private static final String IN_APP = "inapp";
    private static final String PRODUCT_ID = "productId";
    private static final String PACKAGE_NAME = "packageName";
    private static final String CLASSNAME_BILLING_CLIENT = "com.android.billingclient.api.BillingClient";
    private static final String CLASSNAME_PURCHASE = "com.android.billingclient.api.Purchase";
    private static final String CLASSNAME_PURCHASES_RESULT = "com.android.billingclient.api.Purchase$PurchasesResult";
    private static final String CLASSNAME_SKU_DETAILS = "com.android.billingclient.api.SkuDetails";
    private static final String CLASSNAME_PURCHASE_HISTORY_RECORD = "com.android.billingclient.api.PurchaseHistoryRecord";
    private static final String CLASSNAME_SKU_DETAILS_RESPONSE_LISTENER = "com.android.billingclient.api.SkuDetailsResponseListener";
    private static final String CLASSNAME_PURCHASE_HISTORY_RESPONSE_LISTENER = "com.android.billingclient.api.PurchaseHistoryResponseListener";
    private static final String CLASSNAME_BILLING_CLIENT_BUILDER = "com.android.billingclient.api.BillingClient$Builder";
    private static final String CLASSNAME_PURCHASE_UPDATED_LISTENER = "com.android.billingclient.api.PurchasesUpdatedListener";
    private static final String CLASSNAME_BILLING_CLIENT_STATE_LISTENER = "com.android.billingclient.api.BillingClientStateListener";
    private static final String METHOD_QUERY_PURCHASES = "queryPurchases";
    private static final String METHOD_GET_PURCHASE_LIST = "getPurchasesList";
    private static final String METHOD_GET_ORIGINAL_JSON = "getOriginalJson";
    private static final String METHOD_QUERY_SKU_DETAILS_ASYNC = "querySkuDetailsAsync";
    private static final String METHOD_QUERY_PURCHASE_HISTORY_ASYNC = "queryPurchaseHistoryAsync";
    private static final String METHOD_NEW_BUILDER = "newBuilder";
    private static final String METHOD_ENABLE_PENDING_PURCHASES = "enablePendingPurchases";
    private static final String METHOD_SET_LISTENER = "setListener";
    private static final String METHOD_BUILD = "build";
    private static final String METHOD_START_CONNECTION = "startConnection";
    private static final String METHOD_ON_BILLING_SETUP_FINISHED = "onBillingSetupFinished";
    private static final String METHOD_ON_BILLING_SERVICE_DISCONNECTED = "onBillingServiceDisconnected";
    private static final String METHOD_ON_PURCHASE_HISTORY_RESPONSE = "onPurchaseHistoryResponse";
    private static final String METHOD_ON_SKU_DETAILS_RESPONSE = "onSkuDetailsResponse";

    private InAppPurchaseBillingClientWrapper(Context context, Object billingClient, Class<?> billingClientClazz, Class<?> purchaseResultClazz, Class<?> purchaseClazz, Class<?> skuDetailsClazz, Class<?> PurchaseHistoryRecordClazz, Class<?> skuDetailsResponseListenerClazz, Class<?> purchaseHistoryResponseListenerClazz, Method queryPurchasesMethod, Method getPurchaseListsMethod, Method getOriginalJsonMethod, Method getOriginalJsonSkuMethod, Method getOriginalJsonPurchaseHistoryMethod, Method querySkuDetailsAsyncMethod, Method queryPurchaseHistoryAsyncMethod, InAppPurchaseSkuDetailsWrapper inAppPurchaseSkuDetailsWrapper) {
        this.context = context;
        this.billingClient = billingClient;
        this.billingClientClazz = billingClientClazz;
        this.purchaseResultClazz = purchaseResultClazz;
        this.purchaseClazz = purchaseClazz;
        this.skuDetailsClazz = skuDetailsClazz;
        this.PurchaseHistoryRecordClazz = PurchaseHistoryRecordClazz;
        this.skuDetailsResponseListenerClazz = skuDetailsResponseListenerClazz;
        this.purchaseHistoryResponseListenerClazz = purchaseHistoryResponseListenerClazz;
        this.queryPurchasesMethod = queryPurchasesMethod;
        this.getPurchaseListMethod = getPurchaseListsMethod;
        this.getOriginalJsonMethod = getOriginalJsonMethod;
        this.getOriginalJsonSkuMethod = getOriginalJsonSkuMethod;
        this.getOriginalJsonPurchaseHistoryMethod = getOriginalJsonPurchaseHistoryMethod;
        this.querySkuDetailsAsyncMethod = querySkuDetailsAsyncMethod;
        this.queryPurchaseHistoryAsyncMethod = queryPurchaseHistoryAsyncMethod;
        this.inAppPurchaseSkuDetailsWrapper = inAppPurchaseSkuDetailsWrapper;
    }

    @Nullable
    public static synchronized InAppPurchaseBillingClientWrapper getOrCreateInstance(Context context) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseBillingClientWrapper.class)) {
            return null;
        }
        try {
            Context context2;
            if (initialized.get()) {
                return mInstance;
            }
            InAppPurchaseBillingClientWrapper.createInstance(context2);
            initialized.set(true);
            return mInstance;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseBillingClientWrapper.class);
            return null;
        }
    }

    private static void createInstance(Context context) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseBillingClientWrapper.class)) {
            return;
        }
        try {
            Context context2;
            InAppPurchaseSkuDetailsWrapper inAppPurchaseSkuDetailsWrapper = InAppPurchaseSkuDetailsWrapper.getOrCreateInstance();
            if (inAppPurchaseSkuDetailsWrapper == null) {
                return;
            }
            Class<?> billingClientClazz = InAppPurchaseUtils.getClass(CLASSNAME_BILLING_CLIENT);
            Class<?> purchaseClazz = InAppPurchaseUtils.getClass(CLASSNAME_PURCHASE);
            Class<?> purchaseResultClazz = InAppPurchaseUtils.getClass(CLASSNAME_PURCHASES_RESULT);
            Class<?> skuDetailsClazz = InAppPurchaseUtils.getClass(CLASSNAME_SKU_DETAILS);
            Class<?> PurchaseHistoryRecordClazz = InAppPurchaseUtils.getClass(CLASSNAME_PURCHASE_HISTORY_RECORD);
            Class<?> skuDetailsResponseListenerClazz = InAppPurchaseUtils.getClass(CLASSNAME_SKU_DETAILS_RESPONSE_LISTENER);
            Class<?> purchaseHistoryResponseListenerClazz = InAppPurchaseUtils.getClass(CLASSNAME_PURCHASE_HISTORY_RESPONSE_LISTENER);
            if (billingClientClazz == null || purchaseResultClazz == null || purchaseClazz == null || skuDetailsClazz == null || skuDetailsResponseListenerClazz == null || PurchaseHistoryRecordClazz == null || purchaseHistoryResponseListenerClazz == null) {
                return;
            }
            Method queryPurchasesMethod = InAppPurchaseUtils.getMethod(billingClientClazz, METHOD_QUERY_PURCHASES, String.class);
            Method getPurchaseListMethod = InAppPurchaseUtils.getMethod(purchaseResultClazz, METHOD_GET_PURCHASE_LIST, new Class[0]);
            Method getOriginalJsonMethod = InAppPurchaseUtils.getMethod(purchaseClazz, METHOD_GET_ORIGINAL_JSON, new Class[0]);
            Method getOriginalJsonSkuMethod = InAppPurchaseUtils.getMethod(skuDetailsClazz, METHOD_GET_ORIGINAL_JSON, new Class[0]);
            Method getOriginalJsonPurchaseHistoryMethod = InAppPurchaseUtils.getMethod(PurchaseHistoryRecordClazz, METHOD_GET_ORIGINAL_JSON, new Class[0]);
            Method querySkuDetailsAsyncMethod = InAppPurchaseUtils.getMethod(billingClientClazz, METHOD_QUERY_SKU_DETAILS_ASYNC, inAppPurchaseSkuDetailsWrapper.getSkuDetailsParamsClazz(), skuDetailsResponseListenerClazz);
            Method queryPurchaseHistoryAsyncMethod = InAppPurchaseUtils.getMethod(billingClientClazz, METHOD_QUERY_PURCHASE_HISTORY_ASYNC, String.class, purchaseHistoryResponseListenerClazz);
            if (queryPurchasesMethod == null || getPurchaseListMethod == null || getOriginalJsonMethod == null || getOriginalJsonSkuMethod == null || getOriginalJsonPurchaseHistoryMethod == null || querySkuDetailsAsyncMethod == null || queryPurchaseHistoryAsyncMethod == null) {
                return;
            }
            Object billingClient = InAppPurchaseBillingClientWrapper.createBillingClient(context2, billingClientClazz);
            if (billingClient == null) {
                return;
            }
            mInstance = new InAppPurchaseBillingClientWrapper(context2, billingClient, billingClientClazz, purchaseResultClazz, purchaseClazz, skuDetailsClazz, PurchaseHistoryRecordClazz, skuDetailsResponseListenerClazz, purchaseHistoryResponseListenerClazz, queryPurchasesMethod, getPurchaseListMethod, getOriginalJsonMethod, getOriginalJsonSkuMethod, getOriginalJsonPurchaseHistoryMethod, querySkuDetailsAsyncMethod, queryPurchaseHistoryAsyncMethod, inAppPurchaseSkuDetailsWrapper);
            mInstance.startConnection();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseBillingClientWrapper.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static Object createBillingClient(Context context, Class<?> clazz) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseBillingClientWrapper.class)) {
            return null;
        }
        try {
            Context context2;
            void billingClientClazz;
            Class<?> builderClazz = InAppPurchaseUtils.getClass(CLASSNAME_BILLING_CLIENT_BUILDER);
            Class<?> listenerClazz = InAppPurchaseUtils.getClass(CLASSNAME_PURCHASE_UPDATED_LISTENER);
            if (builderClazz == null || listenerClazz == null) {
                return null;
            }
            Method newBuilderMethod = InAppPurchaseUtils.getMethod(billingClientClazz, METHOD_NEW_BUILDER, new Class[]{Context.class});
            Method enablePendingPurchasesMethod = InAppPurchaseUtils.getMethod(builderClazz, METHOD_ENABLE_PENDING_PURCHASES, new Class[0]);
            Method setListenerMethod = InAppPurchaseUtils.getMethod(builderClazz, METHOD_SET_LISTENER, listenerClazz);
            Method buildMethod = InAppPurchaseUtils.getMethod(builderClazz, METHOD_BUILD, new Class[0]);
            if (newBuilderMethod == null || enablePendingPurchasesMethod == null || setListenerMethod == null || buildMethod == null) {
                return null;
            }
            Object builder = InAppPurchaseUtils.invokeMethod(billingClientClazz, newBuilderMethod, null, new Object[]{context2});
            if (builder == null) {
                return null;
            }
            Object listenerObj = Proxy.newProxyInstance(listenerClazz.getClassLoader(), new Class[]{listenerClazz}, (InvocationHandler)new PurchasesUpdatedListenerWrapper());
            if ((builder = InAppPurchaseUtils.invokeMethod(builderClazz, setListenerMethod, builder, listenerObj)) == null) {
                return null;
            }
            if ((builder = InAppPurchaseUtils.invokeMethod(builderClazz, enablePendingPurchasesMethod, builder, new Object[0])) == null) {
                return null;
            }
            return InAppPurchaseUtils.invokeMethod(builderClazz, buildMethod, builder, new Object[0]);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseBillingClientWrapper.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void queryPurchaseHistory(String string, Runnable runnable2) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void queryPurchaseHistoryRunnable;
            void skuType;
            this.queryPurchaseHistoryAsync((String)skuType, new Runnable((Runnable)queryPurchaseHistoryRunnable){
                final /* synthetic */ Runnable val$queryPurchaseHistoryRunnable;
                {
                    this.val$queryPurchaseHistoryRunnable = runnable2;
                }

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        InAppPurchaseBillingClientWrapper.access$100(InAppPurchaseBillingClientWrapper.this, InAppPurchaseBillingClientWrapper.IN_APP, new ArrayList(InAppPurchaseBillingClientWrapper.access$000(InAppPurchaseBillingClientWrapper.this)), this.val$queryPurchaseHistoryRunnable);
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void queryPurchase(String string, Runnable runnable2) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            Object purchaseResult = InAppPurchaseUtils.invokeMethod(this.billingClientClazz, this.queryPurchasesMethod, this.billingClient, IN_APP);
            Object purchaseObjects = InAppPurchaseUtils.invokeMethod(this.purchaseResultClazz, this.getPurchaseListMethod, purchaseResult, new Object[0]);
            if (!(purchaseObjects instanceof List)) {
                return;
            }
            try {
                void querySkuRunnable;
                void skuType;
                ArrayList<String> skuIDs = new ArrayList<String>();
                for (Object purchaseObject : (List)purchaseObjects) {
                    JSONObject purchaseJson;
                    Object purchaseJsonStr = InAppPurchaseUtils.invokeMethod(this.purchaseClazz, this.getOriginalJsonMethod, purchaseObject, new Object[0]);
                    if (!(purchaseJsonStr instanceof String) || !(purchaseJson = new JSONObject((String)purchaseJsonStr)).has(PRODUCT_ID)) continue;
                    String skuID = purchaseJson.getString(PRODUCT_ID);
                    skuIDs.add(skuID);
                    purchaseDetailsMap.put(skuID, purchaseJson);
                }
                this.querySkuDetailsAsync((String)skuType, skuIDs, (Runnable)querySkuRunnable);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void querySkuDetailsAsync(String string, List<String> list, Runnable runnable2) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void skuIDs;
            void skuType;
            void runnable3;
            Object listenerObj = Proxy.newProxyInstance(this.skuDetailsResponseListenerClazz.getClassLoader(), new Class[]{this.skuDetailsResponseListenerClazz}, (InvocationHandler)new SkuDetailsResponseListenerWrapper((Runnable)runnable3));
            Object skuDetailsParams = this.inAppPurchaseSkuDetailsWrapper.getSkuDetailsParams((String)skuType, (List<String>)skuIDs);
            InAppPurchaseUtils.invokeMethod(this.billingClientClazz, this.querySkuDetailsAsyncMethod, this.billingClient, skuDetailsParams, listenerObj);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void queryPurchaseHistoryAsync(String string, Runnable runnable2) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void skuType;
            void runnable3;
            Object listenerObj = Proxy.newProxyInstance(this.purchaseHistoryResponseListenerClazz.getClassLoader(), new Class[]{this.purchaseHistoryResponseListenerClazz}, (InvocationHandler)new PurchaseHistoryResponseListenerWrapper((Runnable)runnable3));
            InAppPurchaseUtils.invokeMethod(this.billingClientClazz, this.queryPurchaseHistoryAsyncMethod, this.billingClient, skuType, listenerObj);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    private void startConnection() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            Class<?> listenerClazz = InAppPurchaseUtils.getClass(CLASSNAME_BILLING_CLIENT_STATE_LISTENER);
            if (listenerClazz == null) {
                return;
            }
            Method method = InAppPurchaseUtils.getMethod(this.billingClientClazz, METHOD_START_CONNECTION, listenerClazz);
            if (method == null) {
                return;
            }
            Object listenerObj = Proxy.newProxyInstance(listenerClazz.getClassLoader(), new Class[]{listenerClazz}, (InvocationHandler)new BillingClientStateListenerWrapper());
            InAppPurchaseUtils.invokeMethod(this.billingClientClazz, method, this.billingClient, listenerObj);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    static /* synthetic */ Set access$000(InAppPurchaseBillingClientWrapper inAppPurchaseBillingClientWrapper) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseBillingClientWrapper.class)) {
            return null;
        }
        try {
            InAppPurchaseBillingClientWrapper x0;
            return x0.historyPurchaseSet;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseBillingClientWrapper.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(InAppPurchaseBillingClientWrapper inAppPurchaseBillingClientWrapper, String string, List list, Runnable runnable2) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseBillingClientWrapper.class)) {
            return;
        }
        try {
            void x3;
            void x2;
            void x1;
            InAppPurchaseBillingClientWrapper x0;
            x0.querySkuDetailsAsync((String)x1, (List<String>)x2, (Runnable)x3);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseBillingClientWrapper.class);
            return;
        }
    }

    static /* synthetic */ Class access$200(InAppPurchaseBillingClientWrapper inAppPurchaseBillingClientWrapper) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseBillingClientWrapper.class)) {
            return null;
        }
        try {
            InAppPurchaseBillingClientWrapper x0;
            return x0.PurchaseHistoryRecordClazz;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseBillingClientWrapper.class);
            return null;
        }
    }

    static /* synthetic */ Method access$300(InAppPurchaseBillingClientWrapper inAppPurchaseBillingClientWrapper) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseBillingClientWrapper.class)) {
            return null;
        }
        try {
            InAppPurchaseBillingClientWrapper x0;
            return x0.getOriginalJsonPurchaseHistoryMethod;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseBillingClientWrapper.class);
            return null;
        }
    }

    static /* synthetic */ Context access$400(InAppPurchaseBillingClientWrapper inAppPurchaseBillingClientWrapper) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseBillingClientWrapper.class)) {
            return null;
        }
        try {
            InAppPurchaseBillingClientWrapper x0;
            return x0.context;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseBillingClientWrapper.class);
            return null;
        }
    }

    static /* synthetic */ Class access$500(InAppPurchaseBillingClientWrapper inAppPurchaseBillingClientWrapper) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseBillingClientWrapper.class)) {
            return null;
        }
        try {
            InAppPurchaseBillingClientWrapper x0;
            return x0.skuDetailsClazz;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseBillingClientWrapper.class);
            return null;
        }
    }

    static /* synthetic */ Method access$600(InAppPurchaseBillingClientWrapper inAppPurchaseBillingClientWrapper) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseBillingClientWrapper.class)) {
            return null;
        }
        try {
            InAppPurchaseBillingClientWrapper x0;
            return x0.getOriginalJsonSkuMethod;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseBillingClientWrapper.class);
            return null;
        }
    }

    class SkuDetailsResponseListenerWrapper
    implements InvocationHandler {
        Runnable runnable;

        public SkuDetailsResponseListenerWrapper(Runnable runnable2) {
            this.runnable = runnable2;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method m, Object[] args) {
            Object skuDetailsObj;
            if (m.getName().equals(InAppPurchaseBillingClientWrapper.METHOD_ON_SKU_DETAILS_RESPONSE) && (skuDetailsObj = args[1]) instanceof List) {
                this.parseSkuDetails((List)skuDetailsObj);
            }
            return null;
        }

        void parseSkuDetails(List<?> skuDetailsObjectList) {
            for (Object skuDetail : skuDetailsObjectList) {
                try {
                    JSONObject skuJson;
                    Object skuDetailJson = InAppPurchaseUtils.invokeMethod(InAppPurchaseBillingClientWrapper.access$500(InAppPurchaseBillingClientWrapper.this), InAppPurchaseBillingClientWrapper.access$600(InAppPurchaseBillingClientWrapper.this), skuDetail, new Object[0]);
                    if (!(skuDetailJson instanceof String) || !(skuJson = new JSONObject((String)skuDetailJson)).has(InAppPurchaseBillingClientWrapper.PRODUCT_ID)) continue;
                    String skuID = skuJson.getString(InAppPurchaseBillingClientWrapper.PRODUCT_ID);
                    skuDetailsMap.put(skuID, skuJson);
                }
                catch (Exception exception) {}
            }
            this.runnable.run();
        }
    }

    class PurchaseHistoryResponseListenerWrapper
    implements InvocationHandler {
        Runnable runnable;

        public PurchaseHistoryResponseListenerWrapper(Runnable runnable2) {
            this.runnable = runnable2;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) {
            Object purchaseHistoryRecordListObject;
            if (method.getName().equals(InAppPurchaseBillingClientWrapper.METHOD_ON_PURCHASE_HISTORY_RESPONSE) && (purchaseHistoryRecordListObject = args[1]) instanceof List) {
                this.getPurchaseHistoryRecord((List)purchaseHistoryRecordListObject);
            }
            return null;
        }

        private void getPurchaseHistoryRecord(List<?> purchaseHistoryRecordList) {
            for (Object purchaseHistoryObject : purchaseHistoryRecordList) {
                try {
                    Object purchaseHistoryJsonRaw = InAppPurchaseUtils.invokeMethod(InAppPurchaseBillingClientWrapper.access$200(InAppPurchaseBillingClientWrapper.this), InAppPurchaseBillingClientWrapper.access$300(InAppPurchaseBillingClientWrapper.this), purchaseHistoryObject, new Object[0]);
                    if (!(purchaseHistoryJsonRaw instanceof String)) continue;
                    JSONObject purchaseHistoryJson = new JSONObject((String)purchaseHistoryJsonRaw);
                    String packageName = InAppPurchaseBillingClientWrapper.access$400(InAppPurchaseBillingClientWrapper.this).getPackageName();
                    purchaseHistoryJson.put(InAppPurchaseBillingClientWrapper.PACKAGE_NAME, (Object)packageName);
                    if (!purchaseHistoryJson.has(InAppPurchaseBillingClientWrapper.PRODUCT_ID)) continue;
                    String skuID = purchaseHistoryJson.getString(InAppPurchaseBillingClientWrapper.PRODUCT_ID);
                    InAppPurchaseBillingClientWrapper.access$000(InAppPurchaseBillingClientWrapper.this).add(skuID);
                    purchaseDetailsMap.put(skuID, purchaseHistoryJson);
                }
                catch (Exception exception) {}
            }
            this.runnable.run();
        }
    }

    static class PurchasesUpdatedListenerWrapper
    implements InvocationHandler {
        @Override
        @Nullable
        public Object invoke(Object proxy, Method m, Object[] args) {
            return null;
        }
    }

    static class BillingClientStateListenerWrapper
    implements InvocationHandler {
        @Override
        @Nullable
        public Object invoke(Object proxy, Method m, Object[] args) {
            if (m.getName().equals(InAppPurchaseBillingClientWrapper.METHOD_ON_BILLING_SETUP_FINISHED)) {
                isServiceConnected.set(true);
            } else if (m.getName().endsWith(InAppPurchaseBillingClientWrapper.METHOD_ON_BILLING_SERVICE_DISCONNECTED)) {
                isServiceConnected.set(false);
            }
            return null;
        }
    }
}

